/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.util.List;
import oracle.dbtools.raptor.UtilResources;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class HTMLFormatter
extends ResultsFormatter {
    public static final String TYPE = "HTML";
    public static final String EXT = "htm";
    public static final String KEY_REC_TERM = "EXPORT_HTM_REC_TERM";
    private boolean _result = true;
    private static final String HEADER = "<html><head>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=@@ENCODING@@\">\n<!-- base href=\"http://apexdev.us.oracle.com:7778/pls/apx11w/\" -->\n<style type=\"text/css\">\ntable {\nbackground-color:#F2F2F5;\nborder-width:1px 1px 0px 1px;\nborder-color:#C9CBD3;\nborder-style:solid;\n}\ntd {\ncolor:#000000;\nfont-family:Tahoma,Arial,Helvetica,Geneva,sans-serif;\nfont-size:9pt;\nbackground-color:#EAEFF5;\npadding:8px;\nbackground-color:#F2F2F5;\nborder-color:#ffffff #ffffff #cccccc #ffffff;\nborder-style:solid solid solid solid;\nborder-width:1px 0px 1px 0px;\n}\nth {\nfont-family:Tahoma,Arial,Helvetica,Geneva,sans-serif;\nfont-size:9pt;\npadding:8px;\nbackground-color:#CFE0F1;\nborder-color:#ffffff #ffffff #cccccc #ffffff;\nborder-style:solid solid solid none;\nborder-width:1px 0px 1px 0px;\nwhite-space:nowrap;\n}\n</style>\n<script type=\"text/javascript\">\nwindow.apex_search = {};\napex_search.init = function (){\n\tthis.rows = document.getElementById('data').getElementsByTagName('TR');\n\tthis.rows_length = apex_search.rows.length;\n\tthis.rows_text =  [];\n\tfor (var i=0;i<apex_search.rows_length;i++){\n        this.rows_text[i] = (apex_search.rows[i].innerText)?apex_search.rows[i].innerText.toUpperCase():apex_search.rows[i].textContent.toUpperCase();\n\t}\n\tthis.time = false;\n}\n\napex_search.lsearch = function(){\n\tthis.term = document.getElementById('S').value.toUpperCase();\n\tfor(var i=0,row;row = this.rows[i],row_text = this.rows_text[i];i++){\n\t\trow.style.display = ((row_text.indexOf(this.term) != -1) || this.term  === '')?'':'none';\n\t}\n\tthis.time = false;\n}\n\napex_search.search = function(e){\n    var keycode;\n    if(window.event){keycode = window.event.keyCode;}\n    else if (e){keycode = e.which;}\n    else {return false;}\n    if(keycode == 13){\n\t\tapex_search.lsearch();\n\t}\n    else{return false;}\n}</script>\n</head><body onload=\"apex_search.init();\">\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n<tbody><tr><td><input type=\"text\" size=\"30\" maxlength=\"1000\" value=\"\" id=\"S\" onkeyup=\"apex_search.search(event);\" /><input type=\"button\" value=\"Search\" onclick=\"apex_search.lsearch();\"/> \n</td></tr>\n</tbody></table>\n<br>\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";

    public HTMLFormatter() {
        super(TYPE, UtilResources.getString("HTMLFormatter_0"), EXT);
    }

    @Override
    public boolean isTextEditorReadable() {
        return false;
    }

    @Override
    public void start() throws IOException {
        this.write(HEADER.replace("@@ENCODING@@", this.getEncode()) + this.getLineTerminator());
        this.write("<tr>");
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string = this.getColumnName(i);
            this.write("\t<th>" + string + "</th>" + this.getLineTerminator());
        }
        this.write("</tr>\n<tbody id=\"data\">\n" + this.getLineTerminator());
    }

    @Override
    public void startRow() throws IOException {
        this.write("\t<tr>" + this.getLineTerminator());
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        if (super.getDataType(n) == 2) {
            this.write("<td align=\"right\">");
        } else {
            this.write("<td>");
        }
        if (object != null) {
            if (object instanceof List) {
                String string = "<table><tr>";
                List list = (List)object;
                List list2 = (List)list.get(0);
                int n3 = 0;
                for (Object object2 : list2) {
                    string = string + "<th>" + list2.get(n3) + "</th>";
                    ++n3;
                }
                string = string + "</tr>";
                int n4 = 0;
                for (Object e : list) {
                    if (n4 > 0) {
                        string = string + "<tr>";
                        int n5 = 0;
                        for (Object e2 : (List)e) {
                            string = string + "<td>" + this.escape(this.getValue(e2).toString()) + "</td>";
                            ++n5;
                        }
                        string = string + "</tr>";
                    }
                    ++n4;
                }
                string = string + "</table>";
                this.write(string);
            } else {
                this.write(this.escape(this.getValue(object).toString()));
            }
        } else {
            this.write("&nbsp;");
        }
        this.write("</td>" + this.getLineTerminator());
    }

    private String escape(String string) {
        return string.replace("<", "&lt;").replace(">", "&gt;");
    }

    @Override
    public void endRow() throws IOException {
        this.write("\t</tr>" + this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
        this.write("</tbody></table><!-- SQL:\n" + this.getWrapper().getSQL() + "--></body></html>");
    }

    public void setResult(boolean bl) {
        this._result = bl;
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }
}

