/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.RAW;

public class InsertFormatter
extends ResultsFormatter {
    public static final String TYPE = "INSERT";
    public static final String EXT = "sql";
    public static final String KEY_REC_TERM = "EXPORT_INS_REC_TERM";
    public static final String COMMIT = "COMMIT";
    public static final String COMMIT_ROWS = "COMMIT_ROWS";
    StringBuffer sb = new StringBuffer();
    String tableName = null;
    boolean isTruncate = false;
    boolean isCommit = false;
    int commitRows = 0;
    boolean isDecSepComma = false;
    long rowCount = 0L;
    float block;

    public InsertFormatter() {
        super(TYPE, "SQL File", EXT);
    }

    public String getString() {
        return this.sb.toString();
    }

    public boolean allowsHeader() {
        return false;
    }

    @Override
    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void start() throws IOException {
        this.sb = new StringBuffer();
        this.write("REM INSERTING into " + this.getTableName());
        this.write(this.getLineTerminator());
        this.write("SET DEFINE OFF;");
        this.write(this.getLineTerminator());
        this.isDecSepComma = NLSProvider.getProvider(this.getWrapper().getConnection()).getDecimalSeparator() == ',';
        this.block = 0.0f;
        this.rowCount = 0L;
    }

    @Override
    public void startRow() throws IOException {
        int n = this.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (this.getColumnName(0).equals(ConnectionArb.getString("RS_MODEL_ROW_COLUMN"))) {
            n2 = 1;
        }
        if (n > n2) {
            stringBuffer.append(DBUtil.addDoubleQuote(this.getColumnName(n2)));
            ++n2;
        }
        for (int i = n2; i < n; ++i) {
            stringBuffer.append(',').append(DBUtil.addDoubleQuote(this.getColumnName(i)));
        }
        this.write("Insert into ");
        if (this.getTableName().indexOf(".") > -1) {
            this.write(this.getTableName());
        } else {
            this.write(DBUtil.addDoubleQuote(this.getTableName()));
        }
        this.write(" (" + stringBuffer + ") values (");
        ++this.rowCount;
        this.block += 1.0f;
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        String string;
        block28: {
            String string2;
            string = "";
            String string3 = string2 = n == 0 ? "" : ",";
            if (object != null) {
                int n3 = this.getDataType(n);
                if (n3 == 91) {
                    string = this.getDateFormat() == null ? string2 + "'" + this.cleanString(this.getValue(object).toString()) + "'" : string2 + "to_date('" + this.cleanString(this.getValue(object).toString()) + "','" + this.getDateFormat() + "')";
                } else if (n3 == 4 || n3 == -5 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 2 || n3 == 2 || n3 == -6 || n3 == 3) {
                    string = this.cleanString(this.getValue(object).toString());
                    if (this.isDecSepComma && !string.startsWith("'")) {
                        string = "'" + string + "'";
                    }
                    string = string2 + string;
                } else if (n3 == 93 || n3 == -102) {
                    string = string2 + "to_timestamp('" + this.getValue(object) + "','" + this.getTimeStampFormat() + "')";
                } else if (n3 == -101) {
                    string = string2 + "to_timestamp_tz('" + this.getValue(object) + "','" + this.getTimeStampTZFormat() + "')";
                } else if (n3 == 2005) {
                    if (object == null) {
                        string = string2 + " EMPTY_CLOB()";
                    } else {
                        try {
                            String string4 = this.getClobString(object);
                            string = string2 + "'" + string4 + "'";
                        }
                        catch (SQLException sQLException) {
                            string = string2 + " EMPTY_CLOB()";
                        }
                    }
                } else if (n3 == 2004) {
                    try {
                        if (object == null) {
                            string = string2 + " EMPTY_BLOB()";
                            break block28;
                        }
                        String string5 = this.getUUEncodedBlob(object);
                        string = string2 + "'" + string5 + "'";
                    }
                    catch (SQLException sQLException) {
                        string = string2 + " EMPTY_BLOB()";
                    }
                } else if (object instanceof byte[] && (n3 == -2 || n3 == -2 || n3 == -3)) {
                    String string6 = this.byteArrayToHexValue(object);
                    string = string2 + "'" + string6 + "'";
                } else if (n3 == -13) {
                    try {
                        string = string2 + " BFILENAME ('" + ((BFILE)object).getDirAlias() + "', '" + ((BFILE)object).getName() + "')";
                    }
                    catch (SQLException sQLException) {
                        throw new IOException(sQLException.getMessage());
                    }
                } else {
                    string = n3 == 2003 ? string2 + this.getValue(object).toString() : (n3 == 2002 ? string2 + this.getValue(object).toString() : string2 + "'" + this.cleanString(this.getValue(object).toString()) + "'");
                }
            } else {
                int n4 = this.getDataType(n);
                string = n4 == 2005 ? string2 + " EMPTY_CLOB()" : (n4 == 2004 ? string2 + " EMPTY_BLOB()" : string2 + "null");
            }
        }
        this.write(string);
    }

    @Override
    public String cleanString(String string) {
        String string2 = "";
        Character c = Character.valueOf('\'');
        for (int i = 0; i < string.length(); ++i) {
            Character c2 = Character.valueOf(string.charAt(i));
            string2 = c2.equals(c) ? string2 + "''" : string2 + c2;
        }
        return string2;
    }

    @Override
    public void endRow() throws IOException {
        this.write(");" + this.getLineTerminator());
        if (this.isCommit && this.commitRows > 0 && this.block == (float)this.commitRows) {
            this.write("commit;" + this.getLineTerminator());
            this.block = 0.0f;
        }
    }

    @Override
    public void end() throws IOException {
        if (this.isCommit && this.block != 0.0f) {
            this.write("commit;" + this.getLineTerminator());
        }
    }

    @Override
    public Boolean getPromptForTable() {
        return true;
    }

    @Override
    protected void write(String string) throws IOException {
        if (string != null) {
            if (this._out != null || this._zipper != null) {
                super.write(string);
            } else {
                this.sb.append(string);
            }
            this.checkAndFlush();
        }
    }

    @Override
    public boolean allowsLobs() {
        return false;
    }

    private String getClobString(Object object) throws SQLException {
        long l = ((CLOB)object).length();
        int n = (int)l;
        int n2 = (int)Math.min((long)n, l);
        String string = ((CLOB)object).getSubString(1L, n2);
        return string;
    }

    private String getUUEncodedBlob(Object object) throws SQLException {
        String string = null;
        long l = 0L;
        byte[] byArray = null;
        Connection connection = this.getConnection();
        OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{ ? = call utl_encode.uuencode(utl_raw.cast_to_raw(?),'1','uuencode.buf') }");
        oracleCallableStatement.registerOutParameter(1, -2);
        if (object instanceof BLOB) {
            l = ((BLOB)object).length();
            byArray = ((BLOB)object).getBytes(1L, (int)l);
        } else if (object instanceof Blob) {
            l = ((Blob)object).length();
            byArray = ((Blob)object).getBytes(1L, (int)l);
        }
        oracleCallableStatement.setString(2, new String(byArray));
        oracleCallableStatement.execute();
        RAW rAW = oracleCallableStatement.getRAW(1);
        string = rAW.stringValue();
        oracleCallableStatement.close();
        return string;
    }

    private String byteArrayToHexValue(Object object) {
        byte[] byArray = (byte[])object;
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isTableNameSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public boolean isTruncateSupported() {
        return true;
    }

    @Override
    public boolean isTruncate() {
        return this.isTruncate;
    }

    @Override
    public void isTruncate(boolean bl) {
        this.isTruncate = bl;
    }

    @Override
    public boolean isCommitSupported() {
        return true;
    }

    @Override
    public boolean isCommit() {
        return this.isCommit;
    }

    @Override
    public void isCommit(boolean bl) {
        this.isCommit = bl;
    }

    @Override
    public int getCommitRows() {
        return this.commitRows;
    }

    @Override
    public void setCommitRows(int n) {
        this.commitRows = n;
    }

    @Override
    public String getCommitConfigKey() {
        return COMMIT;
    }

    @Override
    public String getCommitRowsConfigKey() {
        return COMMIT_ROWS;
    }
}

