/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class JSONFormatter
extends ResultsFormatter {
    public static final String TYPE = "JSON";
    public static final String EXT = "json";

    public JSONFormatter() {
        super(TYPE, Messages.getString("JSONFormatter.0"), EXT);
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public void start() throws IOException {
        this.write("{\"items\":[\n");
    }

    @Override
    public void startRow() throws IOException {
        this.write("{");
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        if (n2 != 0) {
            this.write(",");
        }
        int n3 = this.getDataType(n);
        this.write("\"" + this.getColumnName(n).toLowerCase() + "\":");
        if (object == null) {
            this.write("null");
        } else if (n3 == 4 || n3 == -5 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 2 || n3 == 2 || n3 == -6 || n3 == 3) {
            this.write(this.getValue(object) + "");
        } else {
            this.write("\"" + this.getValue(object) + "\"");
        }
    }

    @Override
    public void endRow() throws IOException {
        this.write("}");
    }

    @Override
    public void end() throws IOException {
        this.write("]}");
    }
}

