/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.rtf.RTFEditorKit;
import oracle.dbtools.raptor.datatypes.blob.BlobMimeXmlParser;
import oracle.dbtools.raptor.format.FormatterResources;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportAsianFonts;
import oracle.dbtools.raptor.format.ReportFonts;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.format.ReportPatternInfo;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.ZipFileWriter;
import oracle.ide.Ide;
import oracle.ide.print.PrintManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class PDFFormatter
extends ResultsFormatter {
    public static final String TYPE = "PDF";
    public static final String EXT = "pdf";
    private static final int INCH = 72;
    private static final int MIN_CONTENT_SPACE = 144;
    private static final int ROWHEIGHT_OFFSET = 36;
    private Document _pdfDocument = null;
    private PdfPTable _pdfTable = null;
    private PdfWriter _pdfWriter = null;
    private PDFFormatOptions _pdfOptions = null;
    private PdfAnnotation _pdfAnnotation = null;
    private CustomHeaderFooter _customHeaderFooter = null;
    private boolean _includeCustomHeader = false;
    private boolean _includeCustomFooter = false;
    private Calendar _today = null;
    private Font _font = null;
    private boolean _isInitPDF = true;
    private int _tableCounter = 0;
    private boolean _isAbsoluteColWidth = true;
    private boolean _isDataExist = false;
    private boolean _isRepeatColumnHeaders = false;
    private boolean _isRepeatColumnFooters = false;
    private boolean _isSplitTableVertically = false;
    private ArrayList<Integer> _columnsPerPage = null;
    private float _contentSpace = 0.0f;
    private String _tableName = null;
    private int _rowNum = 0;
    private int _pageNum = 1;
    private String _blobDirRelativePath = null;
    private String _blobDirAbsolutePath = null;
    private ArrayList<String> _fileList = null;
    private ArrayList<String> _entryList = null;
    private String _blobName = null;
    private com.itextpdf.text.Image _linkImage = null;
    private Rectangle _pageSize = null;
    private ArrayList<String> _sampleColumns = null;
    private boolean _useSampleCols = false;
    private String _tmpTitle;
    private String _tmpSubject;
    private String _tmpKeywords;
    private String _errorMsg = null;

    public PDFFormatter() {
        super(TYPE, FormatterResources.getString("PDF_FORMAT"), EXT);
    }

    @Override
    public void start() throws IOException {
        try {
            this._rowNum = 0;
            this._pageNum = 1;
            this._isDataExist = false;
            this._isRepeatColumnHeaders = false;
            this._isRepeatColumnFooters = false;
            this._pageSize = null;
            this._errorMsg = null;
            if (this._isInitPDF) {
                this._today = Calendar.getInstance();
                this.initPDFDocument();
            }
            this.initTable();
            this.initColumnHeadersFooters();
            if (!this.isContentSpaceAvailable()) {
                String string = this.getNoContentSpaceMessage();
                throw new IOException(string);
            }
            if (!this._pdfDocument.isOpen()) {
                this._pdfDocument.open();
                if (!this._isSplitTableVertically && (this._includeCustomHeader || this._includeCustomFooter)) {
                    this.createHeaderFooterEvent();
                }
            }
        }
        catch (Exception exception) {
            this.cleanUpPDF();
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void startRow() throws IOException {
        if (!this._isDataExist) {
            this._isDataExist = true;
        }
        ++this._rowNum;
        if (this._isSplitTableVertically) {
            this.alterRowShading();
        }
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        try {
            if (object == null) {
                this._pdfTable.addCell("");
            } else if (object instanceof Blob) {
                PDFFormatOptions.BLOB_ACTION bLOB_ACTION = this._pdfOptions.getBlobAction();
                switch (bLOB_ACTION) {
                    case EMBED: {
                        this.embedBlobIntoPDF(object, n);
                        break;
                    }
                    case LINK: {
                        this.linkToBlob(object, n);
                        break;
                    }
                    default: {
                        this._pdfTable.addCell("");
                        break;
                    }
                }
            } else {
                Object object2 = this.getValue(object);
                if (object2 != null) {
                    this._pdfTable.addCell(new Phrase(this.getValue(object).toString(), this._font));
                } else {
                    this._pdfTable.addCell("");
                }
            }
        }
        catch (Exception exception) {
            this.cleanUpPDF();
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void endRow() throws IOException {
        try {
            if (this._isSplitTableVertically && this._pdfTable.getTotalHeight() > this._contentSpace) {
                float f = this._pdfTable.getRowHeight(this._pdfTable.getRows().size() - 1);
                if (f > 36.0f) {
                    this.writeSplittedRows();
                } else {
                    this.writeRows();
                }
            }
        }
        catch (Exception exception) {
            this.cleanUpPDF();
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void end() throws IOException {
        try {
            if (this._isSplitTableVertically) {
                if (!this._isDataExist) {
                    this.addEmptyCells();
                    this.writeRows();
                } else {
                    ArrayList arrayList = this._pdfTable.getRows();
                    if (arrayList != null && arrayList.size() > this._pdfTable.getHeaderRows()) {
                        this.writeRows();
                    }
                }
            } else {
                if (!this._isDataExist) {
                    this.addEmptyCells();
                }
                this._pdfDocument.add((Element)this._pdfTable);
            }
            ++this._tableCounter;
        }
        catch (Exception exception) {
            this.cleanUpPDF();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw new IOException(exception);
        }
        finally {
            this._isSplitTableVertically = false;
        }
    }

    @Override
    public boolean isStreamHandler() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStream() {
        try {
            if (this._pdfDocument != null) {
                this.closeDocument();
                if (this._pdfOptions.getBlobAction() == PDFFormatOptions.BLOB_ACTION.LINK && this._pdfOptions.isCreateZipFile() && (this._entryList != null || this._fileList != null)) {
                    ZipFileWriter zipFileWriter = new ZipFileWriter();
                    File file = new File(this.getFileName());
                    String string = file.getName();
                    int n = string.lastIndexOf(".");
                    if (n != -1) {
                        string = file.getParent() + File.separator + string.substring(0, n) + FormatterResources.getString("ZIP");
                    }
                    zipFileWriter.createZipFile(string, this._fileList, this._entryList, true);
                    file = new File(this._blobDirAbsolutePath);
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            this.reInit();
        }
    }

    public void setPDFFormatOptions(PDFFormatOptions pDFFormatOptions) {
        this._pdfOptions = pDFFormatOptions;
    }

    @Override
    public void setTableName(String string) {
        this._tableName = string;
    }

    private String getTableName() {
        return this._tableName;
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isTextEditorReadable() {
        return false;
    }

    public void setTempTitle(String string) {
        this._tmpTitle = string;
    }

    public void setTempSubject(String string) {
        this._tmpSubject = string;
    }

    public void setTempKeywords(String string) {
        this._tmpKeywords = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int validateOptions() {
        int n = 0;
        try {
            if (!this.isValidContentSpace()) {
                this.setValidationMessage(this.getNoContentSpaceMessage());
                n = 1;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            this.reInit();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidContentSpace() {
        this._useSampleCols = true;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this._pageSize = this._pdfOptions.getOrientation() == 1 ? PageSize.LETTER : PageSize.LETTER.rotate();
        float f4 = this._pageSize.getHeight() - this._pdfOptions.getTopMargin() - this._pdfOptions.getBottomMargin() - 36.0f;
        f4 = f4 - (float)this._pdfOptions.getSpacingBeforeTable() - (float)this._pdfOptions.getSpacingAfterTable();
        try {
            this._customHeaderFooter = new CustomHeaderFooter();
            if (this._pdfOptions.isInsertHeader() && this._pdfOptions.getHeader() != null) {
                f = this.getHeaderFooterRowHeight(this._pdfOptions.getHeader());
            }
            if (this._pdfOptions.isInsertFooter() && this._pdfOptions.getFooter() != null) {
                f2 = this.getHeaderFooterRowHeight(this._pdfOptions.getFooter());
            }
            f4 = f4 - f - f2;
            this.createSampleHeaderFooter();
            if (this._pdfTable != null) {
                f3 = this._pdfTable.getHeaderHeight() + this._pdfTable.getFooterHeight();
            }
            if ((f4 -= f3) >= 144.0f) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            this._useSampleCols = false;
        }
        return false;
    }

    private void createSampleHeaderFooter() {
        if (this._sampleColumns == null || this._sampleColumns.isEmpty()) {
            this._sampleColumns = new ArrayList();
            this._sampleColumns.add(FormatterResources.getString("SAMPLE_COLUMN_1"));
            this._sampleColumns.add(FormatterResources.getString("SAMPLE_COLUMN_3"));
        }
        try {
            this._pdfTable = new PdfPTable(this._sampleColumns.size());
            this._pdfTable.setTotalWidth(new float[]{72.0f, 144.0f});
            this._pdfTable.setLockedWidth(true);
            this.assignPDFTableOptions();
            this.initColumnHeadersFooters();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void initTable() throws Exception {
        try {
            if (this._tableCounter > 0) {
                this._pdfDocument.newPage();
            }
            this._pdfTable = new PdfPTable(this.getColumnCount());
            if (this._isAbsoluteColWidth) {
                this._pdfTable.setTotalWidth(this.getColumnWidths());
                this._pdfTable.setLockedWidth(true);
                if (this._pdfTable.getTotalWidth() > this.getAvailablePageWidth()) {
                    this._isSplitTableVertically = true;
                    this.calculateNumberOfColumnsPerPage();
                }
            } else {
                this._pdfTable.setTotalWidth((float)PrintManager.getPrintManager().getPageFormat().getImageableWidth());
                this._pdfTable.setLockedWidth(true);
                this._pdfTable.setWidths(this.getColumnWidths());
            }
            this._contentSpace = this._pdfDocument.getPageSize().getHeight() - this._pdfOptions.getTopMargin() - this._pdfOptions.getBottomMargin() - 36.0f;
            if (this._includeCustomHeader || this._includeCustomFooter) {
                float f = this._pdfOptions.getTopMargin();
                float f2 = this._pdfOptions.getBottomMargin();
                float f3 = 0.0f;
                float f4 = 0.0f;
                if (this._includeCustomHeader) {
                    f3 = this.getHeaderFooterRowHeight(this._pdfOptions.getHeader());
                    if (f3 > 0.0f) {
                        f = this._pdfOptions.getSpacingBeforeTable() > 0 ? this._pdfOptions.getTopMargin() + f3 + (float)this._pdfOptions.getSpacingBeforeTable() : this._pdfOptions.getTopMargin() + f3 + 1.0f;
                    }
                } else if (this._pdfOptions.getSpacingBeforeTable() > 0) {
                    f = this._pdfOptions.getTopMargin() + (float)this._pdfOptions.getSpacingBeforeTable();
                }
                if (this._includeCustomFooter) {
                    f4 = this.getHeaderFooterRowHeight(this._pdfOptions.getFooter());
                    if (f4 > 0.0f) {
                        f2 = this._pdfOptions.getSpacingAfterTable() > 0 ? this._pdfOptions.getBottomMargin() + f4 + (float)this._pdfOptions.getSpacingAfterTable() : this._pdfOptions.getBottomMargin() + f4 + 1.0f;
                    }
                } else if (this._pdfOptions.getSpacingAfterTable() > 0) {
                    f2 = this._pdfOptions.getBottomMargin() + (float)this._pdfOptions.getSpacingAfterTable();
                }
                this._contentSpace = this._contentSpace - f3 - f4 - (float)this._pdfOptions.getSpacingBeforeTable() - (float)this._pdfOptions.getSpacingAfterTable();
                if (!this._isSplitTableVertically) {
                    this._pdfDocument.setMargins(this._pdfOptions.getLeftMargin(), this._pdfOptions.getRightMargin(), f, f2);
                }
            }
            this.assignPDFTableOptions();
            if (!this._isSplitTableVertically && this._pdfOptions.isUseRowShading()) {
                RowShadingEvent rowShadingEvent = new RowShadingEvent(this._pdfOptions.getOddRowShading(), this._pdfOptions.getEvenRowShading());
                this._pdfTable.setTableEvent((PdfPTableEvent)rowShadingEvent);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw exception;
        }
    }

    private void assignPDFTableOptions() {
        ReportFormatOptions.HORIZONTAL_ALIGNMENT hORIZONTAL_ALIGNMENT = this._pdfOptions.getTableHorizontalAlignment();
        switch (hORIZONTAL_ALIGNMENT) {
            case CENTER: {
                this._pdfTable.setHorizontalAlignment(1);
                break;
            }
            case RIGHT: {
                this._pdfTable.setHorizontalAlignment(2);
                break;
            }
            default: {
                this._pdfTable.setHorizontalAlignment(0);
            }
        }
        this._pdfTable.setSpacingBefore((float)this._pdfOptions.getSpacingBeforeTable());
        this._pdfTable.setSpacingAfter((float)this._pdfOptions.getSpacingAfterTable());
        ReportFormatOptions.HORIZONTAL_ALIGNMENT hORIZONTAL_ALIGNMENT2 = this._pdfOptions.getCellHorizontalAlignment();
        switch (hORIZONTAL_ALIGNMENT2) {
            case CENTER: {
                this._pdfTable.getDefaultCell().setHorizontalAlignment(1);
                break;
            }
            case RIGHT: {
                this._pdfTable.getDefaultCell().setHorizontalAlignment(2);
                break;
            }
            default: {
                this._pdfTable.getDefaultCell().setHorizontalAlignment(0);
            }
        }
        ReportFormatOptions.VERTICAL_ALIGNMENT vERTICAL_ALIGNMENT = this._pdfOptions.getCellVerticalAlignment();
        switch (vERTICAL_ALIGNMENT) {
            case MIDDLE: {
                this._pdfTable.getDefaultCell().setVerticalAlignment(5);
                break;
            }
            case BOTTOM: {
                this._pdfTable.getDefaultCell().setVerticalAlignment(6);
                break;
            }
            default: {
                this._pdfTable.getDefaultCell().setVerticalAlignment(4);
            }
        }
        this._pdfTable.getDefaultCell().setPaddingLeft((float)this._pdfOptions.getCellPaddingLeft());
        this._pdfTable.getDefaultCell().setPaddingRight((float)this._pdfOptions.getCellPaddingRight());
        this._pdfTable.getDefaultCell().setPaddingTop((float)this._pdfOptions.getCellPaddingTop());
        this._pdfTable.getDefaultCell().setPaddingBottom((float)this._pdfOptions.getCellPaddingBottom());
        this._pdfTable.getDefaultCell().setNoWrap(!this._pdfOptions.isWrapText());
        if (this._pdfOptions.isShowAllBorders()) {
            this._pdfTable.getDefaultCell().setBorderColor(new BaseColor(this._pdfOptions.getBorderColor()));
        } else {
            this._pdfTable.getDefaultCell().setBorder(0);
        }
    }

    private void createColumnHeadings() throws Exception {
        Font font;
        if (this._pdfOptions.getHeaderFontName() == null) {
            this._pdfOptions.setHeaderFontName(ReportFonts.getDefaultFontName(this._pdfOptions.getFontLocations()));
        }
        if ((font = this.getFont(this._pdfOptions.getHeaderFontName(), this._pdfOptions.getHeaderFontSize(), this._pdfOptions.getHeaderFontStyle(), this._pdfOptions.getHeaderFontColor())) == null) {
            final String string = this._errorMsg != null ? this._errorMsg : FormatterResources.format("FONT_REGISTER_ERROR", this._pdfOptions.getHeaderFontName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)FormatterResources.getString("PDF_FORMAT"), null);
                }
            });
            throw new Exception(string);
        }
        this._pdfTable.getDefaultCell().setBackgroundColor(new BaseColor(this._pdfOptions.getHeaderRowShading()));
        if (this._useSampleCols) {
            for (String string : this._sampleColumns) {
                this._pdfTable.addCell(new Phrase(string, font));
            }
        } else {
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this._pdfTable.addCell(new Phrase(this.getColumnName(i), font));
            }
        }
    }

    private void createColumnFootings() throws Exception {
        Font font;
        if (this._pdfOptions.getFooterFontName() == null) {
            this._pdfOptions.setFooterFontName(ReportFonts.getDefaultFontName(this._pdfOptions.getFontLocations()));
        }
        if ((font = this.getFont(this._pdfOptions.getFooterFontName(), this._pdfOptions.getFooterFontSize(), this._pdfOptions.getFooterFontStyle(), this._pdfOptions.getFooterFontColor())) == null) {
            final String string = this._errorMsg != null ? this._errorMsg : FormatterResources.format("FONT_REGISTER_ERROR", this._pdfOptions.getFooterFontName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)FormatterResources.getString("PDF_FORMAT"), null);
                }
            });
            throw new Exception(string);
        }
        this._pdfTable.getDefaultCell().setBackgroundColor(new BaseColor(this._pdfOptions.getFooterRowShading()));
        if (this._useSampleCols) {
            for (String string : this._sampleColumns) {
                this._pdfTable.addCell(new Phrase(string, font));
            }
        } else {
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this._pdfTable.addCell(new Phrase(this.getColumnName(i), font));
            }
        }
    }

    private void initColumnHeadersFooters() throws Exception {
        try {
            this._isRepeatColumnHeaders = false;
            this._isRepeatColumnFooters = false;
            ReportFormatOptions.COLUMN_LABELING cOLUMN_LABELING = this._pdfOptions.getColumnHeadingsAction();
            ReportFormatOptions.COLUMN_LABELING cOLUMN_LABELING2 = this._pdfOptions.getColumnFootingsAction();
            if (cOLUMN_LABELING == ReportFormatOptions.COLUMN_LABELING.ALL_PAGES || cOLUMN_LABELING2 == ReportFormatOptions.COLUMN_LABELING.ALL_PAGES) {
                int n = 0;
                if (cOLUMN_LABELING == ReportFormatOptions.COLUMN_LABELING.ALL_PAGES) {
                    this.createColumnHeadings();
                    ++n;
                    this._isRepeatColumnHeaders = true;
                }
                if (cOLUMN_LABELING2 == ReportFormatOptions.COLUMN_LABELING.ALL_PAGES) {
                    this.createColumnFootings();
                    ++n;
                    this._isRepeatColumnFooters = true;
                }
                this._pdfTable.setHeaderRows(n);
                if (cOLUMN_LABELING2 == ReportFormatOptions.COLUMN_LABELING.ALL_PAGES) {
                    this._pdfTable.setFooterRows(1);
                }
            }
            if (cOLUMN_LABELING == ReportFormatOptions.COLUMN_LABELING.FIRST_PAGE) {
                this.createColumnHeadings();
            }
            this._pdfTable.getDefaultCell().setBackgroundColor(null);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw exception;
        }
    }

    private void initPDFDocument() throws Exception {
        try {
            if (this._pdfOptions == null) {
                throw new Exception("Error, pdfOptions is NULL!");
            }
            if (this._pdfOptions.getFontName() == null) {
                this._pdfOptions.setFontName(ReportFonts.getDefaultFontName(this._pdfOptions.getFontLocations()));
            }
            this._font = this.getFont(this._pdfOptions.getFontName(), this._pdfOptions.getFontSize(), this._pdfOptions.getFontStyle(), this._pdfOptions.getFontColor());
            if (this._font == null) {
                final String string = this._errorMsg != null ? this._errorMsg : FormatterResources.format("FONT_REGISTER_ERROR", this._pdfOptions.getFontName());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)FormatterResources.getString("PDF_FORMAT"), null);
                    }
                });
                throw new Exception(string);
            }
            this._tableCounter = 0;
            this._pdfDocument = new Document();
            this._pdfWriter = PdfWriter.getInstance((Document)this._pdfDocument, (OutputStream)this.getOutputStream());
            if (this._pdfOptions.getPaperSize() == ReportFormatOptions.PAPER_SIZE.LETTER) {
                if (this._pdfOptions.getOrientation() == 1) {
                    this._pdfDocument.setPageSize(PageSize.LETTER);
                } else {
                    this._pdfDocument.setPageSize(PageSize.LETTER.rotate());
                }
            } else if (this._pdfOptions.getOrientation() == 1) {
                this._pdfDocument.setPageSize(PageSize.LEGAL);
            } else {
                this._pdfDocument.setPageSize(PageSize.LEGAL.rotate());
            }
            this._pdfDocument.setMargins(this._pdfOptions.getLeftMargin(), this._pdfOptions.getRightMargin(), this._pdfOptions.getTopMargin(), this._pdfOptions.getBottomMargin());
            if (this._tmpTitle != null) {
                this._pdfDocument.addTitle(this._tmpTitle);
            }
            if (this._pdfOptions.getAuthor() != null) {
                this._pdfDocument.addAuthor(this._pdfOptions.getAuthor());
            }
            if (this._tmpSubject != null) {
                this._pdfDocument.addSubject(this._tmpSubject);
            }
            if (this._tmpKeywords != null) {
                this._pdfDocument.addKeywords(this._tmpKeywords);
            }
            if (this._pdfOptions.getProductNameVersion() != null) {
                this._pdfDocument.addCreator(this._pdfOptions.getProductNameVersion());
            }
            PDFFormatOptions.PDF_COMPATIBILITY pDF_COMPATIBILITY = this._pdfOptions.getSupportedVersion();
            switch (pDF_COMPATIBILITY) {
                case VERSION_1_5: {
                    this._pdfWriter.setPdfVersion('5');
                    break;
                }
                case VERSION_1_6: {
                    this._pdfWriter.setPdfVersion('6');
                    break;
                }
                default: {
                    this._pdfWriter.setPdfVersion('7');
                }
            }
            PDFFormatOptions.COMPRESSION_LEVEL cOMPRESSION_LEVEL = this._pdfOptions.getCompressionLevel();
            switch (cOMPRESSION_LEVEL) {
                case NONE: {
                    this._pdfWriter.setCompressionLevel(0);
                    break;
                }
                case ENTIRE_FILE: {
                    this._pdfWriter.setFullCompression();
                    break;
                }
                default: {
                    this._pdfWriter.setCompressionLevel(9);
                }
            }
            if (this._pdfOptions.isSecurityAllowed()) {
                byte[] byArray = null;
                if (this._pdfOptions.isOpenPasswordRequired()) {
                    byArray = this._pdfOptions.getOpenPassword().getBytes(this.getEncode());
                }
                int n = 0;
                int n2 = 0;
                byte[] byArray2 = null;
                PDFFormatOptions.ENCRYPTION_LEVEL eNCRYPTION_LEVEL = this._pdfOptions.getEncryptionLevel();
                switch (eNCRYPTION_LEVEL) {
                    case ENTIRE_CONTENT: {
                        n2 = 2;
                        break;
                    }
                    default: {
                        n2 = 10;
                    }
                }
                if (this._pdfOptions.isPermissionsAllowed()) {
                    byArray2 = this._pdfOptions.getPermissionPassword().getBytes(this.getEncode());
                    if (this._pdfOptions.isPrintingAllowed()) {
                        n |= 0x804;
                    }
                    if (this._pdfOptions.isCopyingAllowed()) {
                        n |= 0x10;
                    }
                    if (this._pdfOptions.isUpdatingAllowed()) {
                        n = n | 8 | 0x400;
                    }
                    if (this._pdfOptions.isAccessibleDevicesCopyingAllowed()) {
                        n |= 0x200;
                    }
                }
                this._pdfWriter.setEncryption(byArray, byArray2, n, n2);
            }
            this._includeCustomHeader = this._pdfOptions.isInsertHeader() && this._pdfOptions.getHeader() != null;
            boolean bl = this._includeCustomFooter = this._pdfOptions.isInsertFooter() && this._pdfOptions.getFooter() != null;
            if (this._includeCustomHeader || this._includeCustomFooter) {
                this._customHeaderFooter = new CustomHeaderFooter();
                this._customHeaderFooter.initialize(this._pdfOptions);
            }
            this._isInitPDF = false;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw exception;
        }
    }

    private Font getFont(String string, int n, ReportFormatOptions.FONT_STYLE fONT_STYLE, int n2) throws Exception {
        try {
            if (ReportAsianFonts.isVendorAsianJar(this._pdfOptions.getExternalLibrary())) {
                URL uRL = this.getClass().getResource("/com/itextpdf/text/pdf/fonts/cjkfonts.properties");
                if (uRL == null) {
                    this._errorMsg = ReportAsianFonts.asianJarRequiredMessage(this._pdfOptions.getExternalLibrary());
                    return null;
                }
                return this.getAsianFont(string, n, fONT_STYLE, n2);
            }
            if (!this.isFontAvailable(string)) {
                this._errorMsg = FormatterResources.format("FONT_REGISTER_ERROR", string);
                return null;
            }
            ReportFormatOptions.FONT_STYLE fONT_STYLE2 = fONT_STYLE;
            int n3 = 0;
            switch (fONT_STYLE2) {
                case BOLD: {
                    n3 = 1;
                    break;
                }
                case ITALIC: {
                    n3 = 2;
                    break;
                }
                case BOLDITALIC: {
                    n3 = 3;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            Font font = null;
            if (ReportFonts.isDefaultJavaLogicalFont(string)) {
                int n4 = 0;
                switch (n3) {
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 3: {
                        n4 = 3;
                        break;
                    }
                    default: {
                        n4 = 0;
                    }
                }
                java.awt.Font font2 = new java.awt.Font(string, n4, n);
                DefaultFontMapper defaultFontMapper = new DefaultFontMapper();
                BaseFont baseFont = defaultFontMapper.awtToPdf(font2);
                font = new Font(baseFont);
                if (font == null) {
                    return null;
                }
                font.setColor(new BaseColor(n2));
            } else {
                boolean bl = this._pdfOptions.isEmbedFonts();
                font = FontFactory.getFont((String)string, (String)this.getEncode(), (boolean)bl, (float)n, (int)n3, (BaseColor)new BaseColor(n2));
            }
            return font;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw exception;
        }
    }

    private Font getAsianFont(String string, int n, ReportFormatOptions.FONT_STYLE fONT_STYLE, int n2) throws Exception {
        String string2 = string;
        if (string == null || !ReportAsianFonts.isVendorAsianFont(string)) {
            string2 = "STSong-Light";
        }
        String string3 = ReportAsianFonts.getAsianFontStyle(string2, fONT_STYLE);
        try {
            BaseFont baseFont = BaseFont.createFont((String)string3, (String)ReportAsianFonts.getFontDirection(string2), (boolean)false);
            Font font = new Font(baseFont, (float)n);
            font.setColor(new BaseColor(n2));
            return font;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            throw exception;
        }
    }

    private boolean isFontAvailable(String string) {
        if (FontFactory.isRegistered((String)string)) {
            return true;
        }
        ReportFonts.registerFonts(this._pdfOptions.getFontLocations());
        return ReportFonts.isFontAvailable(string);
    }

    private float[] getColumnWidths() {
        float[] fArray = new float[this.getColumnCount()];
        block6: for (int i = 0; i < fArray.length; ++i) {
            int n = this.getDataType(i);
            switch (n) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    fArray[i] = this._isAbsoluteColWidth ? 72 : 1;
                    continue block6;
                }
                case 2004: {
                    this._blobName = FormatterResources.getString("BLOB");
                    if (this._pdfOptions.getBlobAction() == PDFFormatOptions.BLOB_ACTION.EMBED || this._pdfOptions.getBlobAction() == PDFFormatOptions.BLOB_ACTION.LINK) {
                        fArray[i] = this._isAbsoluteColWidth ? 72 : 1;
                        continue block6;
                    }
                    fArray[i] = this._isAbsoluteColWidth ? 72 : 1;
                    continue block6;
                }
                case 12: {
                    fArray[i] = this._isAbsoluteColWidth ? 144 : 2;
                    continue block6;
                }
                case 91: {
                    fArray[i] = this._isAbsoluteColWidth ? 144 : 2;
                    continue block6;
                }
                default: {
                    fArray[i] = this._isAbsoluteColWidth ? 72 : 1;
                }
            }
        }
        return fArray;
    }

    private void calculateNumberOfColumnsPerPage() {
        this._columnsPerPage = new ArrayList();
        float f = this._pdfDocument.getPageSize().getWidth() - this._pdfOptions.getLeftMargin() - this._pdfOptions.getRightMargin();
        float[] fArray = this._pdfTable.getAbsoluteWidths();
        if (this._pdfTable.getTotalWidth() > f) {
            float f2 = 0.0f;
            int n = 0;
            for (int i = 0; i < fArray.length; ++i) {
                if ((f2 += fArray[i]) > f) {
                    this._columnsPerPage.add(new Integer(n));
                    f2 = fArray[i];
                    n = 1;
                    continue;
                }
                ++n;
            }
            this._columnsPerPage.add(new Integer(-1));
        }
    }

    private void writeRows() {
        PdfPTable pdfPTable = null;
        PdfPTable pdfPTable2 = null;
        float f = (float)PrintManager.getPrintManager().getPageFormat().getImageableX();
        float f2 = 0.0f;
        float f3 = 0.0f;
        this._pdfTable.completeRow();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this._isRepeatColumnHeaders) {
            n3 = 0;
            ++n5;
            if (this._isRepeatColumnFooters) {
                n4 = 1;
                ++n5;
            }
        } else if (this._isRepeatColumnFooters) {
            n4 = 0;
            ++n5;
        }
        for (Integer n6 : this._columnsPerPage) {
            f2 = this._pdfDocument.getPageSize().getHeight() - this._pdfOptions.getTopMargin();
            if (this._includeCustomHeader && (pdfPTable = this._customHeaderFooter.getHeaderTable(this._pdfWriter, (int)this.getAvailablePageWidth(), this._pageNum)) != null) {
                f2 = pdfPTable.writeSelectedRows(0, -1, f, f2, this._pdfWriter.getDirectContent());
            }
            f2 -= (float)this._pdfOptions.getSpacingBeforeTable();
            n2 = n6 != -1 ? n + n6 : n6;
            if (this._isRepeatColumnHeaders) {
                f2 = this._pdfTable.writeSelectedRows(n, n2, n3, 1, f, f2, this._pdfWriter.getDirectContent());
            }
            f2 = this._pdfTable.writeSelectedRows(n, n2, n5, -1, f, f2, this._pdfWriter.getDirectContent());
            if (this._isRepeatColumnFooters) {
                f2 = this._pdfTable.writeSelectedRows(n, n2, n4, n4 + 1, f, f2, this._pdfWriter.getDirectContent());
            }
            if (this._includeCustomFooter && (pdfPTable2 = this._customHeaderFooter.getFooterTable(this._pdfWriter, (int)this.getAvailablePageWidth(), this._pageNum)) != null) {
                f3 = this._pdfOptions.getBottomMargin() + pdfPTable2.getRowHeight(pdfPTable2.getRows().size() - 1);
                if (f3 < f2) {
                    f2 = f3;
                }
                f2 = pdfPTable2.writeSelectedRows(0, -1, f, f2, this._pdfWriter.getDirectContent());
            }
            this._pdfDocument.newPage();
            ++this._pageNum;
            n = n2;
        }
        this._pdfTable.deleteBodyRows();
        this._rowNum = 0;
    }

    private void writeSplittedRows() {
        float f = 0.0f;
        boolean bl = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        float f4 = 0.0f;
        float f5 = 0.0f;
        while (this._pdfTable.getTotalHeight() > this._contentSpace && !bl) {
            f2 = this._pdfTable.getTotalHeight();
            PdfPRow pdfPRow = null;
            PdfPRow pdfPRow2 = this._pdfTable.getRow(this._pdfTable.getRows().size() - 1);
            f4 = pdfPRow2.getMaxHeights();
            f = this._contentSpace - (this._pdfTable.getTotalHeight() - pdfPRow2.getMaxHeights());
            pdfPRow = pdfPRow2.splitRow(this._pdfTable, this._pdfTable.getRows().size() - 1, f);
            f5 = pdfPRow2.getMaxHeights();
            if (f5 == f4 || pdfPRow == null || f5 > f) {
                pdfPRow = new PdfPRow(pdfPRow2);
                this._pdfTable.deleteLastRow();
            }
            this.writeRows();
            if (pdfPRow != null) {
                PdfPCell[] pdfPCellArray;
                ++this._rowNum;
                for (PdfPCell pdfPCell : pdfPCellArray = pdfPRow.getCells()) {
                    this.alterRowShading(pdfPCell);
                    this._pdfTable.addCell(pdfPCell);
                }
                f3 = this._pdfTable.getTotalHeight();
                if (f2 == f3) {
                    if (n == 3) {
                        bl = true;
                    }
                    ++n;
                    continue;
                }
                if (n <= 0) continue;
                n = 0;
                continue;
            }
            bl = true;
        }
    }

    private boolean embedBlobIntoPDF(Object object, int n) {
        if (object == null) {
            return false;
        }
        BlobMimeXmlParser blobMimeXmlParser = null;
        Phrase phrase = null;
        try {
            if (object instanceof Blob) {
                blobMimeXmlParser = new BlobMimeXmlParser(((Blob)object).getBinaryStream());
                if (!blobMimeXmlParser.isMimeTypeSupported() || blobMimeXmlParser.getExtension() == null || blobMimeXmlParser.getExtension().isEmpty()) {
                    phrase = new Phrase(this.getUnsupportedType(object, n), this._font);
                    this._pdfTable.addCell(phrase);
                    return false;
                }
            } else {
                this._pdfTable.addCell(new Phrase(this.getUnsupportedType(object, n), this._font));
                this._pdfTable.addCell(phrase);
                return false;
            }
            String string = this.getFileName(blobMimeXmlParser.getExtension());
            byte[] byArray = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
            this._pdfAnnotation = PdfAnnotation.createFileAttachment((PdfWriter)this._pdfWriter, null, (String)blobMimeXmlParser.getDescription(), (byte[])byArray, null, (String)string);
            this._pdfAnnotation.setTitle(FormatterResources.getString("BLOB_TYPE"));
            this._pdfAnnotation.put(PdfName.NAME, (PdfObject)new PdfString("Paperclip"));
            phrase = new Phrase();
            String string2 = this._blobName + "  ";
            Chunk chunk = new Chunk(string2, this._font);
            phrase.add((Element)chunk);
            chunk = new Chunk("\u00a0\u00a0");
            chunk.setAnnotation(this._pdfAnnotation);
            phrase.add((Element)chunk);
            this._pdfTable.addCell(phrase);
            return true;
        }
        catch (SQLException sQLException) {
            this._pdfTable.addCell(new Phrase(this.getUnsupportedType(object, n), this._font));
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
        catch (IOException iOException) {
            this._pdfTable.addCell(new Phrase(this.getUnsupportedType(object, n), this._font));
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return false;
        }
    }

    private String getFileName(String string) {
        Random random = new Random();
        int n = random.nextInt(99999999);
        n = Math.abs(n);
        String string2 = Integer.toString(n) + "." + string;
        return string2;
    }

    private String getUnsupportedType(Object object, int n) {
        if (object instanceof Blob) {
            StringBuffer stringBuffer = new StringBuffer(this._blobName);
            stringBuffer.append("  ").append(FormatterResources.getString("TYPE_UNSUPPORTED"));
            return stringBuffer.toString();
        }
        return FormatterResources.getString("TYPE_UNSUPPORTED");
    }

    private boolean linkToBlob(Object object, int n) {
        if (object == null) {
            return false;
        }
        BlobMimeXmlParser blobMimeXmlParser = null;
        Phrase phrase = null;
        try {
            if (object instanceof Blob) {
                Image image;
                blobMimeXmlParser = new BlobMimeXmlParser(((Blob)object).getBinaryStream());
                if (!blobMimeXmlParser.isMimeTypeSupported() || blobMimeXmlParser.getExtension() == null || blobMimeXmlParser.getExtension().isEmpty()) {
                    phrase = new Phrase(this.getUnsupportedType(object, n), this._font);
                    this._pdfTable.addCell(phrase);
                    return false;
                }
                String string = this.getFileName(blobMimeXmlParser.getExtension());
                if (this._blobDirAbsolutePath == null) {
                    if (this._pdfOptions.isCreateZipFile()) {
                        this._fileList = new ArrayList();
                        this._entryList = new ArrayList();
                    }
                    this.createBlobDirectory();
                }
                String string2 = this._blobDirAbsolutePath + File.separator + string;
                URI uRI = this.createBlobFile(((Blob)object).getBinaryStream(), string2);
                if (uRI == null) {
                    return false;
                }
                if (this._linkImage == null) {
                    image = ((ImageIcon)OracleIcons.getIcon((String)"link.png")).getImage();
                    try {
                        if (image != null) {
                            this._linkImage = com.itextpdf.text.Image.getInstance((Image)image, null);
                            this._linkImage.scaleToFit(16.0f, 16.0f);
                            this._linkImage.setAlignment(1);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                phrase = new Phrase();
                image = null;
                image = new Chunk(this._blobName, this._font);
                if (this._linkImage != null) {
                    phrase.add((Element)image);
                    image = new Chunk(this._linkImage, 0.0f, 0.0f);
                }
                image.setAction(new PdfAction(uRI.toString()));
                phrase.add((Element)image);
                this._pdfTable.addCell(phrase);
                if (this._pdfOptions.isCreateZipFile()) {
                    this._fileList.add(string2);
                    this._entryList.add(this._blobDirRelativePath.substring(2) + File.separator + string);
                }
            } else {
                this._pdfTable.addCell(new Phrase(this.getUnsupportedType(object, n), this._font));
                this._pdfTable.addCell(phrase);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this._pdfTable.addCell(new Phrase(this.getUnsupportedType(object, n), this._font));
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return false;
        }
    }

    private void createBlobDirectory() throws IOException {
        String string;
        File file;
        if (this.getFileName() == null) {
            throw new IOException(FormatterResources.getString("FILE_MISSING_ERROR"));
        }
        File file2 = new File(this.getFileName());
        String string2 = file2.getName();
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((file = new File(string = file2.getParent() + File.separator + string2 + FormatterResources.getString("BLOB_DIR"))).exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (File file3 : fileArray) {
                    file3.delete();
                }
            }
        } else {
            file.mkdir();
            file.setReadable(true);
            file.setWritable(true);
        }
        this._blobDirAbsolutePath = file.getAbsolutePath();
        this._blobDirRelativePath = "." + File.separator + file.getName();
        if (this._pdfOptions.isCreateZipFile()) {
            this._fileList.add(this.getFileName());
            this._entryList.add(file2.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI createBlobFile(InputStream inputStream, String string) throws IOException {
        File file = new File(string);
        URI uRI = file.toURI();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            if (inputStream != null) {
                byte[] byArray = new byte[256];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
            uRI = null;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException(iOException);
                }
            }
        }
        return uRI;
    }

    private void addEmptyCells() {
        int n = this.getColumnCount();
        this._pdfTable.getDefaultCell().setBorder(0);
        for (int i = 0; i < n; ++i) {
            this._pdfTable.addCell("");
        }
    }

    private void alterRowShading() {
        this.alterRowShading(null);
    }

    private void alterRowShading(PdfPCell pdfPCell) {
        if (this._pdfOptions.isUseRowShading()) {
            if (this._rowNum % 2 == 0) {
                if (pdfPCell == null) {
                    this._pdfTable.getDefaultCell().setBackgroundColor(new BaseColor(this._pdfOptions.getEvenRowShading()));
                } else {
                    pdfPCell.setBackgroundColor(new BaseColor(this._pdfOptions.getEvenRowShading()));
                }
            } else if (pdfPCell == null) {
                this._pdfTable.getDefaultCell().setBackgroundColor(new BaseColor(this._pdfOptions.getOddRowShading()));
            } else {
                pdfPCell.setBackgroundColor(new BaseColor(this._pdfOptions.getOddRowShading()));
            }
        }
    }

    private void reInit() {
        this._pdfDocument = null;
        this._pdfWriter = null;
        this._pdfTable = null;
        this._isInitPDF = true;
        this._tableCounter = 0;
        this._isSplitTableVertically = false;
        this._blobDirAbsolutePath = null;
        this._blobDirRelativePath = null;
        this._fileList = null;
        this._entryList = null;
    }

    private float getAvailablePageWidth() {
        if (this._pageSize == null) {
            this._pageSize = this._pdfOptions.getOrientation() == 1 ? PageSize.LETTER : PageSize.LETTER.rotate();
        }
        return this._pageSize.getWidth() - this._pdfOptions.getLeftMargin() - this._pdfOptions.getRightMargin();
    }

    private float getHeaderFooterRowHeight(String string) {
        float f = -1.0f;
        if (string == null) {
            return f;
        }
        JTextPane jTextPane = this._customHeaderFooter.getRTFTextPane(string);
        if (jTextPane != null) {
            f = (float)jTextPane.getSize().getHeight();
        }
        return f;
    }

    private void createHeaderFooterEvent() {
        HeaderFooterEvent headerFooterEvent = new HeaderFooterEvent((int)this.getAvailablePageWidth());
        this._pdfWriter.setPageEvent((PdfPageEvent)headerFooterEvent);
    }

    private boolean isContentSpaceAvailable() {
        float f;
        float f2 = 0.0f;
        if (this._pdfTable != null) {
            f2 = this._pdfTable.getHeaderHeight() + this._pdfTable.getFooterHeight();
        }
        return (f = this._contentSpace - f2) >= 144.0f;
    }

    private String getNoContentSpaceMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._pdfOptions.isInsertHeader() && this._pdfOptions.getHeader() != null) {
            stringBuffer.append("\n").append(FormatterResources.getString("CUSTOM_HEADER"));
        }
        if (this._pdfOptions.isInsertFooter() && this._pdfOptions.getFooter() != null) {
            stringBuffer.append("\n").append(FormatterResources.getString("CUSTOM_FOOTER"));
        }
        if (this._pdfOptions.getColumnHeadingsAction() != ReportFormatOptions.COLUMN_LABELING.NONE) {
            stringBuffer.append("\n").append(FormatterResources.getString("COLUMN_HEADER"));
        }
        if (this._pdfOptions.getColumnFootingsAction() != ReportFormatOptions.COLUMN_LABELING.NONE) {
            stringBuffer.append("\n").append(FormatterResources.getString("COLUMN_FOOTER"));
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, FormatterResources.getString("CONTENT_SPACE_SIZE_ERROR"));
        } else {
            stringBuffer.append(FormatterResources.getString("CONTENT_SPACE_MARGIN_ERROR"));
        }
        return stringBuffer.toString();
    }

    private void closeDocument() {
        try {
            if (this._pdfDocument != null) {
                if (this._pdfDocument.isOpen()) {
                    try {
                        this._pdfDocument.close();
                    }
                    catch (Exception exception) {
                        if (this.getOutputStream() != null) {
                            this.getOutputStream().close();
                        }
                    }
                } else if (this.getOutputStream() != null) {
                    this.getOutputStream().close();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void cleanUpPDF() {
        try {
            File file;
            this.closeDocument();
            String string = this.getFileName();
            if (string != null && (file = new File(string)).exists()) {
                file.delete();
            }
            this.reInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    class HeaderFooterEvent
    extends PdfPageEventHelper {
        PdfPTable _headerTable = null;
        PdfPTable _footerTable = null;
        int _availableWidth;
        float _headerYCoord = -1.0f;
        float _footerYCoord = -1.0f;

        public HeaderFooterEvent(int n) {
            this._availableWidth = n;
        }

        public void onOpenDocument(PdfWriter pdfWriter, Document document) {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            try {
                float f = 0.0f;
                float f2 = 0.0f;
                if (PDFFormatter.this._includeCustomHeader) {
                    this._headerTable = PDFFormatter.this._customHeaderFooter.getHeaderTable(pdfWriter, this._availableWidth, pdfWriter.getPageNumber());
                    if (this._headerTable != null) {
                        f = (float)PrintManager.getPrintManager().getPageFormat().getImageableX();
                        f2 = document.getPageSize().getHeight() - PDFFormatter.this._pdfOptions.getTopMargin();
                        this._headerYCoord = this._headerTable.writeSelectedRows(0, -1, f, f2, pdfWriter.getDirectContent());
                    }
                }
                if (PDFFormatter.this._includeCustomFooter) {
                    this._footerTable = PDFFormatter.this._customHeaderFooter.getFooterTable(pdfWriter, this._availableWidth, pdfWriter.getPageNumber());
                    if (this._footerTable != null) {
                        f = (float)PrintManager.getPrintManager().getPageFormat().getImageableX();
                        f2 = PDFFormatter.this._pdfOptions.getBottomMargin() + this.getFooterHeight();
                        this._footerYCoord = this._footerTable.writeSelectedRows(0, -1, f, f2, pdfWriter.getDirectContent());
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }

        public void onCloseDocument(PdfWriter pdfWriter, Document document) {
            this._headerTable = null;
            this._footerTable = null;
        }

        public float getHeaderHeight() {
            if (this._headerTable == null) {
                return -1.0f;
            }
            return this._headerTable.getRowHeight(this._headerTable.getRows().size() - 1);
        }

        public float getFooterHeight() {
            if (this._footerTable == null) {
                return -1.0f;
            }
            return this._footerTable.getRowHeight(this._footerTable.getRows().size() - 1);
        }
    }

    class RowShadingEvent
    implements PdfPTableEvent {
        BaseColor _oddRowColor;
        BaseColor _evenRowColor;

        public RowShadingEvent(int n, int n2) {
            this._oddRowColor = new BaseColor(n);
            this._evenRowColor = new BaseColor(n2);
        }

        public void tableLayout(PdfPTable pdfPTable, float[][] fArray, float[] fArray2, int n, int n2, PdfContentByte[] pdfContentByteArray) {
            int n3;
            int n4 = fArray.length - pdfPTable.getFooterRows();
            for (int i = n3 = pdfPTable.getHeaderRows() - pdfPTable.getFooterRows(); i < n4; ++i) {
                int n5 = fArray[i].length - 1;
                Rectangle rectangle = new Rectangle(fArray[i][0], fArray2[i], fArray[i][n5], fArray2[i + 1]);
                if (i % 2 == 0) {
                    rectangle.setBackgroundColor(this._evenRowColor);
                } else {
                    rectangle.setBackgroundColor(this._oddRowColor);
                }
                rectangle.setBorder(0);
                pdfContentByteArray[0].rectangle(rectangle);
            }
        }
    }

    class CustomHeaderFooter {
        private static final int MAX_HEIGHT = 216;
        private ArrayList<ReportPatternInfo> _customHeaderPagePatterns = null;
        private ArrayList<ReportPatternInfo> _customFooterPagePatterns = null;
        private JTextPane _customHeaderTextPane = null;
        private JTextPane _customFooterTextPane = null;
        private DefaultFontMapper _fontMapper = null;
        private PdfPTable _customHeaderTable = null;
        private PdfPTable _customFooterTable = null;
        private String _headerPageStr = "1";
        private String _footerPageStr = "1";

        CustomHeaderFooter() {
        }

        public void initialize(PDFFormatOptions pDFFormatOptions) throws Exception {
            ArrayList<Object> arrayList;
            if (PDFFormatter.this._includeCustomHeader) {
                this._customHeaderTextPane = this.getRTFTextPane(pDFFormatOptions.getHeader());
                if (pDFFormatOptions.getHeaderPatternList() != null && !pDFFormatOptions.getHeaderPatternList().isEmpty()) {
                    arrayList = this.resetDateTime(pDFFormatOptions.getHeaderPatternList(), this._customHeaderTextPane);
                    this._customHeaderPagePatterns = this.getPageNoPatterns(arrayList);
                }
            }
            if (PDFFormatter.this._includeCustomFooter) {
                this._customFooterTextPane = this.getRTFTextPane(PDFFormatter.this._pdfOptions.getFooter());
                if (pDFFormatOptions.getFooterPatternList() != null && !pDFFormatOptions.getFooterPatternList().isEmpty()) {
                    arrayList = this.resetDateTime(pDFFormatOptions.getFooterPatternList(), this._customFooterTextPane);
                    this._customFooterPagePatterns = this.getPageNoPatterns(arrayList);
                }
            }
            if ((arrayList = pDFFormatOptions.getFontDirectories()) == null || arrayList.isEmpty()) {
                throw new Exception(FormatterResources.getString("FONT_DIRECTORY_ERROR"));
            }
            this._fontMapper = this.getFontMapper(arrayList);
        }

        public PdfPTable getHeaderTable(PdfWriter pdfWriter, int n, int n2) {
            if (this._customHeaderPagePatterns == null || this._customHeaderPagePatterns.isEmpty()) {
                if (this._customHeaderTable == null) {
                    this._customHeaderTable = this.createHeaderFooterTable(PDFFormatter.this._pdfWriter, this._customHeaderTextPane, n);
                }
            } else {
                String string = Integer.toString(n2);
                int n3 = 0;
                int n4 = 0;
                for (ReportPatternInfo reportPatternInfo : this._customHeaderPagePatterns) {
                    try {
                        n3 = reportPatternInfo.getPosition();
                        n4 = string.length() - this._headerPageStr.length();
                        this._customHeaderTextPane.setCaretPosition(n3);
                        AttributeSet attributeSet = this._customHeaderTextPane.getCharacterAttributes();
                        this._customHeaderTextPane.getDocument().remove(reportPatternInfo.getPosition(), this._headerPageStr.length());
                        this._customHeaderTextPane.getDocument().insertString(reportPatternInfo.getPosition(), string, attributeSet);
                        for (ReportPatternInfo reportPatternInfo2 : this._customHeaderPagePatterns) {
                            int n5 = reportPatternInfo2.getPosition();
                            if (n5 <= n3) continue;
                            reportPatternInfo2.setPosition(n5 + n4);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                if (n4 > 0) {
                    this._headerPageStr = string;
                }
                this._customHeaderTable = this.createHeaderFooterTable(PDFFormatter.this._pdfWriter, this._customHeaderTextPane, n);
            }
            return this._customHeaderTable;
        }

        public PdfPTable getFooterTable(PdfWriter pdfWriter, int n, int n2) {
            if (this._customFooterPagePatterns == null || this._customFooterPagePatterns.isEmpty()) {
                if (this._customFooterTable == null) {
                    this._customFooterTable = this.createHeaderFooterTable(PDFFormatter.this._pdfWriter, this._customFooterTextPane, n);
                }
            } else {
                String string = Integer.toString(n2);
                int n3 = 0;
                int n4 = 0;
                for (ReportPatternInfo reportPatternInfo : this._customFooterPagePatterns) {
                    try {
                        n3 = reportPatternInfo.getPosition();
                        n4 = string.length() - this._footerPageStr.length();
                        this._customFooterTextPane.setCaretPosition(n3);
                        AttributeSet attributeSet = this._customFooterTextPane.getCharacterAttributes();
                        this._customFooterTextPane.getDocument().remove(reportPatternInfo.getPosition(), this._footerPageStr.length());
                        this._customFooterTextPane.getDocument().insertString(reportPatternInfo.getPosition(), string, attributeSet);
                        for (ReportPatternInfo reportPatternInfo2 : this._customFooterPagePatterns) {
                            int n5 = reportPatternInfo2.getPosition();
                            if (n5 <= n3) continue;
                            reportPatternInfo2.setPosition(n5 + n4);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                if (n4 > 0) {
                    this._footerPageStr = string;
                }
                this._customFooterTable = this.createHeaderFooterTable(PDFFormatter.this._pdfWriter, this._customFooterTextPane, n);
            }
            return this._customFooterTable;
        }

        private PdfPTable createHeaderFooterTable(PdfWriter pdfWriter, JTextPane jTextPane, int n) {
            if (jTextPane == null) {
                return null;
            }
            PdfPTable pdfPTable = null;
            try {
                PdfTemplate pdfTemplate = null;
                pdfTemplate = pdfWriter.getDirectContent().createTemplate((float)n, (float)((int)jTextPane.getSize().getHeight()));
                Graphics2D graphics2D = pdfTemplate.createGraphics((float)n, (float)((int)jTextPane.getSize().getHeight()), (FontMapper)this._fontMapper);
                if (jTextPane != null) {
                    jTextPane.print(graphics2D);
                    graphics2D.dispose();
                }
                com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((PdfTemplate)pdfTemplate);
                pdfPTable = new PdfPTable(1);
                pdfPTable.setTotalWidth((float)n);
                pdfPTable.setLockedWidth(true);
                pdfPTable.getDefaultCell().setHorizontalAlignment(0);
                pdfPTable.getDefaultCell().setBorder(2);
                pdfPTable.getDefaultCell().setPaddingLeft(0.0f);
                pdfPTable.getDefaultCell().setPaddingRight(0.0f);
                pdfPTable.getDefaultCell().setPaddingTop(0.0f);
                pdfPTable.getDefaultCell().setPaddingBottom(0.0f);
                PdfPCell pdfPCell = new PdfPCell(image);
                pdfPTable.addCell(pdfPCell);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return pdfPTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JTextPane getRTFTextPane(String string) {
            JTextPane jTextPane;
            block15: {
                jTextPane = null;
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    if (string == null) break block15;
                    RTFEditorKit rTFEditorKit = new RTFEditorKit();
                    jTextPane = new JTextPane();
                    int n = (int)PDFFormatter.this.getAvailablePageWidth();
                    jTextPane.setEditorKit(rTFEditorKit);
                    byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    rTFEditorKit.read(byteArrayInputStream, jTextPane.getDocument(), 0);
                    jTextPane.setSize(n, 100);
                    int n2 = 0;
                    try {
                        java.awt.Rectangle rectangle = jTextPane.modelToView(jTextPane.getDocument().getLength());
                        n2 = rectangle.y + rectangle.height;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n2 > 216) {
                        n2 = 216;
                    }
                    jTextPane.setSize(n, n2);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (byteArrayInputStream != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return jTextPane;
        }

        private ArrayList<ReportPatternInfo> resetDateTime(ArrayList<ReportPatternInfo> arrayList, JTextPane jTextPane) {
            if (arrayList == null || arrayList.isEmpty()) {
                return arrayList;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string = null;
            String string2 = null;
            String string3 = null;
            AttributeSet attributeSet = null;
            for (ReportPatternInfo reportPatternInfo : arrayList) {
                string = reportPatternInfo.getPattern();
                if (string == null || string.equals("#")) continue;
                n = jTextPane.getDocument().getLength();
                n3 = reportPatternInfo.getPosition();
                string2 = reportPatternInfo.getText();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                string3 = simpleDateFormat.format(PDFFormatter.this._today.getTime());
                try {
                    jTextPane.setCaretPosition(n3);
                    attributeSet = jTextPane.getCharacterAttributes();
                    jTextPane.getDocument().insertString(n3, string3, attributeSet);
                    jTextPane.getDocument().remove(n3 + string3.length(), string2.length());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                n2 = jTextPane.getDocument().getLength();
                int n4 = 0;
                if (n2 > n) {
                    n4 = n2 - n;
                } else {
                    if (n2 >= n) continue;
                    n4 = (n - n2) * -1;
                }
                for (ReportPatternInfo reportPatternInfo2 : arrayList) {
                    int n5 = reportPatternInfo2.getPosition();
                    if (n5 <= n3) continue;
                    reportPatternInfo2.setPosition(n5 + n4);
                }
            }
            return arrayList;
        }

        public ArrayList<ReportPatternInfo> getPageNoPatterns(ArrayList<ReportPatternInfo> arrayList) {
            ArrayList<ReportPatternInfo> arrayList2 = new ArrayList<ReportPatternInfo>();
            String string = null;
            for (ReportPatternInfo reportPatternInfo : arrayList) {
                string = reportPatternInfo.getPattern();
                if (string == null || !string.equals("#")) continue;
                arrayList2.add(reportPatternInfo);
            }
            return arrayList2;
        }

        private DefaultFontMapper getFontMapper(ArrayList<String> arrayList) {
            DefaultFontMapper defaultFontMapper = new DefaultFontMapper();
            for (String string : arrayList) {
                defaultFontMapper.insertDirectory(string);
            }
            return defaultFontMapper;
        }
    }
}

