/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public abstract class ResultsFormatterWrapper {
    private List<String> m_colNames;
    private int[] m_colSizes;
    private int[] m_precisions;
    private int[] m_scales;
    private transient boolean m_interrupted;
    protected IResultFormatter m_formatter;

    protected ResultsFormatterWrapper() {
    }

    void setParent(IResultFormatter iResultFormatter) {
        this.m_formatter = iResultFormatter;
    }

    protected void setColumnNames(List<String> list) {
        this.m_colNames = list;
    }

    protected void setColumnSizes(int[] nArray) {
        this.m_colSizes = nArray;
    }

    protected void setPrecisions(int[] nArray) {
        this.m_precisions = nArray;
    }

    protected void setScales(int[] nArray) {
        this.m_scales = nArray;
    }

    public abstract Connection getConnection();

    public void close() {
    }

    public abstract int getDataType(int var1) throws SQLException;

    public abstract int print() throws IOException;

    public abstract int print(IRaptorTaskProgressUpdater var1) throws IOException, ExecutionException;

    public String getColumnName(int n) {
        try {
            return this.m_colNames.get(n);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getColumnSize(int n) {
        return this.m_colSizes[n];
    }

    public int getPrecision(int n) {
        return this.m_precisions == null ? this.m_colSizes[n] : this.m_precisions[n];
    }

    public int getScale(int n) {
        return this.m_scales == null ? 0 : this.m_scales[n];
    }

    public int getColumnCount() {
        return this.m_colNames.size();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.m_colNames);
    }

    public void interrupt() {
        this.m_interrupted = true;
    }

    protected boolean isInterrupted() {
        return this.m_interrupted;
    }

    public Object getValue(Object object) {
        try {
            return DataTypesUtil.stringValue(object, this.getConnection());
        }
        catch (Exception exception) {
            return object;
        }
    }

    public Object getValue(Object object, FormatType formatType) {
        try {
            return DataTypesUtil.stringValue(object, this.getConnection(), formatType);
        }
        catch (Exception exception) {
            return object;
        }
    }

    public abstract String getSQL();
}

