/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class XMLFormatter
extends ResultsFormatter {
    public static final String TYPE = "XML";
    public static final String EXT = "xml";
    public static final String KEY_REC_TERM = "EXPORT_XML_REC_TERM";
    private boolean _result = true;

    public XMLFormatter() {
        super(TYPE, Messages.getString("XMLFormatter.0"), EXT);
    }

    public void setResult(boolean bl) {
        this._result = bl;
    }

    @Override
    public void start() throws IOException {
        this.write("<?xml version='1.0'  encoding='" + this.getEncode() + "' ?>" + this.getLineTerminator());
        this.write("<RESULTS>" + this.getLineTerminator());
    }

    @Override
    public void startRow() throws IOException {
        this.write("\t<ROW>" + this.getLineTerminator());
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = this.getColumnName(n);
        this.write("\t\t<COLUMN NAME=\"" + string.replace(' ', '_').replace('/', '_') + "\">");
        this.write("<![CDATA[");
        if (object != null) {
            this.write(this.getValue(object));
        }
        this.write("]]>");
        this.write("</COLUMN>" + this.getLineTerminator());
    }

    @Override
    public void endRow() throws IOException {
        this.write("\t</ROW>" + this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
        this.write("</RESULTS>");
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    protected String getValue(Object object) {
        try {
            if (object instanceof Clob) {
                Clob clob = (Clob)object;
                Long l = clob.length();
                int n = 4000;
                String string = "";
                long l2 = 1L;
                while (l > 0L) {
                    string = clob.getSubString(l2, n);
                    this.write(string);
                    l = l - (long)string.length();
                    l2 += (long)string.length();
                }
                return null;
            }
            return super.getValue(object).toString();
        }
        catch (Exception exception) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }
}

