/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.compiler.CompilerStatusDisplay;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

public class PLSQL
extends SQLCommandRunner {
    SQLWarning warn = null;
    public boolean errorToWorksheet = false;
    public static CompilerStatusDisplay display = null;
    private String type = null;
    private String name = null;
    private String owner = null;

    public PLSQL(ISQLCommand iSQLCommand, BufferedOutputStream bufferedOutputStream) {
        super(iSQLCommand, bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
        if (!connectionResolver.lock(this.conn)) {
            return;
        }
        Debug.debug(Messages.getString("PLSQL.0") + this.cmd.getSql());
        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", null);
        try {
            this.errorToWorksheet = false;
            if (this.cmd.isCreatePLSQLCmd()) {
                this.runCreatePLSQL();
            } else {
                this.runNonCreatePLSQL();
            }
            Debug.debug(Messages.getString("PLSQL.1"));
            this.reportfinish();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
        finally {
            if (this.cstmt != null) {
                try {
                    this.cstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.callStmt != null) {
                try {
                    this.callStmt.close();
                }
                catch (SQLException sQLException) {}
            }
            connectionResolver.unlock(this.conn);
        }
    }

    private void handleException(SQLException sQLException) {
        ExceptionHandler.handleException((Exception)sQLException, this.connName, true, false);
        this.getScriptRunnerContext().putProperty("sqldev.error", Boolean.TRUE);
        this.getScriptRunnerContext().putProperty("script.runner.autocommit.errorFlag", Boolean.TRUE);
        this.doWhenever(true);
        String string = sQLException.getMessage();
        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", string);
        if (this.conn instanceof OracleConnection) {
            try {
                Oerr oerr = new Oerr();
                string = string + oerr.oerr(string);
            }
            catch (OerrException oerrException) {
                // empty catch block
            }
        }
        this.report(ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), string, this.getScriptRunnerContext()));
    }

    private void reportfinish() {
        String string = "anon";
        String string2 = null;
        this.parseNameAndType(this.cmd.getSql());
        string = this.type != null ? this.type : string;
        string2 = this.name;
        boolean bl = false;
        if (string.equals("anon") && this.getScriptRunnerContext().getFeedback() != -2) {
            this.report(Messages.getString("PLSQL.4"));
        } else if (this.getScriptRunnerContext().getFeedback() != -2) {
            this.report(MessageFormat.format(Messages.getString("PLSQL.5"), string, string2));
            if (string2 != null && !string2.equals("")) {
                bl = this.reportErrors(string2, true);
            }
        } else if (string2 != null && !string2.equals("")) {
            bl = this.reportErrors(string2, false);
        }
        if (bl) {
            this.report("Errors: check compiler log");
        } else if (this.warn != null && this.warn.getMessage() != null) {
            this.reportWarning(this.warn);
        }
    }

    void checkForDoubleBind(String string) {
        DBUtil dBUtil = DBUtil.getInstance(this.conn);
        List<String> list = DBUtil.getBinds(string, true);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        boolean bl = false;
        if (this.cmd.getBinds() != null && this.cmd.getBinds().size() > 0) {
            this.doubleBinds = null;
            return;
        }
        for (String string2 : list) {
            boolean bl2 = !hashSet.add(string2.toUpperCase(Locale.US));
            if (!bl2) continue;
            bl = true;
            hashSet2.add(string2.toUpperCase(Locale.US));
        }
        if (bl) {
            this.doubleBinds = hashSet2;
        }
    }

    protected String getBindType(String string) throws SQLException {
        boolean bl = true;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        Map map = (Map)this.getScriptRunnerContext().getProperty("f9.popup.binds");
        Map<String, Bind> map2 = this.getScriptRunnerContext().getVarMap();
        HashMap hashMap = (HashMap)this.getScriptRunnerContext().getProperty("BINDMAP");
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (map.containsKey(string)) {
            bl6 = true;
        }
        if (map2.containsKey(string.toUpperCase())) {
            bl5 = true;
        }
        if (hashMap.containsKey(string)) {
            bl4 = true;
        }
        if (bl6 || bl5 || bl4) {
            Bind bind = null;
            String string4 = null;
            if (bl6) {
                string4 = map.get(string).equals(DBUtil.NULL_VALUE) ? null : (String)map.get(string);
                string2 = "VARCHAR2";
            } else if (bl5) {
                bind = map2.get(string.toUpperCase());
                string2 = bind.getType();
                string3 = bind.getBracket();
                if (string3 != null) {
                    string2 = string3;
                }
                string4 = bind.getValue();
            } else {
                bind = (Bind)hashMap.get(string);
                string2 = bind.getType();
                string3 = bind.getBracket();
                if (string3 != null) {
                    string2 = string3;
                }
                string4 = bind.getValue();
            }
            if (string2.indexOf("(") == -1) {
                if (string2.toUpperCase().indexOf("NCHAR") > -1) {
                    string2 = "NVARCHAR2(32767)";
                } else if (string2.toUpperCase().indexOf("CHAR") > -1 && string2.toUpperCase().indexOf("CHAR2") == -1) {
                    string2 = "VARCHAR2(32767)";
                } else if (string2.toUpperCase().indexOf("NCHAR") > -1 || string2.toUpperCase().indexOf("NVARCHAR") > -1 || string2.toUpperCase().indexOf("CHAR") > -1 || string2.toUpperCase().indexOf("VARCHAR") > -1) {
                    string2 = string2 + "(32767)";
                }
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    public void setMyUniq(String string) {
        String string2 = this.myUniq.toUpperCase(Locale.US);
        String string3 = string.toUpperCase(Locale.US);
        int n = 1;
        while (string3.contains(string2 + n + "Z")) {
            ++n;
        }
        this.myUniq = this.myUniq + n + "Z";
    }

    public final String doubleBindPrepareOracleSql(String string) throws SQLException {
        this.setMyUniq(string);
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(string, true);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string2 = string;
        int n = 1;
        HashSet<String> hashSet = new HashSet<String>();
        Collections.reverse(arrayList);
        String string3 = "DECLARE ";
        String string4 = "";
        for (Bind bind : arrayList) {
            String string5 = bind.getName();
            String string6 = string5.toUpperCase(Locale.US);
            if (this.doubleBinds.contains(string6)) {
                if (hashSet.add(string6)) {
                    hashMap.put(string6, n);
                    String string7 = this.getBindType(string5);
                    if (string7 == null) {
                        return null;
                    }
                    string3 = string3 + this.myUniq + "_" + n + " " + string7 + ":=:" + this.myUniq + "Init" + n + "; ";
                    string4 = string4 + ":" + bind.getName() + ":=" + this.myUniq + "_" + n + "; ";
                    this.lookUpMangle.put(this.myUniq + "Init" + n, string5);
                }
                string2 = this.replaceBind(bind, " " + this.myUniq + "_" + hashMap.get(string6), string2);
            }
            ++n;
        }
        return string3 + " BEGIN " + string2 + " " + string4 + " END;";
    }

    private String replaceBind(Bind bind, String string, String string2) {
        if (string2.length() == bind.getEnd()) {
            return string2.substring(0, bind.getBegin()) + string;
        }
        return string2.substring(0, bind.getBegin()) + string + string2.substring(bind.getEnd());
    }

    private void runNonCreatePLSQL() throws SQLException {
        Object object;
        DBUtil dBUtil = DBUtil.getInstance(this.conn);
        if (this.conn instanceof OracleConnection) {
            this.checkForDoubleBind(this.cmd.getSql());
            object = null;
            if (this.doubleBinds != null) {
                this.altSQL = this.doubleBindPrepareOracleSql(this.cmd.getSql());
                if (this.altSQL == null) {
                    this.doubleBinds = null;
                } else {
                    object = this.altSQL;
                }
            }
            if (this.doubleBinds == null) {
                object = dBUtil.prepareOracleSql(this.cmd.getSql());
            }
            this.callStmt = this.conn.prepareCall((String)object);
        } else {
            this.callStmt = this.conn.prepareCall(dBUtil.prepareNonOracleSql(this.cmd.getSql()));
        }
        this.callStmt.setEscapeProcessing(false);
        object = DBUtil.getBinds(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        if (object != null && object.size() > 0) {
            if (this.setBinds(this.callStmt)) {
                this.registerOutParameters();
                this.callStmt.getParameterMetaData().getParameterCount();
                this.callStmt.execute();
                this.fetchOutputParameterValues();
            }
        } else {
            this.callStmt.execute();
        }
        this.warn = this.callStmt.getWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCreatePLSQL() throws SQLException {
        block24: {
            Statement statement = null;
            try {
                String[] stringArray;
                String string;
                boolean bl = false;
                SQLCommand.StmtSubType stmtSubType = this.cmd.getStmtId();
                if (stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_FUNCTION || stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_PROCEDURE || stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_PACKAGE_BODY || stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_PACKAGE_HEADER || stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_JAVA || stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_TRIGGER || stmtSubType == SQLCommand.StmtSubType.G_S_CREATE_TYPE) {
                    string = this.cmd.getSQLOrig();
                    if (string.length() > 1001) {
                        string = string.substring(0, 999);
                    }
                    if ((string = string.toLowerCase()).indexOf("wrapped") != -1) {
                        string = string.replaceAll("\\s+or\\s+replace\\s+", " ");
                        string = string.replaceAll("\\s+noneditionable\\s+", " ");
                        stringArray = (string = string.replaceAll("\\s+editionable\\s+", " ")).trim().split("\\s+");
                        if (stringArray != null && stringArray.length > 5 && (stringArray[3].equals("wrapped") || stringArray[4].equals("wrapped") && stringArray[2].equals("body"))) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    string = null;
                    try {
                        string = CLOB.createTemporary((Connection)this.conn, (boolean)true, (int)10);
                        string.open(1);
                        stringArray = string.setCharacterStream(1L);
                        stringArray.write(this.cmd.getSql() + "\n\n", 0, (this.cmd.getSql() + "\n\n").length());
                        stringArray.flush();
                        stringArray.close();
                        statement = this.conn.prepareStatement("  declare\n    v_large_sql  CLOB;\n    v_num        NUMBER := 0;\n    v_upperbound NUMBER;\n    v_sql        DBMS_SQL.VARCHAR2S;\n    v_cur        INTEGER;\n    v_ret        NUMBER;\n  begin\n    v_large_sql := :1;\n    v_upperbound := CEIL(DBMS_LOB.GETLENGTH(v_large_sql)/256);\n    FOR i IN 1..v_upperbound\n    LOOP\n      v_sql(i) := DBMS_LOB.SUBSTR(v_large_sql\n                                 ,256 -- amount\n                                 ,((i-1)*256)+1 -- offset\n                                 );\n    END LOOP;\n    v_cur := DBMS_SQL.OPEN_CURSOR;\n    DBMS_SQL.PARSE(v_cur, v_sql, 1, v_upperbound, FALSE, DBMS_SQL.NATIVE);\n    v_ret := DBMS_SQL.EXECUTE(v_cur);\n    DBMS_SQL.CLOSE_CURSOR(v_cur);\n  EXCEPTION   \n    when others then\n      dbms_sql.close_cursor(v_cur);\n    raise;\n  END;\n");
                        statement.setClob(1, (Clob)((Object)string));
                        statement.executeUpdate();
                        this.warn = statement.getWarnings();
                        this.errorToWorksheet = true;
                        break block24;
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                        break block24;
                    }
                    finally {
                        try {
                            string.freeTemporary();
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                }
                this.cstmt = this.conn.createStatement();
                this.cstmt.setEscapeProcessing(false);
                this.cstmt.executeUpdate(this.cmd.getSql());
                this.warn = this.cstmt.getWarnings();
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private void reportWarning(SQLWarning sQLWarning) {
        this.getScriptRunnerContext().putProperty("sqldev.last.err.type", this.type == null ? "UNKNOWN" : this.type.toUpperCase());
        this.getScriptRunnerContext().putProperty("sqldev.last.err.name", this.name);
        this.report(sQLWarning.getMessage());
    }

    private String[] parseNameAndType(String string) {
        this.owner = null;
        String string2 = string.length() > 1000 ? string.substring(0, 1000) : string;
        List list = LexerToken.parse((String)string2);
        for (int i = 0; i < 10 && i < list.size(); ++i) {
            LexerToken lexerToken = (LexerToken)list.get(i);
            if (this.type == null && "DECLARE".equalsIgnoreCase(lexerToken.content) || this.type == null && "BEGIN".equalsIgnoreCase(lexerToken.content)) break;
            if (this.type == null && "PACKAGE".equalsIgnoreCase(lexerToken.content)) {
                this.type = lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type == null && "PROCEDURE".equalsIgnoreCase(lexerToken.content)) {
                this.type = lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type == null && "FUNCTION".equalsIgnoreCase(lexerToken.content)) {
                this.type = lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type == null && "TRIGGER".equalsIgnoreCase(lexerToken.content)) {
                this.type = lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type == null && "JAVA".equalsIgnoreCase(lexerToken.content)) {
                this.type = lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type == null && "TYPE".equalsIgnoreCase(lexerToken.content)) {
                this.type = lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type != null && "BODY".equalsIgnoreCase(lexerToken.content)) {
                this.type = this.type + " " + lexerToken.content.toUpperCase();
                continue;
            }
            if (this.type == null || "BODY".equalsIgnoreCase(lexerToken.content) || this.name != null) continue;
            this.name = Service.handleMixedCase((String)lexerToken.content);
            if (this.name.equals("[")) {
                String string3 = string2 + " ";
                boolean bl = true;
                int n = lexerToken.begin + 1;
                int n2 = string3.length() - 1;
                for (int j = lexerToken.begin + 1; j < 1000 && j < string3.length() - 1; ++j) {
                    String string4 = string3.substring(j, j + 1);
                    if (string4.matches("[ \t\r\n]") && !bl) {
                        n2 = j;
                        break;
                    }
                    if (string4.equals(".") && !bl) {
                        n = j + 1;
                    }
                    if (string4.equals("[")) {
                        bl = true;
                        continue;
                    }
                    if (!string4.equals("]")) continue;
                    bl = false;
                }
                if (n2 - n >= 100 || n2 - n <= 0) break;
                this.name = string3.substring(n, n2).replaceAll("\\[", "").replaceAll("\\]", "");
                break;
            }
            if (list.size() <= i + 2) break;
            LexerToken lexerToken2 = (LexerToken)list.get(i + 1);
            if (!".".equalsIgnoreCase(lexerToken2.content)) break;
            this.owner = this.name;
            LexerToken lexerToken3 = (LexerToken)list.get(i + 2);
            this.name = lexerToken3.content.toUpperCase();
            break;
        }
        if (this.name != null && this.name.startsWith("\"") && this.name.endsWith("\"")) {
            this.name = this.name.substring(1, this.name.length() - 1);
        }
        return new String[]{this.name, this.type};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportErrors(String string, boolean bl) {
        boolean bl2;
        Iterator iterator;
        Object object2;
        boolean bl3 = true;
        if (display != null) {
            if (this.getScriptRunnerContext().node == null) {
                bl3 = false;
            } else {
                display.registerAsynchronousLogPage(this.getScriptRunnerContext().node);
            }
        }
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/compiler/source.xml");
        Query query = queryXMLSupport.getQuery("COMPILER_ERRORS", this.conn);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", this.name);
        hashMap.put("TYPE", this.type);
        if (this.owner == null) {
            if (this.conn instanceof OracleConnection) {
                this.owner = DBUtil.getInstance(this.conn).executeReturnOneCol("select UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) from dual");
            } else {
                try {
                    this.owner = this.conn.getMetaData().getUserName();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        hashMap.put("OWNER", this.owner);
        ResultSetWrapper resultSetWrapper = null;
        OraSubmitResults oraSubmitResults = new OraSubmitResults();
        try {
            object2 = DBUtil.getInstance(this.conn);
            resultSetWrapper = ((DBUtil)object2).executeQuery(query.getSql(), hashMap);
            if (resultSetWrapper != null) {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    int bl22 = resultSet.getInt(1);
                    int n = resultSet.getInt(2);
                    iterator = resultSet.getString(3);
                    String string2 = resultSet.getString(4);
                    boolean bl4 = "ERROR".equals(string2);
                    oraSubmitResults.addError(new PlSqlErrorInfo(bl22, n, (String)((Object)iterator), !bl4));
                }
            }
        }
        catch (SQLException sQLException) {
            if (bl3 && display != null) {
                display.outputLog(MessageFormat.format(Messages.getString("PLSQL.19"), sQLException.getMessage()));
            }
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        object2 = new ArrayList();
        boolean bl5 = false;
        boolean bl6 = false;
        List<PlSqlErrorInfo> list = oraSubmitResults.getErrorList();
        object2.addAll(list);
        if (null != list) {
            if (this.errorToWorksheet && list.size() != 0) {
                this.report(MessageFormat.format(Messages.getString("CREATED"), this.type, this.name));
            }
            for (PlSqlErrorInfo plSqlErrorInfo : list) {
                if (plSqlErrorInfo.isWarning()) {
                    if (!bl3 || display == null) continue;
                    display.warning(plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                    continue;
                }
                if (!bl3 || display == null) continue;
                display.error(plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
            }
            if (list.size() == 20 && bl3 && display != null) {
                display.warning(1, 1, 0, Messages.getString("PLSQL.20"));
            }
        }
        this.errorToWorksheet = false;
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            PlSqlErrorInfo plSqlErrorInfo = (PlSqlErrorInfo)iterator.next();
            if (!plSqlErrorInfo.isWarning()) {
                bl2 = true;
                continue;
            }
            bl5 = true;
        }
        if (bl3 && display != null) {
            display.unRegisterAsynchronousLogPage();
        }
        if (bl2 && bl5) {
            if (bl3 && display != null) {
                display.outputLog(MessageFormat.format(Messages.getString("PLSQL.21"), string));
            } else if (bl2) {
                if (bl3 && display != null) {
                    display.outputLog(MessageFormat.format(Messages.getString("PLSQL.22"), string));
                } else if (bl5) {
                    if (bl3 && display != null) {
                        display.outputLog(MessageFormat.format(Messages.getString("PLSQL.23"), string));
                    } else if (bl3 && display != null) {
                        display.outputLog(MessageFormat.format(Messages.getString("PLSQL.24"), string));
                    }
                }
            }
        }
        this.getScriptRunnerContext().putProperty("sqldev.last.err.type", this.type.toUpperCase());
        if (this.owner != null && !this.owner.equals("")) {
            this.getScriptRunnerContext().putProperty("sqldev.last.err.name", this.owner + "." + this.name);
        } else {
            this.getScriptRunnerContext().putProperty("sqldev.last.err.name", this.name);
        }
        return bl2;
    }

    private void fetchOutputParameterValues() throws SQLException {
        int n = 1;
        Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
        List<String> list = DBUtil.getBinds(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        n = list.size();
        for (int i = list.size() - 1; i >= 0; --i) {
            Bind bind;
            String string;
            if (n <= 0) continue;
            String string2 = null;
            if (this.doubleBinds != null) {
                string2 = (String)this.lookUpMangle.get(list.get(i));
                if (string2 == null) {
                    string2 = list.get(i);
                }
                if (list.get(i).contains(this.myUniq + "Init")) {
                    --n;
                    continue;
                }
                if (string2 == null) {
                    string2 = list.get(i);
                }
            } else {
                string2 = list.get(i);
            }
            if ((string = (bind = map.get(string2.toUpperCase())).getType()).toUpperCase().indexOf("CHAR") > -1) {
                bind.setValue(this.callStmt.getString(n));
            } else if (string.toUpperCase().equals("NUMBER")) {
                bind.setValue(this.callStmt.getObject(n) == null ? null : this.callStmt.getObject(n).toString());
            } else if (string.toUpperCase().indexOf("CLOB") > -1) {
                bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(n), this.conn));
            } else if (string.toUpperCase().equals("REFCURSOR")) {
                bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(n), this.conn));
            } else if (string.toUpperCase().indexOf("BINARY_") > -1) {
                bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(n), this.conn));
            }
            map.put(string2, bind);
            --n;
        }
    }

    private void registerOutParameters() throws SQLException {
        int n = 1;
        List<String> list = null;
        list = DBUtil.getBinds(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        Map<String, Bind> map = this.getScriptRunnerContext().getVarMap();
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            string = null;
            if (this.doubleBinds != null && list.get(i).contains(this.myUniq + "Init")) {
                ++n;
                continue;
            }
            string = list.get(i);
            if (!map.containsKey(string.toUpperCase())) continue;
            Bind bind = map.get(string.toUpperCase());
            String string2 = bind.getType();
            if (string2.toUpperCase().indexOf("NCHAR") > -1 || string2.toUpperCase().indexOf("NVARCHAR") > -1 || string2.toUpperCase().indexOf("NCLOB") > -1) {
                ((OracleCallableStatement)this.callStmt).setFormOfUse(n, (short)2);
            }
            if (string2.toUpperCase().indexOf("CHAR") > -1) {
                this.callStmt.registerOutParameter(n, 12);
            } else if (string2.toUpperCase().equals("NUMBER")) {
                this.callStmt.registerOutParameter(n, 2);
            } else if (string2.toUpperCase().indexOf("CLOB") > -1) {
                this.callStmt.registerOutParameter(n, 2005);
            } else if (string2.toUpperCase().equals("REFCURSOR")) {
                this.callStmt.registerOutParameter(n, -10);
            } else if (string2.toUpperCase().equals("BINARY_DOUBLE")) {
                this.callStmt.registerOutParameter(n, 101);
            } else if (string2.toUpperCase().equals("BINARY_FLOAT")) {
                this.callStmt.registerOutParameter(n, 100);
            }
            ++n;
        }
    }
}

