/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.Debug;
import oracle.ide.Ide;
import oracle.jdbc.OraclePreparedStatement;

public abstract class SQLCommandRunner {
    protected static final Logger LOGGER = Logger.getLogger(SQLCommandRunner.class.getName());
    public static final int EXIT = 4;
    public static final int CONTINUE = 0;
    public static final int EXITMASK = 4;
    public static final int ACTIONMASK = 3;
    public static final int ACTIONNONE = 0;
    public static final int ACTIONCOMMIT = 1;
    public static final int ACTIONROLLBACK = 2;
    private ScriptRunnerContext scriptRunnerContext = null;
    protected ISQLCommand cmd;
    protected Connection conn;
    protected String connName;
    protected BufferedOutputStream out;
    protected PreparedStatement stmt;
    protected CallableStatement callStmt;
    Statement st;
    Statement cstmt;
    protected Debug debug = new Debug();
    protected String statusLine = null;
    private ConnectionResolver m_connRes;
    public static final String EXECUTEFAILED = "EXECUTEFAILED";
    protected HashSet<String> doubleBinds = null;
    protected HashMap<String, String> lookUpMangle = new HashMap();
    protected String altSQL = null;
    protected String myUniq = "SqlDevBind";

    protected String alteredSQL(HashSet<String> hashSet, String string, String string2) {
        String string3 = null;
        string3 = hashSet != null ? string2 : string;
        return string3;
    }

    public void interrupt() {
        try {
            if (this.stmt != null && !this.stmt.isClosed()) {
                this.stmt.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            assert (sQLFeatureNotSupportedException != null);
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].getMethodName() + "Line:" + exception.getStackTrace()[0].getLineNumber() + ":" + exception.getMessage());
        }
        try {
            if (this.st != null && !this.st.isClosed()) {
                this.st.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].getMethodName() + "Line:" + exception.getStackTrace()[0].getLineNumber() + ":" + exception.getMessage());
        }
        try {
            if (this.callStmt != null && !this.callStmt.isClosed()) {
                this.callStmt.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].getMethodName() + "Line:" + exception.getStackTrace()[0].getLineNumber() + ":" + exception.getMessage());
        }
        try {
            if (this.cstmt != null && !this.cstmt.isClosed()) {
                this.cstmt.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            LOGGER.log(Level.WARNING, "Unsupported Feature");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].getMethodName() + "Line:" + exception.getStackTrace()[0].getLineNumber() + ":" + exception.getMessage());
        }
    }

    public SQLCommandRunner(ISQLCommand iSQLCommand, BufferedOutputStream bufferedOutputStream) {
        this.cmd = iSQLCommand;
        this.out = bufferedOutputStream;
        this.m_connRes = DBUtil.getConnectionResolver();
    }

    protected void report(String string) {
        if (this.statusLine != null) {
            Ide.getStatusBar().setText(string);
        }
        if (this.out != null) {
            try {
                this.out.write(string.getBytes("UTF-8"));
                this.out.write(10);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public void doWhenever(boolean bl) {
        this.cmd.setProperty(EXECUTEFAILED, EXECUTEFAILED);
        int n = 0;
        n = bl ? this.scriptRunnerContext.getSqlError() : this.scriptRunnerContext.getOsError();
        int n2 = n & 3;
        if (n2 == 2) {
            try {
                this.conn.rollback();
                this.report("Rollback");
            }
            catch (SQLException sQLException) {
                this.report(ScriptRunnerDbArb.format("ERROR_ON", "Rollback"));
            }
        } else if (n2 == 1) {
            try {
                this.conn.commit();
                this.report("Commit");
            }
            catch (SQLException sQLException) {
                this.report(ScriptRunnerDbArb.format("ERROR_ON", "Commit"));
            }
        }
        if ((n & 4) == 4) {
            this.scriptRunnerContext.setExited(true);
        }
    }

    public ISQLCommand getCmd() {
        return this.cmd;
    }

    public void setCmd(ISQLCommand iSQLCommand) {
        this.cmd = iSQLCommand;
    }

    public String getConnName() {
        return this.connName;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
        this.connName = this.m_connRes.getConnectionName(connection);
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }

    public void write(String string) throws IOException {
        this.out.write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
    }

    public void setConnName(String string) {
        this.connName = string;
        try {
            this.conn = this.m_connRes.getConnection(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatusLine() {
        return Ide.getStatusBar().getText();
    }

    public void setStatusLine(String string) {
        Ide.getStatusBar().setText(string);
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    protected boolean setBinds(PreparedStatement preparedStatement) throws SQLException {
        boolean bl = true;
        boolean bl2 = false;
        List<String> list = DBUtil.getBinds(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        int n = 1;
        Map map = (Map)this.getScriptRunnerContext().getProperty("f9.popup.binds");
        Map<String, Bind> map2 = this.getScriptRunnerContext().getVarMap();
        HashMap hashMap = (HashMap)this.getScriptRunnerContext().getProperty("BINDMAP");
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = null;
            if (this.doubleBinds != null) {
                string = this.lookUpMangle.get(list.get(i));
                if (string == null) {
                    string = list.get(i);
                }
            } else {
                string = list.get(i);
            }
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (map.containsKey(string)) {
                bl5 = true;
            }
            if (map2.containsKey(string.toUpperCase())) {
                bl4 = true;
            }
            if (hashMap.containsKey(string)) {
                bl3 = true;
            }
            if (bl5 || bl4 || bl3) {
                block44: {
                    Bind bind = null;
                    String string2 = null;
                    String string3 = null;
                    if (bl5) {
                        string3 = map.get(string).equals(DBUtil.NULL_VALUE) ? null : (String)map.get(string);
                        string2 = "VARCHAR2";
                    } else if (bl4) {
                        bind = map2.get(string.toUpperCase());
                        string2 = bind.getType();
                        string3 = bind.getValue();
                    } else {
                        bind = (Bind)hashMap.get(string);
                        string2 = bind.getType();
                        string3 = bind.getValue();
                    }
                    if (bl5) {
                        if (string3 != null) {
                            preparedStatement.setString(n, string3);
                        } else {
                            preparedStatement.setNull(n, 12);
                        }
                    } else {
                        if (string2.toUpperCase().indexOf("NCHAR") > -1 || string2.toUpperCase().indexOf("NVARCHAR") > -1 || string2.toUpperCase().indexOf("NCLOB") > -1) {
                            ((OraclePreparedStatement)preparedStatement).setFormOfUse(n, (short)2);
                        }
                        if (string2.toUpperCase().indexOf("CHAR") > -1) {
                            if (string3 != null) {
                                preparedStatement.setString(n, string3);
                            } else {
                                preparedStatement.setNull(n, 12);
                            }
                        } else if (string2.toUpperCase().equals("NUMBER")) {
                            try {
                                if (string3 != null) {
                                    preparedStatement.setInt(n, Integer.parseInt(string3));
                                    break block44;
                                }
                                preparedStatement.setNull(n, 4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                preparedStatement.setInt(n, 0);
                            }
                        } else if (string2.toUpperCase().indexOf("CLOB") > -1) {
                            if (string3 != null) {
                                preparedStatement.setClob(n, (Clob)DataTypesUtil.getCLOB(string3, this.conn));
                            } else {
                                preparedStatement.setNull(n, 2005);
                            }
                        } else if (!string2.toUpperCase().equals("REFCURSOR")) {
                            if (string2.toUpperCase().equals("BINARY_DOUBLE")) {
                                try {
                                    if (string3 != null) {
                                        ((OraclePreparedStatement)preparedStatement).setBinaryDouble(n, Double.parseDouble(string3));
                                        break block44;
                                    }
                                    preparedStatement.setNull(n, 101);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    preparedStatement.setString(n, string3);
                                }
                            } else if (string2.toUpperCase().equals("BINARY_FLOAT")) {
                                try {
                                    if (string3 != null) {
                                        ((OraclePreparedStatement)preparedStatement).setBinaryFloat(n, Float.parseFloat(string3));
                                    } else {
                                        preparedStatement.setNull(n, 100);
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    preparedStatement.setString(n, string3);
                                }
                            }
                        }
                    }
                }
                ++n;
                continue;
            }
            if (this.cmd.getBinds().size() > 0) {
                bl2 = true;
                continue;
            }
            this.report(ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", string));
            bl = false;
            break;
        }
        if (bl2) {
            DBUtil.bind(preparedStatement, this.cmd.getBinds());
            bl = true;
        }
        return bl;
    }

    protected void unlockConnection() {
        try {
            this.m_connRes.unlock(this.conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean lockConnection() {
        return this.m_connRes.lock(this.conn);
    }

    protected String resolveConnectionName() {
        return this.m_connRes.getConnectionName(this.getScriptRunnerContext().getBaseConnection());
    }

    protected Properties getConnectionInfo() {
        return this.m_connRes.getConnectionInfo(this.resolveConnectionName());
    }
}

