/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCompoundCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;

public class ScriptParser {
    private static final Logger s_logger = Logger.getLogger(ScriptParser.class.getName());
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] m_startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private List<ISQLCommand> m_sqlArray = new ArrayList<ISQLCommand>();
    private String m_rawSQL;
    private BufferedReader m_reader = null;
    private int m_readerLineCnt = -1;
    private int m_readerLineStartCnt = 0;
    private int m_state = 0;
    private boolean m_firstLine = true;
    private String m_quoteString = "";
    private String m_leftOver = null;
    private String m_setLeftOver = null;

    public ScriptParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public ScriptParser(Reader reader) {
        this(reader, null);
    }

    public ScriptParser(InputStream inputStream, Connection connection) {
        this(new InputStreamReader(inputStream), connection);
    }

    public ScriptParser(Reader reader, Connection connection) {
        this.scriptParserInit(reader, connection);
    }

    private void scriptParserInit(Reader reader, Connection connection) {
        this.m_reader = new BufferedReader(reader);
    }

    public ScriptParser(String string) {
        this(string, null);
    }

    public ScriptParser(String string, Connection connection) {
        this(new StringReader(string), connection);
        this.m_rawSQL = string;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        ScriptParser scriptParser = new ScriptParser(fileInputStream);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        for (int i = 0; i < iSQLCommandArray.length; ++i) {
            System.out.print("Command " + i + ":");
            if (iSQLCommandArray[i].isSqlPlusSetCmd()) {
                System.out.println(" SQLPLUS");
                continue;
            }
            if (iSQLCommandArray[i].isCreateCmd()) {
                System.out.println(" Create");
                continue;
            }
            if (iSQLCommandArray[i].isCreatePLSQLCmd()) {
                System.out.println(" PLSQL");
                continue;
            }
            if (!iSQLCommandArray[i].isCreateSQLCmd()) continue;
            System.out.println(" SQL");
        }
    }

    public void parse() {
        this.m_leftOver = null;
        this.m_setLeftOver = null;
        this.m_readerLineCnt = -1;
        try {
            ISQLCommand iSQLCommand = this.next();
            while (iSQLCommand != null) {
                this.m_sqlArray.add(iSQLCommand);
                iSQLCommand = this.next();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void parseinit() {
        this.m_leftOver = null;
        this.m_setLeftOver = null;
        this.m_readerLineCnt = -1;
    }

    public ISQLCommand next() throws IOException {
        String string = this.getTop(this.m_leftOver);
        this.m_leftOver = null;
        if (string == null) {
            return null;
        }
        SQLCommand sQLCommand = this.getPropertiesForParserHint(string);
        if (sQLCommand == null) {
            sQLCommand = this.getPropertiesWhenNoSpaceRequired(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.getPropertiesWhenTokensKnown(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.getPropertiesWhenMulitpleTokensKnown(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.getHalfRecognizedMultiToken(string);
        }
        if (sQLCommand == null) {
            sQLCommand = this.createUnknownStatementProperties();
        }
        sQLCommand = this.refineStmtRecognition(sQLCommand, string);
        if ((sQLCommand = this.identifyEndOfStatement(string, this.m_reader, sQLCommand)).getStmtResultType() != null && sQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH) {
            sQLCommand.setStmtType(SQLCommand.StmtType.G_C_SQL);
        }
        return sQLCommand;
    }

    private SQLCommand getPropertiesForParserHint(String string) {
        SQLCommand sQLCommand = null;
        Object var3_3 = null;
        if (string.startsWith("/*")) {
            string = string.toLowerCase();
            for (String string2 : SQLStatementTypes.hintTokens.keySet()) {
                if (!string.startsWith(string2)) continue;
                sQLCommand = SQLStatementTypes.hintTokens.get(string2);
            }
        }
        return sQLCommand;
    }

    private SQLCommand getHalfRecognizedMultiToken(String string) {
        Set<String> set = SQLStatementTypes.halfRecognizedMultiToken.keySet();
        for (String string2 : set) {
            if (!string.toLowerCase().startsWith(string2)) continue;
            return SQLStatementTypes.halfRecognizedMultiToken.get(string2);
        }
        return null;
    }

    private void setError(SQLCommand sQLCommand) {
        sQLCommand.setProperty("prop_error_string", ScriptRunnerDbArb.getString("SQLPLUS_COMMAND_USAGE"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLCommand refineStmtRecognition(SQLCommand sQLCommand, String string) {
        String string2 = null;
        String string3 = null;
        if (sQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET) {
            String[] stringArray = this.getTokens(string);
            if (stringArray.length < 2) {
                sQLCommand.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_ECHO);
                this.setError(sQLCommand);
                sQLCommand.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
                return sQLCommand;
            }
            if (stringArray[1].equalsIgnoreCase("constraint") || stringArray[1].equalsIgnoreCase("constraints") || stringArray[1].equalsIgnoreCase("role") || stringArray[1].equalsIgnoreCase("transaction")) {
                SQLCommand sQLCommand2 = this.getSetCommand(stringArray[1]);
                sQLCommand2.setOrigSQL(string);
                sQLCommand2.setModifiedSQL(string);
                sQLCommand2.setStartLine(sQLCommand.getStartLine());
                sQLCommand2.setEndLine(sQLCommand.getEndLine());
                sQLCommand2.setLines(sQLCommand.getLines());
                sQLCommand2.setOrigEndLine(sQLCommand.getOrigEndLine());
                sQLCommand2.setOrigStartLine(sQLCommand.getOrigStartLine());
                sQLCommand2.setStmtType(SQLCommand.StmtType.G_C_SQL);
                return sQLCommand2;
            }
            if (!stringArray[1].equalsIgnoreCase("worksheetname")) {
                sQLCommand.setProperty("SET_TOKENS", stringArray);
                sQLCommand.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
                return sQLCommand;
            }
            SQLCommand sQLCommand3 = this.getSetCommand(stringArray[1]);
            sQLCommand3.setOrigSQL(string);
            sQLCommand3.setModifiedSQL(string);
            sQLCommand3.setStartLine(sQLCommand.getStartLine());
            sQLCommand3.setEndLine(sQLCommand.getEndLine());
            sQLCommand3.setLines(sQLCommand.getLines());
            sQLCommand3.setOrigEndLine(sQLCommand.getOrigEndLine());
            sQLCommand3.setOrigStartLine(sQLCommand.getOrigStartLine());
            sQLCommand3.setStmtType(SQLCommand.StmtType.G_C_USERDEFINED);
            sQLCommand = sQLCommand3;
            if (stringArray.length <= 2) {
                this.setError(sQLCommand);
                return sQLCommand;
            }
            string3 = stringArray[2];
            string2 = stringArray[2].toLowerCase();
            if (string2.equals("on")) {
                sQLCommand.setProperty("prop_status_boolean", new Boolean(true));
            } else if (string2.equals("off")) {
                sQLCommand.setProperty("prop_status_boolean", new Boolean(false));
            }
            if (string3 != null && !string3.equals("")) {
                sQLCommand.setProperty("prop_file_string", string3);
            } else {
                sQLCommand.setProperty("prop_file_string", string2);
            }
            if (sQLCommand.getProperty("prop_status_boolean") != null) return sQLCommand;
            sQLCommand.setProperty("prop_status_boolean", new Boolean(true));
            return sQLCommand;
        }
        if (sQLCommand.isSqlPlusSetCmd() || sQLCommand.isCreateCmd() || sQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME) {
            String[] stringArray = this.getTokens(string);
            if (stringArray.length <= 2) {
                this.setError(sQLCommand);
                return sQLCommand;
            }
            string3 = stringArray[2];
            string2 = stringArray[2].toLowerCase();
            if (string2.equals("replace") || string2.equals("temporary")) {
                if (stringArray.length <= 4) {
                    this.setError(sQLCommand);
                    return sQLCommand;
                }
                string3 = stringArray[4];
                string2 = stringArray[4];
            }
        } else {
            String[] stringArray;
            if (sQLCommand.getStmtSubType() != SQLCommand.StmtSubType.G_S_SPOOL) {
                if (sQLCommand.getStmtSubType() != SQLCommand.StmtSubType.G_S_DEFINE) return sQLCommand;
            }
            if ((stringArray = this.getTokens(string)).length <= 1) return sQLCommand;
            string3 = stringArray[1];
            string2 = stringArray[1].toLowerCase();
        }
        if (string2.equals("on")) {
            sQLCommand.setProperty("prop_status_boolean", new Boolean(true));
        } else if (string2.equals("off")) {
            sQLCommand.setProperty("prop_status_boolean", new Boolean(false));
        }
        if (string3 != null && !string3.equals("")) {
            sQLCommand.setProperty("prop_file_string", string3);
        } else {
            sQLCommand.setProperty("prop_file_string", string2);
        }
        if (sQLCommand.getProperty("prop_status_boolean") != null) return sQLCommand;
        sQLCommand.setProperty("prop_status_boolean", new Boolean(true));
        return sQLCommand;
    }

    private void lateEvaluateInitCompoundSetCommand(SQLCompoundCommand sQLCompoundCommand, boolean bl) {
        SQLCompoundCommand sQLCompoundCommand2 = sQLCompoundCommand;
        Boolean bl2 = (Boolean)sQLCompoundCommand2.getProperty("SET_PARSED");
        if (bl2 == null || !bl2.booleanValue()) {
            String[] stringArray = null;
            stringArray = !bl ? this.getTokens(SQLPLUS.removeDashNewline(sQLCompoundCommand.getOrigSQL())) : this.getTokens(sQLCompoundCommand.getOrigSQL());
            sQLCompoundCommand.setProperty("SET_PARSED", Boolean.TRUE);
            if (stringArray != null) {
                int n = 0;
                for (int i = 1; i < stringArray.length; ++i) {
                    String string;
                    SQLCommand sQLCommand = null;
                    boolean bl3 = false;
                    if (i != n + 1) {
                        string = stringArray[i].toLowerCase(Locale.US);
                        sQLCommand = this.getSetCommand(string);
                        if (sQLCommand != null && (string.equals("table") || string.equals("worksheetname") || string.equals("spool"))) {
                            sQLCommand = null;
                        } else if (sQLCommand == null) {
                            bl3 = this.checkAllTokens(string);
                            if (bl3 && string.equals("context")) {
                                bl3 = false;
                            }
                            if (bl3 && (string.equals("table") || string.equals("worksheetname") || string.equals("spool"))) {
                                bl3 = false;
                            }
                        }
                        if (string.equals("head") && stringArray[n + 1].toLowerCase(Locale.US).startsWith("mark") && i + 1 != stringArray.length - 1 && !stringArray[i + 1].toLowerCase(Locale.US).equals("on") && !stringArray[i + 1].toLowerCase(Locale.US).equals("off")) {
                            sQLCommand = null;
                            bl3 = false;
                        }
                    }
                    string = "";
                    String string2 = "";
                    if (sQLCommand != null || bl3) {
                        string = stringArray[i - 1].toLowerCase(Locale.US);
                        if (i > n + 1) {
                            string2 = stringArray[i - 2].toLowerCase(Locale.US);
                        }
                        if (i > n + 1 && (stringArray[n + 1].toLowerCase(Locale.US).startsWith("errorl") && (string.equals("table") || string.equals("identifier")) && !string2.equals("table") && !string2.equals("identifier") || stringArray[n + 1].toLowerCase(Locale.US).startsWith("mark") && (string.equals("table") || string.equals("body") || string.equals("head")) && !string2.equals("table") && !string2.equals("body") && !string2.equals("head"))) {
                            sQLCommand = null;
                        } else if (i == n + 2 && (string.startsWith("appi") || string.startsWith("editf") || string.startsWith("colsep") || string.equals("null") || string.startsWith("pau") || string.startsWith("worksheetname") || string.startsWith("numf") || string.startsWith("sqlco") || string.startsWith("sqlp") || string.equals("instance") || string.equals("logsource") || string.startsWith("suf"))) {
                            sQLCommand = null;
                        } else if (i == n + 3 && stringArray[i - 2].toLowerCase().equals("xquery") && (string.equals("context") || string.equals("baseuri"))) {
                            sQLCommand = null;
                        }
                    }
                    if (sQLCommand == null && !bl3) continue;
                    this.fillSubCmd(sQLCompoundCommand, stringArray, n, i - 1);
                    n = i - 1;
                }
                if (n != stringArray.length - 1) {
                    this.fillSubCmd(sQLCompoundCommand, stringArray, n, stringArray.length - 1);
                }
            }
        }
    }

    private SQLCommand fillSubCmd(SQLCompoundCommand sQLCompoundCommand, String[] stringArray, int n, int n2) {
        SQLCommand sQLCommand = this.getSetCommand(stringArray[n + 1]);
        if (sQLCommand == null) {
            sQLCommand = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_SET_UNKNOWN, SQLCommand.StmtResultType.G_R_NONE, false);
        }
        if (sQLCommand != null || stringArray[n + 1].equalsIgnoreCase("worksheetname")) {
            sQLCompoundCommand.addCommand(sQLCommand);
            StringBuffer stringBuffer = new StringBuffer("set");
            for (int i = n + 1; i <= n2 && i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuffer.append(" " + stringArray[i]);
            }
            sQLCommand.setOrigStartLine(sQLCompoundCommand.getOrigStartLine());
            sQLCommand.setOrigEndLine(sQLCompoundCommand.getOrigEndLine());
            sQLCommand.setStartLine(sQLCompoundCommand.getStartLine());
            sQLCommand.setEndLine(sQLCompoundCommand.getEndLine());
            sQLCommand.setOrigSQL(stringBuffer.toString());
            sQLCommand.setModifiedSQL(sQLCommand.getOrigSQL());
            int n3 = n + 1;
            if (n2 >= n3 + 1) {
                String string = stringArray[n3 + 1];
                String string2 = string.toLowerCase();
                if (string2.equals("on")) {
                    sQLCommand.setProperty("prop_status_boolean", Boolean.TRUE);
                } else if (string2.equals("off")) {
                    sQLCommand.setProperty("prop_status_boolean", Boolean.FALSE);
                }
                if (string != null && !string.equals("")) {
                    sQLCommand.setProperty("prop_file_string", string);
                } else {
                    sQLCommand.setProperty("prop_file_string", string2);
                }
                if (sQLCommand.getProperty("prop_status_boolean") == null) {
                    sQLCommand.setProperty("prop_status_boolean", Boolean.TRUE);
                }
                if (sQLCommand.getProperty("prop_status_boolean") == null) {
                    sQLCommand.setProperty("prop_status_boolean", new Boolean(true));
                }
            } else {
                this.setError(sQLCommand);
            }
        } else {
            sQLCompoundCommand.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_UNKNOWN);
        }
        return sQLCommand;
    }

    private boolean checkAllTokens(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"appi", "array", "auto", "blo", "cmds", "colsep", "con", "copyc", "copytypecheck", "def", "describe", "echo", "editf", "emb", "errorl", "esc", "exitc", "feed", "flagger", "flu", "hea", "instrance", "lin", "lobof", "logsource", "long", "mark", "newp", "null", "num", "pages", "pau", "recsep", "serverout", "shift", "show", "sqlbl", "sqlc", "sqln", "sqlpluscompat", "sqlpre", "sqlp", "sqlt", "suf", "tab", "term", "ti", "trim", "und", "ver", "wra", "xmlopt", "xquery"}) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private SQLCommand getSetCommand(String string) {
        String string2 = string.toLowerCase(Locale.US);
        Set<String> set = SQLStatementTypes.setCommands.keySet();
        for (String string3 : set) {
            if (!string2.startsWith(string3)) continue;
            return SQLStatementTypes.setCommands.get(string3);
        }
        return null;
    }

    private String[] getTokens(String string) {
        string = string.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
        string = string.replace("  ", " ");
        if ((string = string.trim()).endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        State state = State.NORM;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (state) {
                case INQUOTE: {
                    if (string.charAt(i) != '\'') continue block5;
                    if (i == string.length() - 1 || string.charAt(i + 1) != '\'') {
                        state = State.NORM;
                        arrayList.add(string.substring(n, i + 1));
                        while (i + 1 != string.length() && string.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        n = i + 1;
                        continue block5;
                    }
                    if (i == string.length() - 1 || string.charAt(i + 1) != '\'') continue block5;
                    ++i;
                    continue block5;
                }
                case INDOUBLEQUOTE: {
                    if (string.charAt(i) != '\"') continue block5;
                    if (i == string.length() - 1 || string.charAt(i + 1) != '\"') {
                        state = State.NORM;
                        arrayList.add(string.substring(n, i + 1));
                        while (i + 1 != string.length() && string.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        n = i + 1;
                        continue block5;
                    }
                    if (i == string.length() - 1 || string.charAt(i + 1) != '\"') continue block5;
                    ++i;
                    continue block5;
                }
                case NORM: {
                    if (string.charAt(i) == '\'') {
                        if (i != 0 && string.charAt(i - 1) != ' ') continue block5;
                        state = State.INQUOTE;
                        continue block5;
                    }
                    if (string.charAt(i) == '\"') {
                        if (i != 0 && string.charAt(i - 1) != ' ') continue block5;
                        state = State.INDOUBLEQUOTE;
                        continue block5;
                    }
                    if (string.charAt(i) != ' ') continue block5;
                    arrayList.add(string.substring(n, i));
                    while (i + 1 != string.length() && string.charAt(i + 1) == ' ') {
                        ++i;
                    }
                    n = i + 1;
                }
            }
        }
        if (n != string.length()) {
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private SQLCommand getPropertiesWhenMulitpleTokensKnown(String string) {
        String string2 = this.stripLine(string);
        Set<String> set = SQLStatementTypes.multiToken.keySet();
        for (String string3 : set) {
            if (!string2.startsWith(string3)) continue;
            return SQLStatementTypes.multiToken.get(string3);
        }
        return null;
    }

    private SQLCommand createUnknownStatementProperties() {
        return new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_UNKNOWN, SQLCommand.StmtResultType.G_R_UNKNOWN, true);
    }

    private SQLCommand getPropertiesWhenNoSpaceRequired(String string) {
        SQLCommand sQLCommand = null;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = null;
        if ((string = string.trim()).length() >= 2) {
            string2 = string.trim().substring(0, 2);
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(string2)) {
                sQLCommand = SQLStatementTypes.noSpaceRequiredTokens.get(string2);
            } else {
                string2 = string.trim().substring(0, 1);
                if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(string2)) {
                    sQLCommand = SQLStatementTypes.noSpaceRequiredTokens.get(string2);
                }
            }
        } else {
            string2 = string;
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(string2)) {
                sQLCommand = SQLStatementTypes.noSpaceRequiredTokens.get(string2);
            }
        }
        return sQLCommand;
    }

    private SQLCommand getPropertiesWhenTokensKnown(String string) {
        String[] stringArray = string.trim().split("[ \n\r\t*]");
        if (stringArray[0] != null) {
            if (stringArray[0].length() > 0 && stringArray[0].charAt(stringArray[0].length() - 1) == ';') {
                stringArray[0] = stringArray[0].replaceAll(";", "");
            }
            return SQLStatementTypes.spaceRequiredTokens.get(stringArray[0].toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    private boolean isWrapped(String string) {
        String string2 = string.toLowerCase();
        if (string2.indexOf("wrapped") == -1) {
            return false;
        }
        boolean bl = false;
        String string3 = this.checkInLineComments(string2);
        int n = string3.indexOf("wrapped");
        if (n > 2 && string3.length() > n + 8) {
            char c = string3.charAt(n - 1);
            char c2 = string3.charAt(n + 7);
            if (Character.isWhitespace(c) && Character.isWhitespace(c2)) {
                bl = true;
            }
        }
        return bl;
    }

    private StringBuffer findEndOfSQLAndPLSQL(String string, BufferedReader bufferedReader, SQLCommand sQLCommand, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        boolean bl3 = false;
        int n = 0;
        int n2 = 1;
        String string2 = null;
        while (bl2) {
            int n3;
            int n4 = -1;
            if (string == null) {
                n3 = 0;
            } else {
                boolean bl4 = true;
                if (sQLCommand.getStmtType() == SQLCommand.StmtType.G_C_PLSQL) {
                    bl4 = false;
                }
                int[] nArray = this.numberOfQuotes(string, bl4, true);
                n3 = nArray[0];
                n = nArray[1];
                n4 = nArray[2];
            }
            if (n3 % 2 != 0) {
                boolean bl5 = bl3 = !bl3;
            }
            if (string != null && !bl && bl3 && (string.trim().endsWith("\n/") || string.trim().equals("/")) && this.isWrapped(stringBuffer.toString())) {
                n3 = 0;
                bl3 = false;
            }
            if (string != null && !bl3) {
                if (n4 != -1 && bl) {
                    this.m_leftOver = string.length() != n4 + 1 ? string.substring(n4 + 1) : null;
                    string = string.substring(0, n4);
                    string2 = ";";
                    bl2 = false;
                } else if (string.trim().endsWith(";") && n == 0 && bl) {
                    bl2 = false;
                    string = string.substring(0, string.lastIndexOf(";"));
                    string2 = ";";
                } else if (string.trim().endsWith("\n/") || string.trim().equals("/")) {
                    bl2 = false;
                    string = string.substring(0, string.lastIndexOf("/"));
                    string2 = "\n/";
                } else if (string.trim().equals(".")) {
                    bl2 = false;
                    string = string.substring(0, string.lastIndexOf("."));
                    string2 = "\n.";
                }
                stringBuffer.append(string + "\n");
                if (bl2) {
                    string = bufferedReader.readLine();
                    ++n2;
                    ++this.m_readerLineCnt;
                }
            } else {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
                ++n2;
                ++this.m_readerLineCnt;
            }
            if (string != null) continue;
            bl2 = false;
        }
        sQLCommand.setOrigStartLine(this.m_readerLineStartCnt);
        sQLCommand.setOrigEndLine(this.m_readerLineCnt);
        sQLCommand.setStatementTerminator(string2);
        return stringBuffer;
    }

    private StringBuffer findEndOfSQLPLUS(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 1;
        while (bl) {
            if (string.trim().endsWith("-")) {
                bl = true;
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
                ++n;
                ++this.m_readerLineCnt;
                if (string != null) continue;
                bl = false;
                continue;
            }
            bl = false;
            stringBuffer.append(string + "\n");
        }
        sQLCommand.setOrigStartLine(this.m_readerLineStartCnt);
        sQLCommand.setOrigEndLine(this.m_readerLineCnt);
        if (stringBuffer.toString().trim().endsWith(";") && stringBuffer.length() > 1) {
            String string2 = stringBuffer.substring(0, stringBuffer.lastIndexOf(";"));
            stringBuffer = new StringBuffer(string2);
            sQLCommand.setStatementTerminator(";");
        }
        return stringBuffer;
    }

    private StringBuffer findEndOfMultiLineComment(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 1;
        while (bl) {
            int n2 = string.indexOf("*/");
            if (n2 >= 0) {
                bl = false;
                if (n2 + 2 == string.length()) {
                    this.m_leftOver = "";
                } else {
                    this.m_leftOver = string.substring(n2 + 2);
                    string = string.substring(0, n2 + 2);
                }
                stringBuffer.append(string + "\n");
                continue;
            }
            stringBuffer.append(string + "\n");
            string = bufferedReader.readLine();
            ++n;
            ++this.m_readerLineCnt;
            if (string != null) continue;
            bl = false;
            stringBuffer.append("*/");
        }
        sQLCommand.setOrigStartLine(this.m_readerLineStartCnt);
        sQLCommand.setOrigEndLine(this.m_readerLineCnt);
        return stringBuffer;
    }

    private StringBuffer findEndOfOldComment(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 1;
        while (bl) {
            if (!string.trim().equals("#")) {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
                ++n;
                ++this.m_readerLineCnt;
                if (string != null) continue;
                bl = false;
                stringBuffer.append("\n#\n");
                continue;
            }
            stringBuffer.append(string + "\n");
            bl = false;
        }
        sQLCommand.setOrigStartLine(this.m_readerLineStartCnt);
        sQLCommand.setOrigEndLine(this.m_readerLineCnt);
        return stringBuffer;
    }

    private SQLCommand identifyEndOfStatement(String string, BufferedReader bufferedReader, SQLCommand sQLCommand) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            switch (sQLCommand.getStmtType()) {
                case G_C_SQL: {
                    stringBuffer = this.findEndOfSQLAndPLSQL(string, bufferedReader, sQLCommand, true);
                    break;
                }
                case G_C_PLSQL: {
                    stringBuffer = this.findEndOfSQLAndPLSQL(string, bufferedReader, sQLCommand, false);
                    break;
                }
                case G_C_SQLPLUS: {
                    stringBuffer = this.findEndOfSQLPLUS(string, bufferedReader, sQLCommand);
                    break;
                }
                case G_C_USERDEFINED: 
                case G_C_COMMENT: {
                    stringBuffer = this.findEndOfLine(string, sQLCommand);
                    break;
                }
                case G_C_UNKNOWN: {
                    s_logger.severe(ScriptRunnerDbArb.format("UNSUPPORTED_COMMAND_ARG", string));
                }
                case G_C_MULTILINECOMMENT: {
                    stringBuffer = this.findEndOfMultiLineComment(string, bufferedReader, sQLCommand);
                    break;
                }
                case G_C_OLDCOMMENT: {
                    stringBuffer = this.findEndOfOldComment(string, bufferedReader, sQLCommand);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            s_logger.severe(iOException.getLocalizedMessage());
        }
        this.m_state = 0;
        if (stringBuffer.length() > 0) {
            while (stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || stringBuffer.charAt(stringBuffer.length() - 1) == '\r') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            object = stringBuffer.toString();
            if (!(sQLCommand.getStmtResultType() == null || sQLCommand.getStmtResultType() != SQLCommand.StmtResultType.G_R_QUERY && sQLCommand.getStmtResultType() != SQLCommand.StmtResultType.G_R_DML || this.isWrapped(stringBuffer.toString()))) {
                object = this.checkInLineComments(stringBuffer.toString());
            }
            if (sQLCommand.getStmtResultType() != null && sQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH && ((String)object).trim().endsWith(";")) {
                object = ((String)object).trim().substring(0, ((String)object).trim().length() - 1);
            }
            sQLCommand.setOrigSQL(stringBuffer.toString());
            sQLCommand.setModifiedSQL((String)object);
        } else {
            sQLCommand.setOrigSQL(stringBuffer.toString());
            sQLCommand.setModifiedSQL(stringBuffer.toString());
        }
        if (sQLCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET) && sQLCommand instanceof SQLCompoundCommand) {
            object = (SQLCompoundCommand)sQLCommand;
            this.lateEvaluateInitCompoundSetCommand((SQLCompoundCommand)object, this.m_setLeftOver != null);
            if (!sQLCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                if (this.m_setLeftOver == null) {
                    this.m_setLeftOver = this.m_leftOver == null ? "" : this.m_leftOver;
                }
                List<SQLCommand> list = ((SQLCompoundCommand)object).getCommands();
                String string2 = "set ";
                boolean bl = false;
                for (SQLCommand sQLCommand2 : list) {
                    if (!bl) {
                        sQLCommand = sQLCommand2;
                        bl = true;
                        continue;
                    }
                    string2 = string2 + sQLCommand2.getSql().trim().substring(3).trim() + " ";
                }
                if (list.size() == 1) {
                    this.m_leftOver = this.m_setLeftOver;
                    this.m_setLeftOver = null;
                } else {
                    this.m_leftOver = string2;
                }
            }
        } else if (this.m_setLeftOver != null) {
            this.m_leftOver = this.m_setLeftOver;
            this.m_setLeftOver = null;
        }
        return sQLCommand;
    }

    private StringBuffer findEndOfLine(String string, SQLCommand sQLCommand) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "\n");
        sQLCommand.setOrigStartLine(this.m_readerLineStartCnt);
        sQLCommand.setOrigEndLine(this.m_readerLineCnt);
        return stringBuffer;
    }

    private String checkInLineComments(String string) {
        if ((string = this.checkforContinuationChars(string)).contains("--")) {
            int n = 0;
            int n2 = string.indexOf("--", n);
            while (n2 != -1) {
                if (this.amIInitial(string.substring(0, n2), true)) {
                    int n3 = string.indexOf("\n", n2);
                    if (n3 == -1 || n3 == string.length()) {
                        string = string.substring(0, n2);
                        n2 = -1;
                        continue;
                    }
                    string = string.substring(0, n2) + System.getProperty("line.separator") + string.substring(n3 + 1);
                    n2 = string.indexOf("--", n2);
                    continue;
                }
                ++n2;
                n2 = string.indexOf("--", n2);
            }
        }
        return string;
    }

    private String checkforContinuationChars(String string) {
        boolean bl = true;
        if (string.contains("-")) {
            String[] stringArray = string.split("\n");
            String string2 = "";
            if (stringArray.length != 0) {
                String[] stringArray2 = stringArray;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string3;
                    String string4 = string3 = stringArray2[i];
                    String string5 = "";
                    if (bl && string4.replaceAll("\\s+$", "").endsWith("-") && !string4.replaceAll("^\\s+", "").startsWith("--")) {
                        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string4);
                        boolean bl2 = false;
                        char c = stringCharacterIterator.last();
                        while (c != '\uffff') {
                            if (c == '-' && !bl2) {
                                string5 = ' ' + string5;
                                bl2 = true;
                            } else {
                                string5 = c + string5;
                            }
                            c = stringCharacterIterator.previous();
                        }
                        string2 = string2 + string5;
                        continue;
                    }
                    bl = false;
                    string5 = string4;
                    string2 = string2 + string5 + " \n";
                }
            } else {
                string2 = string;
            }
            if (string2.length() > 2) {
                if (string2.endsWith("\r\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(13));
                } else if (string2.endsWith("\n")) {
                    string2 = string2.substring(0, string2.lastIndexOf(10));
                }
            }
            return string2;
        }
        return string;
    }

    public String stripLine(String string) {
        String string2 = string;
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replaceAll("\n", "");
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\t", "");
        string2 = string2.toLowerCase();
        return string2;
    }

    private String getTop(String string) {
        String string2 = null;
        try {
            if (string == null) {
                string2 = this.m_reader.readLine();
                ++this.m_readerLineCnt;
            } else {
                string2 = string;
            }
            if (string2 == null) {
                return null;
            }
            while (this.isWhitespaceLTrim(string2).equals("")) {
                string2 = this.m_reader.readLine();
                ++this.m_readerLineCnt;
                if (string2 != null) continue;
                return null;
            }
            if (string2 != null) {
                string2 = this.isWhitespaceLTrim(string2);
            }
            this.m_readerLineStartCnt = this.m_readerLineCnt;
            if (string2.trim().toLowerCase().startsWith("create") || string2.trim().toLowerCase().startsWith("drop") || string2.trim().toLowerCase().startsWith("alter") || string2.trim().toLowerCase().startsWith("with")) {
                String string3 = "";
                while (string2.indexOf(";") == -1 && string2.indexOf("/") == -1 && string2.toLowerCase().indexOf("begin") == -1 && string3 != null) {
                    string3 = this.m_reader.readLine();
                    if (string3 != null) {
                        string2 = string2 + "\n" + string3;
                    }
                    ++this.m_readerLineCnt;
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return string2;
    }

    private String isWhitespaceLTrim(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            n = i;
            break;
        }
        if (n == -1) {
            string = "";
        } else if (n != 0) {
            string = string.substring(n);
        }
        return string;
    }

    public String getRawSQL() {
        return this.m_rawSQL;
    }

    public void setRawSQL(String string) {
        this.m_rawSQL = string;
    }

    public ISQLCommand[] getSqlStatements() {
        return this.m_sqlArray.toArray(new SQLCommand[this.m_sqlArray.size()]);
    }

    private boolean amIInitial(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if (n == 0) {
                int n5;
                int n6 = 100000;
                n4 = 0;
                int n7 = 1;
                for (n7 = 1; n7 < m_startAndEnd.length; ++n7) {
                    n5 = string.indexOf(m_startAndEnd[n7][0], n3);
                    if (n5 == -1 || n5 >= n6 || n7 == 5 && n5 + 2 == string.length()) continue;
                    n6 = n5;
                    n4 = n7;
                }
                n7 = 5;
                n5 = string.indexOf("Q'", n3);
                if (n5 != -1 && n5 < n6 && (n7 != 5 || n5 + 2 != string.length())) {
                    n6 = n5;
                    n4 = n7;
                }
                if (n4 == 5) {
                    this.m_quoteString = string.substring(n6 + 2, n6 + 3);
                    this.m_quoteString = this.getEndQuoteString(this.m_quoteString);
                }
                if (n4 == 5) {
                    ++n2;
                    n = 5;
                    n3 = n6 + 3;
                    continue;
                }
                if (n4 == 4) {
                    ++n2;
                    n = 4;
                    n3 = n6 + 1;
                    continue;
                }
                if (n4 == 0) {
                    return n == 0;
                }
                n = n4;
                n3 = n6 + m_startAndEnd[n4][0].length();
                continue;
            }
            String string2 = m_startAndEnd[n][1];
            if (n == 5) {
                string2 = this.m_quoteString + string2;
            }
            if ((n4 = string.indexOf(string2, n3)) == -1) {
                return n == 0;
            }
            n3 = n4 + string2.length();
            if (n == 4 || n == 5) {
                ++n2;
                this.m_quoteString = "";
            }
            n = 0;
        }
    }

    private int[] numberOfQuotes(String string, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        if ((string = string.replaceAll("\r", "")).indexOf(10) != -1) {
            int[] nArray = null;
            int n5 = 0;
            for (String string2 : string.split("\n")) {
                nArray = this.numberOfQuotes(string2, bl, bl2);
                n += nArray[0];
                if (bl && nArray[2] != -1) {
                    return new int[]{n, nArray[1], nArray[2] + n5};
                }
                n5 = n5 + string2.length() + "\n".length();
            }
            return new int[]{n, nArray[1], nArray[2]};
        }
        while (true) {
            int n6;
            int n7;
            int n8;
            if (this.m_state == 0) {
                int n9 = 100000;
                n8 = 0;
                n7 = 1;
                for (n7 = 1; n7 < m_startAndEnd.length; ++n7) {
                    n6 = string.indexOf(m_startAndEnd[n7][0], n2);
                    if (n6 == -1 || n6 >= n9 || n7 == 5 && n6 + 2 == string.length()) continue;
                    n9 = n6;
                    n8 = n7;
                }
                n7 = 5;
                n6 = string.indexOf("Q'", n2);
                if (n6 != -1 && n6 < n9 && (n7 != 5 || n6 + 2 != string.length())) {
                    n9 = n6;
                    n8 = n7;
                }
                if (bl && (n6 = string.indexOf(";", n2)) != -1 && n6 < n9) {
                    this.setFirstLine(string);
                    n4 = n6;
                    int[] nArray = new int[]{n, 0, n4};
                    return nArray;
                }
                if (n8 == 5) {
                    this.m_quoteString = string.substring(n9 + 2, n9 + 3);
                    this.m_quoteString = this.getEndQuoteString(this.m_quoteString);
                }
                if (n8 == 5) {
                    ++n;
                    this.m_state = 5;
                    n2 = n9 + 3;
                    continue;
                }
                if (n8 == 4) {
                    ++n;
                    this.m_state = 4;
                    n2 = n9 + 1;
                    continue;
                }
                if (n8 == 1 && this.m_firstLine && string.substring(n9).replaceAll("\\s+$", "").equals("--") && !string.replaceAll("\\s+$", "").replaceAll("^\\s+", "").equals("--")) {
                    n2 = n9 + 1;
                    continue;
                }
                if (n8 == 0) {
                    this.setFirstLine(string);
                    int[] nArray = new int[]{n, 0, n4};
                    return nArray;
                }
                this.m_state = n8;
                n2 = n9 + m_startAndEnd[n8][0].length();
                continue;
            }
            String string3 = m_startAndEnd[this.m_state][1];
            if (this.m_state == 5) {
                string3 = this.m_quoteString + string3;
            }
            n8 = 0;
            n7 = string.indexOf(string3, n2);
            if (bl2 && this.m_firstLine && this.m_state == 1 && n7 == -1 && string.replaceAll("\\s+$", "").endsWith("-") && !string.replaceAll("^\\s+", "").startsWith("--")) {
                n8 = 1;
            }
            if (bl2 && this.m_firstLine && this.m_state == 1) {
                while (n7 != -1) {
                    int n10 = n6 = string.substring(n2, n7).replaceAll("\\s+$", "").endsWith("-") && !string.replaceAll("^\\s+", "").startsWith("--") ? 1 : 0;
                    if (n6 == 0) break;
                    if (n7 + 1 <= string.length()) {
                        n7 = string.indexOf(string3, n7 + 1);
                        continue;
                    }
                    n8 = 1;
                    n7 = -1;
                }
            }
            if (n7 == -1) {
                if (this.m_state == 1) {
                    if (n8 == 0) {
                        this.m_state = 0;
                    }
                    if (string.trim().endsWith(";")) {
                        n3 = 1;
                    }
                } else if (this.m_state != 0 && string.trim().endsWith(";")) {
                    n3 = 1;
                }
                this.setFirstLine(string);
                int[] nArray = new int[]{n, n3, n4};
                return nArray;
            }
            n2 = n7 + string3.length();
            if (this.m_state == 4 || this.m_state == 5) {
                ++n;
                this.m_quoteString = "";
            }
            this.m_state = 0;
        }
    }

    void setFirstLine(String string) {
        if (this.m_firstLine && (!string.replaceAll("\\s+$", "").endsWith("-") || string.replaceAll("^\\s+", "").startsWith("--"))) {
            this.m_firstLine = false;
        }
    }

    boolean isQuoteStringValid(String string) {
        boolean bl = true;
        if (string.equals("\t") || string.equals("\r") || string.equals("\n") || string.equals(" ")) {
            bl = false;
        }
        return bl;
    }

    String getEndQuoteString(String string) {
        String string2 = string;
        if (string2.equals("[")) {
            string2 = "]";
        } else if (string2.equals("{")) {
            string2 = "}";
        } else if (string2.equals("<")) {
            string2 = ">";
        } else if (string2.equals("(")) {
            string2 = ")";
        }
        return string2;
    }

    static enum State {
        NORM,
        INQUOTE,
        INDOUBLEQUOTE;

    }
}

