/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.newscriptrunner.SQL;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptStatusDisplay;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.jdbc.OracleConnection;

public class ScriptRunner {
    private static final Logger LOGGER = Logger.getLogger(ScriptRunner.class.getName());
    private final String ENCODING = "UTF-8";
    private Connection m_conn;
    private ScriptRunnerContext m_scriptRunnerContext = null;
    private BufferedOutputStream m_out = null;
    private boolean m_printComments = false;
    private ScriptStatusDisplay m_status;
    private String m_directory = null;
    public static final String FORCE_PRINT = "force_print";
    public static final byte[] FORCE_PRINT_BYTES = ScriptRunnerContext.stringToByteArrayForScriptRunner(" force_print\n");
    SQLCommandRunner m_commandRunner = null;

    public static String[] nextToChar(String string, char c) {
        int n = string.indexOf(c);
        if (n == -1) {
            ScriptRunner.usage();
        }
        String string2 = n == string.length() - 1 ? "" : string.substring(n + 1);
        String[] stringArray = new String[]{string.substring(0, n), string2};
        return stringArray;
    }

    public static void usage() {
        LOGGER.info("Usage: java ooracle.dbtools.raptor.scriptrunner.ScriptRunner username/password@host:port:sid @file1 @file2 @file3 ...");
        System.exit(1);
    }

    public ScriptRunner(Connection connection, BufferedOutputStream bufferedOutputStream, ScriptRunnerContext scriptRunnerContext) {
        this.setConn(connection);
        this.m_out = bufferedOutputStream;
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    public Connection getConn() {
        return this.m_conn;
    }

    public BufferedOutputStream getOut() {
        return this.m_out;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    public ScriptStatusDisplay getStatusDisplay() {
        return this.m_status;
    }

    public String getStatusLine() {
        return this.m_status != null ? this.m_status.getText() : null;
    }

    public boolean isPrintComments() {
        return this.m_printComments;
    }

    protected void report(String string) {
        if (this.m_out != null) {
            try {
                this.m_out.write(string.getBytes("UTF-8"));
                this.m_out.write(10);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ISQLCommand iSQLCommand) throws IOException {
        Object object;
        if (!(this.m_out instanceof WrapListenBufferOutputStream)) {
            this.getScriptRunnerContext().setOutputStreamWrapper(this.m_out);
            this.m_out = this.getScriptRunnerContext().getOutputStream();
        }
        boolean bl = this.getConn() instanceof OracleConnection;
        if (this.getScriptRunnerContext().getExited()) {
            CommandRegistry.fireBeginListeners(this.m_conn, this.getScriptRunnerContext(), iSQLCommand);
            return;
        }
        Substitution substitution = new Substitution(this.getScriptRunnerContext());
        try {
            try {
                substitution.replaceSubstitution(iSQLCommand);
            }
            finally {
                CommandRegistry.fireBeginListeners(this.m_conn, this.getScriptRunnerContext(), iSQLCommand);
            }
        }
        catch (Substitution.SubstitutionException substitutionException) {
            this.report(substitutionException.getMessage());
            return;
        }
        if (this.getScriptRunnerContext().getExited()) {
            return;
        }
        if (!bl && iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_UNKNOWN) {
            object = SQLStatementTypes.hintTokens.get("/*sqldev:stmt*/");
            iSQLCommand.setStmtClass(((SQLCommand)object).getStmtClass());
            iSQLCommand.setStmtId(((SQLCommand)object).getStmtId());
            iSQLCommand.setResultsType(((SQLCommand)object).getResultsType());
            iSQLCommand.setExecutable(((SQLCommand)object).getExecutable());
        }
        object = (Integer)this.getScriptRunnerContext().getProperty("script.runner.restrictionlevel");
        boolean bl2 = true;
        if (object != null && (Integer)object != 0 && this.skipRestricted(iSQLCommand, (Integer)object)) {
            bl2 = false;
        }
        if (bl2 && !CommandRegistry.fireListeners(this.m_conn, this.getScriptRunnerContext(), iSQLCommand)) {
            switch (iSQLCommand.getStmtType()) {
                case G_C_SQL: {
                    this.runSQL(iSQLCommand);
                    break;
                }
                case G_C_PLSQL: {
                    this.runPLSQL(iSQLCommand);
                    break;
                }
                case G_C_SQLPLUS: 
                case G_C_OLDCOMMENT: {
                    this.runSQLPLUS(iSQLCommand);
                    break;
                }
                case G_C_COMMENT: 
                case G_C_MULTILINECOMMENT: 
                case G_C_EMPTYLINE: {
                    break;
                }
                case G_C_UNKNOWN: {
                    this.unknown(ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"), iSQLCommand);
                    break;
                }
                default: {
                    this.unknown("class", iSQLCommand);
                }
            }
        }
        CommandRegistry.fireEndListeners(this.m_conn, this.getScriptRunnerContext(), iSQLCommand);
        if (this.m_scriptRunnerContext.getProperty("script.runner.using.systemout") == null || !((Boolean)this.m_scriptRunnerContext.getProperty("script.runner.using.systemout")).booleanValue()) {
            this.m_out.write(FORCE_PRINT_BYTES);
        }
        this.m_out.flush();
    }

    private void runPLSQL(ISQLCommand iSQLCommand) {
        PLSQL pLSQL = new PLSQL(iSQLCommand, this.m_out);
        this.m_commandRunner = pLSQL;
        pLSQL.setScriptRunnerContext(this.getScriptRunnerContext());
        pLSQL.setConn(this.m_conn);
        pLSQL.run();
        this.setScriptRunnerContext(pLSQL.getScriptRunnerContext());
        pLSQL = null;
    }

    private void runSQL(ISQLCommand iSQLCommand) {
        SQL sQL = new SQL(iSQLCommand, this.m_out);
        this.m_commandRunner = sQL;
        sQL.setScriptRunnerContext(this.getScriptRunnerContext());
        sQL.setConn(this.m_conn);
        int n = sQL.getScriptRunnerContext().getFeedback();
        try {
            if (iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE)) {
                sQL.getScriptRunnerContext().setFeedback(-2);
                byte[] byArray = (iSQLCommand.getSQLOrig() + "\n").getBytes("UTF-8");
                this.m_out.write(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sQL.run();
        this.setScriptRunnerContext(sQL.getScriptRunnerContext());
        sQL.getScriptRunnerContext().setFeedback(n);
        sQL = null;
    }

    private void runSQLPLUS(ISQLCommand iSQLCommand) {
        SQLPLUS sQLPLUS = new SQLPLUS(iSQLCommand, this.m_out);
        this.m_commandRunner = sQLPLUS;
        sQLPLUS.setScriptRunnerContext(this.getScriptRunnerContext());
        sQLPLUS.setConn(this.m_conn);
        sQLPLUS.setDirectory(this.m_directory);
        sQLPLUS.run();
        this.m_conn = sQLPLUS.getConn();
        this.setScriptRunnerContext(sQLPLUS.getScriptRunnerContext());
        sQLPLUS = null;
        this.getScriptRunnerContext().setCurrentConnection(this.m_conn);
    }

    public void setConn(Connection connection) {
        this.m_conn = connection;
    }

    public void setOut(BufferedOutputStream bufferedOutputStream) {
        this.m_out = bufferedOutputStream;
    }

    public void setPrintComments(boolean bl) {
        this.m_printComments = bl;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    public void setStatusDisplay(ScriptStatusDisplay scriptStatusDisplay) {
        this.m_status = scriptStatusDisplay;
    }

    public void setStatusLine(String string) {
        if (this.m_status != null) {
            this.m_status.setText(string);
        }
    }

    private void unknown(String string, ISQLCommand iSQLCommand) {
        try {
            this.setStatusLine(ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"));
            String string2 = ScriptRunnerContext.lineErr(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), new Integer(iSQLCommand.getStartLine() + 1), iSQLCommand.getSQLOrig(), ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", string), this.getScriptRunnerContext());
            this.m_out.write(string2.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void setDirectory(String string) {
        this.m_directory = string;
    }

    public void cancel() {
        if (this.m_commandRunner != null) {
            this.m_commandRunner.interrupt();
        }
    }

    private boolean skipRestricted(ISQLCommand iSQLCommand, Integer n) {
        boolean bl = false;
        if (!n.equals(new Integer(4))) {
            return false;
        }
        switch (iSQLCommand.getStmtSubType()) {
            case G_S_ALTER: {
                String string = iSQLCommand.getSql().toLowerCase().trim().replace('\r', ' ').replace('\n', ' ');
                if (string.matches("alter\\s+session.*$")) {
                    bl = true;
                    break;
                }
                if (!string.matches("alter\\s+system.*$")) break;
                bl = true;
            }
        }
        if (!bl) {
            boolean bl2 = false;
            switch (iSQLCommand.getStmtType()) {
                case G_C_SQLPLUS: {
                    bl2 = true;
                }
            }
            if (!bl2) {
                return false;
            }
            switch (iSQLCommand.getStmtSubType()) {
                case G_S_EDIT: 
                case G_S_GET: 
                case G_S_HOST: 
                case G_S_HOSTALIAS: 
                case G_S_SAVE: 
                case G_S_SPOOL: 
                case G_S_AT: 
                case G_S_START: 
                case G_S_ATNESTED: 
                case G_S_STORE: 
                case G_S_CONNECT: {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.report(ScriptRunnerDbArb.format("RESTRICTED_COMMAND", iSQLCommand.getSQLOrig()));
        }
        return bl;
    }
}

