/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class WrapListenBufferOutputStream
extends BufferedOutputStream {
    private BufferedOutputStream m_out = null;
    private ArrayList<BufferedOutputStream> m_alout = new ArrayList();
    private File m_fileOutput = null;
    private boolean m_removeForcePrint = false;
    private ScriptRunnerContext ctx = null;

    public WrapListenBufferOutputStream(OutputStream outputStream) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
        assert (outputStream instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)outputStream;
        this.addToList((BufferedOutputStream)outputStream);
    }

    public WrapListenBufferOutputStream(OutputStream outputStream, int n) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()), n);
        assert (outputStream instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)outputStream;
        this.addToList((BufferedOutputStream)outputStream);
    }

    public WrapListenBufferOutputStream(OutputStream outputStream, ScriptRunnerContext scriptRunnerContext) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
        assert (outputStream instanceof BufferedOutputStream);
        this.m_out = (BufferedOutputStream)outputStream;
        this.addToList((BufferedOutputStream)outputStream);
        this.ctx = scriptRunnerContext;
    }

    public BufferedOutputStream getMainStream() {
        return this.m_out;
    }

    private boolean doIWrite(BufferedOutputStream bufferedOutputStream) {
        return this.ctx == null || !bufferedOutputStream.equals(this.getMainStream()) || this.ctx.getTopLevel() || !this.ctx.isOutputSupressed();
    }

    public void replaceMainStream(BufferedOutputStream bufferedOutputStream) throws IOException {
        if (!this.m_out.equals(bufferedOutputStream)) {
            this.flush();
            this.removeFromList(this.m_out);
            this.addToList(bufferedOutputStream);
            this.m_out = bufferedOutputStream;
        }
    }

    public void addToList(BufferedOutputStream bufferedOutputStream) {
        this.m_alout.add(bufferedOutputStream);
    }

    public boolean removeFromList(BufferedOutputStream bufferedOutputStream) {
        return this.m_alout.remove(bufferedOutputStream);
    }

    @Override
    public void flush() throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                bufferedOutputStream.flush();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                if (this.doIWrite(bufferedOutputStream)) {
                    bufferedOutputStream.write(byArray, n, n2);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    @Override
    public void write(int n) throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                if (this.doIWrite(bufferedOutputStream)) {
                    bufferedOutputStream.write(n);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        for (BufferedOutputStream bufferedOutputStream : this.m_alout) {
            IOException iOException = null;
            try {
                if ((!this.m_removeForcePrint || !Arrays.equals("force_print".getBytes("UTF8"), byArray) && !Arrays.equals(ScriptRunner.FORCE_PRINT_BYTES, byArray)) && this.doIWrite(bufferedOutputStream)) {
                    bufferedOutputStream.write(byArray);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) continue;
            throw iOException;
        }
    }

    public File getFileOutput() {
        return this.m_fileOutput;
    }

    public void setFileOutput(File file) {
        this.m_fileOutput = file;
    }

    public boolean isRemoveForcePrint() {
        return this.m_removeForcePrint;
    }

    public void setRemoveForcePrint(boolean bl) {
        this.m_removeForcePrint = bl;
    }
}

