/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class AutoTrace
extends AForAllStmtsCommand {
    private static final String ctxTraceState = "AUTOTRACE_STATE";
    private static final String ctxTraceType = "AUTOTRACE_TYPE";
    private static final String SPACE = "                                                                                ";
    private String AUTO_EXPLAIN = "EXPLAIN";
    private String AUTO_STAT = "STATISTICS";
    private String AUTO_ALL = "ALL";
    private String AUTO_NONE = "NONE";
    private String statSql = "select ms.Statistic# stat,ms.value,sn.name from v$mystat ms, v$statname  sn where sn.statistic# =  ms.statistic#  order by 1";
    private ResultSet _rset = null;
    private HashMap<Integer, Stat> bStats;
    private ArrayList<Stat> aStats;
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOTRACE;

    public AutoTrace() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty(ctxTraceState);
        if (bl == null) {
            scriptRunnerContext.putProperty(ctxTraceState, false);
            scriptRunnerContext.putProperty(ctxTraceType, false);
            bl = false;
        }
        if (bl.booleanValue() && !iSQLCommand.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) {
            this.bStats = new HashMap();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(this.statSql);
                this._rset = preparedStatement.executeQuery();
                while (this._rset.next()) {
                    Stat stat = new Stat(this._rset.getInt(2), this._rset.getString(3));
                    this.bStats.put(this._rset.getInt(1), stat);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void doEndWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (((Boolean)scriptRunnerContext.getProperty(ctxTraceState)).booleanValue() && !iSQLCommand.getStmtClass().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS)) {
            Object object;
            this.aStats = new ArrayList();
            try {
                object = connection.prepareStatement(this.statSql);
                this._rset = object.executeQuery();
                while (this._rset.next()) {
                    if (this._rset.getInt(2) - this.bStats.get(this._rset.getInt(1)).getValue() == 0) continue;
                    Stat stat = new Stat(this._rset.getInt(2) - this.bStats.get(this._rset.getInt(1)).getValue(), this._rset.getString(3));
                    this.aStats.add(stat);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_ALL) || scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_EXPLAIN)) {
                try {
                    object = connection.prepareStatement("explain plan for " + iSQLCommand.getSql());
                    this._rset = object.executeQuery();
                    object = connection.prepareStatement("SELECT * FROM table(DBMS_XPLAN.DISPLAY)");
                    this._rset = object.executeQuery();
                    while (this._rset.next()) {
                        this.write(this._rset.getString(1) + "\n", scriptRunnerContext);
                    }
                    this.write("\n", scriptRunnerContext);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            if (scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_ALL) || scriptRunnerContext.getProperty(ctxTraceType).equals(this.AUTO_STAT)) {
                if (this.aStats.size() > 0) {
                    this.write("   Statistics\n", scriptRunnerContext);
                    this.write("-----------------------------------------------------------\n", scriptRunnerContext);
                    Collections.sort(this.aStats, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return ((Stat)object).getName().compareTo(((Stat)object2).getName());
                        }
                    });
                    for (Stat stat : this.aStats) {
                        this.write(AutoTrace.lpad(16, String.valueOf(stat.getValue())) + "  " + stat.getName() + "\n", scriptRunnerContext);
                    }
                } else {
                    this.write(Messages.getString("AutoTrace.19"), scriptRunnerContext);
                    this.write(Messages.getString("AutoTrace.20"), scriptRunnerContext);
                }
            }
        }
    }

    @Override
    public boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().toLowerCase().trim().indexOf("set autotrace on exp") == 0) {
            scriptRunnerContext.putProperty(ctxTraceState, true);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_EXPLAIN);
            this.write(Messages.getString("AutoTrace.22"), scriptRunnerContext);
        } else if (iSQLCommand.getSql().toLowerCase().trim().indexOf("set autotrace on stat") == 0) {
            scriptRunnerContext.putProperty(ctxTraceState, true);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_STAT);
            this.write(Messages.getString("AutoTrace.24"), scriptRunnerContext);
        } else if (iSQLCommand.getSql().toLowerCase().trim().indexOf("set autotrace trace") == 0) {
            this.write(Messages.getString("AutoTrace.26"), scriptRunnerContext);
        } else if (iSQLCommand.getSql().toLowerCase().trim().equals("set autotrace on")) {
            scriptRunnerContext.putProperty(ctxTraceState, true);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_ALL);
            this.write(Messages.getString("AutoTrace.28"), scriptRunnerContext);
        } else if (iSQLCommand.getSql().toLowerCase().indexOf("set autotrace off") == 0) {
            scriptRunnerContext.putProperty(ctxTraceState, false);
            scriptRunnerContext.putProperty(ctxTraceType, this.AUTO_NONE);
            this.write(Messages.getString("AutoTrace.30"), scriptRunnerContext);
        } else if (iSQLCommand.getSql().toLowerCase().indexOf("set autotrace") == 0) {
            this.write(Messages.getString("AutoTrace.32"), scriptRunnerContext);
        }
        return true;
    }

    private static String lpad(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(SPACE.substring(0, n - string.length()));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void write(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        try {
            ((FilterOutputStream)wrapListenBufferOutputStream).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    @Override
    protected boolean isListenerOn(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty(ctxTraceState);
        return bl != null && bl != false;
    }

    private class Stat {
        int _value;
        String _name;

        Stat(int n, String string) {
            this._value = n;
            this._name = string;
        }

        String getName() {
            return this._name;
        }

        Integer getValue() {
            return this._value;
        }
    }
}

