/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Column
extends CommandListener {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String CMD = "\\b(?i:co(?:l\\b|lu\\b|lum\\b|lumn\\b))";
    private static final String CLEAR = "\\b(?i:cl(?:e\\b|ea\\b|ear\\b))";
    private static final String ONOROFF = "\\b(?i:on)|(?i:off)\\b";
    private static final String ON = "\\b(?i:on)\\b";
    private static final String OFF = "\\b(?i:off)\\b";
    private static final String WRAPPED = "(?i:wr(?:a|ap|app|appe|apped))";
    private static final String WORD_WRAPPED = "(?i:wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped))";
    private static final String TRUNCATED = "(?i:tr(?:u|un|unc|unca|uncat|uncate|uncated))";
    private static final String WRAP = "\\b(?:(?i:wr(?:a|ap|app|appe|apped))|(?i:wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped))|(?i:tr(?:u|un|unc|unca|uncat|uncate|uncated)))\\b";
    private static final String PRINT = "(?i:pr(?:i|in|int))";
    private static final String NPRINT = "(?i:nopr(?:i|in|int))";
    private static final String PRNT = "\\b(?:(?i:pr(?:i|in|int))|(?i:nopr(?:i|in|int)))\\b";
    private static final String FORMAT = "\\b(?i:fo(?:r|rm|rma|rmat))\\b";
    private static final String HEADING = "\\b(?i:he(?:a|ad|adi|adin|ading))\\b";
    private static final String LEFT = "(?i:l(?:|e|ef|eft))";
    private static final String CENTER = "(?i:c(?:|e|en|ent|ente|enter))";
    private static final String RIGHT = "(?i:r(?:|i|ig|igh|ight))";
    private static final String JUSTIFY = "\\b(?i:ju(?:s|st|sti|stif|stify))\\s+(?:(?i:l(?:|e|ef|eft))|(?i:c(?:|e|en|ent|ente|enter))|(?i:r(?:|i|ig|igh|ight)))\\b";
    private static final String NULL = "\\b(?i:nu(?:l|ll))\\b";
    private static final String NEWVAL = "\\b(?i:new_(?:v|va|val|value))\\b";
    private static final String HEADVAL_PTRN = "\\b(?i:he(?:a|ad|adi|adin|ading))\\b\\s+['\"].+['\"]";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().trim();
        String[] stringArray = string.split("\\s+");
        if (stringArray[0].matches(CMD)) {
            HashMap<String, ArrayList<String>> hashMap = scriptRunnerContext.getStoredFormatCmds();
            if (stringArray.length <= 2) {
                if (stringArray.length == 1) {
                    this.printAllColumns(scriptRunnerContext, hashMap);
                } else {
                    this.printColumn(scriptRunnerContext, hashMap, stringArray[1].trim());
                }
            } else {
                this.addOrRemoveColumnCommand(scriptRunnerContext, string);
            }
            return true;
        }
        return false;
    }

    private void addOrRemoveColumnCommand(ScriptRunnerContext scriptRunnerContext, String string) {
        Object object;
        HashMap<String, ArrayList<String>> hashMap = scriptRunnerContext.getStoredFormatCmds();
        String[] stringArray = string.split("(?i:\\s+|\\b(?i:he(?:a|ad|adi|adin|ading))\\b\\s+['\"].+['\"])");
        Matcher matcher = Pattern.compile(HEADVAL_PTRN).matcher(string);
        String string2 = "";
        if (matcher != null && matcher.find()) {
            boolean bl = false;
            string2 = matcher.group();
            object = string2.split("['\"].+['\"]");
            String[] stringArray2 = null;
            if (((String[])object).length == 1) {
                stringArray2 = new String[((String[])object).length + 1];
                stringArray2[0] = object[0].trim();
                stringArray2[1] = string2.replaceAll(object[0], "").trim();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() != 0) continue;
                stringArray[i] = stringArray2[0];
                stringArray[++i] = stringArray2[1];
                bl = true;
            }
            if (!bl) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                arrayList.addAll(Arrays.asList(stringArray2));
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
        }
        if (stringArray.length >= 3) {
            String string3 = stringArray[1].toLowerCase();
            object = null;
            object = hashMap.get(string3) != null ? hashMap.get(string3) : new ArrayList();
            for (int i = 2; i < stringArray.length; ++i) {
                Object object2;
                String string4 = "";
                if (stringArray[i].matches(CLEAR)) {
                    if (hashMap.containsKey(string3)) {
                        hashMap.remove(string3);
                        object = null;
                        continue;
                    }
                } else if (stringArray[i].matches(NEWVAL)) {
                    object2 = scriptRunnerContext.getColumnMap();
                    object2.put((String)string3.toUpperCase(), (String)stringArray[3].toUpperCase());
                } else if (stringArray[i].matches(ONOROFF)) {
                    if (stringArray[i].matches(ON)) {
                        this.removeItem((ArrayList<String>)object, "off");
                    } else if (stringArray[i].matches(OFF) && !((String)((ArrayList)object).get(0)).equalsIgnoreCase(stringArray[i])) {
                        ((ArrayList)object).add(0, stringArray[i]);
                    }
                } else if (stringArray[i].matches(WRAP)) {
                    if (((ArrayList)object).contains("wrapped")) {
                        this.removeItem((ArrayList<String>)object, "wrapped");
                    } else if (((ArrayList)object).contains("word_wrapped")) {
                        this.removeItem((ArrayList<String>)object, "word_wrapped");
                    } else if (((ArrayList)object).contains("truncated")) {
                        this.removeItem((ArrayList<String>)object, "truncated");
                    }
                    if (stringArray[i].matches(WRAPPED)) {
                        string4 = "wrapped";
                    } else if (stringArray[i].matches(WORD_WRAPPED)) {
                        string4 = "word_wrapped";
                    } else if (stringArray[i].matches(TRUNCATED)) {
                        string4 = "truncated";
                    }
                } else if (stringArray[i].matches(PRNT)) {
                    if (((ArrayList)object).contains("noprint")) {
                        this.removeItem((ArrayList<String>)object, "noprint");
                    } else {
                        this.removeItem((ArrayList<String>)object, "print");
                    }
                    if (stringArray[i].matches(PRINT)) {
                        string4 = "print";
                    } else if (stringArray[i].matches(NPRINT)) {
                        string4 = "noprint";
                    }
                } else if (stringArray[i].matches(FORMAT) || stringArray[i].matches(HEADING) || i + 1 < stringArray.length && (stringArray[i] + " " + stringArray[i + 1]).matches(JUSTIFY) || stringArray[i].matches(NULL)) {
                    this.removeItem((ArrayList<String>)object, stringArray[i]);
                    if (i == stringArray.length - 1) {
                        string4 = stringArray[i];
                    } else {
                        if (stringArray[i].matches(FORMAT)) {
                            string4 = "format ";
                        } else if (stringArray[i].matches(HEADING)) {
                            string4 = "heading ";
                        } else if ((stringArray[i] + " " + stringArray[i + 1]).matches(JUSTIFY)) {
                            string4 = "justify ";
                        } else if (stringArray[i].matches(NULL)) {
                            string4 = "null ";
                        }
                        object2 = stringArray[++i];
                        if (string4.startsWith("justify")) {
                            if (((String)object2).matches(LEFT)) {
                                object2 = "left";
                            } else if (((String)object2).matches(CENTER)) {
                                object2 = "center";
                            } else if (((String)object2).matches(RIGHT)) {
                                object2 = "right";
                            }
                        }
                        object2 = ((String)object2).replaceAll("['\"]", "");
                        string4 = string4 + (String)object2;
                    }
                }
                if (string4.equals("")) continue;
                if (object == null) {
                    object = new ArrayList();
                }
                ((ArrayList)object).add(string4);
            }
            if (object != null) {
                hashMap.put(string3, (ArrayList<String>)object);
            }
        }
    }

    private void removeItem(ArrayList<String> arrayList, String string) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).startsWith(string.toLowerCase()) && !arrayList.get(i).equalsIgnoreCase(string)) continue;
                arrayList.remove(i);
                break;
            }
        }
    }

    private void printAllColumns(ScriptRunnerContext scriptRunnerContext, HashMap<String, ArrayList<String>> hashMap) {
        if (hashMap != null) {
            for (Map.Entry<String, ArrayList<String>> entry : hashMap.entrySet()) {
                this.print(scriptRunnerContext, entry);
            }
        }
    }

    private void printColumn(ScriptRunnerContext scriptRunnerContext, HashMap<String, ArrayList<String>> hashMap, String string) {
        if (string.length() > 0) {
            for (Map.Entry<String, ArrayList<String>> entry : hashMap.entrySet()) {
                if (!entry.getKey().equals(string)) continue;
                this.print(scriptRunnerContext, entry);
                return;
            }
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("COLUMN_NOTDEFINED"), string) + m_lineSeparator + m_lineSeparator);
        }
    }

    private void print(ScriptRunnerContext scriptRunnerContext, Map.Entry<String, ArrayList<String>> entry) {
        if (scriptRunnerContext != null && entry != null) {
            String string = "";
            String string2 = "";
            String string3 = entry.getKey();
            ArrayList<String> arrayList = entry.getValue();
            if (arrayList.size() > 0) {
                String string4 = arrayList.get(0);
                string = string4.equalsIgnoreCase("off") ? "COLUMN  '" + string3 + "'" + " OFF" + m_lineSeparator : "COLUMN  '" + string3 + "'" + " ON" + m_lineSeparator;
            }
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5 = arrayList.get(i);
                if (string5.equalsIgnoreCase("off")) continue;
                String[] stringArray = string5.split("\\s+");
                if (stringArray.length > 1) {
                    if (stringArray[0].equalsIgnoreCase("heading")) {
                        string = string + stringArray[0].toUpperCase().trim() + "  " + "'" + stringArray[1] + "'";
                        string = string + " headsep '" + (String)scriptRunnerContext.getProperty("script.runner.setheadsepchar") + "'";
                        string = string + m_lineSeparator;
                        continue;
                    }
                    if (stringArray[0].equalsIgnoreCase("justify")) {
                        string2 = string2 + stringArray[0].toUpperCase().trim() + " " + stringArray[1] + " ";
                        continue;
                    }
                    string = string + stringArray[0].toUpperCase().trim() + "  " + stringArray[1] + m_lineSeparator;
                    continue;
                }
                string2 = stringArray[0].equalsIgnoreCase("word_wrapped") ? string2 + "word_wrap " : (stringArray[0].equalsIgnoreCase("wrapped") ? string2 + "wrap " : (stringArray[0].equalsIgnoreCase("truncated") ? string2 + "truncate " : string2 + stringArray[0] + " "));
            }
            string = string + string2.trim() + m_lineSeparator + m_lineSeparator;
            scriptRunnerContext.write(string);
        }
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

