/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Help
extends CommandListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (iSQLCommand.getSql() + " ").substring((iSQLCommand.getSql() + " ").indexOf(" ")).trim();
        try {
            scriptRunnerContext.write(this.HelpOnOrIndex(string));
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    private String HelpOnOrIndex(String string) throws Exception {
        if (string == null || string.equals("") || string.equalsIgnoreCase("help") || string.equalsIgnoreCase("index") || string.equalsIgnoreCase("?")) {
            return this.getHelpProperties("");
        }
        String string2 = this.getHelpProperties(string);
        if (string2 == null || string2.equals("")) {
            return this.getHelpProperties("");
        }
        return string2;
    }

    private String getHelpProperties(String string) throws Exception {
        String string2 = null;
        if (string.equals("")) {
            Enumeration<String> enumeration = HelpMessages.getKeys();
            if (enumeration == null) {
                throw new Exception(Messages.getString("NO_HELP_KEYS"));
            }
            ArrayList<String> arrayList = Collections.list(enumeration);
            Collections.sort(arrayList);
            string2 = Messages.getString("LIST_OF_HELP_TOPICS");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : arrayList) {
                stringBuilder.append("    ").append(string3.replace("_", " ")).append("\n");
            }
            string2 = string2 + stringBuilder.toString();
        } else {
            string2 = HelpMessages.getString(string.replace(" ", "_").toUpperCase());
        }
        return string2;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

