/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetAutoCommit
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOCOMMIT;

    public SetAutoCommit() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        scriptRunnerContext.putProperty("script.runner.autocommit.errorFlag", Boolean.FALSE);
    }

    @Override
    public void doEndWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            Long l = (Long)scriptRunnerContext.getProperty("script.runner.autocommit.setting");
            if (l.equals(ScriptRunnerContext.AUTOCOMMITOFF)) {
                return;
            }
            if (l.equals(ScriptRunnerContext.AUTOCOMMITON)) {
                this.doCommit(scriptRunnerContext);
                return;
            }
            switch (iSQLCommand.getStmtSubType()) {
                case G_S_INSERT: 
                case G_S_UPDATE: 
                case G_S_DELETE: 
                case G_S_EXECUTE: 
                case G_S_BEGIN: {
                    Long l2;
                    if (scriptRunnerContext.getProperty("script.runner.autocommit.errorFlag") != null && ((Boolean)scriptRunnerContext.getProperty("script.runner.autocommit.errorFlag")).booleanValue()) break;
                    if (l.equals(ScriptRunnerContext.AUTOCOMMITON)) {
                        this.doCommit(scriptRunnerContext);
                        return;
                    }
                    Long l3 = l2 = (Long)scriptRunnerContext.getProperty("script.runner.autocommit.counter");
                    Long l4 = l2 = Long.valueOf(l2 + 1L);
                    if (l.equals(l2)) {
                        scriptRunnerContext.putProperty("script.runner.autocommit.counter", new Long(0L));
                        this.doCommit(scriptRunnerContext);
                    } else {
                        scriptRunnerContext.putProperty("script.runner.autocommit.counter", l2);
                    }
                    return;
                }
                case G_S_SET_AUTOCOMMIT: 
                case G_S_COMMIT: 
                case G_S_ROLLBACK_PLUS: 
                case G_S_ROLLBACK_SQL: {
                    scriptRunnerContext.putProperty("script.runner.autocommit.counter", new Long(0L));
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(ScriptRunnerContext scriptRunnerContext) {
        Connection connection = scriptRunnerContext.getCurrentConnection();
        boolean bl = false;
        try {
            bl = DBUtil.getConnectionResolver().lock(connection);
            if (bl) {
                scriptRunnerContext.getCurrentConnection().commit();
                if (scriptRunnerContext.getFeedback() != -2) {
                    scriptRunnerContext.write(Messages.getString("COMMIT_COMPLETE") + "\n");
                }
            }
        }
        catch (SQLException sQLException) {
            scriptRunnerContext.write(Messages.getString("COMMIT_FAILED") + "\n");
            scriptRunnerContext.write(sQLException.getLocalizedMessage() + "\n");
        }
        finally {
            if (bl) {
                try {
                    DBUtil.getConnectionResolver().unlock(connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)iSQLCommand.getProperty("prop_file_string");
        if (string != null) {
            try {
                if (scriptRunnerContext.getCurrentConnection().getAutoCommit()) {
                    scriptRunnerContext.write(Messages.getString("SCRIPT_AUTOCOMMIT_FORCED_OFF_CONNECTION_AUTOCOMMIT_ON"));
                    scriptRunnerContext.putProperty("script.runner.autocommit.setting", ScriptRunnerContext.AUTOCOMMITOFF);
                    return true;
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            string = string.toLowerCase().trim();
            if (string.startsWith("imm") || string.startsWith("on")) {
                scriptRunnerContext.putProperty("script.runner.autocommit.setting", ScriptRunnerContext.AUTOCOMMITON);
            } else if (string.startsWith("off")) {
                scriptRunnerContext.putProperty("script.runner.autocommit.setting", ScriptRunnerContext.AUTOCOMMITOFF);
            } else {
                try {
                    Long l = Long.parseLong(string);
                    if (l > -1L && l < 2000000001L) {
                        scriptRunnerContext.putProperty("script.runner.autocommit.setting", l);
                        scriptRunnerContext.putProperty("script.runner.autocommit.counter", 0L);
                    } else {
                        scriptRunnerContext.write(MessageFormat.format(Messages.getString("AUTO_COMMIT_RANGE"), l) + "\n");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    scriptRunnerContext.write(Messages.getString("AUTO_COMMIT_NUMBER_FORMAT_EXCEPTION") + "\n");
                }
            }
        }
        return true;
    }
}

