/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetLinesize
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_LINESIZE;

    public SetLinesize() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getProperty("prop_file_string") != null) {
            String string = iSQLCommand.getSql();
            string = string.trim().replaceAll("^(?i:set\\s+li)(?i:n|ne|nes|nesi|nesiz|nesize)\\s+", "").trim();
            string = string.replaceAll("['\"]", "");
            scriptRunnerContext.putProperty("script.runner.setlinesize", new Integer(string));
            int n = (Integer)scriptRunnerContext.getProperty("script.runner.setlinesize");
            if (n <= 0) {
                String string2 = ScriptRunnerDbArb.getString("ZERO_LNSIZE");
                try {
                    scriptRunnerContext.getOutputStream().write(string2.getBytes());
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().toString()).log(Level.WARNING, "Failed to print to worksheet stream");
                }
            }
        }
        return true;
    }
}

