/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetNumberwidth
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NUMBERWIDTH;

    public SetNumberwidth() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getProperty("prop_file_string") != null) {
            String string = iSQLCommand.getSql();
            string = string.trim().replaceAll("^(?i:set\\s+nu)(?i:m|mw|mwi|mwid|mwidt|mwidth)\\s+", "").trim();
            int n = new Integer(string = string.replaceAll("['\"]", ""));
            if (n < 2 || n > 50) {
                String string2 = MessageFormat.format(ScriptRunnerDbArb.getString("NUMWIDTH_OUTOFRANGE"), n);
                try {
                    scriptRunnerContext.getOutputStream().write(string2.getBytes());
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().toString()).log(Level.WARNING, "Failed to set the Number width");
                }
            } else {
                scriptRunnerContext.putProperty("script.runner.setnumwidth", new Integer(string));
            }
        }
        return true;
    }
}

