/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;

public class SetServerOutput
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_SERVEROUTPUT;
    private static Hashtable<Connection, Boolean> m_enableHashFlag = new Hashtable();
    private boolean isDbmsOn = false;

    public SetServerOutput() {
        super(m_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        super.beginEvent(connection, scriptRunnerContext, iSQLCommand);
        if (iSQLCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            Boolean bl = Boolean.FALSE;
            boolean bl2 = this.isEnabled(scriptRunnerContext.getCurrentConnection());
            if (bl2) {
                bl = Boolean.TRUE;
            }
            scriptRunnerContext.putProperty("script.runner.context.serveroutput", bl);
        }
    }

    @Override
    protected void doEndWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (connection instanceof OracleConnection) {
            String string = "\n";
            Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.dbmsouputpane");
            if (this.isEnabled(connection) || bl != null && bl.equals(Boolean.TRUE)) {
                string = DBUtil.getInstance(connection).getDBMSOUTPUT();
            }
            if (!string.equals("\n")) {
                try {
                    if (this.isEnabled(connection)) {
                        scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
                    }
                    scriptRunnerContext.pushDbmsOutput(string);
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
    }

    private boolean isEnabled(Connection connection) {
        if (m_enableHashFlag.get(connection) == null) {
            return false;
        }
        return m_enableHashFlag.get(connection);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        int n = this.getSetServerOnOrOff(iSQLCommand);
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = this.setServerOutputOn(connection, scriptRunnerContext, iSQLCommand);
                this.isDbmsOn = true;
                break;
            }
            case 0: {
                bl = this.setServerOutputOff(connection, scriptRunnerContext, iSQLCommand);
                this.isDbmsOn = true;
                break;
            }
            default: {
                scriptRunnerContext.write(MessageFormat.format(Messages.getString("SERVEROUTPUT_ERROR"), iSQLCommand.getSql()) + "\n");
                return false;
            }
        }
        return bl;
    }

    private boolean setServerOutputOff(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        DBUtil.getInstance(connection).execute("BEGIN DBMS_OUTPUT.DISABLE(); END;", (List)null);
        m_enableHashFlag.put(connection, false);
        scriptRunnerContext.enableDbmsOutput();
        return true;
    }

    private boolean setServerOutputOn(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = iSQLCommand.getSql().toLowerCase().replace("\n", " ").replace("-", "").replace("\\", " ").replaceAll("\\s+", " ").trim().replace("set serveroutput on size", "").trim();
        if (string.equals("unlimited")) {
            DBUtil.getInstance(connection).execute("begin dbms_output.enable(1000000); end;", (List)null);
            scriptRunnerContext.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
            this.flushOnSwitchOn(connection, scriptRunnerContext);
            m_enableHashFlag.put(connection, true);
        } else {
            try {
                int n = new Integer(string);
                if (n <= 1999 || n >= 1000001) {
                    scriptRunnerContext.write(MessageFormat.format(Messages.getString("SERVEROUTPUT_ERROR"), string) + "\n");
                    return false;
                }
                DBUtil.getInstance(connection).execute("begin dbms_output.enable(" + n + "); end;", (List)null);
                this.flushOnSwitchOn(connection, scriptRunnerContext);
                m_enableHashFlag.put(connection, true);
                scriptRunnerContext.putProperty("script.runner.lastsetserveroutput", new Integer(n));
            }
            catch (NumberFormatException numberFormatException) {
                DBUtil.getInstance(connection).execute("begin dbms_output.enable(1000000); end;", (List)null);
                scriptRunnerContext.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
                this.flushOnSwitchOn(connection, scriptRunnerContext);
                m_enableHashFlag.put(connection, true);
            }
        }
        return true;
    }

    private int getSetServerOnOrOff(ISQLCommand iSQLCommand) {
        String[] stringArray = iSQLCommand.getSql().toLowerCase().replaceFirst("set", " ").replaceFirst("serveroutput", " ").trim().split(" ");
        if (stringArray[0].equalsIgnoreCase("on")) {
            return 1;
        }
        if (stringArray[0].equalsIgnoreCase("off")) {
            return 0;
        }
        return -1;
    }

    @Override
    protected boolean isListenerOn(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return this.isDbmsOn;
    }

    @Override
    public void setCmdOn(boolean bl) {
        super.setCmdOn(bl);
        this.isDbmsOn = bl;
    }

    protected void flushOnSwitchOn(Connection connection, ScriptRunnerContext scriptRunnerContext) {
        if (connection instanceof OracleConnection && !this.isEnabled(connection)) {
            String string = "\n";
            string = DBUtil.getInstance(connection).getDBMSOUTPUT();
            if (!string.equals("\n")) {
                scriptRunnerContext.pushDbmsOutput(string);
            }
        }
    }
}

