/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapBufferOutputStreamToWriter;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;

public class SetSpool
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SPOOL;

    public SetSpool() {
        super(m_cmdStmtSubType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBeginWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL) {
            WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
            if (wrapListenBufferOutputStream != null) {
                this.writeToMain(wrapListenBufferOutputStream.getFileOutput().getAbsolutePath(), scriptRunnerContext);
                this.writeToExisting("\n\n", scriptRunnerContext);
            }
        } else if (!scriptRunnerContext.isEchoOn() && scriptRunnerContext.getTopLevel()) {
            this.writeToExisting("> " + iSQLCommand.getSQLOrig(), scriptRunnerContext);
            this.writeToExisting("\n", scriptRunnerContext);
        }
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if ((Boolean)iSQLCommand.getProperty("prop_status_boolean") != null && ((Boolean)iSQLCommand.getProperty("prop_status_boolean")).booleanValue()) {
            if (iSQLCommand.getProperty("prop_file_string") != null) {
                String string = iSQLCommand.getSql().trim().replaceAll("^.*?[sS][pP][oO][^\\s]*\\s+", "").trim();
                if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
                    string = string.substring(1, string.length() - 1);
                } else if (string.startsWith("'") && string.endsWith("'") && string.length() > 2) {
                    string = string.substring(1, string.length() - 1);
                }
                this.initFile(string, scriptRunnerContext);
            } else if (iSQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && iSQLCommand.getSql().trim().toLowerCase().equals("spool")) {
                this.spoolKeyword(scriptRunnerContext);
            } else {
                this.initFile("spool", scriptRunnerContext);
            }
        } else if (iSQLCommand.getStmtSubType() == SQLCommand.StmtSubType.G_S_SPOOL && iSQLCommand.getSql().trim().toLowerCase().equals("spool")) {
            this.spoolKeyword(scriptRunnerContext);
        } else {
            this.stopSpool(scriptRunnerContext);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolKeyword(ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            this.writeToMain(wrapListenBufferOutputStream.getFileOutput().getAbsolutePath(), scriptRunnerContext);
        } else {
            this.writeToMain(Messages.getString("SetSpool.2"), scriptRunnerContext);
        }
        this.writeToMain("\n\n", scriptRunnerContext);
    }

    public void writeToMain(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = scriptRunnerContext.getOutputStream();
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public void writeToExisting(String string, ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.write(string.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFile(String string, ScriptRunnerContext scriptRunnerContext) {
        try {
            WrapListenBufferOutputStream wrapListenBufferOutputStream;
            String string2 = "";
            if (string.startsWith("/") || string.startsWith("\\") || string.length() > 2 && string.charAt(1) == ':') {
                string2 = string;
            } else {
                Object object;
                boolean bl = false;
                URL uRL = (URL)scriptRunnerContext.getProperty("script.runner.node.url");
                if (uRL != null && uRL.getProtocol().equalsIgnoreCase("file")) {
                    object = null;
                    try {
                        File file;
                        String string3 = null;
                        try {
                            file = new File(uRL.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            file = new File(uRL.getPath());
                        }
                        if (!file.getParent().equals(System.getProperty("java.io.tmpdir"))) {
                            string3 = file.getParent() + File.separator + string;
                            if (!this.doesParentExist(string3 = string3.replace('/', '\\'))) {
                                string3 = string3.replace('\\', '/');
                            }
                            if (this.addDotLst(string3)) {
                                string3 = System.getProperty("os.name").startsWith("Windows") ? string3 + ".LST" : string3 + ".lst";
                            }
                            new File(string3).createNewFile();
                            File file2 = new File(string3);
                            object = new FileOutputStream(file2, false);
                            ((FileOutputStream)object).write(1);
                            ((OutputStream)object).flush();
                            file2.delete();
                            string2 = string3;
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((FileOutputStream)object).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!bl) {
                    if (Ide.isRunning()) {
                        string2 = Ide.getUserSettingsDirectory() + File.separator + string;
                    } else {
                        object = null;
                        object = System.getProperty("ide.pref.dir");
                        if (object == null) {
                            object = System.getProperty("ide.base.dir");
                        }
                        if (object == null) {
                            object = System.getProperty("user.home") + File.separator + ".sqldeveloper";
                        }
                        try {
                            if (!new File((String)object).exists()) {
                                new File((String)object).mkdir();
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        string2 = (String)object + File.separator + string;
                    }
                }
            }
            string2 = string2.replace('/', '\\');
            if (!this.doesParentExist(string2)) {
                string2 = string2.replace('\\', '/');
            }
            if (this.addDotLst(string2)) {
                string2 = System.getProperty("os.name").startsWith("Windows") ? string2 + ".LST" : string2 + ".lst";
            }
            if ((wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer")) != null) {
                this.stopSpool(scriptRunnerContext);
                scriptRunnerContext.putProperty("Spool.out.buffer", null);
                this.createNewSpoolOut(string2, scriptRunnerContext);
                new File(string2).createNewFile();
            } else {
                this.createNewSpoolOut(string2, scriptRunnerContext);
            }
        }
        catch (IOException iOException) {
            this.writeToMain(MessageFormat.format(Messages.getString("SetSpool.initFailed"), string), scriptRunnerContext);
        }
    }

    public void stopSpool(ScriptRunnerContext scriptRunnerContext) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            try {
                wrapListenBufferOutputStream.flush();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            scriptRunnerContext.getOutputStream().removeFromList(wrapListenBufferOutputStream);
            try {
                wrapListenBufferOutputStream.flush();
                wrapListenBufferOutputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            scriptRunnerContext.putProperty("Spool.out.buffer", null);
        }
    }

    private void createNewSpoolOut(String string, ScriptRunnerContext scriptRunnerContext) throws IOException {
        new File(string).createNewFile();
        String string2 = IdeUtil.getIdeEncoding();
        WrapListenBufferOutputStream wrapListenBufferOutputStream = null;
        WrapBufferOutputStreamToWriter wrapBufferOutputStreamToWriter = new WrapBufferOutputStreamToWriter(null);
        wrapBufferOutputStreamToWriter.setOut(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), string2)));
        wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)new BufferedOutputStream(wrapBufferOutputStreamToWriter), null);
        wrapListenBufferOutputStream.setFileOutput(new File(string));
        wrapListenBufferOutputStream.setRemoveForcePrint(true);
        scriptRunnerContext.putProperty("Spool.out.buffer", wrapListenBufferOutputStream);
        scriptRunnerContext.getOutputStream().addToList(wrapListenBufferOutputStream);
    }

    private boolean doesParentExist(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("\\");
        int n3 = string.lastIndexOf(".");
        int n4 = n2;
        if (n > n4) {
            n4 = n;
        }
        if (n4 == -1) {
            return false;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            ++n4;
        }
        return new File(string.substring(0, n4)).exists();
    }

    private boolean addDotLst(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("\\");
        int n3 = string.lastIndexOf(".");
        int n4 = n2;
        if (n > n4) {
            n4 = n;
        }
        return n3 <= n4;
    }

    @Override
    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext) {
        super.endScript(connection, scriptRunnerContext);
        if (scriptRunnerContext.getTopLevel()) {
            this.stopSpool(scriptRunnerContext);
            this.setCmdOn(false);
        }
    }
}

