/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleConnection;

public class Show
extends CommandListener {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String SHOWCONID = "con_id";
    private static final String SHOWCONNAME = "con_name";
    private static final String SHOWARRAYCMD = "array";
    private static final String SHOWUSERCMD = "user";
    private static final String SHOWAPPICMD = "appi";
    private static final String SHOWCOPYC = "copyc";
    private static final String SHOWPARAMETERS = "parameters";
    private static final String SHOWPARAMETER = "parameter";
    private static final String SHOWSPPARAMETERS = "spparameters";
    private static final String SHOWSPPARAMETER = "spparameter";
    private static final String SHOWSGA = "sga";
    private static final String SHOWRELEASE = "rel";
    private static final String SHOWALL = "all";
    private static final String SHOWAUTOCOMMIT = "auto";
    private static final String SHOWAUTOPRINT = "autop";
    private static final String SHOWAUTOTRACE = "autot";
    private static final String SHOWAUTORECOVERY = "autor";
    private static final String SHOWDEFINE = "def";
    private static final String SHOWECHO = "echo";
    private static final String SHOWESCAPE = "esc";
    private static final String SHOWFEEDBACK = "feed";
    private static final String SHOWSERVEROUTPUT = "serverout";
    private static final String SHOWSQLCODE = "sqlcode";
    private static final String SHOWSPOOL = "spoo";
    private static final String SHOWTERMOUT = "term";
    private static final String SHOWTIMINGOUT = "timi";
    private static final String SHOWVERIFY = "ver";
    private static final String SHOWRECYCLE = "recyc";
    private static final String SHOWXQUERY = "xquery";
    private static final String SHOWNULL = "null";
    private static final String SHOWERR = "err";
    private static final String SHOWHEADING = "hea";
    private static final String SHOWWRAP = "wra";
    private static final String SHOWHEADSEP = "heads";
    private static final String SHOWCOLSEP = "colsep";
    private static final String SHOWLINESIZE = "lin";
    private static final String SHOWPAGESIZE = "pages";
    private static final String SHOWLONG = "long";
    private static final String SHOWJDBC = "jdbc";
    private static final String SHOWNUMWIDTH = "num";
    private static final String SHOWNUMFORMAT = "numf";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    private String eatOneWord(String string) {
        return (string.trim() + " ").replaceAll("^[^\\s]*\\s+", "").trim();
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = null;
        try {
            string = iSQLCommand.getSql().trim().toLowerCase().replaceAll("^show?\\s+", "");
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage() + "\n");
        }
        if (scriptRunnerContext.getCurrentConnection() instanceof OracleConnection || string.startsWith(SHOWJDBC)) {
            try {
                boolean bl = false;
                boolean bl2 = false;
                if (string.startsWith(SHOWERR)) {
                    return false;
                }
                while (!bl) {
                    bl = true;
                    if (string != null && !string.trim().equals("")) {
                        if (string.startsWith(SHOWARRAYCMD)) {
                            if (this.doArray(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWUSERCMD)) {
                            if (this.doUser(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWAPPICMD)) {
                            if (this.doAppi(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWCOPYC)) {
                            if (this.doCopyCommit(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWPARAMETER)) {
                            if (this.doParameters(string, connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            bl = true;
                            continue;
                        }
                        if (string.startsWith(SHOWSPPARAMETER)) {
                            if (this.doSPParameters(string, connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            bl = true;
                            continue;
                        }
                        if (string.startsWith(SHOWRECYCLE)) {
                            string = this.doRecycle(string, connection, scriptRunnerContext, iSQLCommand);
                            bl2 = true;
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWRELEASE)) {
                            if (this.doRelease(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWSGA)) {
                            if (this.doSGA(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWAUTOTRACE)) {
                            if (this.doAutoTrace(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWAUTOPRINT)) {
                            if (this.doAutoPrint(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWAUTOCOMMIT) && !string.startsWith(SHOWAUTORECOVERY)) {
                            if (this.doAutoCommit(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWDEFINE)) {
                            if (this.doDefine(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWECHO)) {
                            if (this.doEcho(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWESCAPE)) {
                            if (this.doEscape(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWFEEDBACK)) {
                            if (this.doFeedback(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWSERVEROUTPUT)) {
                            if (this.doServeroutput(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWSQLCODE)) {
                            if (this.doSqlcode(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWSPOOL)) {
                            if (this.doSpool(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWTERMOUT)) {
                            if (this.doTermOut(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWNULL)) {
                            if (this.doNull(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWTIMINGOUT)) {
                            if (this.doTimingOut(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWVERIFY)) {
                            if (this.doVerify(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWXQUERY)) {
                            if (this.doXQuery(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWHEADING)) {
                            if (this.doHeading(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWWRAP)) {
                            if (this.doWrap(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWHEADSEP)) {
                            if (this.doHeadsep(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWCOLSEP)) {
                            if (this.doColsep(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWLONG)) {
                            if (this.doLong(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWJDBC)) {
                            if (this.doJDBC(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWLINESIZE)) {
                            if (this.doLinesize(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWPAGESIZE)) {
                            if (this.doPagesize(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWNUMFORMAT)) {
                            if (this.doNumformat(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWNUMWIDTH)) {
                            if (this.doNumwidth(connection, scriptRunnerContext, iSQLCommand)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWCONNAME)) {
                            if (this.doConNameOrId(connection, scriptRunnerContext, iSQLCommand, false)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWCONID)) {
                            if (this.doConNameOrId(connection, scriptRunnerContext, iSQLCommand, true)) {
                                bl2 = true;
                            }
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        if (string.startsWith(SHOWALL)) {
                            this.doAppi(connection, scriptRunnerContext, iSQLCommand);
                            this.doArray(connection, scriptRunnerContext, iSQLCommand);
                            this.doAutoCommit(connection, scriptRunnerContext, iSQLCommand);
                            this.doAutoPrint(connection, scriptRunnerContext, iSQLCommand);
                            this.doAutoTrace(connection, scriptRunnerContext, iSQLCommand);
                            this.doColsep(connection, scriptRunnerContext, iSQLCommand);
                            this.doCopyCommit(connection, scriptRunnerContext, iSQLCommand);
                            this.doDefine(connection, scriptRunnerContext, iSQLCommand);
                            this.doEcho(connection, scriptRunnerContext, iSQLCommand);
                            this.doEscape(connection, scriptRunnerContext, iSQLCommand);
                            this.doFeedback(connection, scriptRunnerContext, iSQLCommand);
                            this.doHeading(connection, scriptRunnerContext, iSQLCommand);
                            this.doHeadsep(connection, scriptRunnerContext, iSQLCommand);
                            this.doLinesize(connection, scriptRunnerContext, iSQLCommand);
                            this.doLong(connection, scriptRunnerContext, iSQLCommand);
                            this.doNull(connection, scriptRunnerContext, iSQLCommand);
                            this.doNumformat(connection, scriptRunnerContext, iSQLCommand);
                            this.doNumwidth(connection, scriptRunnerContext, iSQLCommand);
                            this.doPagesize(connection, scriptRunnerContext, iSQLCommand);
                            this.doServeroutput(connection, scriptRunnerContext, iSQLCommand);
                            this.doSpool(connection, scriptRunnerContext, iSQLCommand);
                            this.doSqlcode(connection, scriptRunnerContext, iSQLCommand);
                            this.doTermOut(connection, scriptRunnerContext, iSQLCommand);
                            this.doTimingOut(connection, scriptRunnerContext, iSQLCommand);
                            this.doUser(connection, scriptRunnerContext, iSQLCommand);
                            this.doVerify(connection, scriptRunnerContext, iSQLCommand);
                            this.doWrap(connection, scriptRunnerContext, iSQLCommand);
                            bl2 = true;
                            string = this.eatOneWord(string);
                            bl = false;
                            continue;
                        }
                        scriptRunnerContext.write(MessageFormat.format(Messages.getString("SHOWUNKNOWNOPTION"), (string.trim() + " ").replaceAll("^([^\\s*])\\s+.*", "$1").trim()));
                        string = this.eatOneWord(string);
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                scriptRunnerContext.write(exception.getLocalizedMessage() + "\n");
            }
            return true;
        }
        return false;
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public boolean doAutoCommit(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Long l = (Long)scriptRunnerContext.getProperty("script.runner.autocommit.setting");
        if (l == 1L || l == ScriptRunnerContext.AUTOCOMMITON) {
            scriptRunnerContext.write("autocommit IMMEDIATE\n");
        } else if (l == ScriptRunnerContext.AUTOCOMMITOFF) {
            scriptRunnerContext.write("autocommit OFF\n");
        } else {
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("SHOWAUTOCOMMITEVERYN"), "AUTOCOMMIT ON", l));
        }
        return true;
    }

    public boolean doAutoPrint(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.context.autoprint");
        if (bl != null && bl.equals(Boolean.TRUE)) {
            scriptRunnerContext.write("autoprint ON\n");
        } else {
            scriptRunnerContext.write("autoprint OFF\n");
        }
        return true;
    }

    public boolean doAutoTrace(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("AUTOTRACE_STATE");
        if (bl == null || bl.equals(Boolean.FALSE)) {
            scriptRunnerContext.write("autotrace OFF\n");
        } else {
            String string = "autotrace ON";
            String string2 = (String)scriptRunnerContext.getProperty("AUTOTRACE_TYPE");
            if (string2 != null) {
                if (string2.equals("EXPLAIN")) {
                    string = string + " EXPLAIN";
                } else if (string2.equals("ALL")) {
                    string = string + " EXPLAIN STATISTICS";
                } else if (string2.equals("STATISTICS")) {
                    string = string + " STATISTICS";
                }
            }
            scriptRunnerContext.write(string + "\n");
        }
        return true;
    }

    public boolean doDefine(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        scriptRunnerContext.write("define \"" + scriptRunnerContext.getSubstitutionChar() + "\"\n");
        return true;
    }

    public boolean doEcho(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.isEchoOn()) {
            scriptRunnerContext.write("echo ON\n");
        } else {
            scriptRunnerContext.write("echo OFF\n");
        }
        return true;
    }

    public boolean doEscape(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.getEscape()) {
            scriptRunnerContext.write("escape \"" + scriptRunnerContext.getEscapeChar() + "\" \n");
        } else {
            scriptRunnerContext.write("escape OFF\n");
        }
        return true;
    }

    public boolean doFeedback(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        int n = scriptRunnerContext.getFeedback();
        if (n == -1) {
            scriptRunnerContext.write("FEEDBACK ON\n");
        } else if (n == -2) {
            scriptRunnerContext.write("FEEDBACK OFF\n");
        } else {
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("FEEDBACKONFORN"), "FEEDBACK ON", n));
        }
        return true;
    }

    public boolean doServeroutput(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.context.serveroutput");
        if (bl != null && bl.equals(Boolean.TRUE)) {
            scriptRunnerContext.write("serveroutput ON\n");
        } else {
            scriptRunnerContext.write("serveroutput OFF\n");
        }
        return true;
    }

    public boolean doSqlcode(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.message.forsqlcode");
        int n = 0;
        if (string != null) {
            try {
                String string2 = string.split("\n")[0].trim();
                n = string2.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(string2.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                n = -1;
            }
        }
        scriptRunnerContext.write("sqlcode " + n + "\n");
        return true;
    }

    public boolean doSpool(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        WrapListenBufferOutputStream wrapListenBufferOutputStream = (WrapListenBufferOutputStream)scriptRunnerContext.getProperty("Spool.out.buffer");
        if (wrapListenBufferOutputStream != null) {
            scriptRunnerContext.write("spool ON\n");
        } else {
            scriptRunnerContext.write("spool OFF\n");
        }
        return true;
    }

    public boolean doTermOut(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        boolean bl = scriptRunnerContext.isOutputSupressed();
        if (bl) {
            scriptRunnerContext.write("termout OFF\n");
        } else {
            scriptRunnerContext.write("termout ON\n");
        }
        return true;
    }

    public boolean doTimingOut(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty("script.runner.context.timing");
        if (bl != null && bl.equals(Boolean.TRUE)) {
            scriptRunnerContext.write("timing ON\n");
        } else {
            scriptRunnerContext.write("timing OFF\n");
        }
        return true;
    }

    public boolean doVerify(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (scriptRunnerContext.isVerifyOn()) {
            scriptRunnerContext.write("verify ON\n");
        } else {
            scriptRunnerContext.write("verify OFF\n");
        }
        return true;
    }

    public boolean doArray(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (scriptRunnerContext.getProperty("script.runner.arraysize") != null) {
                scriptRunnerContext.write("arraysize " + (String)scriptRunnerContext.getProperty("script.runner.arraysize") + "\n");
            } else {
                scriptRunnerContext.write("arraysize " + Messages.getString("DEFAULTARRAYSIZE") + "\n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }

    public boolean doUser(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", DBUtil.getInstance(connection).executeOracleReturnOneCol("select USER from dual", new HashMap()))));
            scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner("\n"));
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doAppi(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            String string = "";
            if (scriptRunnerContext.getCurrentConnection() instanceof OracleConnection) {
                boolean bl = false;
                Statement statement = null;
                try {
                    bl = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getCurrentConnection());
                    if (bl) {
                        statement = scriptRunnerContext.getCurrentConnection().prepareCall("BEGIN DBMS_APPLICATION_INFO.READ_MODULE(:MOD, :ACT); END;");
                        statement.registerOutParameter(1, 12);
                        statement.registerOutParameter(2, 12);
                        statement.execute();
                        string = statement.getString(1);
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (bl) {
                        try {
                            DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getCurrentConnection());
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            String string2 = "OFF";
            if (scriptRunnerContext.getProperty("script.runner.appinfo") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.appinfo").equals(new Boolean(true))).booleanValue()) {
                string2 = "ON";
            }
            scriptRunnerContext.write(MessageFormat.format(Messages.getString("APPINFO"), string2, string) + "\n");
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }

    public boolean doCopyCommit(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (scriptRunnerContext.getProperty("script.runner.copycommit") != null) {
                scriptRunnerContext.write("copycommit " + (String)scriptRunnerContext.getProperty("script.runner.copycommit") + "\n");
            } else {
                scriptRunnerContext.write("copycommit 0");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }

    public boolean doNull(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (scriptRunnerContext.getProperty("script.runner.setnull") != null) {
                scriptRunnerContext.write("null \"" + (String)scriptRunnerContext.getProperty("script.runner.setnull") + "\"\n");
            } else {
                scriptRunnerContext.write("null \"\" \n");
            }
        }
        catch (Exception exception) {
            scriptRunnerContext.write(exception.getLocalizedMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSGA(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        boolean bl = false;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            bl = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getBaseConnection());
            if (bl) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
                String string = "SELECT DECODE(null,'','Total System Global Area','') NAME_COL_PLUS_SHOW_SGA,  to_char(SUM(VALUE)) VALUE, DECODE (null,'', 'bytes','') units_col_plus_show_sga FROM V$SGA  UNION ALL  SELECT NAME NAME_COL_PLUS_SHOW_SGA , to_char(value) VALUE,  DECODE (null,'', 'bytes','') units_col_plus_show_sga FROM V$SGA";
                statement = scriptRunnerContext.getCurrentConnection().createStatement();
                resultSet = statement.executeQuery(string);
                String string2 = "                                                                                                                                ";
                if (resultSet != null) {
                    int[] nArray = new int[]{40, 40};
                    while (resultSet.next()) {
                        int n = 0;
                        for (int n2 : nArray) {
                            String string3;
                            if ((string3 = resultSet.getString(++n)) == null) {
                                string3 = "";
                            }
                            string3 = (string3 + string2).substring(0, n2);
                            scriptRunnerContext.write(string3);
                            scriptRunnerContext.write(" ");
                        }
                        scriptRunnerContext.write("\n");
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
            scriptRunnerContext.write(sQLException.getLocalizedMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (bl) {
                try {
                    DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getBaseConnection());
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public boolean doRelease(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeOracleReturnOneCol("select * from v$version where banner like '%Oracle%'", null);
        if (string != null) {
            String[] stringArray = string.split(" ");
            String string2 = "[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*\\.[0-9]*";
            String string3 = null;
            try {
                for (String string4 : stringArray) {
                    if (!Pattern.matches(string2, string4)) continue;
                    string3 = string4;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                scriptRunnerContext.write(patternSyntaxException.getLocalizedMessage() + "\n");
            }
            if (string3 != null) {
                String[] stringArray2 = string3.split("\\.");
                try {
                    int n = new Integer(stringArray2[0]) * 100000000;
                    n += new Integer(stringArray2[1]) * 1000000;
                    n += new Integer(stringArray2[2]) * 10000;
                    n += new Integer(stringArray2[3]) * 100;
                    scriptRunnerContext.write(Messages.getString("SHOWRELEASE") + " " + (n += new Integer(stringArray2[4]).intValue()) + "\n");
                }
                catch (NumberFormatException numberFormatException) {
                    scriptRunnerContext.write(numberFormatException.getLocalizedMessage() + "\n");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSPParameters(String string, Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        block32: {
            String string2 = string.toLowerCase();
            String string3 = null;
            string3 = string2.startsWith(SHOWSPPARAMETERS) ? string2.replaceAll("^spparameters", "").trim().split("\\s+")[0] : string2.replaceAll("^spparameter", "").trim().split("\\s+")[0];
            String string4 = "%";
            if (!string3.equals("")) {
                string4 = "%" + string3 + "%";
            }
            boolean bl = false;
            ResultSetWrapper resultSetWrapper = null;
            try {
                bl = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getBaseConnection());
                if (!bl) break block32;
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
                String string5 = "SELECT  substr(SID,0,20) SID,  substr(NAME,0,50) NAME,  TYPE,  DISPLAY_VALUE VALUE FROM V$SPPARAMETER  WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ)  ORDER BY NAME,VALUE";
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string4);
                resultSetWrapper = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeQuery(string5, arrayList);
                if (resultSetWrapper != null) {
                    ResultSetFormatter resultSetFormatter = new ResultSetFormatter(scriptRunnerContext);
                    resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                    int n = 0;
                    Properties properties = DBUtil.getConnectionResolver().getConnectionInfo(DBUtil.getConnectionResolver().getConnectionName(scriptRunnerContext.getBaseConnection()));
                    Integer n2 = null;
                    try {
                        n2 = scriptRunnerContext.getProperty("script.runner.arraysize") != null ? Integer.valueOf((String)scriptRunnerContext.getProperty("script.runner.arraysize")) : Integer.valueOf(properties.getProperty("PreferfedFetchSize"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    if (n2 != null) {
                        try {
                            resultSet.setFetchSize(n2);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    n = resultSetFormatter.rset2sqlplus(resultSet, scriptRunnerContext.getCurrentConnection(), scriptRunnerContext.getOutputStream());
                    break block32;
                }
                scriptRunnerContext.write(Messages.getString("SHOWSPPARAMETERSNORESULTSET"));
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSetWrapper != null) {
                    try {
                        resultSetWrapper.close();
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    try {
                        DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getBaseConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doParameters(String string, Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        block32: {
            String string2 = string.toLowerCase();
            String string3 = null;
            string3 = string2.startsWith(SHOWPARAMETERS) ? string2.replaceAll("^parameters", "").trim().split("\\s+")[0] : string2.replaceAll("^parameter", "").trim().split("\\s+")[0];
            String string4 = "%";
            if (!string3.equals("")) {
                string4 = "%" + string3 + "%";
            }
            boolean bl = false;
            ResultSetWrapper resultSetWrapper = null;
            try {
                bl = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getBaseConnection());
                if (!bl) break block32;
                String string5 = null;
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
                string5 = DBUtil.getDbVersion(scriptRunnerContext.getCurrentConnection()).compareTo((Object)new Version("10.0")) >= 0 ? "SELECT   substr(NAME,0,50) NAME, DECODE(TYPE,1,'boolean',2,'string',3,'integer',4,'file',5,'number',  6,'big integer', 'unknown') TYPE, substr(DISPLAY_VALUE,0,100) VALUE FROM V$PARAMETER  WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ) ORDER BY NAME,ROWNUM" : "SELECT substr(NAME,0,50) NAME, DECODE(TYPE,1,'boolean',2,'string',3,'integer',4,'file',6,'big integer',  'unknown') TYPE, substr(VALUE,0,100) VALUE FROM V$PARAMETER WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ)  ORDER BY NAME,ROWNUM ";
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string4);
                resultSetWrapper = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeQuery(string5, arrayList);
                if (resultSetWrapper != null) {
                    ResultSetFormatter resultSetFormatter = new ResultSetFormatter(scriptRunnerContext);
                    resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                    int n = 0;
                    Properties properties = DBUtil.getConnectionResolver().getConnectionInfo(DBUtil.getConnectionResolver().getConnectionName(scriptRunnerContext.getBaseConnection()));
                    Integer n2 = null;
                    try {
                        n2 = scriptRunnerContext.getProperty("script.runner.arraysize") != null ? Integer.valueOf((String)scriptRunnerContext.getProperty("script.runner.arraysize")) : Integer.valueOf(properties.getProperty("PreferfedFetchSize"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    if (n2 != null) {
                        try {
                            resultSet.setFetchSize(n2);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    n = resultSetFormatter.rset2sqlplus(resultSet, scriptRunnerContext.getCurrentConnection(), scriptRunnerContext.getOutputStream());
                    break block32;
                }
                scriptRunnerContext.write(Messages.getString("SHOWPARAMETERSNORESULTSET"));
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSetWrapper != null) {
                    try {
                        resultSetWrapper.close();
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    try {
                        DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getBaseConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doConNameOrId(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand, boolean bl) {
        block36: {
            boolean bl2 = false;
            ResultSetWrapper resultSetWrapper = null;
            try {
                bl2 = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getBaseConnection());
                if (!bl2) break block36;
                String string = null;
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", null);
                String string2 = null;
                if (DBUtil.getDbVersion(scriptRunnerContext.getCurrentConnection()).compareTo((Object)new Version("12.1")) >= 0) {
                    if (!bl) {
                        if (DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                            string2 = Messages.getString("SHOWCONNONCONSOLIDATED");
                            scriptRunnerContext.write(string2);
                        }
                        string = "SELECT substr(SYS_CONTEXT ('USERENV', 'CON_NAME'),1,30) CON_NAME from dual";
                    } else {
                        string = "SELECT substr(SYS_CONTEXT ('USERENV', 'CON_ID'),1,30) CON_ID from dual";
                    }
                } else {
                    string2 = Messages.getString("SHOWCONVERSIONTOOLOW");
                    scriptRunnerContext.write(string2);
                    scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", "SP2-0614: Server version too low for this feature");
                }
                if (string2 != null) break block36;
                ArrayList arrayList = new ArrayList();
                resultSetWrapper = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection()).executeQuery(string, arrayList);
                if (resultSetWrapper != null) {
                    ResultSetFormatter resultSetFormatter = new ResultSetFormatter(scriptRunnerContext);
                    resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                    int n = 0;
                    Properties properties = DBUtil.getConnectionResolver().getConnectionInfo(DBUtil.getConnectionResolver().getConnectionName(scriptRunnerContext.getBaseConnection()));
                    Integer n2 = null;
                    try {
                        n2 = scriptRunnerContext.getProperty("script.runner.arraysize") != null ? Integer.valueOf((String)scriptRunnerContext.getProperty("script.runner.arraysize")) : Integer.valueOf(properties.getProperty("PreferfedFetchSize"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    if (n2 != null) {
                        try {
                            resultSet.setFetchSize(n2);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    n = resultSetFormatter.rset2sqlplus(resultSet, scriptRunnerContext.getCurrentConnection(), scriptRunnerContext.getOutputStream());
                    break block36;
                }
                scriptRunnerContext.write(Messages.getString("SHOWPARAMETERSNORESULTSET"));
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSetWrapper != null) {
                    try {
                        resultSetWrapper.close();
                    }
                    catch (Exception exception) {}
                }
                if (bl2) {
                    try {
                        DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getBaseConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doRecycle(String string, Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        block56: {
            String string2;
            string = this.eatOneWord(string).trim();
            boolean bl = true;
            int n = -1;
            int n2 = string.length();
            boolean bl2 = false;
            boolean bl3 = false;
            while (bl) {
                if (++n == n2) {
                    bl = false;
                    break;
                }
                string2 = string.substring(n, n + 1);
                if (string2.equals("\"")) {
                    if (bl3) continue;
                    if (!bl2) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (string2.equals("'")) {
                    if (bl2) continue;
                    if (!bl3) {
                        bl3 = true;
                        continue;
                    }
                    bl3 = false;
                    continue;
                }
                if (!string2.matches("\\s") || bl2 || bl3) continue;
                bl = false;
                break;
            }
            if ((string2 = string.substring(0, n).trim()).startsWith("\"") && string2.endsWith("\"") && string2.length() > 1) {
                string2 = string2.substring(1, string2.length() - 1);
            } else if (string2.startsWith("'") && string2.endsWith("'") && string2.length() > 1) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            string = n == n2 ? "" : string.substring(n).trim();
            if (DBUtil.getDbVersion(connection).compareTo((Object)new Version("10.0")) < 0) {
                scriptRunnerContext.write(Messages.getString("SERVER_VERSION_TOO_LOW"));
                return string;
            }
            boolean bl4 = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string3;
                String string4;
                String string5;
                boolean bl5;
                block57: {
                    bl4 = DBUtil.getConnectionResolver().lock(scriptRunnerContext.getBaseConnection());
                    if (!bl4) break block56;
                    bl5 = false;
                    string5 = null;
                    string4 = " where UPPER(original_name) = UPPER(:INPUT)";
                    String string6 = "select original_name \"ORIGINAL NAME\", object_name \"RECYCLEBIN NAME\", type \"OBJECT TYPE\", droptime  \"DROP TIME\"   from dba_recyclebin r where owner = USER";
                    string3 = "select original_name \"ORIGINAL NAME\", object_name \"RECYCLEBIN NAME\", type \"OBJECT TYPE\", droptime  \"DROP TIME\"  from recyclebin r";
                    try {
                        if (!string2.equals("")) {
                            string5 = string6 + string4;
                            statement = connection.prepareStatement(string5);
                            statement.setString(1, string2);
                        } else {
                            string5 = string6;
                            statement = connection.prepareStatement(string5);
                        }
                        resultSet = statement.executeQuery();
                    }
                    catch (SQLException sQLException) {
                        bl5 = true;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                        if (statement == null) break block57;
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException3) {
                            // empty catch block
                        }
                    }
                }
                if (bl5) {
                    if (!string2.equals("")) {
                        string5 = string3 + string4;
                        statement = connection.prepareStatement(string5);
                        statement.setString(1, string2);
                    } else {
                        string5 = string3;
                        statement = connection.prepareStatement(string5);
                    }
                    resultSet = statement.executeQuery();
                }
                if (!resultSet.next()) break block56;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (!string2.equals("")) {
                    statement = connection.prepareStatement(string5);
                    statement.setString(1, string2);
                } else {
                    statement = connection.prepareStatement(string5);
                }
                resultSet = statement.executeQuery();
                ResultSetFormatter resultSetFormatter = new ResultSetFormatter();
                resultSetFormatter.setProgressUpdater(scriptRunnerContext.getTaskProgressUpdater());
                resultSetFormatter.rset2sqlplus(resultSet, scriptRunnerContext.getCurrentConnection(), scriptRunnerContext.getOutputStream());
            }
            catch (IOException iOException) {
                scriptRunnerContext.write(iOException.getLocalizedMessage());
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.putProperty("sqldev.last.err.message.forsqlcode", sQLException.getMessage());
                scriptRunnerContext.write(sQLException.getLocalizedMessage());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (bl4) {
                    DBUtil.getConnectionResolver().unlock(scriptRunnerContext.getBaseConnection());
                }
            }
        }
        return string;
    }

    public boolean doXQuery(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (DBUtil.getDbVersion(connection).compareTo((Object)new Version("10.2")) < 0) {
            scriptRunnerContext.write(Messages.getString("SERVER_VERSION_TOO_LOW"));
            return true;
        }
        String string = (String)scriptRunnerContext.getProperty("xquery.baseuri");
        String string2 = (String)scriptRunnerContext.getProperty("xquery.ordering");
        String string3 = (String)scriptRunnerContext.getProperty("xquery.node");
        String string4 = (String)scriptRunnerContext.getProperty("xquery.context");
        if (string == null) {
            string = "";
        }
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            string = "\"" + string + "\"";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (!string4.startsWith("\"") || !string4.endsWith("\"")) {
            string4 = "\"" + string4 + "\"";
        }
        if (string2 == null) {
            string2 = "DEFAULT";
        }
        if (string3 == null) {
            string3 = "DEFAULT";
        }
        scriptRunnerContext.write("xquery BASEURI " + string + " CONTEXT " + string4 + " NODE " + string3 + " ORDERING " + string2 + "\n");
        return true;
    }

    public boolean doHeading(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setheading");
        if (string.matches("(?i:on|off)")) {
            String string2 = MessageFormat.format(Messages.getString("HEADING"), string) + m_lineSeparator;
            scriptRunnerContext.write(string2);
        }
        return true;
    }

    public boolean doWrap(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setwrap");
        if (string.matches("(?i:on|off)")) {
            String string2 = "";
            string2 = string.equalsIgnoreCase("ON") ? Messages.getString("WRAP_ON") + m_lineSeparator : Messages.getString("WRAP_OFF") + m_lineSeparator;
            scriptRunnerContext.write(string2);
        }
        return true;
    }

    public boolean doHeadsep(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setheadsep");
        if (string.matches("(?i:on|off)")) {
            String string2 = "";
            if (string.equalsIgnoreCase("ON")) {
                String string3 = (String)scriptRunnerContext.getProperty("script.runner.setheadsepchar");
                string2 = MessageFormat.format(Messages.getString("HEADSEP_ON"), string3, String.format("%x", new BigInteger(string3.getBytes())));
                string2 = string2 + m_lineSeparator;
            } else {
                string2 = Messages.getString("HEADSEP_OFF") + m_lineSeparator;
            }
            scriptRunnerContext.write(string2);
        }
        return true;
    }

    public boolean doColsep(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setcolsep");
        String string2 = MessageFormat.format(Messages.getString("COLSEP"), string) + m_lineSeparator;
        scriptRunnerContext.write(string2);
        return true;
    }

    public boolean doLong(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Integer n = (Integer)scriptRunnerContext.getProperty("script.runner.setlong");
        String string = MessageFormat.format(Messages.getString("LONG"), n.toString()) + m_lineSeparator;
        scriptRunnerContext.write(string);
        return true;
    }

    public boolean doJDBC(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            stringBuffer.append("-- Database Info --\n");
            stringBuffer.append("Database Product Name: " + databaseMetaData.getDatabaseProductName() + "\n");
            stringBuffer.append("Database Product Version: " + databaseMetaData.getDatabaseProductVersion() + "\n");
            stringBuffer.append("Database Major Version: " + databaseMetaData.getDatabaseMajorVersion() + "\n");
            stringBuffer.append("Database Minor Version: " + databaseMetaData.getDatabaseMinorVersion() + "\n");
            stringBuffer.append("-- Driver Info --\n");
            stringBuffer.append("Driver Name: " + databaseMetaData.getDriverName() + "\n");
            stringBuffer.append("Driver Version: " + databaseMetaData.getDriverVersion() + "\n");
            stringBuffer.append("Driver Major Version: " + databaseMetaData.getDriverMajorVersion() + "\n");
            stringBuffer.append("Driver Minor Version: " + databaseMetaData.getDriverMinorVersion() + "\n");
        }
        catch (Exception exception) {
            stringBuffer.append("\nUnable to gather information\n");
        }
        scriptRunnerContext.write(stringBuffer.toString());
        return true;
    }

    public boolean doPagesize(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Integer n = (Integer)scriptRunnerContext.getProperty("script.runner.setpagesize");
        String string = MessageFormat.format(Messages.getString("PAGESIZE"), n.toString()) + m_lineSeparator;
        scriptRunnerContext.write(string);
        return true;
    }

    public boolean doLinesize(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Integer n = (Integer)scriptRunnerContext.getProperty("script.runner.setlinesize");
        String string = MessageFormat.format(Messages.getString("LINESIZE"), n.toString()) + m_lineSeparator;
        scriptRunnerContext.write(string);
        return true;
    }

    public boolean doNumwidth(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Integer n = (Integer)scriptRunnerContext.getProperty("script.runner.setnumwidth");
        String string = MessageFormat.format(Messages.getString("NUMWIDTH"), n.toString()) + m_lineSeparator;
        scriptRunnerContext.write(string);
        return true;
    }

    public boolean doNumformat(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)scriptRunnerContext.getProperty("script.runner.setnumformat");
        String string2 = MessageFormat.format(Messages.getString("NUMFORMAT"), "\"" + string + "\"") + m_lineSeparator;
        scriptRunnerContext.write(string2);
        return true;
    }

    public boolean doBTitle(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return true;
    }

    public boolean doTTitle(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return true;
    }
}

