/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class ShowErrors
extends CommandListener {
    private static final String CMD = "show err";
    private static final String VERBOSE_CMD = "set errorswithlines";
    private static final String VERBOSE_CMD_NUM_LINES = "set errorswithlines num lines";
    private ISQLCommand _lastCmd;

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (!iSQLCommand.getSql().trim().toLowerCase().startsWith(CMD)) {
            this._lastCmd = iSQLCommand;
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getSql().trim().toLowerCase().startsWith(VERBOSE_CMD)) {
            String[] stringArray = iSQLCommand.getSQLOrig().split(" ");
            if (stringArray.length >= 3 && stringArray[2].toLowerCase().trim().equals("on")) {
                scriptRunnerContext.putProperty(VERBOSE_CMD, Boolean.TRUE);
            } else {
                scriptRunnerContext.putProperty(VERBOSE_CMD, Boolean.FALSE);
            }
            if (stringArray.length == 5) {
                scriptRunnerContext.putProperty(VERBOSE_CMD_NUM_LINES, Integer.parseInt(stringArray[3]));
            }
        }
        if (iSQLCommand.getSql().trim().toLowerCase().startsWith(CMD)) {
            String[] stringArray;
            Serializable serializable;
            String[] stringArray2;
            String[][] stringArrayArray;
            String[][] stringArrayArray2;
            String[] stringArray3;
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            String string = iSQLCommand.getSql().trim().replaceAll("^[sS][hH][oO][wW]\\s+[eE][rR][rR][^\\s]*", "").trim();
            String[] stringArray4 = string.toUpperCase().split("\\s+");
            String string2 = null;
            String string3 = null;
            if (stringArray4.length > 1) {
                object = new String[]{"PACKAGE BODY", "TYPE BODY", "JAVA CLASS"};
                stringArray3 = new String[]{"FUNCTION", "PROCEDURE", "PACKAGE", "TRIGGER", "VIEW", "TYPE", "DIMENSION"};
                stringArrayArray2 = new String[][]{object, stringArray3};
                boolean bl3 = false;
                boolean bl4 = false;
                block10: while (!bl3) {
                    stringArrayArray = stringArrayArray2;
                    int n = stringArrayArray.length;
                    for (int i = 0; i < n; ++i) {
                        for (String string4 : stringArray2 = stringArrayArray[i]) {
                            serializable = stringArray4[0];
                            bl4 = false;
                            if (string4.contains(" ")) {
                                serializable = stringArray4[0] + " " + stringArray4[1];
                                bl4 = true;
                            }
                            if (!((String)((Object)serializable)).equals(string4)) continue;
                            bl3 = true;
                            string3 = string4;
                            break;
                        }
                        if (bl3) continue block10;
                    }
                }
                if (string3 != null) {
                    if (bl4) {
                        string = string.replaceAll("^[^\\s]*", "").trim();
                    }
                    string2 = string = string.replaceAll("^[^\\s]*", "").trim();
                }
            }
            if ((string3 == null && string.length() > 0) | (string3 != null && (string2 == null || string2.equals("")))) {
                scriptRunnerContext.write(Messages.getString("ShowErrorsFailedToResolve"));
                return true;
            }
            if (string2 == null || string3 == null) {
                string2 = (String)scriptRunnerContext.getProperty("sqldev.last.err.name");
                string3 = (String)scriptRunnerContext.getProperty("sqldev.last.err.type");
                if (string2 == null || string3 == null) {
                    scriptRunnerContext.write("No Errors.\n");
                    return true;
                }
                bl = true;
            }
            if ((object = DBUtil.getInstance(connection).resolveName(string2)) == null) {
                scriptRunnerContext.write(Messages.getString("ShowErrorsFailedToResolve"));
                return true;
            }
            if (string3.toUpperCase().indexOf("BODY") > 0) {
                object.put("OBJECT_TYPE", (String)object.get("OBJECT_TYPE") + " BODY");
            }
            stringArray3 = new ArrayList();
            stringArray3.add(object.get("OBJECT_TYPE"));
            stringArray3.add(object.get("OBJECT_NAME"));
            stringArray3.add(object.get("OWNER"));
            stringArrayArray2 = "select substr(line||'/'||position,0,10) linenum ,text from all_errors  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER and    attribute != 'WARNING' ";
            ResultSetWrapper resultSetWrapper = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            stringArrayArray = new ArrayList();
            ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
            try {
                stringArray = DBUtil.getInstance(connection);
                if (connectionResolver.lock(connection)) {
                    resultSetWrapper = stringArray.executeQuery((String)stringArrayArray2, (List<?>)stringArray3);
                    stringArray2 = resultSetWrapper.getResultSet();
                    while (stringArray2.next()) {
                        arrayList.add(stringArray2.getString(1));
                        stringArrayArray.add(stringArray2.getString(2));
                    }
                }
            }
            catch (SQLException sQLException) {
                scriptRunnerContext.write(sQLException.getMessage());
            }
            finally {
                connectionResolver.unlock(connection);
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
            }
            stringArray = null;
            if (arrayList.size() > 0) {
                void var21_35;
                int n = 10;
                int n2 = 10;
                for (String string4 : arrayList) {
                    if (string4.length() <= n) continue;
                    n = string4.length();
                }
                for (String string5 : stringArrayArray) {
                    if (string5.length() <= n2) continue;
                    n2 = string5.length();
                }
                n += 5;
                String string6 = "                             ";
                boolean i = false;
                while (var21_35 < arrayList.size()) {
                    Object object2;
                    scriptRunnerContext.write((String)arrayList.get((int)var21_35) + string6.substring(0, n - ((String)arrayList.get((int)var21_35)).length()));
                    scriptRunnerContext.write((String)stringArrayArray.get((int)var21_35) + "\n");
                    Boolean bl3 = (Boolean)scriptRunnerContext.getProperty(VERBOSE_CMD);
                    if (bl3 != null && bl3.booleanValue()) {
                        if (bl) {
                            stringArray = this._lastCmd.getSQLOrig().split("\n");
                        } else if (!bl2) {
                            bl2 = true;
                            serializable = new ArrayList();
                            serializable.add(object.get("OBJECT_TYPE"));
                            serializable.add(object.get("OBJECT_NAME"));
                            serializable.add(object.get("OWNER"));
                            String string5 = "select text from all_source  where  type = :TYPE  and    name = :OBJECT_NAME  and    owner = :OWNER order by line";
                            ResultSetWrapper resultSetWrapper2 = null;
                            ArrayList<String> j = new ArrayList<String>();
                            try {
                                DBUtil dBUtil = DBUtil.getInstance(connection);
                                if (connectionResolver.lock(connection)) {
                                    resultSetWrapper2 = dBUtil.executeQuery(string5, (List<?>)((Object)serializable));
                                    object2 = resultSetWrapper2.getResultSet();
                                    while (object2.next()) {
                                        j.add(object2.getString(1));
                                    }
                                    stringArray = j.toArray(new String[j.size()]);
                                    if (j.size() == 0) {
                                        stringArray = null;
                                    }
                                }
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                if (resultSetWrapper2 != null) {
                                    resultSetWrapper2.close();
                                }
                                connectionResolver.unlock(connection);
                            }
                            if (stringArray == null) {
                                scriptRunnerContext.write(MessageFormat.format(Messages.getString("TYPE_NAME_SOURCE_NOT_FOUND"), object.get("OBJECT_TYPE"), (String)object.get("OWNER") + "." + (String)object.get("OBJECT_NAME")));
                            }
                        }
                    }
                    if (bl3 != null && bl3.booleanValue() && stringArray != null) {
                        serializable = Integer.valueOf(1);
                        if (scriptRunnerContext.getProperty(VERBOSE_CMD_NUM_LINES) != null) {
                            serializable = (Integer)scriptRunnerContext.getProperty(VERBOSE_CMD_NUM_LINES);
                            serializable = Integer.valueOf((Integer)serializable - 1);
                        }
                        int n3 = Integer.parseInt(((String)arrayList.get((int)var21_35)).substring(0, ((String)arrayList.get((int)var21_35)).indexOf("/")));
                        --n3;
                        int n4 = Integer.parseInt(((String)arrayList.get((int)var21_35)).substring(((String)arrayList.get((int)var21_35)).indexOf("/") + 1));
                        for (int j = ((Integer)serializable).intValue(); j >= 0; --j) {
                            if (n3 - 1 - j < 0) continue;
                            scriptRunnerContext.write(n3 - j + "  " + stringArray[n3 - 1 - j] + "\n");
                        }
                        if (n3 > 0 && n3 < stringArray.length) {
                            scriptRunnerContext.write(n3 + 1 + "* " + stringArray[n3] + "\n");
                            String string7 = "                                                                                                    ";
                            int n5 = (int)Math.round(Math.floor(n4 / 100));
                            object2 = new String();
                            object2 = "" + n3 + "  ";
                            scriptRunnerContext.write(string7.substring(0, ((String)object2).length()));
                            for (int j = 0; j < n5; ++j) {
                                scriptRunnerContext.write(string7);
                            }
                            scriptRunnerContext.write(string7.substring(0, n4 % 100) + "^\n");
                        }
                        for (int j = 1; j < (Integer)serializable + 2; ++j) {
                            if (n3 + j >= stringArray.length) continue;
                            scriptRunnerContext.write(n3 + 1 + j + "  " + stringArray[n3 + j] + "\n");
                        }
                        scriptRunnerContext.write("\n\n");
                    }
                    ++var21_35;
                }
            } else {
                scriptRunnerContext.write(Messages.getString("ShowErrors.34"));
            }
            return true;
        }
        return false;
    }

    public void beginScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endScript(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }
}

