/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.NUMBER;

public class Title
extends CommandListener {
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String LEFTPTRN = "(?i:\\bl(?:e|ef|eft)\\b)";
    private static final String LEFTCMDPTRN = "(?i:(?i:\\bl(?:e|ef|eft)\\b)\\s+(?:'[^']+'\\s+(?i:sql.pno)|'[^']+'|(?i:sql.pno)))";
    private static final String RIGHTPTRN = "(?i:\\br(?:i|ig|igh|ight)\\b)";
    private static final String RIGHTCMDPTRN = "(?i:(?i:\\br(?:i|ig|igh|ight)\\b)\\s+(?:\\'[^\\']+\\'\\s+(?i:sql.pno)|\\'[^\\']+\\'|(?i:sql.pno)))";
    private static final String CENTERPTRN = "(?i:\\bc(?:e|en|ent|ente|enter)\\b)";
    private static final String CENTERCMDPTRN = "(?i:(?i:\\bc(?:e|en|ent|ente|enter)\\b)\\s+(?:\\'[^\\']+\\'\\s+(?i:sql.pno)|\\'[^\\']+\\'|(?i:sql.pno)))";
    private static final String SKIPPTRN = "(?i:\\bs(?:k|ki|kip)\\b)";
    private static final String SKIPCMDPTRN = "(?i:(?i:\\bs(?:k|ki|kip)\\b)(?:|\\s+)(?:\\d+|\\z))";
    private static final String FORMATPTRN = "(?i:\\bformat\\b)";
    private static final String COLPTRN = "(?i:\\bcol\\b)";
    private static final String COLCMDPTRN = "(?:(?i:\\bcol\\b)\\s+(?:|(?i:\\bformat\\b)\\s+)(?:'[^']+'|'[^']+'\\s+(?i:sql.pno)|.+))";
    private static final String FONTPTRN = "(?i:\\bfont\\b)";
    private static final String TABPTRN = "(?i:\\btab\\b)";
    private static final String JUSTIFY = "justify";
    private static final String COL = "col";
    private static final String FORMAT = "format";
    private static final String SKIP = "skip";
    private static final String SQLPNO = "SQL.PNO";
    private static final String JUSTIFYPTRN = "(?:(?i:\\bl(?:e|ef|eft)\\b)|(?i:\\bc(?:e|en|ent|ente|enter)\\b)|(?i:\\br(?:i|ig|igh|ight)\\b))";
    private static final String CURRPAGENO = "(?i:sql.pno)";
    private static final int LINESIZE = 80;
    protected int m_linesize = -1;
    protected String m_titleCmd = "";
    protected String CMD = "";
    protected ArrayList<String> m_parsedList = null;
    protected Connection m_connection = null;
    protected String m_headsepchar = "";

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return false;
    }

    public StringBuffer getTitle(ScriptRunnerContext scriptRunnerContext, Integer n) {
        StringBuffer stringBuffer = new StringBuffer("");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        this.m_parsedList = new ArrayList();
        this.m_headsepchar = (String)scriptRunnerContext.getProperty("script.runner.setheadsepchar");
        this.m_linesize = (Integer)scriptRunnerContext.getProperty("script.runner.setlinesize") + m_lineSeparator.length();
        if (this.m_linesize < 10) {
            this.m_linesize = 80 + m_lineSeparator.length();
        }
        if (this.m_linesize > 1) {
            stringBuffer.append(this.addLine());
            String[] stringArray = this.m_titleCmd.split("\\s+");
            String string = this.m_titleCmd;
            while (string.split("\\s+").length > 0 && string.length() > 0) {
                String string2;
                String string3;
                String[] stringArray2;
                String string4;
                Object object;
                Object object2;
                String string5;
                String[] stringArray3 = this.splitStr(string);
                String string6 = stringArray3[0];
                if (string6.matches(JUSTIFYPTRN)) {
                    linkedHashMap.put(JUSTIFY, string6);
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    string = string.substring(string6.length(), string.length()).trim();
                    continue;
                }
                if (string6.matches(SKIPPTRN)) {
                    string5 = "(?i:\\bs(?:k|ki|kip)\\b)\\s*\\d*";
                    object2 = this.extractFirst(string, string5);
                    if (!object2.isEmpty()) {
                        object = object2.split("\\s+");
                        if (((String[])object).length == 2) {
                            string4 = object[1];
                            linkedHashMap.put(SKIP, string4);
                        } else {
                            linkedHashMap.put(SKIP, "0");
                        }
                    }
                    this.applyPrintSpec(stringBuffer, linkedHashMap, "");
                    linkedHashMap.clear();
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    if (object2.isEmpty()) {
                        string = string.substring(string6.length(), string.length()).trim();
                        continue;
                    }
                    string = string.substring(object2.length(), string.length()).trim();
                    continue;
                }
                if (string6.matches(COLPTRN)) {
                    string5 = "(?i:\\bcol\\b)\\s+\\d+";
                    object2 = this.extractFirst(string, string5);
                    if (!object2.isEmpty() && ((String[])(object = object2.split("\\s+"))).length == 2) {
                        string4 = object[1];
                        linkedHashMap.put(COL, string4);
                    }
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    if (object2.isEmpty()) {
                        string = string.substring(string6.length(), string.length()).trim();
                        continue;
                    }
                    string = string.substring(object2.length(), string.length()).trim();
                    continue;
                }
                if (string6.matches(FORMATPTRN)) {
                    string5 = "(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)";
                    object2 = "(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+.+\\s+(?i:sql.pno)";
                    object = ".+\\s+(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)";
                    string4 = "";
                    stringArray2 = null;
                    string3 = "";
                    string2 = "";
                    if (string.matches(string5)) {
                        string4 = this.extractFirst(string, string5);
                        if (!string4.isEmpty()) {
                            stringArray2 = string4.split("\\s+");
                            string3 = stringArray2[1];
                            string2 = this.getFormattedStr(n.toString(), string3);
                        }
                    } else if (string.matches((String)object2)) {
                        string4 = this.extractFirst(string, (String)object2);
                        if (!string4.isEmpty()) {
                            string2 = string.replaceAll("(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+", "").trim();
                            string2 = string2.replaceAll("\\s+(?i:sql.pno)", "").trim();
                            string2 = string2.replaceAll("['\"]", "").trim();
                            stringArray2 = string4.split("\\s+");
                            string3 = stringArray2[1];
                            string2 = string2 + "     " + this.getFormattedStr(n.toString(), string3);
                        }
                    } else if (string.matches((String)object) && !(string4 = this.extractFirst(string, (String)object)).isEmpty()) {
                        string2 = string.replaceAll("\\s+(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)", "").trim();
                        string2 = string2.replaceAll("['\"]", "").trim();
                        stringArray2 = string4.split("\\s+");
                        string3 = stringArray2[2];
                        string2 = string2 + "          " + this.getFormattedStr(n.toString(), string3);
                    }
                    if (linkedHashMap.size() == 0) {
                        linkedHashMap.put(JUSTIFY, string2);
                    }
                    this.applyPrintSpec(stringBuffer, linkedHashMap, string2);
                    linkedHashMap.clear();
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    if (string4.isEmpty()) {
                        string = string.substring(string6.length(), string.length()).trim();
                        continue;
                    }
                    string = string.substring(string4.length(), string.length()).trim();
                    continue;
                }
                if (string6.equalsIgnoreCase(SQLPNO)) {
                    this.applyPrintSpec(stringBuffer, linkedHashMap, n.toString());
                    linkedHashMap.clear();
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    string = string.substring(string6.length(), string.length()).trim();
                    continue;
                }
                if (string6.matches(FONTPTRN)) {
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    string = string.substring(string6.length(), string.length()).trim();
                    continue;
                }
                if (string6.matches(TABPTRN)) {
                    string5 = "(?i:\\btab\\b)\\s+\\d+";
                    if (string6.equals(string)) {
                        string = "";
                        continue;
                    }
                    string = string.substring(string6.length(), string.length()).trim();
                    continue;
                }
                string5 = string6.replaceAll("['\"]", "");
                object2 = this.splitStr(string);
                if (((String[])object2).length >= 2) {
                    if (object2[1].equalsIgnoreCase(SQLPNO)) {
                        object = string6 + "\\s+" + CURRPAGENO;
                        string5 = string5 + "   " + n.toString();
                        string = object2[1].equals(string) || string.matches((String)object) ? "" : string.substring(object2[1].length(), string.length()).trim();
                    } else if (object2[1].equalsIgnoreCase(FORMAT) && !(string4 = this.extractFirst(string, (String)(object = "(?i:\\bformat\\b)\\s+[\\w.,$]+\\s+(?i:sql.pno)"))).isEmpty() && (stringArray2 = string4.split("\\s+")).length == 3) {
                        string3 = stringArray2[1];
                        string2 = n.toString();
                        String string7 = this.getFormattedStr(string2, string3);
                        string5 = string5 + string7;
                        string = string4.equals(string) ? "" : (string4.isEmpty() ? string.substring(object2[1].length(), string.length()).trim() : string.substring(string4.length(), string.length()).trim());
                    }
                } else if (linkedHashMap.size() == 0) {
                    linkedHashMap.put(JUSTIFY, string5);
                }
                if (string6.equals(string)) {
                    string = "";
                } else if (string.length() > 0) {
                    string = string.substring(string6.length(), string.length()).trim();
                }
                this.applyPrintSpec(stringBuffer, linkedHashMap, string5);
                linkedHashMap.clear();
            }
        }
        return stringBuffer;
    }

    private void applyPrintSpec(StringBuffer stringBuffer, LinkedHashMap<String, String> linkedHashMap, String string) {
        String string2 = "";
        if (linkedHashMap != null) {
            for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
                int n;
                int n2;
                int n3;
                int n4;
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                String string5 = this.applyHeadSep(string);
                if (string3.equals(JUSTIFY)) {
                    String string6 = "";
                    string6 = string4.matches(LEFTPTRN) ? this.justify_left(string5, this.m_linesize - m_lineSeparator.length()) : (string4.matches(RIGHTPTRN) ? this.justify_right(string5, this.m_linesize - m_lineSeparator.length()) : (string4.matches(CENTERPTRN) ? this.justify_center(string5, this.m_linesize - m_lineSeparator.length()) : this.justify_left(string5, this.m_linesize)));
                    n4 = string6.indexOf(string5);
                    n3 = stringBuffer.toString().split(m_lineSeparator).length;
                    if (n4 < 0 || n3 <= 0) continue;
                    n2 = n4 + this.m_linesize * (n3 - 1);
                    n = n2 + string5.length();
                    int n5 = stringBuffer.indexOf(string5);
                    int n6 = this.m_linesize * (n3 - 1);
                    int n7 = n6 + this.m_linesize - (m_lineSeparator.length() + 1);
                    if (n5 > -1 && n5 >= n6 && n5 <= n7) {
                        String string7 = String.format("%1$-" + string5.length() + "s", "");
                        stringBuffer.replace(n5, n5 + string5.length(), string7);
                    }
                    stringBuffer.replace(n2, n, string5);
                    continue;
                }
                if (string3.equals(COL)) {
                    int n8 = new Integer(string4);
                    n4 = stringBuffer.toString().split(m_lineSeparator).length;
                    n3 = this.m_linesize * (n4 - 1);
                    n2 = n3 + this.m_linesize - (m_lineSeparator.length() + 1);
                    n = stringBuffer.indexOf(string5);
                    if (n > -1 && n >= n3 && n <= n2) {
                        String string8 = String.format("%1$-" + string5.length() + "s", "");
                        stringBuffer.replace(n, n + string5.length(), string8);
                    }
                    if (n8 < n3 || n8 > n2) continue;
                    if (n8 + string5.length() <= n2) {
                        stringBuffer.replace(n8, n8 + string5.length(), string5);
                        continue;
                    }
                    int n9 = n2 - n8;
                    String string9 = string5.substring(0, n9);
                    stringBuffer.replace(n8, n8 + string9.length(), string9);
                    continue;
                }
                if (!string3.equals(SKIP)) continue;
                int n10 = new Integer(string4);
                if (n10 <= 1) {
                    stringBuffer.append(this.addLine());
                    continue;
                }
                for (n4 = 0; n4 < n10; ++n4) {
                    stringBuffer.append(this.addLine());
                }
            }
        }
    }

    protected String extractFirst(String string, String string2) {
        Matcher matcher;
        String string3 = "";
        Pattern pattern = Pattern.compile(string2);
        if (pattern != null && (matcher = pattern.matcher(string)) != null && matcher.find()) {
            string3 = matcher.group();
        }
        return string3;
    }

    private String[] splitStr(String string) {
        String string2 = "(?:(['\"])(.*?)(?<!\\\\)(?>\\\\\\\\)*\\1|([^\\s]+))";
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(string2);
        String[] stringArray = null;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(string);
            if (matcher != null) {
                while (matcher.find()) {
                    arrayList.add(matcher.group());
                }
            }
            if (arrayList.size() > 0) {
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
        }
        return stringArray;
    }

    private String applyHeadSep(String string) {
        String string2 = "";
        String string3 = "[\\" + this.m_headsepchar + "]";
        String[] stringArray = string.split(string3);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i].length() > this.m_linesize ? string2 + stringArray[i].substring(0, this.m_linesize) : string2 + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string2 = string2 + m_lineSeparator;
        }
        if (string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    private void skip(StringBuffer stringBuffer, String string, String string2) {
        String string3 = this.getMatch(string);
        if (string3 != null && !string3.isEmpty()) {
            string3 = string3.trim().replaceAll(string2, "").trim();
            string3 = string3.replaceAll("['\"]", "");
            boolean bl = false;
            boolean bl2 = bl = string3.equals("") ? false : Pattern.matches("^\\d*$", string3);
            if (bl) {
                int n = new Integer(string3);
                if (n <= 1) {
                    stringBuffer.append(this.addLine());
                } else {
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(this.addLine());
                    }
                }
            } else {
                stringBuffer.append(this.addLine());
            }
        }
    }

    private void justify(StringBuffer stringBuffer, String string, String string2, Integer n) {
        String string3 = "";
        String string4 = this.getMatch(string);
        if (string4 != null && !string4.isEmpty()) {
            string4 = string4.trim().replaceAll(string2, "").trim();
            int n2 = (string4 = string4.replaceAll("['\"]", "")).toUpperCase().indexOf(SQLPNO);
            if (n2 > 0) {
                string4 = string4.replaceAll(CURRPAGENO, "     " + n.toString());
            }
            string3 = string.equals(LEFTCMDPTRN) ? this.justify_left(string4, this.m_linesize - m_lineSeparator.length()) : (string.equals(RIGHTCMDPTRN) ? this.justify_right(string4, this.m_linesize - m_lineSeparator.length()) : (string.equals(CENTERCMDPTRN) ? this.justify_center(string4, this.m_linesize - m_lineSeparator.length()) : this.justify_left(string4, this.m_linesize)));
            int n3 = string3.indexOf(string4);
            int n4 = stringBuffer.toString().split(m_lineSeparator).length;
            if (n3 >= 0 && n4 > 0) {
                int n5 = n3 + this.m_linesize * (n4 - 1);
                int n6 = n5 + string4.length();
                stringBuffer.replace(n5, n6, string4);
            }
        }
    }

    private void col(StringBuffer stringBuffer, String string, String string2, Integer n) {
        int n2 = stringBuffer.toString().split(m_lineSeparator).length;
        int n3 = this.m_linesize * (n2 - 1);
        int n4 = n3 + this.m_linesize - (m_lineSeparator.length() + 1);
        String string3 = this.getMatch(string);
        if (string3 != null && !string3.isEmpty()) {
            String[] stringArray = string3.split("(?:\\s+|['\"].+['\"])");
            if (stringArray.length >= 3) {
                String string4;
                boolean bl = false;
                int n5 = 0;
                String string5 = "";
                String string6 = "";
                String string7 = "";
                for (int i = 1; i < stringArray.length; ++i) {
                    bl = stringArray[i].matches("^\\d+$");
                    if (bl) {
                        n5 = new Integer(stringArray[i]) - 1;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase(FORMAT)) {
                        string6 = stringArray[++i];
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("sql.pno")) {
                        string4 = this.getFormattedStr(n.toString(), string6);
                        string7 = "     ";
                        string5 = string5 + string7 + string4;
                        continue;
                    }
                    string5 = string5 + stringArray[i];
                }
                Matcher matcher = Pattern.compile("['\"].+['\"]").matcher(string3);
                if (matcher.find()) {
                    string4 = matcher.group();
                    string5 = string4 + string5;
                }
                string5 = string5.replaceAll("['\"]", "");
                string5 = this.getFormattedStr(string5, string6);
                string5 = string7 + string5;
                if (n5 >= n3 && n5 <= n4) {
                    if (n5 + string5.length() <= n4) {
                        stringBuffer.replace(n5, n5 + string5.length(), string5);
                    } else {
                        int n6 = n4 - n5;
                        String string8 = string5.substring(0, n6);
                        stringBuffer.replace(n5, n5 + string8.length(), string8);
                    }
                }
            }
        } else {
            return;
        }
    }

    private String getMatch(String string) {
        String string2 = "";
        Pattern pattern = Pattern.compile(string);
        if (pattern != null) {
            Matcher matcher = pattern.matcher(this.m_titleCmd);
            while (matcher.find()) {
                string2 = matcher.group();
                if (this.m_parsedList.size() == 0) {
                    this.m_parsedList.add(string2);
                    break;
                }
                if (this.m_parsedList.contains(string2)) continue;
                this.m_parsedList.add(string2);
                break;
            }
        }
        return string2;
    }

    private String addLine() {
        String string = "";
        string = this.justify_left(" ", this.m_linesize - m_lineSeparator.length());
        string = string + m_lineSeparator;
        return string;
    }

    private String justify_left(String string, int n) {
        return String.format("%1$-" + n + "s", string);
    }

    private String justify_right(String string, int n) {
        return String.format("%1$" + n + "s", string);
    }

    private String justify_center(String string, int n) {
        String string2 = string.trim();
        if (n < string2.length()) {
            return string;
        }
        int n2 = (n - string2.length()) / 2 + string2.length();
        String string3 = String.format("%1$" + n2 + "s", string2);
        String string4 = String.format("%1$-" + n + "s", string3);
        return string4;
    }

    private String getFormattedStr(String string, String string2) {
        String string3 = string;
        if (string2.startsWith("a") || string2.startsWith("A")) {
            String string4 = string2.replaceAll("^\\D*", "").trim();
            string3 = this.justify_left(string3, new Integer(string4));
        } else {
            NUMBER nUMBER = new NUMBER(new Integer(string3).intValue());
            try {
                string3 = nUMBER.toFormattedText(string2, null);
            }
            catch (Exception exception) {
                string3 = nUMBER.stringValue();
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedNumber(Connection connection, NUMBER nUMBER, String string) {
        String string2 = "";
        ResultSetWrapper resultSetWrapper = null;
        String string3 = "SELECT TO_CHAR(";
        string3 = string3 + nUMBER.stringValue() + ",";
        string3 = string3 + "'" + string + "'" + ") from dual";
        if (connection != null && !string3.equals("")) {
            try {
                DBUtil dBUtil = DBUtil.getInstance(connection);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, null);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
            }
            catch (Exception exception) {
                string2 = DataTypesUtil.stringValue(nUMBER, connection);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
            }
        }
        return string2;
    }

    public String getCommand() {
        return this.m_titleCmd;
    }

    public String buildShowTitle(Title title, ScriptRunnerContext scriptRunnerContext) {
        String string = "";
        String string2 = "";
        boolean bl = false;
        if (title instanceof TopTitle) {
            string = "ttitle";
            bl = scriptRunnerContext.getTTitleFlag();
            string2 = scriptRunnerContext.getTTitleCmd();
        } else if (title instanceof BottomTitle) {
            string = "btitle";
            bl = scriptRunnerContext.getBTitleFlag();
            string2 = scriptRunnerContext.getBTitleCmd();
        } else {
            return string;
        }
        if (bl) {
            if (string2.equals("")) {
                string = string + " " + Messages.getString("Title.1") + m_lineSeparator;
            } else {
                string = string + " " + MessageFormat.format(Messages.getString("Title.2"), string2.length()) + m_lineSeparator;
                string = string + string2 + m_lineSeparator;
            }
        } else if (string2.equals("")) {
            string = string + " " + Messages.getString("Title.3") + m_lineSeparator;
        } else {
            string = string + " " + MessageFormat.format(Messages.getString("Title.4"), string2.length()) + m_lineSeparator;
            string = string + string2 + m_lineSeparator;
        }
        return string;
    }
}

