/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class TransparentGateway
extends CommandListener {
    private static final String AUTO_DB_LINKS = "Auto.DB.Links";
    private Set<String> links;

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        this.links = new HashSet<String>();
        if (!Boolean.TRUE.equals(scriptRunnerContext.getProperty(AUTO_DB_LINKS))) {
            return;
        }
        if (iSQLCommand.getStmtType() != SQLCommand.StmtType.G_C_SQL) {
            return;
        }
        String string = iSQLCommand.getSql();
        if (string.indexOf(64) < 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(){}[]^-|!*+./><='\",;:%@? \n\r\t", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("@".equals(string2)) {
                bl = true;
                continue;
            }
            if (bl) {
                for (String string3 : DBUtil.getConnectionResolver().getConnNames()) {
                    Properties properties = DBUtil.getConnectionResolver().getConnectionInfo(string3);
                    if (!string2.equals(properties.get("ConnName"))) continue;
                    try {
                        Object object;
                        Object object2;
                        Statement statement = connection.createStatement();
                        String string4 = "sid";
                        Object object3 = properties.get(string4);
                        if (object3 == null) {
                            string4 = "serviceName";
                            object3 = properties.get(string4);
                            string4 = "service_name";
                            if (object3 == null) {
                                return;
                            }
                        }
                        if ((object2 = properties.get("password")) == null) {
                            object = new JPasswordField(10);
                            int n = JOptionPane.showConfirmDialog(null, object, "Enter Password for " + string2, 2);
                            if (n < 0) {
                                return;
                            }
                            object2 = new String(((JPasswordField)object).getPassword());
                        }
                        object = "CREATE DATABASE LINK " + string2 + " \n" + "CONNECT TO " + properties.get("user") + " IDENTIFIED BY " + object2 + " \n" + "USING '(DESCRIPTION =(ADDRESS_LIST =(ADDRESS = (PROTOCOL = TCP)(HOST = " + properties.get("hostname") + ")(PORT = " + properties.get("port") + ")))(CONNECT_DATA = (" + string4.toUpperCase() + " = " + object3 + "))) '";
                        statement.execute((String)object);
                        this.links.add(string2);
                        scriptRunnerContext.write("Temporary Database Link" + string2 + " created\n");
                    }
                    catch (Exception exception) {
                        System.out.println("CREATE DATABASE LINK failed: " + exception.getMessage());
                    }
                }
            }
            bl = false;
        }
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (this.links != null) {
            for (String string : this.links) {
                try {
                    Statement statement = connection.createStatement();
                    String string2 = "DROP DATABASE LINK " + string;
                    statement.execute(string2);
                    scriptRunnerContext.write("Temporary Database Link" + string + " dropped\n");
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        }
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        List list;
        String string = iSQLCommand.getSql();
        if (string.length() < 50 && 2 < (list = LexerToken.parse((String)string)).size() && "set".equals(((LexerToken)list.get((int)0)).content.toLowerCase()) && ((LexerToken)list.get((int)1)).content.toLowerCase().startsWith("autodblink")) {
            if ("on".equals(((LexerToken)list.get((int)2)).content.toLowerCase())) {
                scriptRunnerContext.putProperty(AUTO_DB_LINKS, Boolean.TRUE);
            } else if ("off".equals(((LexerToken)list.get((int)2)).content.toLowerCase())) {
                scriptRunnerContext.putProperty(AUTO_DB_LINKS, Boolean.FALSE);
            }
            return true;
        }
        return false;
    }
}

