/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.objects.LargeDatum;
import oracle.dbtools.raptor.datatypes.objects.PLSQLRecord;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.ReaderInputStream;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleTypes;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;

public class DataTypesUtil {
    private static Map<String, TimeZone> timeZoneMap = new HashMap<String, TimeZone>(){
        {
            for (String string : TimeZone.getAvailableIDs()) {
                TimeZone timeZone = TimeZone.getTimeZone(string);
                this.put(string.toUpperCase(), timeZone);
            }
        }
    };
    static Map<Integer, String> dataTypesMap = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            Field[] fieldArray = OracleTypes.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    String string = fieldArray[i].getName();
                    Integer n = (Integer)fieldArray[i].get(null);
                    this.put(n, string);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    };
    static Map<String, Integer> dataTypesMap2 = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            Field[] fieldArray = OracleTypes.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                try {
                    String string = fieldArray[i].getName();
                    Integer n = (Integer)fieldArray[i].get(null);
                    this.put(string, n);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    };
    protected static final String _NULL_ = "NULL";

    public static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public static boolean isEqual(Object object, Object object2, Connection connection, int n) {
        String string;
        if (DataTypesUtil.isExtendedType(object, n)) {
            return ModelUtil.areEqual((Object)object, (Object)object2);
        }
        if (object != null && object2 != null && (string = DataTypesUtil.stringValue(object, connection, Integer.MAX_VALUE)) != null) {
            return string.equals(object2);
        }
        return false;
    }

    public static String stringValueChecked(Object object, Connection connection) throws SQLException, IOException {
        return DataTypesUtil.stringValueChecked(object, connection, 4000);
    }

    public static String stringValueChecked(Object object, Connection connection, int n) throws SQLException, IOException {
        return DataTypesUtil.stringValue(object, connection, n, false);
    }

    public static String stringValue(Object object, Connection connection) {
        return DataTypesUtil.stringValue(object, connection, 4000);
    }

    public static String stringValue(Object object, Connection connection, int n) {
        try {
            return DataTypesUtil.stringValue(object, connection, n, true);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (IOException iOException) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return null;
    }

    public static String stringValue(Object object, Connection connection, FormatType formatType) {
        try {
            return DataTypesUtil.stringValue(object, connection, 4000, true, true, formatType);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (IOException iOException) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return null;
    }

    public static String stringValue(Object object, Connection connection, int n, boolean bl) throws SQLException, IOException {
        return DataTypesUtil.stringValue(object, connection, n, bl, true);
    }

    public static String stringValue(Object object, Connection connection, int n, boolean bl, boolean bl2) throws SQLException, IOException {
        return DataTypesUtil.stringValue(object, connection, n, bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stringValue(Object object, Connection connection, int n, boolean bl, boolean bl2, FormatType formatType) throws SQLException, IOException {
        if (object == null) {
            return null;
        }
        String string = null;
        if (object instanceof RaptorGridCell) {
            return DataTypesUtil.stringValue(((RaptorGridCell)object).getCellData(), connection, n, bl, bl2);
        }
        if (object instanceof Clob) {
            try {
                int n2 = 0;
                n2 = Integer.MAX_VALUE == n ? (int)((Clob)object).length() : n;
                string = ((Clob)object).getSubString(1L, n2);
                if (string.length() != n2) return string;
                if (Integer.MAX_VALUE == n) return string;
                return string + "...";
            }
            catch (SQLException sQLException) {
                if (!bl) throw sQLException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                return string;
            }
        }
        if (object instanceof Blob) {
            return "(BLOB)";
        }
        if (object instanceof RAW) {
            return (String)NLSUtils.getValue(connection, object);
        }
        if (object instanceof BFILE) {
            return "(BFILE)";
        }
        if (object instanceof TIMESTAMPTZ) return (String)NLSUtils.getValue(connection, object, formatType);
        if (object instanceof TIMESTAMPLTZ) return (String)NLSUtils.getValue(connection, object, formatType);
        if (object instanceof TIMESTAMP) return (String)NLSUtils.getValue(connection, object, formatType);
        if (object instanceof INTERVALYM) return (String)NLSUtils.getValue(connection, object, formatType);
        if (object instanceof INTERVALDS) {
            return (String)NLSUtils.getValue(connection, object, formatType);
        }
        if (object instanceof Timestamp) {
            return (String)NLSUtils.getValue(connection, object);
        }
        if (object instanceof DATE) {
            try {
                return (String)NLSUtils.getValue(connection, object, formatType);
            }
            catch (NullPointerException nullPointerException) {
                DATE dATE = (DATE)object;
                return DATE.toString((byte[])dATE.toBytes());
            }
        }
        if (object instanceof Date) {
            return NLSUtils.format(connection, object);
        }
        if (object instanceof NUMBER || object instanceof BINARY_FLOAT || object instanceof BINARY_DOUBLE) {
            try {
                return (String)NLSUtils.getValue(connection, object);
            }
            catch (NullPointerException nullPointerException) {
                NUMBER nUMBER = (NUMBER)object;
                try {
                    return NUMBER.toBigDecimal((byte[])nUMBER.toBytes()).toString();
                }
                catch (SQLException sQLException) {
                    if (!bl) throw sQLException;
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, nullPointerException.getStackTrace()[0].toString(), nullPointerException);
                    return "??";
                }
            }
        }
        if (object instanceof BigDecimal) {
            return (String)NLSUtils.getValue(connection, object);
        }
        if (object instanceof XMLType) {
            XMLType xMLType = (XMLType)object;
            try {
                try {
                    String string2 = xMLType.getStringVal();
                    return DataTypesUtil.stringValue(new StringReader(string2), connection, n, bl, bl2);
                }
                catch (Exception exception) {
                    CLOB cLOB = null;
                    try {
                        cLOB = xMLType.getClobVal();
                        Reader reader = null;
                        try {
                            reader = cLOB.getCharacterStream();
                            string = DataTypesUtil.stringValue(reader, connection, n, bl, bl2);
                            return string;
                        }
                        finally {
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    catch (Exception exception3) {
                        throw exception;
                    }
                    finally {
                        try {
                            if (cLOB != null && cLOB.isTemporary()) {
                                cLOB.freeTemporary();
                            }
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Exception exception) {
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return "(XMLTYPE)";
            }
        }
        if (object instanceof OPAQUE) {
            try {
                OPAQUE oPAQUE = (OPAQUE)object;
                string = oPAQUE.getSQLTypeName().trim();
                if (!string.equalsIgnoreCase("SYS.XMLTYPE")) return "(OPAQUE)";
                try {
                    XMLType xMLType = XMLType.createXML((OPAQUE)oPAQUE);
                    return DataTypesUtil.stringValue(xMLType, connection, n, bl, bl2);
                }
                catch (Exception exception) {
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    return "(XMLTYPE)";
                }
            }
            catch (SQLException sQLException) {
                if (!bl) throw sQLException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.INFO, sQLException.getStackTrace()[0].toString(), sQLException);
                return string;
            }
        }
        if (object instanceof STRUCT) {
            if (!bl2) return "[" + ((STRUCT)object).getSQLTypeName().trim() + "]";
            return DataTypesUtil.getStruct(object, n);
        }
        if (object instanceof ARRAY) {
            try {
                String string3 = ((ARRAY)object).getSQLTypeName();
                string = string3 + "(";
                Datum[] datumArray = ((ARRAY)object).getOracleArray();
                boolean bl3 = true;
                String string4 = "";
                Datum[] datumArray2 = datumArray;
                int n3 = datumArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Datum datum = datumArray2[n4];
                    string4 = datum instanceof CHAR ? "'" : "";
                    string = string + (bl3 ? "" : ",") + string4 + DataTypesUtil.stringValue(datum, connection, n, bl, bl2) + string4;
                    bl3 = false;
                    ++n4;
                }
                return string + ")";
            }
            catch (SQLException sQLException) {
                if (!bl) throw sQLException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                return string;
            }
        }
        if (object instanceof ResultSet) {
            ResultSetFormatter resultSetFormatter = new ResultSetFormatter();
            StringBuffer stringBuffer = new StringBuffer();
            try {
                resultSetFormatter.rset2sqlplus((ResultSet)object, connection, stringBuffer);
                return stringBuffer.toString();
            }
            catch (IOException iOException) {
                if (!bl) throw iOException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                return stringBuffer.toString();
            }
            catch (SQLException sQLException) {
                if (!bl) throw sQLException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            return stringBuffer.toString();
        }
        if (object instanceof PLSQLRecord) {
            string = "<";
            int n5 = 0;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                string = string + (n5++ > 0 ? "," : "") + DataTypesUtil.stringValue(e, connection, n, bl, bl2);
            }
            return string + ">";
        }
        if (object instanceof DataValue) {
            try {
                return ((DataValue)object).getStringValue(n).toString();
            }
            catch (DataTypeException dataTypeException) {
                if (!bl) throw dataTypeException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, dataTypeException.getStackTrace()[0].toString(), dataTypeException);
                return string;
            }
        } else if (object instanceof LargeDatum) {
            try {
                return ((LargeDatum)object).getStringValue(StringType.DEFAULT, n).toString();
            }
            catch (DataTypeException dataTypeException) {
                if (!bl) throw dataTypeException;
                Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, dataTypeException.getStackTrace()[0].toString(), dataTypeException);
                return string;
            }
        } else {
            if (object instanceof List) {
                string = "{";
                List list = (List)object;
                int n6 = 0;
                List list2 = (List)list.get(0);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (n6 > 0) {
                        string = string + "<";
                        int n7 = 0;
                        for (Object e2 : (List)e) {
                            string = string + list2.get(n7) + "=" + DataTypesUtil.stringValue(e2, connection, n, bl, bl2) + ",";
                            ++n7;
                        }
                        string = string.substring(0, string.length() - 1);
                        string = string + ">,";
                    }
                    ++n6;
                }
                return string + "}";
            }
            if (object instanceof REF) {
                try {
                    return DataTypesUtil.stringValue(((REF)object).getValue(), connection, n, bl, bl2);
                }
                catch (SQLException sQLException) {
                    if (!bl) throw sQLException;
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    return string;
                }
            } else if (object instanceof Datum) {
                try {
                    string = ((Datum)object).stringValue();
                    return string.equals("CLOB()") || string.equals("BLOB()") || string.equals("NCLOB()") ? string.replace("()", "") : string;
                }
                catch (SQLException sQLException) {
                    if (!bl) throw sQLException;
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    return string;
                }
            } else {
                if (object instanceof byte[]) {
                    return "(BINARY DATA)";
                }
                if (!(object instanceof Reader)) return object.toString();
                StringWriter stringWriter = new StringWriter();
                DataTypesUtil.copyData((Reader)object, stringWriter, n);
                return stringWriter.toString();
            }
        }
    }

    private static String getStruct(Object object, int n) {
        String string = "";
        try {
            Object[] objectArray = ((STRUCT)object).getAttributes();
            String string2 = ((STRUCT)object).getSQLTypeName();
            StringBuilder stringBuilder = new StringBuilder(string2 + "(");
            int n2 = -1;
            for (int i = 0; i < objectArray.length && stringBuilder.length() <= n; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof STRUCT) {
                    stringBuilder.append(DataTypesUtil.getStruct(object2, n) + ",");
                    continue;
                }
                if (object2 instanceof ARRAY) {
                    String string3 = ((ARRAY)object2).getSQLTypeName();
                    Object[] objectArray2 = (Object[])((ARRAY)object2).getArray();
                    int n3 = ((ARRAY)object2).length();
                    stringBuilder.append(string3 + "(");
                    for (int j = 0; j < n3; ++j) {
                        if (objectArray2[j] instanceof STRUCT) {
                            stringBuilder.append(DataTypesUtil.getStruct(objectArray2[j], n) + ",");
                            continue;
                        }
                        try {
                            BigDecimal bigDecimal = (BigDecimal)objectArray2[j];
                            stringBuilder.append(bigDecimal + ",");
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            stringBuilder.append(objectArray2[j] + ",");
                        }
                    }
                    n2 = stringBuilder.lastIndexOf(",");
                    if (n2 > -1) {
                        stringBuilder.deleteCharAt(n2);
                    }
                    stringBuilder = stringBuilder.append("),");
                    continue;
                }
                if (object2 instanceof BigDecimal) {
                    stringBuilder.append(objectArray[i] + ",");
                    continue;
                }
                if (objectArray[i] == null) {
                    stringBuilder.append("NULL,");
                    continue;
                }
                stringBuilder.append("'" + objectArray[i] + "',");
            }
            n2 = stringBuilder.lastIndexOf(",");
            if (n2 > -1) {
                stringBuilder.deleteCharAt(n2);
            }
            stringBuilder.append(")");
            string = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    public static boolean isExtendedType(Object object, int n) {
        return object instanceof ExtendedType || object instanceof BFILE || object instanceof Blob || n == -13 || n == 2004 || n == 2007 || n == 2009 || n == 2003 || n == -10;
    }

    public static boolean isTemporalType(Object object, int n) {
        return n == 91 || n == 93 || n == -102 || n == -101;
    }

    public static boolean isXMLType(Object object) {
        try {
            return object instanceof XMLType || object instanceof OPAQUE && DataTypesUtil.getXMLSQLTypeName().equals(((OPAQUE)object).getSQLTypeName());
        }
        catch (SQLException sQLException) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
    }

    public static String getXMLSQLTypeName() {
        return "SYS.XMLTYPE";
    }

    public static String getEmptyExtendedType(Object object, int n) {
        if (object instanceof Blob || n == 2004) {
            return "empty_blob()";
        }
        if (object instanceof BFILE || n == -13) {
            return "bfilename(' ',' ')";
        }
        return _NULL_;
    }

    public static String getJdbcTypeName(int n) {
        return dataTypesMap.get(new Integer(n));
    }

    public static Integer getJdbcTypeCode(String string) {
        return dataTypesMap2.get(string);
    }

    public static void main(String[] stringArray) {
    }

    public static boolean canDuplicate(Object object, int n) {
        return !(object instanceof STRUCT) && n != 2002 && !(object instanceof RAW) && n != -4 && n != -2 && n != -3 && !(object instanceof Blob) && n != 2004 && n != -8 && !(object instanceof ARRAY) && n != 2003 && n != -13;
    }

    public static CLOB getCLOB(String string, Connection connection) throws SQLException {
        CLOB cLOB = null;
        try {
            cLOB = DataTypesUtil.getTemporaryCLOB(connection);
            cLOB.open(1);
            Writer writer = cLOB.setCharacterStream(0L);
            writer.write(string);
            writer.flush();
            writer.close();
            cLOB.close();
        }
        catch (SQLException sQLException) {
            cLOB.freeTemporary();
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (Exception exception) {
            cLOB.freeTemporary();
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return cLOB;
    }

    public static CLOB getTemporaryCLOB(Connection connection) throws SQLException {
        return CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
    }

    public static BLOB getTemporaryBLOB(Connection connection) throws SQLException {
        return BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLOB getCLOB(Reader reader, Connection connection) throws SQLException, IOException {
        boolean bl = true;
        CLOB cLOB = DataTypesUtil.getTemporaryCLOB(connection);
        try {
            cLOB.open(1);
            try {
                Writer writer = cLOB.setCharacterStream(0L);
                try {
                    char[] cArray = new char[2048];
                    int n = reader.read(cArray);
                    while (n != -1) {
                        writer.write(cArray, 0, n);
                        n = reader.read(cArray);
                    }
                    writer.flush();
                    bl = false;
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        if (!bl) {
                            bl = true;
                            throw iOException;
                        }
                        Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                    }
                }
            }
            finally {
                try {
                    cLOB.close();
                }
                catch (SQLException sQLException) {
                    if (!bl) {
                        bl = true;
                        throw sQLException;
                    }
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
        }
        finally {
            if (bl) {
                try {
                    cLOB.freeTemporary();
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
        }
        return cLOB;
    }

    public static void copyData(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[2048];
        int n = reader.read(cArray);
        while (n != -1) {
            writer.write(cArray, 0, n);
            n = reader.read(cArray);
        }
    }

    public static void copyData(Reader reader, Writer writer, int n) throws IOException {
        if (n < 0) {
            DataTypesUtil.copyData(reader, writer);
        } else {
            int n2;
            for (int i = 0; (n == -1 || i < n) && (n2 = reader.read()) != -1; ++i) {
                writer.write((char)n2);
            }
        }
    }

    public static Object getDuplicate(Object object, Connection connection, int n) throws SQLException {
        if (DataTypesUtil.canDuplicate(object, n)) {
            if (object instanceof Clob || n == 2005) {
                if (object == null || object.equals("")) {
                    return "";
                }
                if (object instanceof Clob) {
                    return ((Clob)object).getSubString(1L, (int)((Clob)object).length());
                }
                return object;
            }
            if (object instanceof Datum) {
                try {
                    Datum datum = (Datum)object;
                    byte[] byArray = datum.getBytes();
                    Class<?> clazz = datum.getClass();
                    Constructor<?> constructor = clazz.getConstructor(byArray.getClass());
                    return constructor.newInstance(new Object[]{byArray});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object instanceof Cloneable) {
                try {
                    Class<?> clazz = object.getClass();
                    Method method = clazz.getMethod("clone", new Class[0]);
                    return method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return DataTypesUtil.stringValue(object, connection);
        }
        return null;
    }

    public static String stripDataTypeStringConstraints(String string) {
        String string2 = string;
        if (string2 != null) {
            Pattern pattern = Pattern.compile("[(][^()]*[)]");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.matches()) {
                string2 = matcher.replaceAll(" ");
                matcher = pattern.matcher(string2);
            }
            string2 = DataTypesUtil.reformatDataTypeString(string2);
        }
        return string2;
    }

    public static String reformatDataTypeString(String string) {
        String string2 = string;
        if (string2 != null) {
            Pattern pattern = Pattern.compile("[\\s]*[(][\\s]*");
            Matcher matcher = pattern.matcher(string2);
            string2 = matcher.replaceAll("(");
            Pattern pattern2 = Pattern.compile("[\\s]*[,][\\s]*");
            Matcher matcher2 = pattern2.matcher(string2);
            string2 = matcher2.replaceAll(",");
            Pattern pattern3 = Pattern.compile("[\\s]*[)]");
            Matcher matcher3 = pattern3.matcher(string2);
            string2 = matcher3.replaceAll(") ");
            Pattern pattern4 = Pattern.compile("[\\s]+");
            Matcher matcher4 = pattern4.matcher(string2);
            string2 = matcher4.replaceAll(" ");
            Pattern pattern5 = Pattern.compile("^[ ]");
            Matcher matcher5 = pattern5.matcher(string2);
            string2 = matcher5.replaceAll("");
            Pattern pattern6 = Pattern.compile("[ ]$");
            Matcher matcher6 = pattern6.matcher(string2);
            string2 = matcher6.replaceAll("");
        }
        return string2;
    }

    public static boolean canAutoFilter(int n) {
        switch (n) {
            case -16: 
            case -13: 
            case -10: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2011: {
                return false;
            }
        }
        return true;
    }

    public static boolean isNull(Object object) {
        return object == null || (object instanceof CharSequence || object instanceof CHAR) && "".equals(object.toString());
    }

    public static boolean isDateOrTime(int n) {
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static DataTypeKind getDataTypeKind(int n) {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return DataTypeKind.CHARACTER;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return DataTypeKind.NUMERIC;
            }
            case -102: 
            case -101: 
            case 91: 
            case 92: 
            case 93: {
                return DataTypeKind.TEMPORAL;
            }
            case -104: 
            case -103: {
                return DataTypeKind.INTERVAL;
            }
        }
        return DataTypeKind.UNKNOWN;
    }

    public static Calendar getCalendar(Connection connection, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        Calendar calendar = null;
        if (tIMESTAMPTZ != null) {
            Object object;
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat;
            calendar = Calendar.getInstance();
            try {
                oraTIMESTAMPTZFormat = ((OracleNLSProvider)NLSProvider.getProvider(connection)).getOraTIMESTAMPTZFormat();
            }
            catch (ParseException parseException) {
                oraTIMESTAMPTZFormat = null;
            }
            try {
                oraTIMESTAMPTZFormat.applyPattern("TZR");
                object = oraTIMESTAMPTZFormat.format(tIMESTAMPTZ);
                TimeZone timeZone = timeZoneMap.get(((String)object).toUpperCase());
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            object = tIMESTAMPTZ.dateValue(connection);
            if (object != null) {
                calendar.setTime((java.util.Date)object);
            }
        }
        return calendar;
    }

    public static InputStream getXMLAsBytes(Reader reader) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsBytes(reader, "UTF-8");
    }

    public static InputStream getXMLAsBytes(Reader reader, String string) throws XMLStreamException, IOException, UnsupportedEncodingException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        bufferedReader.mark(200);
        String string2 = DataTypesUtil.getEncodingNameFromPI(bufferedReader);
        if (string2 == null) {
            string2 = string;
        }
        bufferedReader.reset();
        if (string2 != null) {
            return new ReaderInputStream(bufferedReader, string2);
        }
        return new ReaderInputStream(bufferedReader);
    }

    public static boolean getXMLAsCharacters(InputStream inputStream, Writer writer) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsCharacters(inputStream, writer, -1);
    }

    public static boolean getXMLAsCharacters(InputStream inputStream, Writer writer, int n) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsCharacters(inputStream, writer, n, null);
    }

    public static boolean getXMLAsCharacters(InputStream inputStream, Writer writer, String string) throws XMLStreamException, IOException, UnsupportedEncodingException {
        return DataTypesUtil.getXMLAsCharacters(inputStream, writer, -1, string);
    }

    public static boolean getXMLAsCharacters(InputStream inputStream, Writer writer, int n, String string) throws XMLStreamException, IOException, UnsupportedEncodingException {
        Reader reader = DataTypesUtil.getXMLAsReader(inputStream, string);
        if (reader != null) {
            DataTypesUtil.copyData(reader, writer, n);
            return true;
        }
        return false;
    }

    public static Reader getXMLAsReader(InputStream inputStream, String string) throws XMLStreamException, IOException, UnsupportedEncodingException {
        byte[] byArray = new byte[200];
        int[] nArray = new int[]{0};
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(200);
        int n = bufferedInputStream.read(byArray, 0, 195);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(byteArrayInputStream);
        bufferedInputStream2.mark(n);
        String string2 = DataTypesUtil.detectedEncodingName(bufferedInputStream2, nArray);
        bufferedInputStream2.reset();
        String string3 = DataTypesUtil.getEncodingNameFromPI(bufferedInputStream2);
        if (string3 != null) {
            string2 = string3;
        }
        if (string2 == null && string != null) {
            string2 = string;
        }
        if (string2 != null) {
            bufferedInputStream.reset();
            bufferedInputStream.skip(nArray[0]);
            return new InputStreamReader((InputStream)bufferedInputStream, string2);
        }
        return null;
    }

    public static String getEncodingNameFromPI(Reader reader) throws XMLStreamException, IOException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new ReaderInputStream(reader, "UTF-8"));
        return xMLStreamReader.getEncoding();
    }

    public static String getEncodingNameFromPI(InputStream inputStream) throws XMLStreamException, IOException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
        return xMLStreamReader.getEncoding();
    }

    public static String detectedEncodingName(InputStream inputStream, int[] nArray) throws IOException {
        byte[] byArray = new byte[4];
        String string = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(4);
        int n = bufferedInputStream.read(byArray, 0, 4);
        string = DataTypesUtil.detectEncodingNameFromBOM(byArray, n, nArray);
        if (string == null) {
            string = DataTypesUtil.detectEncodingNameFromPIMarker(byArray, n);
        }
        return string;
    }

    public static String detectEncodingNameFromBOM(byte[] byArray, int n, int[] nArray) {
        if (n >= 3) {
            int n2 = byArray[0] & 0xFF;
            int n3 = byArray[1] & 0xFF;
            int n4 = byArray[2] & 0xFF;
            if (n2 == 239 && n3 == 187 && n4 == 191) {
                nArray[0] = 3;
                return "UTF-8";
            }
            if (n >= 4) {
                int n5 = byArray[3] & 0xFF;
                if (n2 == 0 && n3 == 0 && (n4 == 254 && n5 == 255 || n4 == 255 && n5 == 254)) {
                    nArray[0] = 4;
                    return "ISO-10646-UCS-4";
                }
                if (n2 == 254 && n3 == 255) {
                    nArray[0] = 4;
                    if (n4 == 0 && n5 == 0) {
                        return "ISO-10646-UCS-4";
                    }
                    return "UTF-16BE";
                }
                if (n2 == 255 && n3 == 254) {
                    nArray[0] = 4;
                    if (n4 == 0 && n5 == 0) {
                        return "ISO-10646-UCS-4";
                    }
                    return "UTF-16LE";
                }
            }
        }
        return null;
    }

    public static String detectEncodingNameFromPIMarker(byte[] byArray, int n) {
        if (n >= 4) {
            int n2 = byArray[0] & 0xFF;
            int n3 = byArray[1] & 0xFF;
            int n4 = byArray[2] & 0xFF;
            int n5 = byArray[3] & 0xFF;
            if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60 || n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0 || n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0 || n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
                return "ISO-10646-UCS-4";
            }
            if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
                return "UTF-16BE";
            }
            if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
                return "UTF-16LE";
            }
            if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
                return "CP037";
            }
            if (n2 == 60 && n3 == 63 && n4 == 120 && n5 == 109) {
                return "US-ASCII";
            }
        }
        return null;
    }

    public static String toSQLSyntax(Connection connection, FormatType formatType, Object object) {
        return DataTypesUtil.toSQLSyntax(connection, formatType, object, object);
    }

    public static String toSQLSyntax(Connection connection, FormatType formatType, Object object, Object object2) {
        int n = DataTypesUtil.getSQLType(object);
        String string = DataTypesUtil.toSQLStringValue(connection, n, formatType, object, object2);
        String string2 = DataTypesUtil.toSQLLiteral(string, n);
        String string3 = DataTypesUtil.getSQLLiteralWrapper(connection, n, formatType);
        return String.format(string3, string2);
    }

    public static String toSQLStringValue(Connection connection, FormatType formatType, Object object, Object object2) {
        return DataTypesUtil.toSQLStringValue(connection, DataTypesUtil.getSQLType(object), formatType, object, object2);
    }

    public static String toSQLStringValue(Connection connection, int n, FormatType formatType, Object object, Object object2) {
        if (object != null) {
            Format format = DataTypesUtil.getSQLFormatter(connection, n, formatType);
            if (format != null) {
                return format.format(object);
            }
            if (object2 == null) {
                return object.toString();
            }
        }
        if (object2 != null) {
            return object2.toString();
        }
        return null;
    }

    public static String getSQLLiteralWrapper(Connection connection, int n, FormatType formatType) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        switch (n) {
            case 91: {
                stringBuffer.append("TO_DATE(");
                break;
            }
            case -102: 
            case 93: {
                stringBuffer.append("TO_TIMESTAMP(");
                break;
            }
            case -101: {
                stringBuffer.append("TO_TIMESTAMP_TZ(");
                break;
            }
            default: {
                bl = false;
            }
        }
        stringBuffer.append("%s");
        if (bl) {
            String string = DataTypesUtil.getSQLFormatPattern(connection, n, formatType);
            if (string != null) {
                stringBuffer.append(", ").append(DataTypesUtil.toSQLLiteral(string, 1));
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static Format getSQLFormatter(Connection connection, int n, FormatType formatType) {
        return NLSUtils.getFormat(connection, n, formatType);
    }

    public static String getSQLFormatPattern(Connection connection, int n, FormatType formatType) {
        switch (n) {
            case 91: {
                return NLSUtils.getDateFormat(connection, formatType);
            }
            case -102: 
            case 93: {
                return NLSUtils.getTimeStampFormat(connection, formatType);
            }
            case -101: {
                return NLSUtils.getTimeStampWithTimeZoneFormat(connection, formatType);
            }
        }
        return null;
    }

    public static int getSQLType(Object object) {
        return object != null ? DataTypesUtil.getSQLType(object.getClass()) : -1;
    }

    public static int getSQLType(Class<?> clazz) {
        if (DATE.class.isAssignableFrom(clazz)) {
            return 91;
        }
        if (TIMESTAMP.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (TIMESTAMPLTZ.class.isAssignableFrom(clazz)) {
            return -102;
        }
        if (TIMESTAMPTZ.class.isAssignableFrom(clazz)) {
            return -101;
        }
        if (INTERVALDS.class.isAssignableFrom(clazz)) {
            return -104;
        }
        if (INTERVALYM.class.isAssignableFrom(clazz)) {
            return -103;
        }
        if (NUMBER.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (BINARY_DOUBLE.class.isAssignableFrom(clazz)) {
            return 101;
        }
        if (BINARY_FLOAT.class.isAssignableFrom(clazz)) {
            return 100;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return 2;
        }
        return -1;
    }

    public static String toSQLLiteral(String string, int n) {
        return DataTypesUtil.toSQLLiteral(string, n, true);
    }

    public static String toSQLLiteral(String string, int n, boolean bl) {
        if (string == null) {
            return _NULL_;
        }
        if (string.length() == 0) {
            if (bl) {
                return _NULL_;
            }
            return "'''";
        }
        if (DataTypesUtil.getDataTypeKind(n) == DataTypeKind.NUMERIC) {
            return string;
        }
        return "'" + string.replaceAll("'", "''") + "'";
    }

    public static enum DataTypeKind {
        UNKNOWN,
        CHARACTER,
        NUMERIC,
        TEMPORAL,
        INTERVAL;

    }
}

