/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import oracle.dbtools.raptor.utils.DatabaseJDBCDriverDefinition;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.javatools.data.HashStructure;

public class DatabaseJDBCRegistry {
    private static final Logger LOGGER = Logger.getLogger(DatabaseJDBCRegistry.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-jdbc";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-jdbc", "sqldev-jdbcdriver-hook");
    private static final String JDBC_DESCRIPTOR = "driver";
    private static final String DRIVER_NAME = "name";
    public static final String DRIVER_CLASS = "clazz";
    private static final String DESCRIPTOR_TEXT = "#text";
    private static Map<String, DatabaseJDBCDriverDefinition> s_knownDrivers = new HashMap<String, DatabaseJDBCDriverDefinition>();
    private static DatabaseJDBCRegistry INSTANCE;
    private HashStructureHookListener s_listener;

    public static synchronized DatabaseJDBCRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DatabaseJDBCRegistry();
        }
        return INSTANCE;
    }

    public DatabaseJDBCRegistry() {
        this.initListener();
    }

    private synchronized void initListener() {
        if (this.s_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            this.s_listener = new Listener();
            hashStructureHook.addHashStructureHookListener(this.s_listener);
        }
    }

    public Set<String> getDriverList() {
        return s_knownDrivers.keySet();
    }

    public ClassLoader getClassLoader(String string) {
        DatabaseJDBCDriverDefinition databaseJDBCDriverDefinition = s_knownDrivers.get(string);
        if (databaseJDBCDriverDefinition != null) {
            ClassLoader classLoader = databaseJDBCDriverDefinition.getClassLoader();
            return classLoader;
        }
        return null;
    }

    private static final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processHooks(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processHooks(HashStructure hashStructure) {
            List list = hashStructure.getAsList(DatabaseJDBCRegistry.JDBC_DESCRIPTOR);
            if (list != null) {
                LOGGER.info(MessageFormat.format("{0} jdbc drivers registered", list.size()));
                for (HashStructure hashStructure2 : list) {
                    Object object;
                    String string = hashStructure2.getString(DatabaseJDBCRegistry.DRIVER_NAME);
                    String string2 = hashStructure2.getString(DatabaseJDBCRegistry.DRIVER_CLASS);
                    ClassLoader classLoader = null;
                    if (string != null && string2 != null) {
                        object = LazyResourceAdapter.getInstance((HashStructure)hashStructure2).getMetaResource(DatabaseJDBCRegistry.DESCRIPTOR_TEXT);
                        object = LazyResourceAdapter.getInstance((HashStructure)hashStructure2).getMetaResource(DatabaseJDBCRegistry.DRIVER_NAME);
                        if (object != null) {
                            classLoader = object.getClassLoader();
                        } else {
                            LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                            classLoader = lazyClassAdapter.getClass().getClassLoader();
                        }
                    }
                    object = new DatabaseJDBCDriverDefinition(string, string2, classLoader);
                    s_knownDrivers.put(string2, object);
                    LOGGER.info(MessageFormat.format("Registered {0} Driver with driver class {1}", string, string2));
                }
            }
        }
    }
}

