/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.awt.Window;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.UtilResources;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.CanceledException;
import oracle.javatools.util.SwingUtils;

public class ExceptionHandler {
    private static Throwable hitException = null;
    private static final String DEFAULT_TITLE = DialogResources.getString("SQL_EXCEPTION_TITLE");

    public static Throwable wasException() {
        return hitException;
    }

    public static void reset() {
        hitException = null;
    }

    public static void handleException(Throwable throwable) {
        ExceptionHandler.handleException(null, throwable);
    }

    public static void handleException(final String string, final Throwable throwable) {
        hitException = throwable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (throwable instanceof TaskException || throwable instanceof ExecutionException) {
                    ExceptionHandler.handleException((Exception)throwable.getCause());
                } else if (!ExceptionHandler.isCancel(throwable)) {
                    if (throwable instanceof SQLException) {
                        SQLErrorDialog.showErrorDialog(string, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)throwable);
                    } else {
                        Throwable throwable2 = throwable.getCause();
                        if (throwable2 instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog(string, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)throwable2);
                        } else {
                            ExceptionDialog.showExceptionDialog((Component)SwingUtils.getMainWindow(), (Throwable)throwable);
                        }
                    }
                }
            }
        });
    }

    private static boolean isCancel(Throwable throwable) {
        return throwable instanceof ConnectionCanceledException || throwable.getCause() instanceof ConnectionCanceledException || throwable instanceof CanceledException;
    }

    public static void handleException(Exception exception, String string, int n) {
        hitException = exception;
        if (exception instanceof SQLException) {
            SQLErrorDialog.showErrorDialog(null, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)exception, string, n);
        } else {
            ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
        }
    }

    public static void handleException(final Exception exception, final String string, final int n, final int n2, final int n3) {
        hitException = exception;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (exception instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(null, SwingUtils.getMainWindow(), DEFAULT_TITLE, (SQLException)exception, string, n, n2, n3);
                } else {
                    ExceptionDialog.showExceptionDialog((Window)SwingUtils.getMainWindow(), (Exception)exception);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static boolean handleExceptionWithAction(Exception exception, String string, String string2, String string3) {
        hitException = exception;
        if (string3 == null || string3.length() <= 0) {
            string3 = UtilResources.getString("ExceptionHandler.0");
        }
        if (string2 == null || string2.length() <= 0) {
            string2 = UtilResources.getString("ExceptionHandler.1");
        }
        return SQLErrorDialog.showErrorWithActionsDialog(null, (Component)Ide.getMainWindow(), string, (SQLException)exception, UtilResources.getString("ExceptionHandler.2"), UtilResources.getString("ExceptionHandler.3"));
    }

    public static void handleException(Exception exception, String string, String string2, int n, int n2, int n3) {
        hitException = exception;
        if (!SQLExceptionListenerRegistry.listenForError(string, string2, exception)) {
            if (string2 != null && string2.length() > 0) {
                ExceptionHandler.handleException(exception, string2, n, n2, n3);
            } else {
                ExceptionHandler.handleException(exception);
            }
        }
    }

    public static void handleException(SQLException sQLException, String string, String string2, int n) {
        if (!SQLExceptionListenerRegistry.listenForError(string, string2, sQLException)) {
            if (string2 != null && string2.length() > 0) {
                ExceptionHandler.handleException(sQLException, string2, n);
            } else {
                ExceptionHandler.handleException(sQLException);
            }
        }
    }

    public static void handleException(Exception exception, String string) {
        if (exception instanceof SQLException) {
            ExceptionHandler.handleException((SQLException)exception, string, null, 0);
        } else {
            ExceptionHandler.handleException(exception);
        }
    }

    public static void handleException(Exception exception, String string, boolean bl, boolean bl2) {
        if (!bl) {
            ExceptionHandler.handleException(exception, string);
        } else {
            SQLExceptionListenerRegistry.listenForError(string, null, exception);
            if (bl2) {
                Logger.getLogger("").log(Level.SEVERE, exception.getMessage());
            }
        }
    }
}

