/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.util.MetaResource;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.util.IdeUtil;
import org.eclipse.core.runtime.FileLocator;

public class FileUtils {
    private static final String OSGI_RESOURCE_PROTOCOL = "bundleresource";
    private static final String OSGI_ENTRY_PROTOCOL = "bundleentry";
    private static final String FWK_PATTERN = ".fwk";

    public static List<URL> getFilesInPackage(String string, ClassLoader classLoader, String string2) {
        if (!(string = string.replaceAll("\\.", "\\/")).endsWith("/")) {
            string = string + "/";
        }
        URL[] uRLArray = Resource.getPath(string, classLoader);
        return FileUtils.getFilesInPath(uRLArray, string2);
    }

    public static List<URL> getFilesInPath(MetaResource metaResource, String string) {
        return FileUtils.getFilesInPath(metaResource.toURL(), string);
    }

    public static List<URL> getFilesInPath(URL[] uRLArray, String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (uRLArray != null) {
            for (URL uRL : uRLArray) {
                arrayList.addAll(FileUtils.getFilesInPath(uRL, string));
            }
        }
        return arrayList;
    }

    public static URL resolveURL(URL uRL) {
        String string = uRL.getProtocol();
        if (OSGI_RESOURCE_PROTOCOL.equals(string) || OSGI_ENTRY_PROTOCOL.equals(string)) {
            try {
                return FileLocator.resolve((URL)uRL);
            }
            catch (IOException iOException) {
                Logger.getLogger(FileUtils.class.getName()).severe(iOException.getLocalizedMessage());
            }
        }
        return uRL;
    }

    private static List<URL> getFilesInPath(URL uRL, final String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL[] uRLArray = URLFileSystem.list((URL)FileUtils.resolveURL(uRL), (URLFilenameFilter)new URLFilenameFilter(){

            public boolean accept(URL uRL, String string2) {
                return string2.endsWith(string);
            }
        });
        if (uRLArray != null) {
            arrayList.addAll(Arrays.asList(uRLArray));
        }
        return arrayList;
    }

    public static Writer getEncodedFileWriter(String string, String string2) throws FileNotFoundException {
        OutputStreamWriter outputStreamWriter = null;
        if (string2 == null) {
            string2 = IdeUtil.getIdeEncoding();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        if (string2 != null) {
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
        }
        return outputStreamWriter;
    }

    public static String getLineTerminator() {
        String string = System.getProperty("line.separator");
        if (Ide.isRunning()) {
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
            int n = environOptions.getLineTerminator();
            if (n == 1) {
                string = "\r\n";
            } else if (n == 3) {
                string = "\r";
            } else if (n == 2) {
                string = "\n";
            }
        }
        return string;
    }
}

