/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.UtilResources;
import oracle.dbtools.raptor.utils.ProvideTnsnamesDir;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.util.PlatformUtils;

public class TNSHelper {
    public static final String ENV_OH = "ORACLE_HOME";
    public static final String ENV_TA = "TNS_ADMIN";
    public static final String ENV_LA = "LDAP_ADMIN";
    private static HashMap<String, Long> lastModified = new HashMap();
    private static Object LOCK = new Object();
    public static final String FILE_TNS = System.getProperty("file.separator") + "network" + System.getProperty("file.separator") + "admin" + System.getProperty("file.separator") + "tnsnames.ora";
    private static ArrayList<TCPTNSEntry> s_entries = null;
    private static Logger logger = Logger.getLogger("oracle.dbtools.raptor.utils");
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.equalsIgnoreCase(".tnsnames") || string.toLowerCase().startsWith("tnsnames.");
        }
    };
    private static final String NETWORK_ADMIN_PATH = File.separator + "network" + File.separator + "admin";
    private static ProvideTnsnamesDir getProvideTnsnamesDir = null;

    public static void forceDirty() {
        lastModified = new HashMap();
    }

    private static boolean checkForTns(String string) {
        logger.info(UtilResources.getString("TNSHelper.12") + string);
        boolean bl = false;
        File file = new File(string);
        if (file.exists() && file.listFiles(filter).length > 0) {
            bl = true;
        }
        return bl;
    }

    private static File getTNSFileContent(boolean bl) throws IOException, NotDirtyException {
        boolean bl2;
        String string;
        File file;
        logger.finest("getTNSFileContent - START");
        String string2 = System.getenv().get(ENV_OH);
        String string3 = System.getenv().get(ENV_TA);
        String string4 = System.getProperty("jdbc.driver.home");
        String string5 = System.getProperty("user.home");
        String string6 = null;
        ProvideTnsnamesDir provideTnsnamesDir = TNSHelper.getProvideTnsnamesDir();
        if (provideTnsnamesDir != null && (file = provideTnsnamesDir.getTnsnamesDir()) != null) {
            try {
                string = file.getAbsolutePath();
                if (TNSHelper.checkForTns(string)) {
                    string6 = string;
                }
            }
            catch (Throwable throwable) {
                string6 = null;
            }
        }
        if (string6 == null && TNSHelper.checkForTns(string5)) {
            string6 = string5;
        }
        if (!(bl2 = PlatformUtils.isWindows()) && string6 == null && TNSHelper.checkForTns("/etc")) {
            string6 = "/etc";
        }
        if (string3 != null && string6 == null && TNSHelper.checkForTns(string3)) {
            string6 = string3;
        }
        string = NETWORK_ADMIN_PATH;
        if (string4 != null && string6 == null && TNSHelper.checkForTns(string4 + string)) {
            string6 = string4 + string;
        }
        if (string2 != null && string6 == null && TNSHelper.checkForTns(string2 + string)) {
            string6 = string2 + string;
        }
        if (string6 == null && bl2) {
            string2 = null;
            String string7 = null;
            try {
                logger.info(UtilResources.getString("TNSHelper.20"));
                String string8 = "SOFTWARE\\ORACLE";
                String string9 = null;
                NativeHandler nativeHandler = new NativeHandler();
                nativeHandler.initialize();
                RegistryKey registryKey = NativeHandler.getRegistry().getLocalMachineKey();
                RegistryKey registryKey2 = null;
                try {
                    registryKey2 = registryKey.openKey(string8, 131097L);
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                if (registryKey2 != null) {
                    RegistryKey registryKey3;
                    Iterator iterator = registryKey2.iterateSubKeys();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        e.toString();
                        try {
                            String string10 = string8 + "\\" + e.toString();
                            registryKey3 = registryKey.openKey(string10, 131097L);
                            string9 = registryKey3.getStringValue("ORACLE_HOME_KEY");
                            logger.info(UtilResources.getString("TNSHelper.24") + string9);
                            string7 = registryKey3.getStringValue(ENV_TA);
                            logger.info(UtilResources.getString("TNSHelper.26") + string7);
                        }
                        catch (RegistryException registryException) {
                            logger.fine(UtilResources.getString("TNSHelper.0") + registryException.getMessage());
                        }
                    }
                    if (string9 != null) {
                        registryKey3 = registryKey.openKey(string9, 131097L);
                        string2 = registryKey3.getStringValue(ENV_OH);
                        logger.info(UtilResources.getString("TNSHelper.29") + string2);
                    }
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                logger.log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
            }
            catch (RegistryException registryException) {
                logger.severe("Error:" + registryException.getMessage());
            }
            if (string2 != null && string7 == null) {
                string6 = string2 + string;
            }
            if (string6 == null && string7 != null) {
                string6 = string7;
            }
        }
        if (string6 == null) {
            return null;
        }
        if (!TNSHelper.isDirty(string6)) {
            throw new NotDirtyException();
        }
        s_entries = new ArrayList();
        logger.finest("getTNSFileContent - END");
        return new File(string6);
    }

    public static String getOracleHome() {
        String string = System.getenv().get(ENV_OH);
        if (string == null && PlatformUtils.isWindows()) {
            try {
                logger.info(UtilResources.getString("TNSHelper.20"));
                String string2 = "SOFTWARE\\ORACLE";
                String string3 = null;
                NativeHandler nativeHandler = new NativeHandler();
                nativeHandler.initialize();
                RegistryKey registryKey = NativeHandler.getRegistry().getLocalMachineKey();
                RegistryKey registryKey2 = null;
                try {
                    registryKey2 = registryKey.openKey(string2, 131097L);
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                if (registryKey2 != null) {
                    RegistryKey registryKey3;
                    Iterator iterator = registryKey2.iterateSubKeys();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        e.toString();
                        try {
                            String string4 = string2 + "\\" + e.toString();
                            registryKey3 = registryKey.openKey(string4, 131097L);
                            string3 = registryKey3.getStringValue("ORACLE_HOME_KEY");
                            logger.info(UtilResources.getString("TNSHelper.24") + string3);
                        }
                        catch (RegistryException registryException) {
                            logger.fine(UtilResources.getString("TNSHelper.0") + registryException.getMessage());
                        }
                    }
                    if (string3 != null) {
                        registryKey3 = registryKey.openKey(string3, 131097L);
                        string = registryKey3.getStringValue(ENV_OH);
                        logger.info(UtilResources.getString("TNSHelper.29") + string);
                    }
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                logger.log(Level.WARNING, registryNotAvailableException.getStackTrace()[0].toString(), registryNotAvailableException);
            }
            catch (RegistryException registryException) {
                logger.severe("Error:" + registryException.getMessage());
            }
        }
        return string;
    }

    public static boolean isDirty(String string) {
        boolean bl = false;
        File file = new File(string);
        for (File file2 : file.listFiles(filter)) {
            if (lastModified.get(file2.toString()) != null && lastModified.get(file2.toString()).longValue() == file2.lastModified()) continue;
            bl = true;
        }
        return bl;
    }

    public static void updateTimeStamps(String string) {
        File file = new File(string);
        for (File file2 : file.listFiles(filter)) {
            lastModified.put(file2.toString(), new Long(file2.lastModified()));
        }
    }

    public static TCPTNSEntry getEntry(String string) {
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (TCPTNSEntry tCPTNSEntry : arrayList) {
            if (!tCPTNSEntry.getName().equalsIgnoreCase(string)) continue;
            return tCPTNSEntry;
        }
        return null;
    }

    private static ArrayList<TCPTNSEntry> getTNSEntries(File file) throws IOException {
        logger.finest("getTNSItems - START");
        ArrayList<TCPTNSEntry> arrayList = new ArrayList<TCPTNSEntry>();
        if (file != null && file.exists() && file.isDirectory()) {
            for (File file2 : file.listFiles(filter)) {
                arrayList.addAll(TNSHelper.getTNSEntries(file2));
            }
            TNSHelper.updateTimeStamps(file.toString());
        } else if (file != null && file.exists()) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            logger.finest("getTNSItems - OPEN: " + file.getPath());
            int n = 0;
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            TCPTNSEntry tCPTNSEntry = null;
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("#") > 0) {
                    string = string.substring(0, string.indexOf("#"));
                }
                if (string.indexOf(35) == 0) continue;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '(') {
                        ++n;
                        continue;
                    }
                    if (string.charAt(i) != ')') continue;
                    --n;
                }
                stringBuilder.append(string);
                if (stringBuilder.indexOf("=") <= 0) continue;
                String string4 = stringBuilder.substring(0, stringBuilder.indexOf("=")).trim();
                int n2 = 0;
                for (int i = 0; i < string4.length(); ++i) {
                    if (string4.charAt(i) == '(') {
                        ++n2;
                        continue;
                    }
                    if (string4.charAt(i) != ')') continue;
                    --n2;
                }
                if (n != n2) continue;
                try {
                    string2 = stringBuilder.substring(0, stringBuilder.indexOf("=")).trim();
                    string3 = stringBuilder.substring(stringBuilder.indexOf("=") + 1).trim();
                    if (string2.trim().toLowerCase().equals("ifile")) {
                        try {
                            String string5 = file.getParent() + File.separator;
                            Object object = new File(string5 + string3);
                            if (!((File)object).exists()) {
                                object = new File(string3);
                            }
                            if (((File)object).exists()) {
                                arrayList.addAll(TNSHelper.getTNSEntries((File)object));
                            } else {
                                logger.severe(UtilResources.getString("TNSHelper.38") + string3);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        stringBuilder.setLength(0);
                        continue;
                    }
                    if (string2.length() <= 0 || string3.trim().length() <= 0) continue;
                    TCPTNSEntry tCPTNSEntry2 = null;
                    for (TCPTNSEntry tCPTNSEntry3 : arrayList) {
                        if (!tCPTNSEntry3.getName().equalsIgnoreCase(string3)) continue;
                        tCPTNSEntry2 = tCPTNSEntry3;
                    }
                    tCPTNSEntry = tCPTNSEntry2 != null ? new TCPTNSEntry(string2, tCPTNSEntry2.getDescriptor()) : new TCPTNSEntry(string2, string3);
                    arrayList.add(tCPTNSEntry);
                    stringBuilder.setLength(0);
                    logger.fine(UtilResources.getString("TNSHelper.39") + string2);
                    n = 0;
                }
                catch (Exception exception) {}
            }
            logger.finest("getTNSItems - CLOSE: " + file.getPath());
            bufferedReader.close();
            TNSHelper.updateTimeStamps(file.getParent());
            logger.finest("getTNSItems - END");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TCPTNSEntry> getTNSEntries() {
        Object object = LOCK;
        synchronized (object) {
            Object object2;
            logger.finest("getTNSEntries - START");
            PerformanceLogger.get().startTiming(TNSHelper.class.toString() + ".getTNSEntries");
            if (s_entries == null) {
                s_entries = new ArrayList();
            }
            ArrayList<TCPTNSEntry> arrayList = s_entries;
            try {
                object2 = TNSHelper.getTNSFileContent(false);
                if (object2 != null) {
                    logger.info(UtilResources.getString("TNSHelper.43") + ((File)object2).toString());
                    arrayList = TNSHelper.getTNSEntries((File)object2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = new Comparator(){

                public int compare(Object object, Object object2) {
                    TCPTNSEntry tCPTNSEntry = (TCPTNSEntry)object;
                    TCPTNSEntry tCPTNSEntry2 = (TCPTNSEntry)object2;
                    return Collator.getInstance().compare(tCPTNSEntry.toString(), tCPTNSEntry2.toString());
                }
            };
            Collections.sort(arrayList, object2);
            PerformanceLogger.get().stopTiming(TNSHelper.class.toString() + ".getTNSEntries", "Finished Parsing TNS");
            logger.finest("getTNSEntries - END");
            if (s_entries != arrayList) {
                s_entries.addAll(arrayList);
            }
            return arrayList;
        }
    }

    public static ProvideTnsnamesDir getProvideTnsnamesDir() {
        return getProvideTnsnamesDir;
    }

    public static void setProvideTnsnamesDir(ProvideTnsnamesDir provideTnsnamesDir) {
        getProvideTnsnamesDir = provideTnsnamesDir;
    }

    public static void main(String[] stringArray) throws Exception {
        logger.info("OH=" + System.getenv(ENV_OH));
        logger.info("TA=" + System.getenv(ENV_TA));
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (TCPTNSEntry tCPTNSEntry : arrayList) {
            logger.info(tCPTNSEntry.toString());
        }
        System.exit(0);
    }

    private static class NotDirtyException
    extends Exception {
        private NotDirtyException() {
        }
    }
}

