/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaResource;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Resource {
    private static Logger logger;
    public static final boolean DEV_MODE;
    public static String DEVDIR;
    public static final String HOME;
    public static File raptorDir;
    public static final File RAPTOR_USER;
    public static final File RAPTOR_USER_TEMP;

    public static boolean saveUserDocument(String string, OutputStream outputStream) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getUserDoucment(String string) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        InputStream inputStream = null;
        try {
            String string2 = raptorDir.getAbsolutePath() + File.separator + string;
            try {
                File file = new File(string2);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not load requested file:" + string);
            }
            dOMParser.parse(inputStream);
        }
        catch (SAXException sAXException) {
            ExceptionHandler.handleException(sAXException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return dOMParser.getDocument();
    }

    public static Document getDoucment(Class<?> clazz, String string) {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(Resource.getResourceAsStream(clazz, string));
        }
        catch (SAXException sAXException) {
            ExceptionHandler.handleException(sAXException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        return dOMParser.getDocument();
    }

    public static synchronized File getResource(Class<?> clazz, String string) {
        File file = null;
        if (DEV_MODE) {
            file = new File(DEVDIR + string);
        }
        if (file == null || !file.exists()) {
            file = new File(clazz.getResource(string).getFile());
        }
        return file;
    }

    public static URL[] getPath(MetaResource metaResource) {
        return Resource.getPath(metaResource.getResourcePath(), metaResource.getClassLoader());
    }

    public static synchronized URL[] getPath(String string, ClassLoader classLoader) {
        URL[] uRLArray = new URL[]{};
        if (DEV_MODE) {
            uRLArray = new URL[]{URLFactory.newFileURL((String)DEVDIR)};
        } else {
            try {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                Enumeration<URL> enumeration = classLoader.getResources(string);
                while (enumeration.hasMoreElements()) {
                    URL uRL = URLFactory.newDirURL((URL)enumeration.nextElement(), (String)"");
                    arrayList.add(uRL);
                }
                uRLArray = arrayList.toArray(new URL[0]);
            }
            catch (IOException iOException) {
                Logger.getLogger(Resource.class.getName()).severe(iOException.getLocalizedMessage());
            }
        }
        return uRLArray;
    }

    public static synchronized InputStream getResourceAsStream(Class<?> clazz, String string) {
        if (DEV_MODE) {
            logger.info("Reading  XML:" + DEVDIR + File.separator + string + "\n");
        }
        InputStream inputStream = null;
        try {
            File file = Resource.getResource(clazz, string);
            inputStream = file.exists() && file.canRead() ? new FileInputStream(file) : clazz.getResourceAsStream(string);
        }
        catch (IOException iOException) {
            System.err.println("Could not load requested file:" + string);
            Logger.getLogger(Resource.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return inputStream;
    }

    static {
        Object object;
        logger = Logger.getLogger(Resource.class.getName());
        DEVDIR = null;
        String string = System.getenv("HOME");
        HOME = string == null ? System.getenv("HOMEPATH") : string;
        File file = new File(Ide.getUserSettingsDirectory());
        File file2 = new File(HOME + File.separator + ".sqldeveloper");
        if (file2.exists()) {
            object = null;
            for (String string2 : file2.list()) {
                object = new File(file.getAbsoluteFile() + File.separator + string2);
                if (!string2.endsWith(".xml") || ((File)object).exists()) continue;
                try {
                    int n;
                    FileReader fileReader = new FileReader(file2.getAbsoluteFile() + File.separator + string2);
                    FileWriter fileWriter = new FileWriter(file.getAbsoluteFile() + File.separator + string2);
                    char[] cArray = new char[8192];
                    while ((n = fileReader.read(cArray)) != -1) {
                        fileWriter.write(cArray, 0, n);
                    }
                    fileWriter.close();
                    fileReader.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(Resource.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        RAPTOR_USER = file;
        RAPTOR_USER_TEMP = new File(file + File.separator + "tmp");
        if (!RAPTOR_USER_TEMP.exists()) {
            RAPTOR_USER_TEMP.mkdir();
        }
        if ((object = System.getProperty("raptor.devdir")) == null) {
            object = System.getenv("raptor.devdir");
        }
        if (object != null) {
            DEV_MODE = true;
            DEVDIR = (String)object + File.separator;
        } else {
            DEV_MODE = false;
        }
    }
}

