/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import oracle.dbtools.util.encoding.BASE64Encoding;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.HEXEncoding;
import oracle.dbtools.util.encoding.MimeType;
import oracle.dbtools.util.encoding.NullEncoding;
import oracle.dbtools.util.encoding.URIEncoding;

public class EncodingFactory {
    private EncodingFactory() {
    }

    public static Encoder getEncoder(EncodingType encodingType, MimeType mimeType) {
        Encoder encoder = null;
        if (encodingType != null && mimeType != null) {
            if (encodingType.equals((Object)EncodingType.ENCODING_NONE)) {
                encoder = new NullEncoding(encodingType, mimeType);
            } else if (encodingType.equals((Object)EncodingType.ENCODING_BASE64)) {
                encoder = new BASE64Encoding(mimeType);
            } else if (encodingType.equals((Object)EncodingType.ENCODING_URI)) {
                encoder = (Encoder)((Object)new URIEncoding(mimeType));
            } else if (encodingType.equals((Object)EncodingType.ENCODING_HEX)) {
                encoder = new HEXEncoding(mimeType);
            }
        }
        return encoder;
    }

    public static Decoder getDecoder(EncodingType encodingType, MimeType mimeType) {
        Encoding encoding = null;
        if (encodingType != null && mimeType != null) {
            if (encodingType.equals((Object)EncodingType.ENCODING_NONE)) {
                encoding = new NullEncoding(encodingType, mimeType);
            } else if (encodingType.equals((Object)EncodingType.ENCODING_BASE64)) {
                encoding = new BASE64Encoding(mimeType);
            } else if (encodingType.equals((Object)EncodingType.ENCODING_URI)) {
                encoding = new URIEncoding(mimeType);
            } else if (encodingType.equals((Object)EncodingType.ENCODING_HEX)) {
                encoding = new HEXEncoding(mimeType);
            }
        }
        return encoding;
    }
}

