/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.logging.Level;
import oracle.ide.model.SingletonProvider;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.DefaultEditor;

public final class DatabaseConnectionEditor {
    private static Class<? extends DatabaseConnectionEditorLauncher> s_launcher;

    private DatabaseConnectionEditor() {
    }

    private static ConnectionInfo launchEditor(String storeName, String connName, boolean allowAllStores) {
        DatabaseConnectionEditorLauncher launcher = DatabaseConnectionEditor.createLauncher();
        if (allowAllStores) {
            launcher.setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.ALL);
        }
        DatabaseConnections conns = ModelUtil.hasLength((String)storeName) ? DatabaseConnectionStores.getInstance().getStore(storeName) : null;
        return launcher.launchEditor(conns, connName);
    }

    @Deprecated
    public static void setEditor(Class<? extends ConnectionEditor> ed) {
    }

    @Deprecated
    public static void setLauncher(Class<? extends DatabaseConnectionEditorLauncher> clz) {
        if (clz != null) {
            if (Product.isJDeveloper()) {
                DBLog.log((String)("Ignoring attempt to set database connection editor launcher to " + clz.getName()), (Object[])new Object[0]);
            } else {
                s_launcher = clz;
            }
        }
    }

    public static DatabaseConnectionEditorLauncher createLauncher() {
        DatabaseConnectionEditorLauncher retval = (DatabaseConnectionEditorLauncher)SingletonProvider.find(DatabaseConnectionEditorLauncher.class);
        try {
            if (retval != null) {
                retval = (DatabaseConnectionEditorLauncher)retval.getClass().newInstance();
            } else if (s_launcher != null) {
                retval = s_launcher.newInstance();
            }
        }
        catch (Exception e) {
            DBLog.getLogger().log(Level.SEVERE, "Cannot create db connection editor", e);
        }
        return retval == null ? DefaultEditor.createDefaultEditor() : retval;
    }

    @Deprecated
    public static String editConnection(String connName) {
        return null;
    }

    public static String editConnection(String storeName, String connName) {
        return DatabaseConnectionEditor.editConnection(storeName, connName, false);
    }

    public static String editConnection(String storeName, String connName, boolean allowAllStores) {
        ConnectionInfo info = DatabaseConnectionEditor.launchEditor(storeName, connName, allowAllStores);
        return info == null ? null : info.getConnectionName();
    }

    public static ConnectionInfo editConnection(ConnectionInfo info, boolean allowAllStores) {
        return DatabaseConnectionEditor.launchEditor(info == null ? null : info.getStoreName(), info == null ? null : info.getConnectionName(), allowAllStores);
    }

    @Deprecated
    public static interface ConnectionEditor {
        public String launchEditor(String var1);

        public String launchEditor(String var1, String var2);
    }
}

