/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.migration;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.resource.ConnBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConnectionsInfo {
    private final URL m_url;
    private boolean m_containsPasswords;
    private boolean m_requiresPassphrase;
    private Boolean m_legacy;

    private ConnectionsInfo(URL url) {
        this.m_url = url;
    }

    public URL getURL() {
        return this.m_url;
    }

    public boolean containsPasswords() {
        return this.m_containsPasswords;
    }

    public boolean requiresPassphrase() {
        return this.m_requiresPassphrase;
    }

    public boolean isLegacyCMFormat() {
        return Boolean.TRUE.equals(this.m_legacy);
    }

    public static ConnectionsInfo getConnectionsInfo(URL url) throws ConnectionException {
        ConnectionsInfo retval = new ConnectionsInfo(url);
        PasswordHandler handler = new PasswordHandler(retval);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(false);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(url.toString());
        }
        catch (WeGotWhatWeWantedException e) {
        }
        catch (IOException ioe) {
            throw new ConnectionException(ConnBundle.format("INFOPARSE_ERR", ioe.getMessage()), ioe);
        }
        catch (SAXException saxe) {
            throw new ConnectionException(ConnBundle.format("INFOPARSE_ERR", saxe.getMessage()), saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new ConnectionException(ConnBundle.format("INFOPARSE_ERR", pce.getMessage()), pce);
        }
        if (retval.m_legacy == null) {
            throw new ConnectionException(ConnBundle.get("INFOPARSE_FORMAT_ERR"));
        }
        return retval;
    }

    private static class WeGotWhatWeWantedException
    extends SAXException {
        private WeGotWhatWeWantedException() {
        }
    }

    private static class PasswordHandler
    extends DefaultHandler {
        private final String CONNECTIONS = "connections";
        private final String PWD = "PWD";
        private final String REFERENCES = "References";
        private final String REFERENCE = "Reference";
        private final String FACTORY = "Factory";
        private final String STRING_REF_ADDR = "StringRefAddr";
        private final String ADDR_TYPE = "addrType";
        private final String CLASS_NAME = "className";
        private ConnectionsInfo m_info;
        private boolean m_inDBConn;

        PasswordHandler(ConnectionsInfo info) {
            this.m_info = info;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("References".equals(localName)) {
                this.m_info.m_legacy = false;
            } else if ("connections".equals(localName)) {
                this.m_info.m_legacy = true;
            } else if (Boolean.FALSE.equals(this.m_info.m_legacy)) {
                if ("Reference".equals(localName)) {
                    if (DatabaseProvider.class.getName().equals(attributes.getValue("className"))) {
                        this.m_inDBConn = true;
                    }
                } else if (this.m_inDBConn) {
                    if ("Factory".equals(localName)) {
                        String factory = attributes.getValue("className");
                        if (DatabaseProviderFactory1212.class.getName().equals(factory)) {
                            this.m_info.m_requiresPassphrase = true;
                        }
                    } else if ("StringRefAddr".equals(localName) && "password".equals(attributes.getValue("addrType"))) {
                        this.m_info.m_containsPasswords = true;
                    }
                }
            } else if (Boolean.TRUE.equals(this.m_info.m_legacy) && "PWD".equals(localName)) {
                this.m_info.m_containsPasswords = true;
            }
            if (this.m_info.m_containsPasswords && this.m_info.m_requiresPassphrase) {
                throw new WeGotWhatWeWantedException();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("Reference".equals(localName)) {
                this.m_inDBConn = false;
            }
        }
    }
}

