/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.controls.ConnectionDetails;
import oracle.jdevimpl.db.resource.ConnBundle;

public abstract class AbstractConnectionPanelUI
extends JPanel {
    private Collection<ItemListener> m_listeners;
    private boolean m_listening;
    private ItemListener m_listener;
    private boolean m_showDetails;
    private boolean m_addButtons;
    private ConnectionInfo m_lastShownInfo;
    private String[] m_subTypes;
    private String m_noConnectionString;
    private Context m_ideContext;
    private JWrappedLabel m_promptLabel;
    private JLabel m_connectionsLabel;
    private JComboBox m_picker;
    private JPanel m_panel;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JPanel m_detailsPanel;
    private GridBagConstraints m_detailsGBC;
    private final DBUIResourceHelper m_reshelp;

    protected AbstractConnectionPanelUI(boolean showDetails) {
        this((String[])null, showDetails);
    }

    protected AbstractConnectionPanelUI(boolean oracleOnly, boolean showDetails) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = AbstractConnectionPanelUI.getOracleSubType();
        } else {
            stringArray = null;
        }
        this(stringArray, showDetails);
    }

    protected AbstractConnectionPanelUI(String[] dbSubTypes, boolean showDetails) {
        this.m_listening = true;
        this.m_listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AbstractConnectionPanelUI.this.m_listening && e.getStateChange() == 1) {
                    AbstractConnectionPanelUI.this.fireSelectionChanged();
                }
            }
        };
        this.m_showDetails = true;
        this.m_addButtons = true;
        this.m_connectionsLabel = new JLabel();
        this.m_btnNew = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.m_btnEdit = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
        this.m_subTypes = dbSubTypes;
        this.m_showDetails = showDetails;
    }

    protected String[] getSubTypes() {
        return this.m_subTypes;
    }

    public void setNoConnectionString(String noConn) {
        if (ModelUtil.areDifferent((Object)this.m_noConnectionString, (Object)noConn)) {
            this.m_noConnectionString = noConn;
            this.resetConnections();
        }
    }

    protected String getNoConnectionString() {
        return this.m_noConnectionString;
    }

    protected void initialise() {
        this.getPanel();
    }

    private JPanel getPanel() {
        if (this.m_panel == null) {
            this.setLayout(new BorderLayout(0, 15));
            this.m_panel = new JPanel();
            this.layoutComponents(this.m_panel);
            this.setShowDetailsImpl(this.m_showDetails);
            this.add((Component)this.m_panel, "Center");
            this.resetConnections();
            this.validate();
        }
        return this.m_panel;
    }

    protected DBUIResourceHelper getResourceHelper() {
        return this.m_reshelp;
    }

    private void layoutComponents(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0);
        panel.add((Component)this.m_connectionsLabel, gbc);
        ++gbc.gridx;
        GridBagConstraints gbcpicker = (GridBagConstraints)gbc.clone();
        gbcpicker.weightx = 1.0;
        gbcpicker.fill = 2;
        ++gbc.gridx;
        if (this.m_addButtons) {
            this.addButtons(panel, gbc);
        }
        this.m_detailsGBC = new GridBagConstraints(0, ++y, gbc.gridx - 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 24, 0, 24), 0, 0);
        this.m_picker = this.getPicker();
        this.m_picker.addItemListener(this.m_listener);
        this.m_reshelp.setName((Component)this.m_picker, "Connection");
        panel.add((Component)this.m_picker, gbcpicker);
        this.setConnectionLabel(ConnBundle.get("LABEL_CONNECTION"));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setShowDetails(boolean showDetails) {
        if (this.m_panel != null && this.m_showDetails != showDetails) {
            this.setShowDetailsImpl(showDetails);
        }
        this.m_showDetails = showDetails;
    }

    private void setShowDetailsImpl(boolean showDetails) {
        if (showDetails) {
            ToolTipManager.sharedInstance().unregisterComponent(this.m_picker);
            if (this.m_detailsPanel == null) {
                this.m_detailsPanel = this.getDetailsPanel();
            }
            if (this.m_detailsPanel != null) {
                this.m_panel.add((Component)this.m_detailsPanel, this.m_detailsGBC);
            }
        } else {
            if (this.m_detailsPanel != null) {
                this.m_panel.remove(this.m_detailsPanel);
            }
            ToolTipManager.sharedInstance().registerComponent(this.m_picker);
        }
        this.repaint();
    }

    protected void addButtons(JPanel panel, GridBagConstraints gbc) {
        gbc.insets.right = 5;
        this.m_btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConnectionPanelUI.this.launchConnectionDialog(false);
                AbstractConnectionPanelUI.this.checkFocus();
            }
        });
        this.addButton(panel, this.m_btnNew, gbc, ConnBundle.get("BUTTON_NEW_TT"), ConnBundle.get("BUTTON_NEW"), "New");
        ++gbc.gridx;
        this.m_btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConnectionPanelUI.this.launchConnectionDialog(true);
                AbstractConnectionPanelUI.this.checkFocus();
            }
        });
        this.addButton(panel, this.m_btnEdit, gbc, ConnBundle.get("BUTTON_EDIT_TT"), ConnBundle.get("BUTTON_EDIT"), "Edit");
        ++gbc.gridx;
    }

    protected void addButton(JPanel panel, JButton button, GridBagConstraints gbc, String tooltip, String mnemonicText, String name) {
        this.m_reshelp.setName((Component)button, name);
        button.setToolTipText(tooltip);
        if (ModelUtil.hasLength((String)mnemonicText)) {
            button.setMnemonic(StringUtils.getMnemonicKeyCode((String)mnemonicText));
        }
        IconicButtonUI.install((AbstractButton)button);
        panel.add((Component)button, gbc);
    }

    protected JPanel getDetailsPanel() {
        ConnectionDetails detailsPanel = new ConnectionDetails();
        return detailsPanel;
    }

    protected final void checkFocus() {
        this.getDefaultFocusComponent().requestFocusInWindow();
    }

    protected void enableButtons(boolean validConn) {
        if (this.getPanel().isEnabled()) {
            this.m_btnEdit.setEnabled(validConn);
        }
    }

    public void enableActiveComponents(boolean boo) {
        this.m_btnNew.setEnabled(boo);
        this.m_picker.setEnabled(boo);
        if (boo) {
            this.checkConnection();
        } else {
            this.m_btnEdit.setEnabled(false);
            this.disableDetails();
        }
    }

    @Override
    public void setEnabled(boolean boo) {
        this.getPanel().setEnabled(boo);
        if (this.m_promptLabel != null) {
            this.m_promptLabel.setEnabled(boo);
        }
        this.m_connectionsLabel.setEnabled(boo);
        this.enableActiveComponents(boo);
    }

    public final void addComboListener(ItemListener itemListener) {
        if (itemListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new ArrayList<ItemListener>();
            }
            if (!this.m_listeners.contains(itemListener)) {
                this.m_listeners.add(itemListener);
            }
        }
    }

    public final void removeComboListener(ItemListener itemListener) {
        if (this.m_listeners != null && itemListener != null) {
            this.m_listeners.remove(itemListener);
        }
    }

    protected final Collection<ItemListener> getListeners() {
        return this.m_listeners == null ? Collections.emptyList() : this.m_listeners;
    }

    protected boolean isListening() {
        return this.m_listening;
    }

    protected void setListening(boolean listening) {
        this.m_listening = listening;
    }

    protected final void fireSelectionChanged() {
        this.checkConnection();
        ItemEvent ie = new ItemEvent(this.m_picker, 701, this.m_picker.getSelectedItem(), 1);
        for (ItemListener il : this.getListeners()) {
            il.itemStateChanged(ie);
        }
    }

    protected void checkConnection() {
        ConnectionInfo connInfo = this.getConnectionInfo();
        if (this.m_addButtons) {
            this.enableButtons(connInfo != null && connInfo.isValid());
        }
        if (this.m_lastShownInfo == null || ModelUtil.areDifferent((Object)((Object)this.m_lastShownInfo), (Object)((Object)connInfo))) {
            this.populateDetails(connInfo);
            this.m_lastShownInfo = new ConnectionInfo(connInfo == null ? null : connInfo.getStoreName(), connInfo == null ? null : connInfo.getConnectionName());
        }
    }

    protected final void clearLastShownInfo() {
        this.m_lastShownInfo = null;
    }

    protected void disableDetails() {
        if (this.m_detailsPanel != null) {
            this.m_detailsPanel.setEnabled(false);
        }
    }

    protected void populateDetails(ConnectionInfo connInfo) {
        if (this.m_detailsPanel instanceof ConnectionDetails) {
            ((ConnectionDetails)this.m_detailsPanel).populateDetails(connInfo);
        } else {
            String tt = ConnectionDetails.getTooltipText(connInfo);
            this.m_picker.setToolTipText(tt);
        }
    }

    @Deprecated
    protected String getPromptText() {
        return null;
    }

    public void setConnectionLabel(String label) {
        this.initialise();
        ResourceUtils.resLabel((JLabel)this.m_connectionsLabel, (Component)this.m_picker, (String)label);
        this.validate();
    }

    public void setConnectionPrompt(String prompt) {
        if (ModelUtil.hasLength((String)prompt)) {
            this.m_promptLabel = new JWrappedLabel(prompt);
            this.add((Component)this.m_promptLabel, "North");
        } else if (this.m_promptLabel != null) {
            this.remove((Component)this.m_promptLabel);
            this.m_promptLabel = null;
        }
        if (this.m_panel != null) {
            this.validate();
        }
    }

    protected final Context getContext() {
        if (this.m_ideContext == null) {
            this.setContext(Context.newIdeContext());
        }
        return this.m_ideContext;
    }

    public void setContext(Context context) {
        this.m_ideContext = context;
    }

    public void setAddButtons(boolean addButtons) {
        this.m_addButtons = addButtons;
    }

    public Component getDefaultFocusComponent() {
        this.initialise();
        JComponent retval = this.m_btnNew;
        if (this.m_picker.getItemCount() > 0) {
            retval = this.m_picker;
        }
        return retval;
    }

    protected abstract String getComponentNamePrefix();

    public abstract ConnectionInfo getConnectionInfo();

    public abstract void setConnectionInfo(ConnectionInfo var1);

    public abstract int resetConnections();

    protected abstract JComboBox getPicker();

    protected abstract void launchConnectionDialog(boolean var1);

    public static String getOracleSubType() {
        return "oraJDBC";
    }

    public static ConnectionInfo getConnection(final AbstractConnectionPanelUI panel, String title, ConnectionInfo connInfo) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_odbselectconnection_html");
        final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultFocusComponent(), (String)title);
        if (connInfo != null) {
            panel.setConnectionInfo(connInfo);
        }
        if (panel.getNoConnectionString() == null) {
            panel.addComboListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ConnectionInfo info = panel.getConnectionInfo();
                    dlg.setOKButtonEnabled(info != null && info.isValid());
                }
            });
            ConnectionInfo info = panel.getConnectionInfo();
            dlg.setOKButtonEnabled(info != null && info.isValid());
        }
        dlg.setMinimumSize(new Dimension(400, 200));
        dlg.setName(panel.getComponentNamePrefix() + "Dialog");
        return WizardLauncher.runDialog((JDialog)dlg) ? panel.getConnectionInfo() : null;
    }

    @Override
    public void addNotify() {
        this.initialise();
        super.addNotify();
    }
}

