/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;

public class ConnectionPanelUI
extends AbstractConnectionPanelUI {
    private static final String LAST_CONNECTION_KEY = "ConnectionPanelUI.LAST_CONNECTION_KEY";
    private DefaultComboBoxModel m_connectionsModel;
    private JComboBox m_connections;

    public ConnectionPanelUI(boolean showDetails) {
        this(false, showDetails);
    }

    public ConnectionPanelUI(boolean oracleOnly, boolean showDetails) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, showDetails);
    }

    public ConnectionPanelUI(String[] subTypes, boolean showDetails) {
        super(subTypes, showDetails);
    }

    @Override
    protected String getComponentNamePrefix() {
        return "ConnectionPanelUI";
    }

    @Override
    protected JComboBox getPicker() {
        this.m_connectionsModel = new NonNullableComboBoxModel();
        return new JComboBox(this.m_connectionsModel);
    }

    public String getConnectionName() {
        String retval = null;
        if (this.m_connectionsModel != null && ModelUtil.areEqual((Object)(retval = (String)this.m_connectionsModel.getSelectedItem()), (Object)this.getNoConnectionString())) {
            retval = null;
        }
        return retval;
    }

    public boolean setConnectionName(String name) {
        boolean exists;
        this.initialise();
        boolean bl = exists = this.m_connectionsModel.getIndexOf(name) != -1;
        if (exists && ModelUtil.areDifferent((Object)this.m_connectionsModel.getSelectedItem(), (Object)name)) {
            this.m_connectionsModel.setSelectedItem(name);
        }
        return exists;
    }

    protected DatabaseConnections getConnections() {
        return DatabaseConnectionStores.getInstance().getStore(this.getStoreName());
    }

    protected String getStoreName() {
        return "IdeConnections";
    }

    protected Collection<String> listConnections() {
        DatabaseConnections conns = this.getConnections();
        return conns == null ? Collections.emptyList() : conns.listConnections(this.getSubTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetConnections() {
        this.initialise();
        String oldConnName = this.getConnectionName();
        int oldConnCount = this.m_connectionsModel.getSize();
        Collection<String> listed = this.listConnections();
        ArrayList<String> connections = new ArrayList<String>(listed);
        Collections.sort(connections);
        String noConnString = this.getNoConnectionString();
        if (noConnString != null) {
            connections.add(0, noConnString);
        }
        if (this.areDifferent(connections, this.m_connectionsModel)) {
            this.setListening(false);
            try {
                this.m_connectionsModel.removeAllElements();
                for (String connName : connections) {
                    this.m_connectionsModel.addElement(connName);
                }
                if (!this.setConnectionName(oldConnName)) {
                    this.loadSettings();
                }
            }
            finally {
                this.setListening(true);
            }
            if (oldConnCount == 0 || ModelUtil.hasLength((String)oldConnName) && !oldConnName.equals(this.getConnectionName())) {
                this.fireSelectionChanged();
            }
        } else if (connections.size() == 0) {
            this.fireSelectionChanged();
        }
        return this.m_connectionsModel.getSize();
    }

    private boolean areDifferent(Collection<String> newConns, DefaultComboBoxModel model) {
        ArrayList<String> oldConns = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            oldConns.add((String)model.getElementAt(i));
        }
        Collections.sort(oldConns);
        return !oldConns.equals(newConns);
    }

    @Override
    public final ConnectionInfo getConnectionInfo() {
        String currConn = this.getConnectionName();
        DatabaseConnections conns = this.getConnections();
        if (conns != null && ModelUtil.hasLength((String)currConn)) {
            return new ConnectionInfo(conns.getStoreName(), currConn);
        }
        return null;
    }

    @Override
    public final void setConnectionInfo(ConnectionInfo info) {
        String store = info.getStoreName();
        if (ModelUtil.areEqual((Object)store, (Object)this.getStoreName())) {
            this.setConnectionName(info.getConnectionName());
        } else {
            DBLog.getLogger((Object)this).warning("Cannot set connection, store " + store + " is not supported by this picker.");
        }
    }

    protected String getSettingsKey() {
        return LAST_CONNECTION_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    public void loadSettings() {
        String key = this.getSettingsKey();
        if (key != null) {
            String lastConn = this.getPropertyStorage().getProperties().getString(key);
            this.setConnectionName(lastConn);
        }
    }

    public void saveSettings() {
        String conn;
        String key = this.getSettingsKey();
        if (key != null && ModelUtil.hasLength((String)(conn = this.getConnectionName()))) {
            this.getPropertyStorage().getProperties().putString(key, conn);
        }
    }

    protected String runConnectionDialog(String conn) {
        DatabaseConnectionEditorLauncher launcher = this.createDatabaseConnectionEditorLauncher();
        ConnectionInfo info = launcher.launchEditor(this.getConnections(), conn);
        return info == null ? null : info.getConnectionName();
    }

    protected DatabaseConnectionEditorLauncher createDatabaseConnectionEditorLauncher() {
        DatabaseConnectionEditorLauncher retval = DatabaseConnectionEditor.createLauncher();
        retval.setContext(this.getContext());
        retval.setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.NONE);
        retval.setAllowedSubTypes(this.getSubTypes());
        return retval;
    }

    @Override
    protected void launchConnectionDialog(boolean edit) {
        String newConn = this.runConnectionDialog(edit ? this.getConnectionName() : null);
        if (this.resetConnections() > 0 && ModelUtil.hasLength((String)newConn)) {
            this.clearLastShownInfo();
            String old = this.getConnectionName();
            if (edit && newConn.equals(old)) {
                this.fireSelectionChanged();
            } else {
                this.setConnectionName(newConn);
            }
            this.checkConnection();
        }
    }

    @Deprecated
    public void itemStateChanged(ItemEvent e) {
    }

    @Deprecated
    public JComboBox getConnCombo() {
        return null;
    }

    @Deprecated
    protected boolean getCanAddNull() {
        return false;
    }

    @Deprecated
    public void setCanAddNull(boolean boo) {
    }

    @Deprecated
    public void actionPerformed(ActionEvent ae) {
    }

    public static String getConnection(String title, String prompt, String connName, boolean oracleOnly) {
        ConnectionPanelUI panel = new ConnectionPanelUI(oracleOnly, true);
        panel.setConnectionPrompt(prompt);
        ConnectionInfo info = ConnectionPanelUI.getConnection(panel, title, new ConnectionInfo("IdeConnections", connName));
        return info == null ? null : info.getConnectionName();
    }
}

