/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.ide.Addin;
import oracle.ide.ProductInformation;
import oracle.ide.model.SingletonProvider;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdevimpl.db.DefaultPasswordPrompter;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class DBConnAddin
implements Addin {
    public static final String EXTENSION_ID = "oracle.jdeveloper.db.connection";

    public void initialize() {
        ProductInformation info = ProductInformation.getProductInformation();
        if (info != null) {
            DatabaseProviderHelper.setProgramName((String)info.getShortName());
        }
        for (DatabaseConnectionHook.ConnectionType ct : DatabaseConnectionHook.getHook().getConnectionTypes()) {
            String subtype = ct.getSubtype();
            ConnectionCreator cc = ct.getConnectionCreator();
            if (!ModelUtil.hasLength((String)subtype) || cc == null) continue;
            DatabaseProvider.registerConnectionCreator((String)subtype, (ConnectionCreator)cc);
        }
        DatabaseProviderHelper.setPasswordPrompter((DatabaseProviderHelper.PasswordPrompter)new DatabaseProviderHelper.PasswordPrompter(){
            private DatabaseProviderHelper.PasswordPrompter m_delegate;

            private DatabaseProviderHelper.PasswordPrompter getDelegate() {
                if (this.m_delegate == null) {
                    if (!Product.isJDeveloper()) {
                        this.m_delegate = (DatabaseProviderHelper.PasswordPrompter)SingletonProvider.find(DatabaseProviderHelper.PasswordPrompter.class);
                    }
                    if (this.m_delegate == null) {
                        this.m_delegate = new DefaultPasswordPrompter();
                    }
                }
                return this.m_delegate;
            }

            public Connection promptForPassword(Properties props, String name, ConnectionCreator c) throws SQLException {
                return this.getDelegate().promptForPassword(props, name, c);
            }

            public void disconnect(Properties props) {
                this.getDelegate().disconnect(props);
            }

            public void cache(Properties props) {
                this.getDelegate().cache(props);
            }
        });
        DatabaseProvider.setClassLoaderFactory((DatabaseProviderClassLoaderFactory)new DatabaseProviderClassLoaderFactory(){

            public ClassLoader getClassLoader(String driverClass) {
                ClassLoader retval = null;
                DatabaseProviderClassLoaderFactory delegate = (DatabaseProviderClassLoaderFactory)SingletonProvider.find(DatabaseProviderClassLoaderFactory.class);
                if (delegate != null) {
                    retval = delegate.getClassLoader(driverClass);
                }
                return retval;
            }
        });
    }
}

