/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class CAConnectionCreator
extends DatabaseFactory.ConnectionCreator {
    private final String m_storeName;
    private final DatabaseContextManager.ContextWrapper m_wrapper;

    public CAConnectionCreator() {
        this("IdeConnections", null);
    }

    public CAConnectionCreator(String storeName, DatabaseContextManager.ContextWrapper wrapper) {
        this.m_storeName = storeName;
        this.m_wrapper = wrapper;
    }

    protected Connection createConnectionImpl(String connName) throws DBException {
        try {
            Object provider;
            Context context = this.m_wrapper == null && "IdeConnections".equals(this.m_storeName) ? DatabaseContextManager.getDatabaseContext() : this.m_wrapper.getDatabaseContext();
            if (context != null && (provider = context.lookup(connName)) instanceof DatabaseProvider) {
                return ((DatabaseProvider)provider).getConnection();
            }
        }
        catch (SQLException sqe) {
            throw new DBException((Throwable)sqe);
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new DBException((Throwable)ne);
        }
        return null;
    }

    protected String getStoreName() {
        return this.m_storeName;
    }

    protected String getDisplayableStoreName() {
        return DatabaseConnectionStores.getInstance().getShortLabel(this.m_storeName);
    }
}

