/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ide.Context;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;
import oracle.jdeveloper.db.panels.DatabaseFinder;

public abstract class DatabaseProviderPicker
extends DBObjectProviderPicker {
    private DBObjectProviderPicker.PickerConfiguration m_config;
    private AbstractConnectionPanelUI m_connUI;
    private ItemListener m_connUIListener;

    protected abstract AbstractConnectionPanelUI createConnectionPicker(DBObjectProviderPicker.PickerConfiguration var1);

    private ConnectionInfo getConnectionInfo() {
        return this.m_connUI == null ? null : this.m_connUI.getConnectionInfo();
    }

    protected void setConnectionInfo(ConnectionInfo info) {
        this.m_connUI.setConnectionInfo(info);
    }

    protected final DBObjectProviderPicker.PickerConfiguration getConfiguration() {
        return this.m_config;
    }

    public final Component getComponent() {
        return this.m_connUI;
    }

    public final void setProvider(String type, Object identifier) {
        if ("db".equals(type) && identifier instanceof String) {
            ConnectionInfo info = new ConnectionInfo((String)identifier);
            this.setConnectionInfo(info);
        }
    }

    public DBObjectProvider getProvider() throws DBException {
        String qname;
        Database retval = null;
        ConnectionInfo ci = this.getConnectionInfo();
        if (ci != null && (qname = ci.getQualifiedName()) != null) {
            retval = DatabaseFinder.findDatabaseEx(qname);
        }
        return retval;
    }

    public DBObjectProviderID getProviderID() {
        DBObjectProviderID retval = null;
        ConnectionInfo ci = this.getConnectionInfo();
        if (ci != null) {
            retval = ci.getProviderID();
        }
        return retval;
    }

    protected final void init(DBObjectProviderPicker.PickerConfiguration config) {
        this.m_config = config;
        if (this.m_connUI == null) {
            this.m_connUI = this.createConnectionPicker(config);
        }
        this.init(this.m_connUI, config);
    }

    protected void init(AbstractConnectionPanelUI connUI, DBObjectProviderPicker.PickerConfiguration config) {
        this.m_connUI.setAddButtons(true);
        connUI.setConnectionPrompt(null);
        Context context = config.getContext();
        if (context != null) {
            this.m_connUI.setContext(context);
        }
        if (config.getAllowNull()) {
            this.m_connUI.setNoConnectionString(" ");
        }
    }

    protected final void addImplementationListener() {
        if (this.m_connUI == null) {
            throw new IllegalArgumentException("ProviderPicker must be initialized before adding a PickerListener");
        }
        if (this.m_connUIListener == null) {
            this.m_connUIListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ConnectionInfo cinfo = DatabaseProviderPicker.this.getConnectionInfo();
                    DatabaseProviderPicker.this.firePickerChanged(cinfo == null ? null : cinfo.getProviderID());
                }
            };
        }
        this.m_connUI.addComboListener(this.m_connUIListener);
    }

    protected final void removeImplementationListener() {
        if (this.m_connUI != null) {
            this.m_connUI.removeComboListener(this.m_connUIListener);
        }
    }
}

