/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.combo.JTreeCombo;
import oracle.javatools.ui.combo.TreeComboModel;
import oracle.javatools.ui.combo.TreeComboRenderer;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class GlobalConnectionPicker
extends JTreeCombo {
    private final DefaultMutableTreeNode m_root;
    private final DefaultTreeModel m_treeModel;
    private final DatabaseConnectionStores m_stores;
    private final String[] m_subTypes;
    private ConnectionInfo m_info = new ConnectionInfo(null, null);
    private String m_singleStore;
    private String m_noConnectionString;
    private DefaultMutableTreeNode m_noConnectionNode;
    private boolean m_listening = true;
    private Collection<ItemListener> m_listeners;
    private Context m_context;
    private final List<DefaultMutableTreeNode> m_connNodes = new ArrayList<DefaultMutableTreeNode>();

    public GlobalConnectionPicker() {
        this(null);
    }

    public GlobalConnectionPicker(String ... subTypes) {
        this.m_subTypes = subTypes;
        this.m_stores = DatabaseConnectionStores.getInstance();
        JTree tree = this.getTree();
        this.m_root = new DefaultMutableTreeNode("ROOT");
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        tree.setModel(this.m_treeModel);
        this.setModel((ComboBoxModel)((Object)new M(tree)));
        this.setRootVisible(false);
        this.setTreeComboRenderer(new R());
    }

    public void setNoConnectionString(String noConn) {
        this.m_noConnectionString = noConn;
        this.resetConnections();
    }

    public int resetConnections() {
        ConnectionInfo info;
        this.m_root.removeAllChildren();
        this.m_connNodes.clear();
        if (ModelUtil.hasLength((String)this.m_noConnectionString)) {
            this.m_noConnectionNode = new DefaultMutableTreeNode(this.m_noConnectionString);
            this.m_root.add(this.m_noConnectionNode);
            this.m_connNodes.add(this.m_noConnectionNode);
        } else {
            this.m_noConnectionNode = null;
        }
        Collection<String> stores = this.listStores();
        for (String storeName : stores) {
            DatabaseConnections store = this.m_stores.getStore(storeName);
            if (store == null) continue;
            DefaultMutableTreeNode storeNode = new DefaultMutableTreeNode(store.getStoreName());
            for (String connName : new TreeSet<String>(this.listConnections(store))) {
                DefaultMutableTreeNode connNode = new DefaultMutableTreeNode((Object)new ConnectionInfo(storeName, connName));
                storeNode.add(connNode);
                this.m_connNodes.add(connNode);
            }
            this.m_root.add(storeNode);
        }
        this.m_singleStore = null;
        if (this.isSingleStoreCollapsible() && this.m_root.getChildCount() == 1) {
            DefaultMutableTreeNode storeNode = (DefaultMutableTreeNode)this.m_root.getFirstChild();
            this.m_singleStore = (String)storeNode.getUserObject();
            this.m_root.remove(storeNode);
            while (storeNode.getChildCount() > 0) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)storeNode.getChildAt(0);
                storeNode.remove(0);
                this.m_root.add(node);
            }
        }
        this.m_treeModel.reload(this.m_root);
        this.expandAll();
        if (!this.m_info.isValid() && (info = this.getDefaultConnectionInfo()) != null) {
            info.copyTo((Object)this.m_info);
        }
        this.selectCurrentConnection();
        return this.m_connNodes.size();
    }

    protected ConnectionInfo getDefaultConnectionInfo() {
        ConnectionInfo retval;
        if (this.m_noConnectionString == null) {
            retval = this.m_stores.getCurrentConnectionInfo(this.m_context);
            if (retval == null) {
                DefaultMutableTreeNode defStoreNode;
                if (this.m_singleStore == null) {
                    DefaultMutableTreeNode defConnsNode;
                    DatabaseConnections defConns = this.m_stores.getCurrentStore(this.m_context);
                    DefaultMutableTreeNode defaultMutableTreeNode = defConnsNode = defConns == null ? null : this.findNode(this.m_root, defConns.getStoreName());
                    defStoreNode = defConnsNode != null && defConnsNode.getChildCount() > 0 ? defConnsNode : this.getFirstChildWithChildren(this.m_root);
                } else {
                    defStoreNode = this.m_root;
                }
                if (defStoreNode != null) {
                    try {
                        DefaultMutableTreeNode connNode = (DefaultMutableTreeNode)defStoreNode.getFirstChild();
                        retval = (ConnectionInfo)((Object)connNode.getUserObject());
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
        } else {
            retval = new ConnectionInfo(null, null);
        }
        return retval;
    }

    private DefaultMutableTreeNode getFirstChildWithChildren(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode retval = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (child.getChildCount() <= 0) continue;
            retval = child;
            break;
        }
        return retval;
    }

    protected boolean isSingleStoreCollapsible() {
        return true;
    }

    public Collection<String> listStores() {
        return this.m_stores.listStores(this.m_context);
    }

    public Collection<String> listConnections(DatabaseConnections conns) {
        return conns.listConnections(this.m_subTypes);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.m_info;
    }

    public Database getDatabase() {
        ConnectionInfo connInfo = this.getConnectionInfo();
        Database db = null;
        if (connInfo != null) {
            try {
                db = connInfo.getDatabase();
            }
            catch (DBException dbe) {
                DBExceptionDialog.showErrorDialog((Component)((Object)this), null, (DBException)dbe);
            }
        }
        return db;
    }

    public void setContext(Context context) {
        this.m_context = context;
        this.clearConnectionInfo();
        this.resetConnections();
    }

    public Context getContext() {
        return this.m_context;
    }

    private void clearConnectionInfo() {
        this.m_info.setStoreName(null);
        this.m_info.setConnectionName(null);
    }

    public void setDatabase(Database db) {
        String storeName = db == null ? null : db.getConnectionStore();
        String connName = db == null ? null : db.getConnectionName();
        this.setConnectionInfo(storeName, connName);
    }

    public void setConnectionInfo(String store, String conn) {
        ConnectionInfo info = new ConnectionInfo(store, conn);
        if (info.isValid()) {
            this.m_info.setStoreName(store);
            this.m_info.setConnectionName(conn);
            this.selectCurrentConnection();
        } else if (this.m_noConnectionString != null) {
            this.clearConnectionInfo();
            this.selectCurrentConnection();
        }
    }

    public void setConnectionInfo(ConnectionInfo info) {
        if (info != null) {
            this.m_info = info;
            this.selectCurrentConnection();
        }
    }

    private void selectCurrentConnection() {
        DefaultMutableTreeNode connNode = null;
        if (this.m_info.isValid()) {
            DefaultMutableTreeNode storeNode = this.m_singleStore != null ? this.m_root : this.findNode(this.m_root, this.m_info.getStoreName());
            if (storeNode != null) {
                connNode = this.findNode(storeNode, (Object)this.m_info);
            }
        } else if (this.m_noConnectionString != null) {
            connNode = this.m_noConnectionNode;
        }
        Object currentSelection = this.getSelectedItem();
        if (connNode == null) {
            this.populateConnectionInfo(currentSelection);
        } else if (connNode != currentSelection) {
            this.setSelectedItem(connNode);
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode parent, Object userObj) {
        DefaultMutableTreeNode retval = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (!ModelUtil.areEqual((Object)node.getUserObject(), (Object)userObj)) continue;
            retval = node;
            break;
        }
        return retval;
    }

    public void addComboListener(ItemListener itemListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<ItemListener>();
        }
        this.m_listeners.add(itemListener);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object anObject = e.getItem();
        if (e.getStateChange() == 1) {
            this.populateConnectionInfo(anObject);
        }
        super.fireItemStateChanged(e);
    }

    private void populateConnectionInfo(Object selected) {
        if (selected instanceof DefaultMutableTreeNode) {
            selected = ((DefaultMutableTreeNode)selected).getUserObject();
        }
        if (selected instanceof ConnectionInfo) {
            if (!selected.equals((Object)this.m_info)) {
                ((ConnectionInfo)((Object)selected)).copyTo((Object)this.m_info);
            }
        } else if (ModelUtil.areEqual((Object)selected, (Object)this.m_noConnectionString)) {
            this.clearConnectionInfo();
        }
    }

    private class R
    extends DefaultTreeCellRenderer
    implements TreeComboRenderer {
        private R() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component retval = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (retval instanceof JLabel && value instanceof DefaultMutableTreeNode) {
                this.renderLabel((DefaultMutableTreeNode)value, (JLabel)retval);
            }
            return retval;
        }

        private void renderLabel(DefaultMutableTreeNode node, JLabel label) {
            Icon icon;
            String text;
            Object value = node.getUserObject();
            if (value instanceof ConnectionInfo) {
                text = ((ConnectionInfo)((Object)value)).getConnectionName();
                icon = OracleIcons.getIcon((String)"database.png");
            } else if (ModelUtil.areEqual((Object)value, (Object)GlobalConnectionPicker.this.m_noConnectionString)) {
                text = GlobalConnectionPicker.this.m_noConnectionString;
                icon = IdeIcons.getIcon((int)23);
            } else {
                text = GlobalConnectionPicker.this.m_stores.getShortLabel((String)value);
                icon = GlobalConnectionPicker.this.m_stores.getIcon((String)value);
            }
            label.setText(text);
            label.setIcon(GlobalConnectionPicker.this.m_singleStore == null ? icon : null);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel();
            if (value instanceof DefaultMutableTreeNode) {
                String text = null;
                if (value == GlobalConnectionPicker.this.m_noConnectionNode) {
                    text = GlobalConnectionPicker.this.m_noConnectionString;
                } else if ((value = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ConnectionInfo) {
                    String store;
                    text = ((ConnectionInfo)((Object)value)).getConnectionName();
                    if (GlobalConnectionPicker.this.m_singleStore == null && (store = ((ConnectionInfo)((Object)value)).getStoreName()) != null) {
                        text = text + " (" + GlobalConnectionPicker.this.m_stores.getShortLabel(store) + ")";
                    }
                }
                label.setText(text);
            }
            return label;
        }
    }

    private class M
    extends TreeComboModel {
        M(JTree tree) {
            super(tree);
        }

        public int getSize() {
            return GlobalConnectionPicker.this.m_connNodes.size();
        }

        public Object getElementAt(int index) {
            return GlobalConnectionPicker.this.m_connNodes.get(index);
        }

        public void setSelectedItem(Object anItem) {
            if (GlobalConnectionPicker.this.m_connNodes.contains(anItem)) {
                super.setSelectedItem(anItem);
            }
        }
    }
}

