/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.panels.JDBCParametersPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public abstract class AbstractConnectionDetailsPanel
implements Traversable {
    private final String m_subType;
    private final DatabaseConnectionHook.ConnectionType m_connType;
    private final String m_panelName;
    private final DBUIResourceHelper m_resourceHelper;
    private JPanel m_panel;
    private JCheckBox m_chkCustomURL;
    private JTextArea m_txtCustomURL;
    private JScrollPane m_spCustomURL;
    private String m_defaultURL;
    private JButton m_btnParams;
    private JPanel m_detailsPanel;
    private Properties m_connectionProps;
    private Map<String, String> m_labelNames = new HashMap<String, String>();
    private Map<String, JTextComponent> m_components = new HashMap<String, JTextComponent>();

    public AbstractConnectionDetailsPanel(String subType, String panelName) {
        this.m_subType = subType;
        this.m_panelName = panelName;
        this.m_resourceHelper = new DBUIResourceHelper(panelName);
        DatabaseConnectionHook.ConnectionType found = null;
        for (DatabaseConnectionHook.ConnectionType type : DatabaseConnectionHook.getHook().getConnectionTypes()) {
            if (!subType.equals(type.getSubtype())) continue;
            found = type;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException(subType + " is not a valid subtype");
        }
        this.m_connType = found;
    }

    protected final DatabaseConnectionHook.ConnectionType getConnectionType() {
        return this.m_connType;
    }

    protected final ConnectionCreator getConnectionCreator() {
        return this.m_connType.getConnectionCreator();
    }

    public String getHelpID() {
        return "f1_dbconnection_html";
    }

    public Component getComponent() {
        if (this.m_panel == null) {
            this.m_panel = new JPanel();
            this.m_panel.setName(this.m_panelName);
            DBUILayoutHelper layout = new DBUILayoutHelper(this.m_panel);
            layout.setMargins(0);
            this.layoutComponents(this.m_panel, layout, this.getResourceHelper());
            layout.layout();
        }
        return this.m_panel;
    }

    protected final String getPropertyLabelText(String property) {
        return this.m_connType.getPropertyLabelText(property);
    }

    protected final void registerTextComponent(String property, JLabel label, JTextComponent field, String componentName) {
        this.registerTextComponent(property, label, field, this.getPropertyLabelText(property), componentName);
    }

    protected final void registerTextComponent(String property, JLabel label, JTextComponent field, String labelText, String componentName) {
        this.getResourceHelper().resLabel(label, (Component)field, labelText, componentName);
        if (this.m_components.containsKey(property)) {
            throw new IllegalStateException("Cannot register a property more than once");
        }
        this.m_components.put(property, field);
        this.m_labelNames.put(property, labelText);
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_resourceHelper;
    }

    protected void layoutComponents(JPanel panel, DBUILayoutHelper layout, DBUIResourceHelper resHelp) {
        this.m_detailsPanel = this.createDetailsPanel(resHelp);
        final ConnectionCreator connCreator = this.getConnectionCreator();
        Collection props = connCreator.listAllowedProperties();
        if (props.contains("parameters")) {
            this.m_btnParams = new JButton();
            resHelp.resButton((AbstractButton)this.m_btnParams, this.getPropertyLabelText("parameters").replace(":", "..."), "Parameters");
            this.m_btnParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractConnectionDetailsPanel.this.m_connectionProps != null) {
                        AbstractConnectionDetailsPanel.this.commitConnectionDetails(AbstractConnectionDetailsPanel.this.m_connectionProps, AbstractConnectionDetailsPanel.this.isCustom());
                        JDBCParametersPanel.editParameters(AbstractConnectionDetailsPanel.this.m_detailsPanel, connCreator, AbstractConnectionDetailsPanel.this.m_connectionProps);
                        AbstractConnectionDetailsPanel.this.populateConnectionDetails(AbstractConnectionDetailsPanel.this.m_connectionProps);
                    }
                }
            });
        }
        if (props.contains("customUrl")) {
            JComponent comp;
            this.m_txtCustomURL = new JTextArea();
            this.m_txtCustomURL.setLineWrap(true);
            this.m_spCustomURL = new JScrollPane(this.m_txtCustomURL, 20, 31);
            if (this.m_detailsPanel == null) {
                JLabel label = new JLabel();
                resHelp.resLabel(label, (Component)this.m_txtCustomURL, this.getPropertyLabelText("customUrl"), "URL");
                comp = label;
            } else {
                this.m_chkCustomURL = new JCheckBox();
                this.m_chkCustomURL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractConnectionDetailsPanel.this.setComponentsVisible(AbstractConnectionDetailsPanel.this.m_chkCustomURL.isSelected());
                    }
                });
                resHelp.resButton((AbstractButton)this.m_chkCustomURL, ConnBundle.get("CONN_CUSTOM_URL"), "Advanced");
                resHelp.setName((Component)this.m_txtCustomURL, "URL");
                comp = this.m_chkCustomURL;
            }
            layout.add((Component)comp);
            if (this.m_btnParams != null) {
                layout.add((Component)this.m_btnParams);
                layout.getConstraints((Component)this.m_btnParams).anchor = 12;
            }
            layout.nextRow();
            layout.add((Component)this.m_spCustomURL, 2, 1, true, true);
            layout.nextRow();
        }
        if (this.m_detailsPanel != null) {
            layout.add((Component)this.m_detailsPanel, 2, 1, true, true);
            layout.nextRow();
        }
    }

    protected abstract JPanel createDetailsPanel(DBUIResourceHelper var1);

    private void setComponentsVisible(boolean isCustomURL) {
        if (this.m_txtCustomURL != null) {
            this.resetCustomURL();
            if (this.m_detailsPanel != null) {
                if (isCustomURL) {
                    this.m_detailsPanel.setVisible(false);
                    this.m_spCustomURL.setVisible(true);
                } else {
                    this.m_spCustomURL.setVisible(false);
                    this.m_detailsPanel.setVisible(true);
                }
                this.m_panel.validate();
                this.m_panel.repaint();
            }
        }
    }

    protected final void resetCustomURL() {
        String curr;
        if (this.isCustom() && (!ModelUtil.hasLength((String)(curr = this.m_txtCustomURL.getText())) || ModelUtil.areEqual((Object)curr, (Object)this.m_defaultURL))) {
            this.m_defaultURL = this.getDefaultURL();
            this.m_txtCustomURL.setText(this.m_defaultURL);
        }
    }

    protected String getDefaultURL() {
        String retval = "jdbc:";
        String protocol = this.getDefaultProtocol();
        if (ModelUtil.hasLength((String)protocol)) {
            retval = retval + protocol + ":";
        }
        return retval;
    }

    protected String getDefaultProtocol() {
        String retval = null;
        Map<String, String> dcs = this.m_connType.getDriverClasses();
        if (!dcs.isEmpty()) {
            retval = dcs.entrySet().iterator().next().getValue();
        }
        return retval;
    }

    public final void onEntry(TraversableContext dataContext) {
        this.m_connectionProps = (Properties)dataContext.get("NewObject");
        this.populateConnectionDetails(this.m_connectionProps);
    }

    protected void populateConnectionDetails(Properties connectionProps) {
        boolean custom;
        String url = connectionProps.getProperty("customUrl");
        boolean bl = custom = url != null;
        if (this.m_txtCustomURL != null) {
            this.m_txtCustomURL.setText(url);
            if (this.m_chkCustomURL != null) {
                this.m_chkCustomURL.setSelected(custom);
            }
        }
        for (Map.Entry<String, JTextComponent> entry : this.m_components.entrySet()) {
            String property = entry.getKey();
            entry.getValue().setText(connectionProps.getProperty(property, this.getDefaultValue(property)));
        }
        this.setComponentsVisible(custom);
    }

    protected String getDefaultValue(String property) {
        String retval = null;
        if ("hostname".equals(property)) {
            retval = "localhost";
        }
        return retval;
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_connectionProps = (Properties)dataContext.get("NewObject");
        boolean isCustom = this.isCustom();
        this.commitConnectionDetails(this.m_connectionProps, isCustom);
        this.validateConnectionDetails(this.m_connectionProps, isCustom);
    }

    private boolean isCustom() {
        return this.m_detailsPanel == null || this.m_chkCustomURL != null && this.m_chkCustomURL.isSelected();
    }

    protected void validateConnectionDetails(Properties connectionProps, boolean isCustom) throws TraversalException {
        if (isCustom) {
            String url = connectionProps.getProperty("customUrl");
            MissingDBConnValueException.check(url, this.m_connType.getPropertyDisplayName("customUrl"));
        } else {
            Collection required = this.getConnectionCreator().listRequiredProperties();
            for (String name : required) {
                MissingDBConnValueException.check(connectionProps.getProperty(name), this.m_connType.getPropertyDisplayName(name));
                String port = connectionProps.getProperty("port");
                if (!ModelUtil.hasLength((String)port) || !port.equals("0")) continue;
                MissingDBConnValueException.check(null, this.m_connType.getPropertyDisplayName("port"));
            }
        }
    }

    private String getLabel(String property) {
        String retval = this.m_labelNames.get(property);
        if (retval == null) {
            retval = property;
        }
        return retval;
    }

    protected void commitConnectionDetails(Properties connectionProps, boolean isCustom) {
        if (isCustom) {
            this.setProperty(connectionProps, "customUrl", this.getTrimmedText(this.m_txtCustomURL));
            for (String prop : this.m_components.keySet()) {
                connectionProps.remove(prop);
            }
        } else {
            connectionProps.remove("customUrl");
            for (Map.Entry<String, JTextComponent> entry : this.m_components.entrySet()) {
                String property = entry.getKey();
                String val = this.getTrimmedText(entry.getValue());
                this.setProperty(connectionProps, property, val);
            }
        }
    }

    protected final void setProperty(Properties connectionProps, String property, String val) {
        if (ModelUtil.hasLength((String)val)) {
            connectionProps.setProperty(property, val);
        } else {
            connectionProps.remove(property);
        }
    }

    public Object getExitTransition() {
        return null;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    protected final String getTrimmedText(JTextComponent tc) {
        Number n;
        String retval = tc instanceof NumberTextField ? ((n = ((NumberTextField)tc).getNumber()) == null ? null : n.toString()) : this.trimIfNotNull(tc.getText());
        return retval;
    }

    protected final String trimIfNotNull(String s) {
        if (s != null) {
            s = s.trim();
        }
        return ModelUtil.nullifyIfEmpty((String)s);
    }

    protected void ensureDialogSize() {
        if (this.m_panel != null) {
            this.m_panel.validate();
            Window win = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.m_panel);
            if (win != null) {
                win.pack();
            }
        }
    }

    protected static NumberTextField newPortField() {
        return new WholeNumberField(6);
    }
}

