/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.JDBCParameterInfo;
import oracle.jdeveloper.db.adapter.JDBCParametersParser;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class JDBCParametersPanel
implements Traversable {
    private final GenericTable m_table;
    private final ReorderableTableWithTitleBar m_component;
    private PropertiesTableModel m_tableModel;
    private final Map<String, JDBCParameterInfo> m_infos = new TreeMap<String, JDBCParameterInfo>();
    private final JComboBox m_nameCombo = new JComboBox();
    private ConnectionCreator m_connCreator;

    public JDBCParametersPanel() {
        DBUIResourceHelper resHelp = new DBUIResourceHelper("JDBCParametersPanel");
        this.m_table = new GenericTable();
        this.m_table.setColumnSelectorAvailable(false);
        resHelp.setName((Component)this.m_table, "ParamsTable");
        this.m_nameCombo.setEditable(true);
        resHelp.setName((Component)this.m_nameCombo, "JdbcParametersPanel.NameCombo");
        new JScrollPane((Component)this.m_table);
        this.m_component = new ReorderableTableWithTitleBar((JTable)this.m_table, false, false);
        TableToolbar toolbar = new TableToolbar((JTable)this.m_table, ConnBundle.get("JDBC_PARAMS"));
        AbstractAction addAction = new AbstractAction(null, OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCParametersPanel.this.stopCellEditing();
                JDBCParametersPanel.this.m_tableModel.addRow(new Vector(2));
                int newRow = JDBCParametersPanel.this.m_tableModel.getRowCount() - 1;
                JDBCParametersPanel.this.m_table.setSelectedRowInModel(newRow);
                if (JDBCParametersPanel.this.m_table.editCellAt(newRow, 0)) {
                    JDBCParametersPanel.this.m_table.getEditorComponent().requestFocusInWindow();
                }
            }
        };
        String add = ConnBundle.get("JDBDC_PARAMS_ADD");
        addAction.putValue("ShortDescription", StringUtils.stripMnemonic((String)add));
        addAction.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)add));
        JButton addButton = new JButton(addAction);
        resHelp.setName((Component)addButton, "Add");
        AbstractAction deleteAction = new AbstractAction(null, OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCParametersPanel.this.stopCellEditing();
                int row = JDBCParametersPanel.this.m_table.getSelectedRowInModel();
                if (row >= 0) {
                    JDBCParametersPanel.this.m_tableModel.removeRow(row);
                    int left = JDBCParametersPanel.this.m_table.getRowCount();
                    if (left > 0) {
                        JDBCParametersPanel.this.m_table.setSelectedRowInModel(row < left ? row : left - 1);
                    }
                }
            }
        };
        String del = ConnBundle.get("JDBDC_PARAMS_DEL");
        deleteAction.putValue("ShortDescription", StringUtils.stripMnemonic((String)del));
        deleteAction.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)del));
        final JButton deleteButton = new JButton(deleteAction);
        resHelp.setName((Component)deleteButton, "Delete");
        deleteButton.setEnabled(false);
        toolbar.addActionControl((Component)addButton, true);
        toolbar.addActionControl((Component)deleteButton, true);
        ListSelectionModel listSelectionModel = this.m_table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                deleteButton.setEnabled(JDBCParametersPanel.this.m_table.getSelectedRowInModel() >= 0);
            }
        });
        this.m_component.setTableToolbar(toolbar);
        resHelp.setName((Component)this.m_component, "ParamsTableWithToolbar");
    }

    public Component getComponent() {
        return this.m_component;
    }

    public String getHelpID() {
        return "f1_dbconnectionparams_html";
    }

    public void onEntry(TraversableContext dataContext) {
        Properties jdbcParams;
        block9: {
            ConnectionCreator connCreator;
            Properties connProps = (Properties)dataContext.get("NewObject");
            String paramString = connProps.getProperty("parameters");
            jdbcParams = new Properties();
            if (ModelUtil.hasLength((String)paramString)) {
                JDBCParametersParser.parseParameterString((String)paramString, (Properties)jdbcParams);
            }
            if ((connCreator = (ConnectionCreator)dataContext.get(ConnectionCreator.class)) != this.m_connCreator) {
                this.m_infos.clear();
                this.m_nameCombo.removeAllItems();
                this.m_connCreator = connCreator;
                if (this.m_connCreator != null) {
                    try {
                        Collection infos = this.m_connCreator.listJDBCParameterInfos(connProps);
                        if (infos != null) {
                            for (JDBCParameterInfo info : infos) {
                                this.m_infos.put(info.getName(), info);
                            }
                            for (String name : this.m_infos.keySet()) {
                                this.m_nameCombo.addItem(name);
                            }
                        }
                    }
                    catch (SQLException sqe) {
                        if (sqe instanceof SQLFeatureNotSupportedException) break block9;
                        DBLog.getLogger((Object)this).warning("Could not populate JDBC parameters: " + sqe.getMessage());
                    }
                }
            }
        }
        this.m_tableModel = new PropertiesTableModel(jdbcParams);
        this.m_table.setModel((TableModel)((Object)this.m_tableModel));
        if (!this.m_infos.isEmpty()) {
            this.m_table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.m_nameCombo){

                @Override
                public boolean stopCellEditing() {
                    String newValue;
                    JDBCParameterInfo info;
                    Object name;
                    Object value;
                    int row;
                    boolean retval = super.stopCellEditing();
                    if (retval && JDBCParametersPanel.this.m_infos != null && (row = JDBCParametersPanel.this.m_table.getSelectedRowInModel()) >= 0 && (value = JDBCParametersPanel.this.m_tableModel.getValueAt(row, 1)) == null && (name = JDBCParametersPanel.this.m_tableModel.getValueAt(row, 0)) != null && (info = (JDBCParameterInfo)JDBCParametersPanel.this.m_infos.get(name)) != null && (newValue = info.getDefaultValue()) != null) {
                        JDBCParametersPanel.this.m_tableModel.setValueAt(newValue, row, 1);
                    }
                    return retval;
                }
            });
        }
    }

    private void stopCellEditing() {
        TableCellEditor ed = this.m_table.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.stopCellEditing();
        Properties connProps = (Properties)dataContext.get("NewObject");
        String paramString = JDBCParametersParser.createParameterString((Properties)this.m_tableModel.getProperties());
        if (ModelUtil.hasLength((String)paramString)) {
            connProps.setProperty("parameters", paramString);
        } else {
            connProps.remove("parameters");
        }
    }

    public Object getExitTransition() {
        return null;
    }

    private static Vector createTableDataVector(Properties props) {
        Vector retval = new Vector(props.size());
        TreeSet<String> names = new TreeSet<String>(props.stringPropertyNames());
        for (String name : names) {
            Vector<String> row = new Vector<String>(2);
            row.add(name);
            row.add(props.getProperty(name));
            retval.add(row);
        }
        return retval;
    }

    private static Vector getColumnNames() {
        Vector<String> retval = new Vector<String>();
        retval.add(ConnBundle.get("JDBC_PARAMS_NAME"));
        retval.add(ConnBundle.get("JDBC_PARAMS_VALUE"));
        return retval;
    }

    public static void editParameters(Component parent, ConnectionCreator connCreator, Properties connectionProps) {
        JDBCParametersPanel panel = new JDBCParametersPanel();
        Namespace data = new Namespace();
        data.put("NewObject", (Object)connectionProps);
        data.put(ConnectionCreator.class.getName(), (Object)connCreator);
        TDialogLauncher launcher = new TDialogLauncher(parent, ConnBundle.get("JDBC_PARAMS"), (Traversable)panel, data);
        launcher.initDialog().setName("JDBCParametersDialog");
        launcher.showDialog();
    }

    private static class PropertiesTableModel
    extends GenericBaseTableModel {
        public PropertiesTableModel(Properties props) {
            super(JDBCParametersPanel.createTableDataVector(props), JDBCParametersPanel.getColumnNames());
        }

        public Properties getProperties() throws TraversalException {
            Properties retval = new Properties();
            HashSet<String> names = new HashSet<String>();
            for (Vector row : this.getDataVector()) {
                String name = (String)row.get(0);
                if (!ModelUtil.hasLength((String)name)) {
                    throw new TraversalException(ConnBundle.get("JDBC_PARAMS_NULL_NAME_ERR"));
                }
                if (names.contains(name)) {
                    throw new TraversalException(ConnBundle.format("JDBC_PARAMS_DUP_ERR", name));
                }
                if ("user".equals(name) || "password".equals(name)) {
                    throw new TraversalException(ConnBundle.format("JDBC_PARAMS_ILLEGAL", name));
                }
                this.checkChars(name);
                String value = (String)row.get(1);
                if (!ModelUtil.hasLength((String)value)) {
                    throw new TraversalException(ConnBundle.format("JDBC_PARAMS_NULL_VAL_ERR", name));
                }
                this.checkChars(value);
                retval.setProperty(name, value);
                names.add(name);
            }
            return retval;
        }

        private void checkChars(String value) throws TraversalException {
            for (char c : new char[]{'=', ',', ';'}) {
                if (value.indexOf(c) <= 0) continue;
                throw new TraversalException(ConnBundle.format("JDBC_PARAMS_CHAR_ERR", value, Character.valueOf(c)));
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean canHide(int column) {
            return false;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

