/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.controls.StorePicker;
import oracle.jdevimpl.db.panels.ConnectionEditorPanel;
import oracle.jdevimpl.db.resource.ConnBundle;

public class StoreConnectionEditorPanel
extends DefaultTraversablePanel {
    private static final String HELP_ID = "f1_dbconnection_html";
    private final JLabel m_lblLoc = new JLabel();
    private final ConnectionEditorPanel m_editPanel = new ConnectionEditorPanel();
    private StorePicker m_picker;

    public StoreConnectionEditorPanel() {
        this.setHelpID(HELP_ID);
    }

    public Component getDefaultFocusComponent() {
        return this.m_editPanel.getDefaultFocusComponent();
    }

    protected StorePicker createStorePicker(Context ideContext) {
        return new StorePicker(ideContext);
    }

    public void onEntry(TraversableContext dataContext) {
        DatabaseConnections defconns;
        Context ideContext = (Context)dataContext.get(Context.class);
        String originalName = (String)dataContext.get("ConnectionOrigNameKey");
        boolean edit = ModelUtil.hasLength((String)originalName);
        if (this.m_picker == null) {
            this.m_picker = this.createStorePicker(ideContext);
            DBUIResourceHelper reshelp = new DBUIResourceHelper("StoreConnectionEditorPanel");
            this.setName(reshelp.getPanelName());
            String locText = edit ? ConnBundle.get("DB_CONN_EXISTS_IN") : ConnBundle.get("DB_CONN_CREATE_IN");
            reshelp.resLabel(this.m_lblLoc, (Component)this.m_picker, locText, "StorePicker");
            DBUILayoutHelper layout = new DBUILayoutHelper((JPanel)((Object)this));
            layout.add((Component)this.m_lblLoc);
            layout.add((Component)this.m_picker);
            layout.nextRowWithGap();
            layout.add((Component)((Object)this.m_editPanel), 2, 1, true, true);
            layout.layout();
        }
        if ((defconns = (DatabaseConnections)dataContext.get("ConnectionsInstanceKey")) == null) {
            defconns = DatabaseConnectionStores.getInstance().getCurrentStore(ideContext);
        }
        this.m_picker.setStore(defconns.getStoreName());
        DatabaseConnectionEditorLauncher.StoreChoice choice = (DatabaseConnectionEditorLauncher.StoreChoice)((Object)dataContext.get(DatabaseConnectionEditorLauncher.StoreChoice.class));
        boolean force = choice == DatabaseConnectionEditorLauncher.StoreChoice.NONE;
        this.m_picker.setEnabled(!force && !edit);
        this.m_editPanel.onEntry(dataContext);
        this.validate();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_editPanel.onExit(dataContext);
        if (this.m_picker != null && this.m_picker.isEnabled()) {
            DatabaseConnections chosenConns = DatabaseConnectionStores.getInstance().getStore(this.m_picker.getStore());
            dataContext.put("ConnectionsInstanceKey", (Object)chosenConns);
        }
    }
}

