/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.peek.Peek;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ColorUtils2;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.BreakpointConditionEvaluationResult;
import oracle.jdevimpl.debugger.DbgArb;

public final class BreakpointConditionHoverBuilder {
    private BreakpointConditionHoverBuilder() {
    }

    public static Peek build(Breakpoint breakpoint, JComponent gutterComponent, BreakpointConditionEvaluationResult evaluationResult, long threadID, Rectangle whereToPoint) {
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 0, gapx 4, gapy 0, fill"));
        content.setOpaque(true);
        content.putClientProperty(UIConstants.VETO_CONVERSION, true);
        Color background = ColorUtils2.alphaColor((Color)UIConstants.getColor((String)"ghost.panel.background", (UIConstants.Look)UIConstants.Look.DARK), (float)0.93f);
        content.setBackground(background);
        Icon statusIcon = null;
        switch (evaluationResult.getResultType(threadID)) {
            case TRUE: {
                statusIcon = OracleIcons.getIcon((String)"check.png");
                break;
            }
            case FALSE: {
                statusIcon = OracleIcons.getIcon((String)"error.png");
                break;
            }
            default: {
                statusIcon = OracleIcons.getIcon((String)"unknownstatus.png");
            }
        }
        JLabel statusLabel = new JLabel(statusIcon);
        statusLabel.setToolTipText(evaluationResult.getMessage(threadID));
        content.add(statusLabel);
        JTextArea conditionText = new JTextArea(breakpoint.getCondition());
        conditionText.setBorder(null);
        conditionText.setOpaque(false);
        conditionText.setLineWrap(true);
        conditionText.setEditable(false);
        conditionText.setForeground(UIConstants.getColor((String)"ghost.text.foreground", (UIConstants.Look)UIConstants.Look.DARK));
        content.add((Component)conditionText, "span");
        if (evaluationResult.getResultType(threadID) != BreakpointConditionEvaluationResult.ResultType.TRUE) {
            JTextArea messageText = new JTextArea(evaluationResult.getMessage(threadID));
            messageText.setBorder(null);
            messageText.setOpaque(false);
            messageText.setLineWrap(true);
            messageText.setEditable(false);
            messageText.setForeground(UIConstants.getColor((String)"ghost.text.foreground", (UIConstants.Look)UIConstants.Look.DARK));
            content.add((Component)messageText, "span");
        }
        Peek peek = new Peek(gutterComponent, (JComponent)content, HoverFlavor.getFlavor((String)"conditionInfo"));
        GhostPointingPalette gp = peek.getGhostPointingPalette();
        gp.setLook(UIConstants.Look.DARK);
        gp.setResizable(false);
        gp.setReceivesFocus(true);
        gp.setHideOnLoseFocus(true);
        gp.setTitle(DbgArb.getString(57));
        gp.pack();
        gp.requestFocusInWindow();
        peek.setAutohide(false);
        return peek;
    }
}

