/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideri.util.Product;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.DebuggerContextMenuListener;
import oracle.jdevimpl.debugger.DebuggerEditorListener;
import oracle.jdevimpl.debugger.SourceIcon;
import oracle.jdevimpl.runner.ExtensionResources;
import oracle.jdevimpl.runner.RunConfigurationReader;
import oracle.jdevimpl.runner.RunItemActions;

public class RunItemAddin
implements Addin,
ShutdownHook,
MenuListener,
ViewSelectionListener {
    private static final String RUN_PROJECT_CMD_PREFIX = "RunProjectCommand";
    private Project activeProject;
    private static int runMenuProjectId;
    private static int toolbarProjectId;
    private JMenu runMenu;
    private static JMenu menuRunConfigurationList;
    private View activeView;

    public void initialize() {
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void mainWindowOpened(IdeEvent e) {
                Breakpoint.loadBreakpoints();
            }
        });
        SourceIcon.createHighlightStyles();
        ExitCommand.addShutdownHook((ShutdownHook)this);
        EditorManager.getEditorManager().addEditorListener((EditorListener)new DebuggerEditorListener());
        Ide.getSystem().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                int messageID = change.getMessageID();
                if (observed == Ide.getSystem() && messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    RunItemAddin.this.activeProject = Ide.getActiveProject();
                    RunItemAddin.updateActionsAndRunConfigurations(RunItemAddin.this.activeProject);
                    RunItemAddin.updateBreakpoints(RunItemAddin.this.activeProject, Ide.getActiveWorkspace());
                }
            }
        });
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new ProjectChangeListener(){

            public void projectOpened(Project project) {
                if (project == RunItemAddin.this.activeProject) {
                    RunItemAddin.updateActionsAndRunConfigurations(project);
                }
            }

            public void projectPropertiesChanged(ProjectChangeEvent e) {
                if (e.getProject() == RunItemAddin.this.activeProject) {
                    toolbarProjectId = 0;
                    runMenuProjectId = 0;
                    RunItemAddin.updateActionsAndRunConfigurations(e.getProject());
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)new DebuggerContextMenuListener());
                RunItemAddin.this.runMenu = MenuManager.getJMenu((String)"Run");
                RunItemAddin.this.runMenu.addMenuListener(RunItemAddin.this);
                Ide.getMainWindow().addActiveViewListener(new ActiveViewListener(){

                    public void activeViewChanged(ActiveViewEvent e) {
                        View newActiveView = Ide.getMainWindow().getLastActiveView();
                        if (newActiveView != RunItemAddin.this.activeView) {
                            if (RunItemAddin.this.activeView != null) {
                                RunItemAddin.this.activeView.removeViewSelectionListener((ViewSelectionListener)RunItemAddin.this);
                            }
                            RunItemAddin.this.activeView = newActiveView;
                            if (RunItemAddin.this.activeView != null) {
                                RunItemAddin.this.activeView.addViewSelectionListener((ViewSelectionListener)RunItemAddin.this);
                            }
                            RunItemActions.getInstance().updateRunDebugActions();
                        }
                    }
                });
            }
        });
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        Breakpoint.saveBreakpoints();
    }

    private static void updateActionsAndRunConfigurations(final Project project) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RunItemAddin.updateRunConfigurationLists(project);
                RunItemActions.getInstance().updateRunDebugActions();
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void updateBreakpoints(final Project project, final Workspace workspace) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Breakpoint.activeProjectChanged(project, workspace);
                RunItemActions.getInstance().updateRunDebugActions();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void updateRunConfigurationLists(Project project) {
        RunItemAddin.updateToolbarRunConfigurationLists(project);
        RunItemAddin.updateRunConfigurationListForRunMenu(project);
    }

    static void updateToolbarRunConfigurationLists(Project project) {
        int projectId;
        int n = projectId = project == null ? 0 : System.identityHashCode(project);
        if (projectId != toolbarProjectId) {
            toolbarProjectId = projectId;
            IdeAction[] actions = RunItemAddin.getActions(project, ExtensionResources.get("ACTION_CATEGORY_RUN"), "runner");
            RunItemAddin.fixMnemonics(actions);
            RunItemActions.getActionRunProject().putValue("ActionMenuActions", (Object)actions);
            actions = RunItemAddin.getActions(project, ExtensionResources.get("ACTION_CATEGORY_DEBUG"), "debugger");
            RunItemAddin.fixMnemonics(actions);
            RunItemActions.getActionDebugProject().putValue("ActionMenuActions", (Object)actions);
        }
    }

    private static void fixMnemonics(IdeAction[] actions) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> mnemonics = new ArrayList<Integer>();
        for (IdeAction a : actions) {
            if (a == null) continue;
            String name = (String)a.getValue("Name");
            Integer mkey = (Integer)a.getValue("MnemonicKey");
            if (name == null) continue;
            names.add(name);
            mnemonics.add(mkey);
        }
        String[] nameArray = names.toArray(new String[names.size()]);
        int[] mArray = new int[names.size()];
        boolean[] fixedArray = new boolean[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            Integer ival = (Integer)mnemonics.get(i);
            mArray[i] = ival == null ? 0 : ival;
        }
        fixedArray[fixedArray.length - 1] = true;
        MnemonicSolver solver = new MnemonicSolver(nameArray, mArray, fixedArray);
        Collection solution = solver.solve();
        HashMap<String, Integer> mmap = new HashMap<String, Integer>();
        for (MnemonicSolver.MenuLabel label : solution) {
            mmap.put(label.getText(), label.getMnemonic());
        }
        for (int i = 0; i < actions.length; ++i) {
            String nameKey;
            if (actions[i] == null || (nameKey = (String)actions[i].getValue("Name")) == null) continue;
            try {
                actions[i].putValue("MnemonicKey", (Object)((Integer)mmap.get(nameKey)));
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    private static IdeAction[] getActions(Project project, String translatedCategory, String category) {
        List<String> runConfigNames;
        List<Object> actions = null;
        if (project != null && (runConfigNames = RunConfigurationReader.getRunConfigurationNames(project)).size() > 0) {
            actions = RunItemActions.getInstance().makeActions(runConfigNames, translatedCategory, category);
        }
        if (actions == null) {
            actions = new ArrayList<IdeAction>(5);
        }
        if (actions.size() == 0) {
            actions.add(RunItemActions.getInstance().getActionEmpty());
        }
        if (category.equals("runner")) {
            actions.add(null);
            actions.add(RunItemActions.getInstance().getActionMruRun());
            actions.add(null);
        } else if (category.equals("debugger")) {
            actions.add(null);
            actions.add(RunItemActions.getInstance().getActionMruDebug());
            actions.add(null);
        }
        actions.add(RunItemActions.getInstance().getActionManageRunConfiguration());
        return actions.toArray(new IdeAction[actions.size()]);
    }

    private static void updateRunConfigurationListForRunMenu(Project project) {
        if (menuRunConfigurationList != null) {
            int projectId;
            int n = projectId = project == null ? 0 : System.identityHashCode(project);
            if (projectId != runMenuProjectId) {
                int i;
                runMenuProjectId = projectId;
                Menubar menubar = Ide.getMenubar();
                IdeAction[] actions = RunItemAddin.getActions(project, ExtensionResources.get("ACTION_CATEGORY_RUN"), "runmanager");
                menuRunConfigurationList.removeAll();
                int actionsLength = actions.length;
                JMenuItem[] menuItems = new JMenuItem[actionsLength];
                MnemonicSolver solver = new MnemonicSolver();
                for (i = 0; i < actionsLength; ++i) {
                    menuItems[i] = menubar.createMenuItem((ToggleAction)actions[i]);
                    solver.addMenuLabel(menuItems[i]);
                }
                solver.solve();
                for (i = 0; i < actionsLength - 1; ++i) {
                    menubar.add((Component)menuItems[i], menuRunConfigurationList, 1.0f);
                }
                menubar.add((Component)menuItems[actionsLength - 1], menuRunConfigurationList, 3.0f);
            }
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        boolean eventSourceIsRunMenu = false;
        Object source = e.getSource();
        if (source == this.runMenu) {
            eventSourceIsRunMenu = true;
        }
        if (source instanceof AbstractButton && ((AbstractButton)source).getText().equals(this.runMenu.getText())) {
            eventSourceIsRunMenu = true;
        }
        if (eventSourceIsRunMenu) {
            this.runMenu.removeMenuListener(this);
            String menuText = ExtensionResources.get("CHOOSE_RUN_CONFIGURATION_MENU");
            menuText = menuText.replace("&", "");
            Component runProjectMenu = null;
            Menubar menubar = Ide.getMenubar();
            for (Component menuComponent : this.runMenu.getMenuComponents()) {
                if (!(menuComponent instanceof JMenu)) continue;
                JMenu menu = (JMenu)menuComponent;
                if (menuText.equals(menu.getText())) {
                    menuRunConfigurationList = menu;
                    continue;
                }
                if (!RUN_PROJECT_CMD_PREFIX.equals(menubar.getId(menuComponent))) continue;
                runProjectMenu = menuComponent;
            }
            if (Product.isRaptor()) {
                if (menuRunConfigurationList != null) {
                    this.runMenu.remove(menuRunConfigurationList);
                    menuRunConfigurationList = null;
                }
                if (runProjectMenu != null) {
                    this.runMenu.remove(runProjectMenu);
                }
            }
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            boolean isJEERole = false;
            if (extensionRegistry.findExtension("oracle.j2ee") != null) {
                isJEERole = true;
            }
            if (!isJEERole) {
                String workingSetMenuItemText = ExtensionResources.get("USE_CURRENT_WORKING_SET_NAME");
                for (Component menuComponent : this.runMenu.getMenuComponents()) {
                    JMenuItem menuItem;
                    if (!(menuComponent instanceof JMenuItem) || !workingSetMenuItemText.equals((menuItem = (JMenuItem)menuComponent).getText())) continue;
                    menuItem.setVisible(false);
                    menuItem.setEnabled(false);
                }
            }
            if (menuRunConfigurationList != null) {
                RunItemAddin.updateRunConfigurationListForRunMenu(this.activeProject);
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        RunItemActions.getInstance().updateRunDebugActions();
    }
}

