/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.net.URL;
import java.util.logging.Level;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.SourceIcon;
import oracle.jdevimpl.runner.ExtensionResources;
import oracle.jdevimpl.runner.RunConfigurationReader;
import oracle.jdevimpl.runner.RunItemActions;

public class RunItemController
implements Controller {
    public static final String MRU_CONFIG_PROJECT_SHORT_NAME = "RunMRUConfigProjectShortName";
    public static final String MRU_CONFIG_PROJECT_RELATIVE_URL = "RunMRUConfigProjectRelativeUrl";
    public static final String MRU_CONFIG_NAME = "RunMRUConfigName";
    public static final String MRU_RUN_TARGET_URL = "RunMRUTargetURL";
    private static final String JDEV_RUNNER_EXTENSION_ID = "oracle.jdeveloper.runner";
    private static final String RUN_ITEM_CATEGORY = "RunItemCategory";
    private static final String RUN_ITEM_CATEGORY_SHARED = "shared";
    static final String RUN_ITEM_CATEGORY_DEBUGGER = "debugger";
    static final String RUN_ITEM_CATEGORY_RUNNER = "runner";
    static final String RUN_ITEM_CATEGORY_RUNMANAGER = "runmanager";
    private static final String DEBUGGER_CONTROLLER = "oracle.jdevimpl.runner.debug.JDebuggerController";
    private static final String SHARED_CONTROLLER = "oracle.jdevimpl.runner.debug.SharedActionsController";
    private static final String RUNNER_CONTROLLER = "oracle.jdevimpl.runner.run.JRunnerController";
    private static final String RUNMANAGER_CONTROLLER = "oracle.jdevimpl.runner.RunManagerController";
    private static final int USE_CURRENT_WORKING_SET_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.runner.UseCurrentWorkingSet");
    private static Controller debuggerController;
    private static Controller sharedController;
    private static Controller runnerController;
    private static Controller runManagerController;
    private static Boolean jdevRunnerLoaded;
    private static RunItemController instance;

    private RunItemController() {
        instance = this;
    }

    public static synchronized RunItemController getInstance() {
        if (instance == null) {
            new RunItemController();
        }
        return instance;
    }

    public static void setJdevRunnerLoaded() {
        jdevRunnerLoaded = Boolean.FALSE;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Controller realController = RunItemController.getRealController(action);
        if (realController != null) {
            return realController.handleEvent(action, context);
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        Controller realController;
        RunItemActions runItemActions = RunItemActions.getInstance();
        if (action == runItemActions.getActionRunProject()) {
            if (!RunItemController.isJDevRunnerLoaded()) {
                this.updateRunProjectAction(action, context);
                return true;
            }
        } else if (action == runItemActions.getActionDebugProject()) {
            if (!RunItemController.isJDevRunnerLoaded()) {
                this.updateDebugProjectAction(action, context);
                return true;
            }
        } else {
            if (action == runItemActions.getActionManageRunConfiguration()) {
                action.setEnabled(context.getProject() != null);
                return true;
            }
            if (RUN_ITEM_CATEGORY_RUNMANAGER.equals(action.getValue(RUN_ITEM_CATEGORY))) {
                String runConfigurationName = action.getValue("UserData").toString().substring(21);
                action.setState(runConfigurationName.equals(this.getActiveRunConfigName(context)));
                action.setEnabled(true);
                return true;
            }
            if (runItemActions.isMruAction(action)) {
                this.updateMruRunConfigAction(action, context);
                action.setState(true);
                return true;
            }
            if (runItemActions.isRunConfigurationAction(action)) {
                action.setEnabled(true);
                action.setState(false);
                return true;
            }
            if (action == RunItemActions.getActionContextMenuRun()) {
                context = (Context)action.getValue("UserData");
                this.updateContextMenuRunAction(action, context);
                return true;
            }
            if (action == RunItemActions.getActionRunSelection()) {
                this.updateRunSelectionAction(action, context);
                return true;
            }
            if (action == RunItemActions.getActionContextMenuDebug()) {
                context = (Context)action.getValue("UserData");
                this.updateContextMenuDebugAction(action, context);
                return true;
            }
            if (action == RunItemActions.getActionDebugSelection()) {
                this.updateDebugSelectionAction(action, context);
                return true;
            }
            if (action.getCommandId() == USE_CURRENT_WORKING_SET_CMD_ID) {
                action.setEnabled(true);
                action.setState(Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet());
                return true;
            }
            if (action == RunItemActions.getActionCodeEditorToggleBreakpoint()) {
                if (!RunItemController.isJDevRunnerLoaded()) {
                    return this.updateToggleBreakpoint(action, context);
                }
            } else if (action == RunItemActions.getActionCodeEditorToggleWatchpoint()) {
                if (!RunItemController.isJDevRunnerLoaded()) {
                    return this.updateToggleWatchpoint(action, context);
                }
            } else if (action == RunItemActions.getActionCodeEditorEnableBreakpoint()) {
                if (!RunItemController.isJDevRunnerLoaded()) {
                    return this.updateEnableBreakpoint(action, context);
                }
            } else if (action == RunItemActions.getActionCodeEditorDisableBreakpoint()) {
                if (!RunItemController.isJDevRunnerLoaded()) {
                    return this.updateDisableBreakpoint(action, context);
                }
            } else if (action == RunItemActions.getActionCodeEditorEditBreakpoint() && !RunItemController.isJDevRunnerLoaded()) {
                return this.updateEditBreakpoint(action, context);
            }
        }
        if (RunItemController.isJDevRunnerLoaded() && (realController = RunItemController.getRealController(action)) != null) {
            return realController.update(action, context);
        }
        return false;
    }

    private void updateRunSelectionAction(IdeAction action, Context context) {
        String name;
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        action.putValue("SmallIcon", null);
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            action.setEnabled(false);
            action.putValue("Name", (Object)ExtensionResources.get(isUseCurrentWorkingSet ? "RUN_SELECTION_MENUITEM_1_WS" : "RUN_SELECTION_MENUITEM_1"));
            return;
        }
        action.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node)) {
            String nodeShortLabel = node.getShortLabel();
            name = ExtensionResources.format(isUseCurrentWorkingSet ? "RUN_SELECTION_MENUITEM_2_WS" : "RUN_SELECTION_MENUITEM_2", nodeShortLabel);
        } else {
            name = ExtensionResources.get(isUseCurrentWorkingSet ? "RUN_SELECTION_MENUITEM_1_WS" : "RUN_SELECTION_MENUITEM_1");
        }
        action.putValue("Name", (Object)name);
    }

    private void updateContextMenuRunAction(IdeAction action, Context context) {
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        action.setEnabled(Runner.getRunner().enableRunDebugActions(context, null) && this.canStartProcess(context));
        action.putValue("Name", (Object)ExtensionResources.get(isUseCurrentWorkingSet ? "CONTEXTMENU_RUN_MENUITEM_WS" : "CONTEXTMENU_RUN_MENUITEM"));
    }

    private void updateDebugSelectionAction(IdeAction action, Context context) {
        String name;
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        Project project = context.getProject();
        if (project != null && RunConfigurationReader.isRemoteDebuggingProfiling(project)) {
            action.setEnabled(false);
            action.putValue("Name", (Object)ExtensionResources.get(isUseCurrentWorkingSet ? "DEBUG_SELECTION_MENUITEM_1_WS" : "DEBUG_SELECTION_MENUITEM_1"));
            return;
        }
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            action.setEnabled(false);
            action.putValue("Name", (Object)ExtensionResources.get(isUseCurrentWorkingSet ? "DEBUG_SELECTION_MENUITEM_1_WS" : "DEBUG_SELECTION_MENUITEM_1"));
            return;
        }
        action.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node, null)) {
            String nodeShortLabel = node.getShortLabel();
            name = ExtensionResources.format(isUseCurrentWorkingSet ? "DEBUG_SELECTION_MENUITEM_2_WS" : "DEBUG_SELECTION_MENUITEM_2", nodeShortLabel);
        } else {
            name = ExtensionResources.get(isUseCurrentWorkingSet ? "DEBUG_SELECTION_MENUITEM_1_WS" : "DEBUG_SELECTION_MENUITEM_1");
        }
        action.putValue("Name", (Object)name);
    }

    private void updateContextMenuDebugAction(IdeAction action, Context context) {
        Project project;
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        boolean enabled = Runner.getRunner().enableRunDebugActions(context, null) && this.canStartProcess(context);
        action.setEnabled(enabled);
        if (enabled && (project = context.getProject()) != null && RunConfigurationReader.isRemoteDebuggingProfiling(project)) {
            action.putValue("Name", (Object)ExtensionResources.get("CONTEXTMENU_DEBUG_MENUITEM_REMOTE"));
            return;
        }
        action.putValue("Name", (Object)ExtensionResources.get(isUseCurrentWorkingSet ? "CONTEXTMENU_DEBUG_MENUITEM_WS" : "CONTEXTMENU_DEBUG_MENUITEM"));
    }

    private boolean canStartProcess(Context context) {
        Node node;
        if (context != null && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean contextOk = false;
        if (context != null) {
            contextOk = this.isContextNodeRunnable(context);
        } else if (Ide.getActiveProject() != null) {
            contextOk = true;
        } else {
            Context activeContext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (activeContext != null) {
                contextOk = this.isContextNodeRunnable(activeContext);
            }
        }
        return contextOk;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node);
    }

    private void updateRunProjectAction(IdeAction action, Context context) {
        String mruMenuLabel = this.getMRUMenuName(context, false);
        if (ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM").equals(mruMenuLabel)) {
            action.setEnabled(false);
            action.setName(ExtensionResources.get("RUN_PROJECT"));
        } else {
            action.setEnabled(true);
            action.setName(ExtensionResources.format("RUN_NAMED_PROJECT", mruMenuLabel));
        }
    }

    private void updateDebugProjectAction(IdeAction action, Context context) {
        String mruMenuLabel = this.getMRUMenuName(context, false);
        if (ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM").equals(mruMenuLabel)) {
            action.setEnabled(false);
            action.setName(ExtensionResources.get("DEBUG_PROJECT"));
        } else {
            action.setEnabled(true);
            action.setName(ExtensionResources.format("DEBUG_NAMED_PROJECT", mruMenuLabel));
        }
    }

    private void updateMruRunConfigAction(IdeAction action, Context context) {
        String mruMenuLabel = this.getMRUMenuName(context, true);
        if (ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM").equals(mruMenuLabel)) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
        action.setName(mruMenuLabel);
    }

    private static boolean isJDevRunnerLoaded() {
        ExtensionRegistry registry;
        Extension extension;
        if (jdevRunnerLoaded == null) {
            return false;
        }
        if (!jdevRunnerLoaded.booleanValue() && (extension = (registry = ExtensionRegistry.getExtensionRegistry()).findExtension(JDEV_RUNNER_EXTENSION_ID)) != null && registry.isFullyLoaded(extension)) {
            jdevRunnerLoaded = Boolean.TRUE;
        }
        return jdevRunnerLoaded;
    }

    private static synchronized Controller getRealController(IdeAction action) {
        Object category = action.getValue(RUN_ITEM_CATEGORY);
        if (category != null) {
            String categoryAsString = category.toString();
            if (categoryAsString.equals(RUN_ITEM_CATEGORY_SHARED)) {
                if (sharedController == null) {
                    sharedController = RunItemController.loadController(SHARED_CONTROLLER);
                }
                return sharedController;
            }
            if (categoryAsString.equals(RUN_ITEM_CATEGORY_DEBUGGER)) {
                if (debuggerController == null) {
                    debuggerController = RunItemController.loadController(DEBUGGER_CONTROLLER);
                }
                return debuggerController;
            }
            if (categoryAsString.equals(RUN_ITEM_CATEGORY_RUNNER)) {
                if (runnerController == null) {
                    runnerController = RunItemController.loadController(RUNNER_CONTROLLER);
                }
                return runnerController;
            }
            if (categoryAsString.equals(RUN_ITEM_CATEGORY_RUNMANAGER)) {
                if (runManagerController == null) {
                    runManagerController = RunItemController.loadController(RUNMANAGER_CONTROLLER);
                }
                return runManagerController;
            }
        }
        return null;
    }

    private static Controller loadController(String controllerClassName) {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Extension extension = registry.findExtension(JDEV_RUNNER_EXTENSION_ID);
        if (extension != null) {
            ClassLoader classLoader;
            if (Boolean.TRUE != jdevRunnerLoaded) {
                registry.fullyLoadExtension(extension, "Needed to execute jdev-runner actions");
                jdevRunnerLoaded = Boolean.TRUE;
            }
            if ((classLoader = registry.getClassLoader(JDEV_RUNNER_EXTENSION_ID)) != null) {
                try {
                    MetaClass controllerMetaClass = new MetaClass(classLoader, controllerClassName);
                    return (Controller)controllerMetaClass.newInstance();
                }
                catch (Exception ex) {
                    ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Cannot load " + controllerClassName + " in jdev-runner-buttons");
                }
            } else {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Cannot find class loader for extension oracle.jdeveloper.runner");
            }
        } else {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Cannot load extension oracle.jdeveloper.runner");
        }
        return null;
    }

    private String getActiveRunConfigName(Context context) {
        Project project = context.getProject();
        if (project == null) {
            project = Ide.getActiveProject();
        }
        if (project != null) {
            return RunConfigurationReader.getActiveRunConfigurationName(project);
        }
        return null;
    }

    private String getMRUMenuName(Context context, boolean includeRunConfigName) {
        String activeName;
        HashStructure userProps;
        Project lastMRUProject = null;
        String shortMruConfigurationLabel = null;
        Workspace currentWorkspace = context.getWorkspace();
        if (currentWorkspace == null) {
            currentWorkspace = Ide.getActiveWorkspace();
        }
        if (currentWorkspace != null && (userProps = currentWorkspace.getUserPropertiesOnly()) != null) {
            URL projUrl;
            String projectShortName = userProps.getString(MRU_CONFIG_PROJECT_SHORT_NAME);
            String projectRelativeUrl = userProps.getString(MRU_CONFIG_PROJECT_RELATIVE_URL);
            String configName = userProps.getString(MRU_CONFIG_NAME);
            if (projectShortName != null && projectRelativeUrl != null && configName != null && (projUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl)) != null && URLFileSystem.exists((URL)projUrl)) {
                StringBuilder sb = new StringBuilder();
                sb.append(projectShortName);
                if (includeRunConfigName) {
                    sb.append(":");
                    sb.append(configName);
                }
                return sb.toString();
            }
        }
        if (lastMRUProject == null) {
            lastMRUProject = Ide.getActiveProject();
        }
        if (lastMRUProject != null && (activeName = RunConfigurationReader.getActiveRunConfigurationName(lastMRUProject)) != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(lastMRUProject.getShortLabel());
            if (includeRunConfigName) {
                sb.append(":");
                sb.append(activeName);
            }
            shortMruConfigurationLabel = sb.toString();
        }
        if (shortMruConfigurationLabel != null) {
            return shortMruConfigurationLabel;
        }
        return ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM");
    }

    private boolean updateToggleBreakpoint(IdeAction action, Context context) {
        int editorLine;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() != 6) {
            action.setEnabled(true);
            return true;
        }
        CodeEditor codeEditor = RunItemController.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = RunItemController.getLineFromCodeEditor(context)) != 0) {
            action.setEnabled(true);
            return true;
        }
        action.setEnabled(false);
        return false;
    }

    private boolean updateToggleWatchpoint(IdeAction action, Context context) {
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() == 6) {
            action.setEnabled(true);
            return true;
        }
        action.setEnabled(false);
        return false;
    }

    private boolean updateEnableBreakpoint(IdeAction action, Context context) {
        return this.updateBreakpoint(action, context, ExtensionResources.get("CODE_EDITOR_ENABLEWATCHPOINT_MENUITEM"), ExtensionResources.get("CODE_EDITOR_ENABLEBREAKPOINT_MENUITEM"), Boolean.FALSE);
    }

    private boolean updateDisableBreakpoint(IdeAction action, Context context) {
        return this.updateBreakpoint(action, context, ExtensionResources.get("CODE_EDITOR_DISABLEWATCHPOINT_MENUITEM"), ExtensionResources.get("CODE_EDITOR_DISABLEBREAKPOINT_MENUITEM"), Boolean.TRUE);
    }

    private boolean updateEditBreakpoint(IdeAction action, Context context) {
        return this.updateBreakpoint(action, context, ExtensionResources.get("CODE_EDITOR_EDITWATCHPOINT_MENUITEM"), ExtensionResources.get("CODE_EDITOR_EDITBREAKPOINT_MENUITEM"), null);
    }

    private boolean updateBreakpoint(IdeAction action, Context context, String watchPointLabel, String breakpointLabel, Boolean desiredBreakpointState) {
        Breakpoint bp;
        int editorLine;
        CodeEditor codeEditor = RunItemController.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = RunItemController.getLineFromCodeEditor(context)) != 0 && (bp = this.getBreakpointFromGutterMarkRightClick(context)) != null && (desiredBreakpointState == null || bp.isRuntimeEnabled() == desiredBreakpointState.booleanValue())) {
            if (bp.getType() == 6) {
                action.putValue("Name", (Object)watchPointLabel);
            } else {
                action.putValue("Name", (Object)breakpointLabel);
            }
            action.setEnabled(true);
            return true;
        }
        action.setEnabled(false);
        return false;
    }

    public static int getLineFromCodeEditor(Context context) {
        View view;
        if (context != null && (view = context.getView()) != null && view instanceof CodeEditorGutterView) {
            int line = CodeEditorGutter.getLineForContext((Context)context);
            if (line != -1) {
                return line;
            }
            return 0;
        }
        CodeEditor codeEditor = RunItemController.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return codeEditor.getCaretLine();
        }
        return 0;
    }

    public static CodeEditor getCodeEditorFromContext(Context context) {
        if (context != null) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                return (CodeEditor)view;
            }
            if (view instanceof CodeEditorGutterView) {
                return (CodeEditor)view.owner();
            }
        }
        return null;
    }

    private Breakpoint getBreakpointFromGutterMarkRightClick(Context context) {
        Object o;
        GutterMark gutterMark;
        if (context.getView() instanceof CodeEditorGutterView && (gutterMark = CodeEditorGutter.getMarkForContext((Context)context)) != null && (o = gutterMark.getUserData()) instanceof SourceIcon) {
            SourceIcon sourceIcon = (SourceIcon)o;
            Breakpoint bp = sourceIcon.getBreakpoint();
            return bp;
        }
        return null;
    }
}

