/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.util.List;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

abstract class HtmlFormAuthentication {
    public static final String USERNAME_FIELD = "j_username";
    public static final String PASSWORD_FIELD = "j_password";
    public static final String REFERRER_FIELD = "referrer";

    private HtmlFormAuthentication() {
    }

    static Pair<String, char[]> credentials(RequestEntity request) {
        String username = null;
        char[] password = null;
        List<Pair<String, Object>> fields = Requests.formFields(request);
        for (Pair<String, Object> field : fields) {
            if (USERNAME_FIELD.equals(field.first())) {
                username = (String)field.second();
                continue;
            }
            if (!PASSWORD_FIELD.equals(field.first())) continue;
            password = ((String)field.second()).toCharArray();
        }
        if (username == null || password == null) {
            return null;
        }
        return Pair.pair(username, password);
    }
}

