/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.AuthenticatorBase;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.session.ServletSessionCallback;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

@Service
@Authenticates(value=AuthenticationRealm.SESSION)
public class SessionVerifier
extends AuthenticatorBase
implements RealmAuthenticator {
    public static final String SESSION_ATTRIBUTE_NAME = "_com.oracle.al";

    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        ServletSessionCallback c = new ServletSessionCallback(SESSION_ATTRIBUTE_NAME);
        Callback[] callbacks = new Callback[]{c};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        SessionState session = (SessionState)c.getAttribute();
        if (session != null) {
            return this.principals(new Principal[]{session.principal()});
        }
        return null;
    }

    public static SessionState session(RequestEntity request) {
        return (SessionState)Requests.sessionAttribute(request, SESSION_ATTRIBUTE_NAME);
    }
}

