/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.rt.authentication.Authenticator;
import oracle.dbtools.rt.authentication.AuthenticatorBase;
import oracle.dbtools.rt.authentication.Principals;
import oracle.dbtools.rt.authentication.file.FileUser;
import oracle.dbtools.rt.authentication.file.SSHA;

@Service(provides={Authenticator.class}, priority=2)
public class FileAuthenticator
extends AuthenticatorBase {
    private final ConcurrentHashMap<String, FileUser> allUsers = new ConcurrentHashMap();
    private File credentials = null;
    private static final String COMMENT = "^\\s#.*$";
    private static final String CREDENTIALS = "credentials";
    private static final String FIELD_SEP = ";";
    private static final String GROUP_SEP = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Principal> authenticate(CallbackHandler callbackHandler) {
        boolean valid;
        NameCallback n = new NameCallback("username");
        PasswordCallback p = new PasswordCallback("password", false);
        Callback[] callbacks = new Callback[]{n, p};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
        catch (UnsupportedCallbackException e) {
            throw this.wrap(e);
        }
        String name = n.getName();
        char[] pwd = p.getPassword();
        FileUser user = this.allUsers.get(name);
        if (user == null) {
            ConcurrentHashMap<String, FileUser> concurrentHashMap = this.allUsers;
            synchronized (concurrentHashMap) {
                Map<String, FileUser> users = FileAuthenticator.read(this.credentials);
                this.allUsers.putAll(users);
            }
            user = this.allUsers.get(name);
        }
        boolean bl = valid = user != null && user.validate(pwd);
        if (valid) {
            return this.principals(Principals.principals(user.name(), user.roles()));
        }
        return null;
    }

    protected void activate(ServiceProperties props) throws Exception {
        String credentialsPath;
        Configuration conf = ConfigurationsProvider.INSTANCE.get("apex");
        File credentials = Files.file((File)ConfigurationFolder.INSTANCE.getFolder(), (String)CREDENTIALS);
        if (conf != null && (credentialsPath = conf.get("security.credentials.file")) != null) {
            credentials = Files.file((String)credentialsPath);
        }
        this.credentials = credentials;
        Map<String, FileUser> users = FileAuthenticator.read(credentials);
        this.allUsers.putAll(users);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<String, FileUser> read(File file) {
        HashMap<String, FileUser> users = new HashMap<String, FileUser>();
        if (file.exists()) {
            BufferedInputStream in = null;
            BufferedReader reader = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                reader = new BufferedReader(new InputStreamReader((InputStream)in, SSHA.UTF8));
                String line = reader.readLine();
                while (null != line) {
                    String[] parts;
                    if (!line.matches(COMMENT) && (parts = line.split(FIELD_SEP)).length >= 2) {
                        String name = parts[0];
                        byte[] hash = new byte[64];
                        byte[] salt = SSHA.decode(parts[1], hash);
                        String[] groups = new String[]{};
                        if (parts.length > 2) {
                            groups = parts[2].split(GROUP_SEP);
                        }
                        users.put(name, new FileUser(name, salt, hash, groups));
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                Closeables.close((Object[])new Closeable[]{reader, in});
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Closeable[]{reader, in});
                    throw throwable;
                }
            }
            Closeables.close((Object[])new Closeable[]{reader, in});
        }
        return users;
    }
}

