/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.file;

import java.util.Arrays;
import oracle.dbtools.rt.authentication.file.SSHA;

class FileUser {
    private final String[] roles;
    private final byte[] hash;
    private final String name;
    private final byte[] salt;

    FileUser(String name, byte[] salt, byte[] hash, String ... roles) {
        this.name = name;
        this.salt = salt;
        this.hash = hash;
        this.roles = roles;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileUser other = (FileUser)obj;
        if (!Arrays.equals(this.roles, other.roles)) {
            return false;
        }
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.salt, other.salt);
    }

    String name() {
        return this.name;
    }

    String[] roles() {
        return this.roles;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.roles);
        result = 31 * result + Arrays.hashCode(this.hash);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.salt);
        return result;
    }

    public String toString() {
        return this.name();
    }

    public boolean validate(char[] credentials) {
        return SSHA.verify(this.salt, this.hash, credentials);
    }
}

