/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization.bdb;

import java.security.Principal;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.BaseScopeAuthorizationPolicy;
import oracle.dbtools.rt.authorization.RoleMappers;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.MultiTenantEntityPK;
import oracle.dbtools.rt.oauth.bdb.BDBScopesProvider;
import oracle.dbtools.rt.oauth.scope.Scope;

@Service(provides={ScopeAuthorizationPolicy.class})
public class BDBScopeAuthorization
extends BaseScopeAuthorizationPolicy {
    @Reference
    private BDBScopesProvider scopes;
    @Reference
    private RoleMappers roles;

    @Override
    protected AuthorizationPolicy.Access authorize(CompoundPrincipal principal, MultiTenantEntityPK scopeId) {
        AuthorizationPolicy.Access access = AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
        Scope scope = (Scope)this.scopes.entity((Transaction)null, principal, scopeId);
        if (scope != null) {
            String scopeName = scope.name();
            access = this.roles.isPrincipalInRole((Principal)principal, scopeName) ? AuthorizationPolicy.Access.READ_WRITE : AuthorizationPolicy.Access.NONE;
        }
        return access;
    }
}

