/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.service.NotAvailableException;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.config.NotYetConfigured;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;

@Service
public class FirstTimeConfiguration
implements RequestDispatcher {
    private static final URITemplate[] IGNORE = new URITemplate[]{NotYetConfigured.URI_TEMPLATE};

    static boolean isConfigured() {
        Iterator confs = ConfigurationsProvider.INSTANCE.iterator();
        boolean configured = false;
        while (confs.hasNext()) {
            String name = (String)confs.next();
            if (name.equals("defaults")) continue;
            configured = true;
            break;
        }
        return configured;
    }

    protected void activate(ServiceProperties properties) {
        if (FirstTimeConfiguration.isConfigured()) {
            throw new NotAvailableException(FirstTimeConfiguration.class);
        }
    }

    @Override
    public RequestDispatcher.Score canDispatch(RequestEntity request) {
        String path = request.path();
        for (URITemplate uriTemplate : IGNORE) {
            if (!uriTemplate.matches(path)) continue;
            return RequestDispatcher.NO_MATCH;
        }
        throw RedirectException.temporaryRedirect("not-yet-configured");
    }

    @Override
    public HttpResource dispatch(RequestDispatcher.Score score, RequestEntity request) throws IOException {
        return null;
    }
}

